# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/bigtable/admin/v2/bigtable_table_admin_pb"

module Google
  module Cloud
    module Bigtable
      module Admin
        module V2
          module BigtableTableAdmin
            ##
            # Client for the BigtableTableAdmin service.
            #
            # Service for creating, configuring, and deleting Cloud Bigtable tables.
            #
            #
            # Provides access to the table schemas only, not the data stored within
            # the tables.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "bigtableadmin.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :bigtable_table_admin_stub

              ##
              # Configure the BigtableTableAdmin Client class.
              #
              # See {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all BigtableTableAdmin clients
              #   ::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Bigtable", "Admin", "V2"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.create_table.timeout = 300.0

                  default_config.rpcs.list_tables.timeout = 60.0
                  default_config.rpcs.list_tables.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [14, 4]
                  }

                  default_config.rpcs.get_table.timeout = 60.0
                  default_config.rpcs.get_table.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [14, 4]
                  }

                  default_config.rpcs.delete_table.timeout = 300.0

                  default_config.rpcs.modify_column_families.timeout = 300.0

                  default_config.rpcs.drop_row_range.timeout = 3600.0

                  default_config.rpcs.generate_consistency_token.timeout = 60.0
                  default_config.rpcs.generate_consistency_token.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [14, 4]
                  }

                  default_config.rpcs.check_consistency.timeout = 3600.0
                  default_config.rpcs.check_consistency.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [14, 4]
                  }

                  default_config.rpcs.get_snapshot.timeout = 60.0
                  default_config.rpcs.get_snapshot.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_snapshots.timeout = 60.0
                  default_config.rpcs.list_snapshots.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [14, 4]
                  }

                  default_config.rpcs.delete_snapshot.timeout = 300.0

                  default_config.rpcs.create_backup.timeout = 60.0

                  default_config.rpcs.get_backup.timeout = 60.0
                  default_config.rpcs.get_backup.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [14, 4]
                  }

                  default_config.rpcs.update_backup.timeout = 60.0

                  default_config.rpcs.delete_backup.timeout = 300.0

                  default_config.rpcs.list_backups.timeout = 60.0
                  default_config.rpcs.list_backups.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [14, 4]
                  }

                  default_config.rpcs.restore_table.timeout = 60.0

                  default_config.rpcs.get_iam_policy.timeout = 60.0
                  default_config.rpcs.get_iam_policy.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [14, 4]
                  }

                  default_config.rpcs.set_iam_policy.timeout = 60.0

                  default_config.rpcs.test_iam_permissions.timeout = 60.0
                  default_config.rpcs.test_iam_permissions.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [14, 4]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the BigtableTableAdmin Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @bigtable_table_admin_stub.universe_domain
              end

              ##
              # Create a new BigtableTableAdmin client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the BigtableTableAdmin client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # These require statements are intentionally placed here to initialize
                # the gRPC module only when it's required.
                # See https://github.com/googleapis/toolkit/issues/446
                require "gapic/grpc"
                require "google/bigtable/admin/v2/bigtable_table_admin_services_pb"

                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end
                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @bigtable_table_admin_stub = ::Gapic::ServiceStub.new(
                  ::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Stub,
                  credentials: credentials,
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  channel_args: @config.channel_args,
                  interceptors: @config.interceptors,
                  channel_pool_config: @config.channel_pool,
                  logger: @config.logger
                )

                @bigtable_table_admin_stub.stub_logger&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Operations]
              #
              attr_reader :operations_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @bigtable_table_admin_stub.logger
              end

              # Service calls

              ##
              # Creates a new table in the specified instance.
              # The table can be created with a full set of initial column families,
              # specified in the request.
              #
              # @overload create_table(request, options = nil)
              #   Pass arguments to `create_table` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::CreateTableRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::CreateTableRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_table(parent: nil, table_id: nil, table: nil, initial_splits: nil)
              #   Pass arguments to `create_table` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The unique name of the instance in which to create the table.
              #     Values are of the form `projects/{project}/instances/{instance}`.
              #   @param table_id [::String]
              #     Required. The name by which the new table should be referred to within the
              #     parent instance, e.g., `foobar` rather than `{parent}/tables/foobar`.
              #     Maximum 50 characters.
              #   @param table [::Google::Cloud::Bigtable::Admin::V2::Table, ::Hash]
              #     Required. The Table to create.
              #   @param initial_splits [::Array<::Google::Cloud::Bigtable::Admin::V2::CreateTableRequest::Split, ::Hash>]
              #     The optional list of row keys that will be used to initially split the
              #     table into several tablets (tablets are similar to HBase regions).
              #     Given two split keys, `s1` and `s2`, three tablets will be created,
              #     spanning the key ranges: `[, s1), [s1, s2), [s2, )`.
              #
              #     Example:
              #
              #     * Row keys := `["a", "apple", "custom", "customer_1", "customer_2",`
              #                    `"other", "zz"]`
              #     * initial_split_keys := `["apple", "customer_1", "customer_2", "other"]`
              #     * Key assignment:
              #         - Tablet 1 `[, apple)                => {"a"}.`
              #         - Tablet 2 `[apple, customer_1)      => {"apple", "custom"}.`
              #         - Tablet 3 `[customer_1, customer_2) => {"customer_1"}.`
              #         - Tablet 4 `[customer_2, other)      => {"customer_2"}.`
              #         - Tablet 5 `[other, )                => {"other", "zz"}.`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigtable::Admin::V2::Table]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigtable::Admin::V2::Table]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::CreateTableRequest.new
              #
              #   # Call the create_table method.
              #   result = client.create_table request
              #
              #   # The returned object is of type Google::Cloud::Bigtable::Admin::V2::Table.
              #   p result
              #
              def create_table request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::CreateTableRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_table.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_table.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_table.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :create_table, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new table from the specified snapshot. The target table must
              # not exist. The snapshot and the table must be in the same instance.
              #
              # Note: This is a private alpha release of Cloud Bigtable snapshots. This
              # feature is not currently available to most Cloud Bigtable customers. This
              # feature might be changed in backward-incompatible ways and is not
              # recommended for production use. It is not subject to any SLA or deprecation
              # policy.
              #
              # @overload create_table_from_snapshot(request, options = nil)
              #   Pass arguments to `create_table_from_snapshot` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::CreateTableFromSnapshotRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::CreateTableFromSnapshotRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_table_from_snapshot(parent: nil, table_id: nil, source_snapshot: nil)
              #   Pass arguments to `create_table_from_snapshot` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The unique name of the instance in which to create the table.
              #     Values are of the form `projects/{project}/instances/{instance}`.
              #   @param table_id [::String]
              #     Required. The name by which the new table should be referred to within the
              #     parent instance, e.g., `foobar` rather than `{parent}/tables/foobar`.
              #   @param source_snapshot [::String]
              #     Required. The unique name of the snapshot from which to restore the table.
              #     The snapshot and the table must be in the same instance. Values are of the
              #     form
              #     `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/{snapshot}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::CreateTableFromSnapshotRequest.new
              #
              #   # Call the create_table_from_snapshot method.
              #   result = client.create_table_from_snapshot request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_table_from_snapshot request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::CreateTableFromSnapshotRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_table_from_snapshot.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_table_from_snapshot.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_table_from_snapshot.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :create_table_from_snapshot, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all tables served from a specified instance.
              #
              # @overload list_tables(request, options = nil)
              #   Pass arguments to `list_tables` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::ListTablesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::ListTablesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_tables(parent: nil, view: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_tables` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The unique name of the instance for which tables should be
              #     listed. Values are of the form `projects/{project}/instances/{instance}`.
              #   @param view [::Google::Cloud::Bigtable::Admin::V2::Table::View]
              #     The view to be applied to the returned tables' fields.
              #     NAME_ONLY view (default) and REPLICATION_VIEW are supported.
              #   @param page_size [::Integer]
              #     Maximum number of results per page.
              #
              #     A page_size of zero lets the server choose the number of items to return.
              #     A page_size which is strictly positive will return at most that many items.
              #     A negative page_size will cause an error.
              #
              #     Following the first request, subsequent paginated calls are not required
              #     to pass a page_size. If a page_size is set in subsequent calls, it must
              #     match the page_size given in the first request.
              #   @param page_token [::String]
              #     The value of `next_page_token` returned by a previous call.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Bigtable::Admin::V2::Table>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Bigtable::Admin::V2::Table>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::ListTablesRequest.new
              #
              #   # Call the list_tables method.
              #   result = client.list_tables request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Bigtable::Admin::V2::Table.
              #     p item
              #   end
              #
              def list_tables request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::ListTablesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_tables.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_tables.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_tables.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :list_tables, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @bigtable_table_admin_stub, :list_tables, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets metadata information about the specified table.
              #
              # @overload get_table(request, options = nil)
              #   Pass arguments to `get_table` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::GetTableRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::GetTableRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_table(name: nil, view: nil)
              #   Pass arguments to `get_table` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The unique name of the requested table.
              #     Values are of the form
              #     `projects/{project}/instances/{instance}/tables/{table}`.
              #   @param view [::Google::Cloud::Bigtable::Admin::V2::Table::View]
              #     The view to be applied to the returned table's fields.
              #     Defaults to `SCHEMA_VIEW` if unspecified.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigtable::Admin::V2::Table]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigtable::Admin::V2::Table]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::GetTableRequest.new
              #
              #   # Call the get_table method.
              #   result = client.get_table request
              #
              #   # The returned object is of type Google::Cloud::Bigtable::Admin::V2::Table.
              #   p result
              #
              def get_table request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::GetTableRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_table.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_table.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_table.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :get_table, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a specified table.
              #
              # @overload update_table(request, options = nil)
              #   Pass arguments to `update_table` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::UpdateTableRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::UpdateTableRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_table(table: nil, update_mask: nil, ignore_warnings: nil)
              #   Pass arguments to `update_table` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param table [::Google::Cloud::Bigtable::Admin::V2::Table, ::Hash]
              #     Required. The table to update.
              #     The table's `name` field is used to identify the table to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to update.
              #     A mask specifying which fields (e.g. `change_stream_config`) in the `table`
              #     field should be updated. This mask is relative to the `table` field, not to
              #     the request message. The wildcard (*) path is currently not supported.
              #     Currently UpdateTable is only supported for the following fields:
              #
              #     * `change_stream_config`
              #     * `change_stream_config.retention_period`
              #     * `deletion_protection`
              #     * `row_key_schema`
              #
              #     If `column_families` is set in `update_mask`, it will return an
              #     UNIMPLEMENTED error.
              #   @param ignore_warnings [::Boolean]
              #     Optional. If true, ignore safety checks when updating the table.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::UpdateTableRequest.new
              #
              #   # Call the update_table method.
              #   result = client.update_table request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_table request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::UpdateTableRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_table.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.table&.name
                  header_params["table.name"] = request.table.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_table.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_table.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :update_table, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Permanently deletes a specified table and all of its data.
              #
              # @overload delete_table(request, options = nil)
              #   Pass arguments to `delete_table` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::DeleteTableRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::DeleteTableRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_table(name: nil)
              #   Pass arguments to `delete_table` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The unique name of the table to be deleted.
              #     Values are of the form
              #     `projects/{project}/instances/{instance}/tables/{table}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Protobuf::Empty]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::DeleteTableRequest.new
              #
              #   # Call the delete_table method.
              #   result = client.delete_table request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_table request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::DeleteTableRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_table.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_table.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_table.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :delete_table, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Restores a specified table which was accidentally deleted.
              #
              # @overload undelete_table(request, options = nil)
              #   Pass arguments to `undelete_table` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::UndeleteTableRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::UndeleteTableRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload undelete_table(name: nil)
              #   Pass arguments to `undelete_table` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The unique name of the table to be restored.
              #     Values are of the form
              #     `projects/{project}/instances/{instance}/tables/{table}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::UndeleteTableRequest.new
              #
              #   # Call the undelete_table method.
              #   result = client.undelete_table request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def undelete_table request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::UndeleteTableRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.undelete_table.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.undelete_table.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.undelete_table.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :undelete_table, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new AuthorizedView in a table.
              #
              # @overload create_authorized_view(request, options = nil)
              #   Pass arguments to `create_authorized_view` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::CreateAuthorizedViewRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::CreateAuthorizedViewRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_authorized_view(parent: nil, authorized_view_id: nil, authorized_view: nil)
              #   Pass arguments to `create_authorized_view` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. This is the name of the table the AuthorizedView belongs to.
              #     Values are of the form
              #     `projects/{project}/instances/{instance}/tables/{table}`.
              #   @param authorized_view_id [::String]
              #     Required. The id of the AuthorizedView to create. This AuthorizedView must
              #     not already exist. The `authorized_view_id` appended to `parent` forms the
              #     full AuthorizedView name of the form
              #     `projects/{project}/instances/{instance}/tables/{table}/authorizedView/{authorized_view}`.
              #   @param authorized_view [::Google::Cloud::Bigtable::Admin::V2::AuthorizedView, ::Hash]
              #     Required. The AuthorizedView to create.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::CreateAuthorizedViewRequest.new
              #
              #   # Call the create_authorized_view method.
              #   result = client.create_authorized_view request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_authorized_view request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::CreateAuthorizedViewRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_authorized_view.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_authorized_view.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_authorized_view.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :create_authorized_view, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all AuthorizedViews from a specific table.
              #
              # @overload list_authorized_views(request, options = nil)
              #   Pass arguments to `list_authorized_views` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::ListAuthorizedViewsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::ListAuthorizedViewsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_authorized_views(parent: nil, page_size: nil, page_token: nil, view: nil)
              #   Pass arguments to `list_authorized_views` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The unique name of the table for which AuthorizedViews should be
              #     listed. Values are of the form
              #     `projects/{project}/instances/{instance}/tables/{table}`.
              #   @param page_size [::Integer]
              #     Optional. Maximum number of results per page.
              #
              #     A page_size of zero lets the server choose the number of items to return.
              #     A page_size which is strictly positive will return at most that many items.
              #     A negative page_size will cause an error.
              #
              #     Following the first request, subsequent paginated calls are not required
              #     to pass a page_size. If a page_size is set in subsequent calls, it must
              #     match the page_size given in the first request.
              #   @param page_token [::String]
              #     Optional. The value of `next_page_token` returned by a previous call.
              #   @param view [::Google::Cloud::Bigtable::Admin::V2::AuthorizedView::ResponseView]
              #     Optional. The resource_view to be applied to the returned AuthorizedViews'
              #     fields. Default to NAME_ONLY.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Bigtable::Admin::V2::AuthorizedView>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Bigtable::Admin::V2::AuthorizedView>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::ListAuthorizedViewsRequest.new
              #
              #   # Call the list_authorized_views method.
              #   result = client.list_authorized_views request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Bigtable::Admin::V2::AuthorizedView.
              #     p item
              #   end
              #
              def list_authorized_views request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::ListAuthorizedViewsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_authorized_views.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_authorized_views.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_authorized_views.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :list_authorized_views, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @bigtable_table_admin_stub, :list_authorized_views, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets information from a specified AuthorizedView.
              #
              # @overload get_authorized_view(request, options = nil)
              #   Pass arguments to `get_authorized_view` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::GetAuthorizedViewRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::GetAuthorizedViewRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_authorized_view(name: nil, view: nil)
              #   Pass arguments to `get_authorized_view` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The unique name of the requested AuthorizedView.
              #     Values are of the form
              #     `projects/{project}/instances/{instance}/tables/{table}/authorizedViews/{authorized_view}`.
              #   @param view [::Google::Cloud::Bigtable::Admin::V2::AuthorizedView::ResponseView]
              #     Optional. The resource_view to be applied to the returned AuthorizedView's
              #     fields. Default to BASIC.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigtable::Admin::V2::AuthorizedView]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigtable::Admin::V2::AuthorizedView]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::GetAuthorizedViewRequest.new
              #
              #   # Call the get_authorized_view method.
              #   result = client.get_authorized_view request
              #
              #   # The returned object is of type Google::Cloud::Bigtable::Admin::V2::AuthorizedView.
              #   p result
              #
              def get_authorized_view request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::GetAuthorizedViewRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_authorized_view.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_authorized_view.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_authorized_view.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :get_authorized_view, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an AuthorizedView in a table.
              #
              # @overload update_authorized_view(request, options = nil)
              #   Pass arguments to `update_authorized_view` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::UpdateAuthorizedViewRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::UpdateAuthorizedViewRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_authorized_view(authorized_view: nil, update_mask: nil, ignore_warnings: nil)
              #   Pass arguments to `update_authorized_view` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param authorized_view [::Google::Cloud::Bigtable::Admin::V2::AuthorizedView, ::Hash]
              #     Required. The AuthorizedView to update. The `name` in `authorized_view` is
              #     used to identify the AuthorizedView. AuthorizedView name must in this
              #     format:
              #     `projects/{project}/instances/{instance}/tables/{table}/authorizedViews/{authorized_view}`.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. The list of fields to update.
              #     A mask specifying which fields in the AuthorizedView resource should be
              #     updated. This mask is relative to the AuthorizedView resource, not to the
              #     request message. A field will be overwritten if it is in the mask. If
              #     empty, all fields set in the request will be overwritten. A special value
              #     `*` means to overwrite all fields (including fields not set in the
              #     request).
              #   @param ignore_warnings [::Boolean]
              #     Optional. If true, ignore the safety checks when updating the
              #     AuthorizedView.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::UpdateAuthorizedViewRequest.new
              #
              #   # Call the update_authorized_view method.
              #   result = client.update_authorized_view request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_authorized_view request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::UpdateAuthorizedViewRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_authorized_view.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.authorized_view&.name
                  header_params["authorized_view.name"] = request.authorized_view.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_authorized_view.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_authorized_view.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :update_authorized_view, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Permanently deletes a specified AuthorizedView.
              #
              # @overload delete_authorized_view(request, options = nil)
              #   Pass arguments to `delete_authorized_view` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::DeleteAuthorizedViewRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::DeleteAuthorizedViewRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_authorized_view(name: nil, etag: nil)
              #   Pass arguments to `delete_authorized_view` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The unique name of the AuthorizedView to be deleted.
              #     Values are of the form
              #     `projects/{project}/instances/{instance}/tables/{table}/authorizedViews/{authorized_view}`.
              #   @param etag [::String]
              #     Optional. The current etag of the AuthorizedView.
              #     If an etag is provided and does not match the current etag of the
              #     AuthorizedView, deletion will be blocked and an ABORTED error will be
              #     returned.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Protobuf::Empty]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::DeleteAuthorizedViewRequest.new
              #
              #   # Call the delete_authorized_view method.
              #   result = client.delete_authorized_view request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_authorized_view request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::DeleteAuthorizedViewRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_authorized_view.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_authorized_view.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_authorized_view.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :delete_authorized_view, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Performs a series of column family modifications on the specified table.
              # Either all or none of the modifications will occur before this method
              # returns, but data requests received prior to that point may see a table
              # where only some modifications have taken effect.
              #
              # @overload modify_column_families(request, options = nil)
              #   Pass arguments to `modify_column_families` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::ModifyColumnFamiliesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::ModifyColumnFamiliesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload modify_column_families(name: nil, modifications: nil, ignore_warnings: nil)
              #   Pass arguments to `modify_column_families` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The unique name of the table whose families should be modified.
              #     Values are of the form
              #     `projects/{project}/instances/{instance}/tables/{table}`.
              #   @param modifications [::Array<::Google::Cloud::Bigtable::Admin::V2::ModifyColumnFamiliesRequest::Modification, ::Hash>]
              #     Required. Modifications to be atomically applied to the specified table's
              #     families. Entries are applied in order, meaning that earlier modifications
              #     can be masked by later ones (in the case of repeated updates to the same
              #     family, for example).
              #   @param ignore_warnings [::Boolean]
              #     Optional. If true, ignore safety checks when modifying the column families.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigtable::Admin::V2::Table]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigtable::Admin::V2::Table]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::ModifyColumnFamiliesRequest.new
              #
              #   # Call the modify_column_families method.
              #   result = client.modify_column_families request
              #
              #   # The returned object is of type Google::Cloud::Bigtable::Admin::V2::Table.
              #   p result
              #
              def modify_column_families request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::ModifyColumnFamiliesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.modify_column_families.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.modify_column_families.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.modify_column_families.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :modify_column_families, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Permanently drop/delete a row range from a specified table. The request can
              # specify whether to delete all rows in a table, or only those that match a
              # particular prefix.
              #
              # @overload drop_row_range(request, options = nil)
              #   Pass arguments to `drop_row_range` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::DropRowRangeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::DropRowRangeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload drop_row_range(name: nil, row_key_prefix: nil, delete_all_data_from_table: nil)
              #   Pass arguments to `drop_row_range` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The unique name of the table on which to drop a range of rows.
              #     Values are of the form
              #     `projects/{project}/instances/{instance}/tables/{table}`.
              #   @param row_key_prefix [::String]
              #     Delete all rows that start with this row key prefix. Prefix cannot be
              #     zero length.
              #
              #     Note: The following parameters are mutually exclusive: `row_key_prefix`, `delete_all_data_from_table`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param delete_all_data_from_table [::Boolean]
              #     Delete all rows in the table. Setting this to false is a no-op.
              #
              #     Note: The following parameters are mutually exclusive: `delete_all_data_from_table`, `row_key_prefix`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Protobuf::Empty]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::DropRowRangeRequest.new
              #
              #   # Call the drop_row_range method.
              #   result = client.drop_row_range request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def drop_row_range request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::DropRowRangeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.drop_row_range.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.drop_row_range.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.drop_row_range.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :drop_row_range, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Generates a consistency token for a Table, which can be used in
              # CheckConsistency to check whether mutations to the table that finished
              # before this call started have been replicated. The tokens will be available
              # for 90 days.
              #
              # @overload generate_consistency_token(request, options = nil)
              #   Pass arguments to `generate_consistency_token` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::GenerateConsistencyTokenRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::GenerateConsistencyTokenRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload generate_consistency_token(name: nil)
              #   Pass arguments to `generate_consistency_token` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The unique name of the Table for which to create a consistency
              #     token. Values are of the form
              #     `projects/{project}/instances/{instance}/tables/{table}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigtable::Admin::V2::GenerateConsistencyTokenResponse]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigtable::Admin::V2::GenerateConsistencyTokenResponse]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::GenerateConsistencyTokenRequest.new
              #
              #   # Call the generate_consistency_token method.
              #   result = client.generate_consistency_token request
              #
              #   # The returned object is of type Google::Cloud::Bigtable::Admin::V2::GenerateConsistencyTokenResponse.
              #   p result
              #
              def generate_consistency_token request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::GenerateConsistencyTokenRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.generate_consistency_token.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.generate_consistency_token.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.generate_consistency_token.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :generate_consistency_token, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Checks replication consistency based on a consistency token, that is, if
              # replication has caught up based on the conditions specified in the token
              # and the check request.
              #
              # @overload check_consistency(request, options = nil)
              #   Pass arguments to `check_consistency` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::CheckConsistencyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::CheckConsistencyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload check_consistency(name: nil, consistency_token: nil, standard_read_remote_writes: nil, data_boost_read_local_writes: nil)
              #   Pass arguments to `check_consistency` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The unique name of the Table for which to check replication
              #     consistency. Values are of the form
              #     `projects/{project}/instances/{instance}/tables/{table}`.
              #   @param consistency_token [::String]
              #     Required. The token created using GenerateConsistencyToken for the Table.
              #   @param standard_read_remote_writes [::Google::Cloud::Bigtable::Admin::V2::StandardReadRemoteWrites, ::Hash]
              #     Checks that reads using an app profile with `StandardIsolation` can
              #     see all writes committed before the token was created, even if the
              #     read and write target different clusters.
              #
              #     Note: The following parameters are mutually exclusive: `standard_read_remote_writes`, `data_boost_read_local_writes`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param data_boost_read_local_writes [::Google::Cloud::Bigtable::Admin::V2::DataBoostReadLocalWrites, ::Hash]
              #     Checks that reads using an app profile with `DataBoostIsolationReadOnly`
              #     can see all writes committed before the token was created, but only if
              #     the read and write target the same cluster.
              #
              #     Note: The following parameters are mutually exclusive: `data_boost_read_local_writes`, `standard_read_remote_writes`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigtable::Admin::V2::CheckConsistencyResponse]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigtable::Admin::V2::CheckConsistencyResponse]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::CheckConsistencyRequest.new
              #
              #   # Call the check_consistency method.
              #   result = client.check_consistency request
              #
              #   # The returned object is of type Google::Cloud::Bigtable::Admin::V2::CheckConsistencyResponse.
              #   p result
              #
              def check_consistency request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::CheckConsistencyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.check_consistency.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.check_consistency.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.check_consistency.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :check_consistency, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new snapshot in the specified cluster from the specified
              # source table. The cluster and the table must be in the same instance.
              #
              # Note: This is a private alpha release of Cloud Bigtable snapshots. This
              # feature is not currently available to most Cloud Bigtable customers. This
              # feature might be changed in backward-incompatible ways and is not
              # recommended for production use. It is not subject to any SLA or deprecation
              # policy.
              #
              # @overload snapshot_table(request, options = nil)
              #   Pass arguments to `snapshot_table` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::SnapshotTableRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::SnapshotTableRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload snapshot_table(name: nil, cluster: nil, snapshot_id: nil, ttl: nil, description: nil)
              #   Pass arguments to `snapshot_table` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The unique name of the table to have the snapshot taken.
              #     Values are of the form
              #     `projects/{project}/instances/{instance}/tables/{table}`.
              #   @param cluster [::String]
              #     Required. The name of the cluster where the snapshot will be created in.
              #     Values are of the form
              #     `projects/{project}/instances/{instance}/clusters/{cluster}`.
              #   @param snapshot_id [::String]
              #     Required. The ID by which the new snapshot should be referred to within the
              #     parent cluster, e.g., `mysnapshot` of the form:
              #     `[_a-zA-Z0-9][-_.a-zA-Z0-9]*` rather than
              #     `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/mysnapshot`.
              #   @param ttl [::Google::Protobuf::Duration, ::Hash]
              #     The amount of time that the new snapshot can stay active after it is
              #     created. Once 'ttl' expires, the snapshot will get deleted. The maximum
              #     amount of time a snapshot can stay active is 7 days. If 'ttl' is not
              #     specified, the default value of 24 hours will be used.
              #   @param description [::String]
              #     Description of the snapshot.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::SnapshotTableRequest.new
              #
              #   # Call the snapshot_table method.
              #   result = client.snapshot_table request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def snapshot_table request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::SnapshotTableRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.snapshot_table.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.snapshot_table.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.snapshot_table.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :snapshot_table, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets metadata information about the specified snapshot.
              #
              # Note: This is a private alpha release of Cloud Bigtable snapshots. This
              # feature is not currently available to most Cloud Bigtable customers. This
              # feature might be changed in backward-incompatible ways and is not
              # recommended for production use. It is not subject to any SLA or deprecation
              # policy.
              #
              # @overload get_snapshot(request, options = nil)
              #   Pass arguments to `get_snapshot` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::GetSnapshotRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::GetSnapshotRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_snapshot(name: nil)
              #   Pass arguments to `get_snapshot` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The unique name of the requested snapshot.
              #     Values are of the form
              #     `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/{snapshot}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigtable::Admin::V2::Snapshot]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigtable::Admin::V2::Snapshot]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::GetSnapshotRequest.new
              #
              #   # Call the get_snapshot method.
              #   result = client.get_snapshot request
              #
              #   # The returned object is of type Google::Cloud::Bigtable::Admin::V2::Snapshot.
              #   p result
              #
              def get_snapshot request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::GetSnapshotRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_snapshot.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_snapshot.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_snapshot.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :get_snapshot, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all snapshots associated with the specified cluster.
              #
              # Note: This is a private alpha release of Cloud Bigtable snapshots. This
              # feature is not currently available to most Cloud Bigtable customers. This
              # feature might be changed in backward-incompatible ways and is not
              # recommended for production use. It is not subject to any SLA or deprecation
              # policy.
              #
              # @overload list_snapshots(request, options = nil)
              #   Pass arguments to `list_snapshots` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::ListSnapshotsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::ListSnapshotsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_snapshots(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_snapshots` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The unique name of the cluster for which snapshots should be
              #     listed. Values are of the form
              #     `projects/{project}/instances/{instance}/clusters/{cluster}`.
              #     Use `{cluster} = '-'` to list snapshots for all clusters in an instance,
              #     e.g., `projects/{project}/instances/{instance}/clusters/-`.
              #   @param page_size [::Integer]
              #     The maximum number of snapshots to return per page.
              #     CURRENTLY UNIMPLEMENTED AND IGNORED.
              #   @param page_token [::String]
              #     The value of `next_page_token` returned by a previous call.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Bigtable::Admin::V2::Snapshot>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Bigtable::Admin::V2::Snapshot>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::ListSnapshotsRequest.new
              #
              #   # Call the list_snapshots method.
              #   result = client.list_snapshots request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Bigtable::Admin::V2::Snapshot.
              #     p item
              #   end
              #
              def list_snapshots request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::ListSnapshotsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_snapshots.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_snapshots.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_snapshots.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :list_snapshots, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @bigtable_table_admin_stub, :list_snapshots, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Permanently deletes the specified snapshot.
              #
              # Note: This is a private alpha release of Cloud Bigtable snapshots. This
              # feature is not currently available to most Cloud Bigtable customers. This
              # feature might be changed in backward-incompatible ways and is not
              # recommended for production use. It is not subject to any SLA or deprecation
              # policy.
              #
              # @overload delete_snapshot(request, options = nil)
              #   Pass arguments to `delete_snapshot` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::DeleteSnapshotRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::DeleteSnapshotRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_snapshot(name: nil)
              #   Pass arguments to `delete_snapshot` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The unique name of the snapshot to be deleted.
              #     Values are of the form
              #     `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/{snapshot}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Protobuf::Empty]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::DeleteSnapshotRequest.new
              #
              #   # Call the delete_snapshot method.
              #   result = client.delete_snapshot request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_snapshot request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::DeleteSnapshotRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_snapshot.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_snapshot.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_snapshot.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :delete_snapshot, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Starts creating a new Cloud Bigtable Backup.  The returned backup
              # {::Google::Longrunning::Operation long-running operation} can be used to
              # track creation of the backup. The
              # {::Google::Longrunning::Operation#metadata metadata} field type is
              # {::Google::Cloud::Bigtable::Admin::V2::CreateBackupMetadata CreateBackupMetadata}. The
              # {::Google::Longrunning::Operation#response response} field type is
              # {::Google::Cloud::Bigtable::Admin::V2::Backup Backup}, if successful. Cancelling the
              # returned operation will stop the creation and delete the backup.
              #
              # @overload create_backup(request, options = nil)
              #   Pass arguments to `create_backup` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::CreateBackupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::CreateBackupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_backup(parent: nil, backup_id: nil, backup: nil)
              #   Pass arguments to `create_backup` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. This must be one of the clusters in the instance in which this
              #     table is located. The backup will be stored in this cluster. Values are
              #     of the form `projects/{project}/instances/{instance}/clusters/{cluster}`.
              #   @param backup_id [::String]
              #     Required. The id of the backup to be created. The `backup_id` along with
              #     the parent `parent` are combined as \\{parent}/backups/\\{backup_id} to create
              #     the full backup name, of the form:
              #     `projects/{project}/instances/{instance}/clusters/{cluster}/backups/{backup_id}`.
              #     This string must be between 1 and 50 characters in length and match the
              #     regex [_a-zA-Z0-9][-_.a-zA-Z0-9]*.
              #   @param backup [::Google::Cloud::Bigtable::Admin::V2::Backup, ::Hash]
              #     Required. The backup to create.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::CreateBackupRequest.new
              #
              #   # Call the create_backup method.
              #   result = client.create_backup request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_backup request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::CreateBackupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_backup.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_backup.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_backup.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :create_backup, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets metadata on a pending or completed Cloud Bigtable Backup.
              #
              # @overload get_backup(request, options = nil)
              #   Pass arguments to `get_backup` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::GetBackupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::GetBackupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_backup(name: nil)
              #   Pass arguments to `get_backup` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the backup.
              #     Values are of the form
              #     `projects/{project}/instances/{instance}/clusters/{cluster}/backups/{backup}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigtable::Admin::V2::Backup]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigtable::Admin::V2::Backup]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::GetBackupRequest.new
              #
              #   # Call the get_backup method.
              #   result = client.get_backup request
              #
              #   # The returned object is of type Google::Cloud::Bigtable::Admin::V2::Backup.
              #   p result
              #
              def get_backup request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::GetBackupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_backup.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_backup.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_backup.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :get_backup, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a pending or completed Cloud Bigtable Backup.
              #
              # @overload update_backup(request, options = nil)
              #   Pass arguments to `update_backup` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::UpdateBackupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::UpdateBackupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_backup(backup: nil, update_mask: nil)
              #   Pass arguments to `update_backup` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param backup [::Google::Cloud::Bigtable::Admin::V2::Backup, ::Hash]
              #     Required. The backup to update. `backup.name`, and the fields to be updated
              #     as specified by `update_mask` are required. Other fields are ignored.
              #     Update is only supported for the following fields:
              #
              #      * `backup.expire_time`.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. A mask specifying which fields (e.g. `expire_time`) in the
              #     Backup resource should be updated. This mask is relative to the Backup
              #     resource, not to the request message. The field mask must always be
              #     specified; this prevents any future fields from being erased accidentally
              #     by clients that do not know about them.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigtable::Admin::V2::Backup]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigtable::Admin::V2::Backup]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::UpdateBackupRequest.new
              #
              #   # Call the update_backup method.
              #   result = client.update_backup request
              #
              #   # The returned object is of type Google::Cloud::Bigtable::Admin::V2::Backup.
              #   p result
              #
              def update_backup request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::UpdateBackupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_backup.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.backup&.name
                  header_params["backup.name"] = request.backup.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_backup.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_backup.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :update_backup, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a pending or completed Cloud Bigtable backup.
              #
              # @overload delete_backup(request, options = nil)
              #   Pass arguments to `delete_backup` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::DeleteBackupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::DeleteBackupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_backup(name: nil)
              #   Pass arguments to `delete_backup` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the backup to delete.
              #     Values are of the form
              #     `projects/{project}/instances/{instance}/clusters/{cluster}/backups/{backup}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Protobuf::Empty]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::DeleteBackupRequest.new
              #
              #   # Call the delete_backup method.
              #   result = client.delete_backup request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_backup request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::DeleteBackupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_backup.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_backup.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_backup.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :delete_backup, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Cloud Bigtable backups. Returns both completed and pending
              # backups.
              #
              # @overload list_backups(request, options = nil)
              #   Pass arguments to `list_backups` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::ListBackupsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::ListBackupsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_backups(parent: nil, filter: nil, order_by: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_backups` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The cluster to list backups from.  Values are of the
              #     form `projects/{project}/instances/{instance}/clusters/{cluster}`.
              #     Use `{cluster} = '-'` to list backups for all clusters in an instance,
              #     e.g., `projects/{project}/instances/{instance}/clusters/-`.
              #   @param filter [::String]
              #     A filter expression that filters backups listed in the response.
              #     The expression must specify the field name, a comparison operator,
              #     and the value that you want to use for filtering. The value must be a
              #     string, a number, or a boolean. The comparison operator must be
              #     <, >, <=, >=, !=, =, or :. Colon ':' represents a HAS operator which is
              #     roughly synonymous with equality. Filter rules are case insensitive.
              #
              #     The fields eligible for filtering are:
              #
              #     * `name`
              #     * `source_table`
              #     * `state`
              #     * `start_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
              #     * `end_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
              #     * `expire_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
              #     * `size_bytes`
              #
              #     To filter on multiple expressions, provide each separate expression within
              #     parentheses. By default, each expression is an AND expression. However,
              #     you can include AND, OR, and NOT expressions explicitly.
              #
              #     Some examples of using filters are:
              #
              #     * `name:"exact"` --> The backup's name is the string "exact".
              #     * `name:howl` --> The backup's name contains the string "howl".
              #     * `source_table:prod`
              #            --> The source_table's name contains the string "prod".
              #     * `state:CREATING` --> The backup is pending creation.
              #     * `state:READY` --> The backup is fully created and ready for use.
              #     * `(name:howl) AND (start_time < \"2018-03-28T14:50:00Z\")`
              #            --> The backup name contains the string "howl" and start_time
              #                of the backup is before 2018-03-28T14:50:00Z.
              #     * `size_bytes > 10000000000` --> The backup's size is greater than 10GB
              #   @param order_by [::String]
              #     An expression for specifying the sort order of the results of the request.
              #     The string value should specify one or more fields in
              #     {::Google::Cloud::Bigtable::Admin::V2::Backup Backup}. The full syntax is described at
              #     https://aip.dev/132#ordering.
              #
              #     Fields supported are:
              #
              #     * name
              #     * source_table
              #     * expire_time
              #     * start_time
              #     * end_time
              #     * size_bytes
              #     * state
              #
              #     For example, "start_time". The default sorting order is ascending.
              #     To specify descending order for the field, a suffix " desc" should
              #     be appended to the field name. For example, "start_time desc".
              #     Redundant space characters in the syntax are insigificant.
              #
              #     If order_by is empty, results will be sorted by `start_time` in descending
              #     order starting from the most recently created backup.
              #   @param page_size [::Integer]
              #     Number of backups to be returned in the response. If 0 or
              #     less, defaults to the server's maximum allowed page size.
              #   @param page_token [::String]
              #     If non-empty, `page_token` should contain a
              #     {::Google::Cloud::Bigtable::Admin::V2::ListBackupsResponse#next_page_token next_page_token}
              #     from a previous
              #     {::Google::Cloud::Bigtable::Admin::V2::ListBackupsResponse ListBackupsResponse} to the
              #     same `parent` and with the same `filter`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Bigtable::Admin::V2::Backup>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Bigtable::Admin::V2::Backup>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::ListBackupsRequest.new
              #
              #   # Call the list_backups method.
              #   result = client.list_backups request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Bigtable::Admin::V2::Backup.
              #     p item
              #   end
              #
              def list_backups request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::ListBackupsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_backups.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_backups.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_backups.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :list_backups, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @bigtable_table_admin_stub, :list_backups, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Create a new table by restoring from a completed backup.  The
              # returned table {::Google::Longrunning::Operation long-running operation} can
              # be used to track the progress of the operation, and to cancel it.  The
              # {::Google::Longrunning::Operation#metadata metadata} field type is
              # {::Google::Cloud::Bigtable::Admin::V2::RestoreTableMetadata RestoreTableMetadata}.  The
              # {::Google::Longrunning::Operation#response response} type is
              # {::Google::Cloud::Bigtable::Admin::V2::Table Table}, if successful.
              #
              # @overload restore_table(request, options = nil)
              #   Pass arguments to `restore_table` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::RestoreTableRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::RestoreTableRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload restore_table(parent: nil, table_id: nil, backup: nil)
              #   Pass arguments to `restore_table` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the instance in which to create the restored
              #     table. Values are of the form `projects/<project>/instances/<instance>`.
              #   @param table_id [::String]
              #     Required. The id of the table to create and restore to. This
              #     table must not already exist. The `table_id` appended to
              #     `parent` forms the full table name of the form
              #     `projects/<project>/instances/<instance>/tables/<table_id>`.
              #   @param backup [::String]
              #     Name of the backup from which to restore.  Values are of the form
              #     `projects/<project>/instances/<instance>/clusters/<cluster>/backups/<backup>`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::RestoreTableRequest.new
              #
              #   # Call the restore_table method.
              #   result = client.restore_table request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def restore_table request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::RestoreTableRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.restore_table.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.restore_table.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.restore_table.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :restore_table, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Copy a Cloud Bigtable backup to a new backup in the destination cluster
              # located in the destination instance and project.
              #
              # @overload copy_backup(request, options = nil)
              #   Pass arguments to `copy_backup` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::CopyBackupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::CopyBackupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload copy_backup(parent: nil, backup_id: nil, source_backup: nil, expire_time: nil)
              #   Pass arguments to `copy_backup` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the destination cluster that will contain the backup
              #     copy. The cluster must already exist. Values are of the form:
              #     `projects/{project}/instances/{instance}/clusters/{cluster}`.
              #   @param backup_id [::String]
              #     Required. The id of the new backup. The `backup_id` along with `parent`
              #     are combined as \\{parent}/backups/\\{backup_id} to create the full backup
              #     name, of the form:
              #     `projects/{project}/instances/{instance}/clusters/{cluster}/backups/{backup_id}`.
              #     This string must be between 1 and 50 characters in length and match the
              #     regex [_a-zA-Z0-9][-_.a-zA-Z0-9]*.
              #   @param source_backup [::String]
              #     Required. The source backup to be copied from.
              #     The source backup needs to be in READY state for it to be copied.
              #     Copying a copied backup is not allowed.
              #     Once CopyBackup is in progress, the source backup cannot be deleted or
              #     cleaned up on expiration until CopyBackup is finished.
              #     Values are of the form:
              #     `projects/<project>/instances/<instance>/clusters/<cluster>/backups/<backup>`.
              #   @param expire_time [::Google::Protobuf::Timestamp, ::Hash]
              #     Required. Required. The expiration time of the copied backup with
              #     microsecond granularity that must be at least 6 hours and at most 30 days
              #     from the time the request is received. Once the `expire_time` has
              #     passed, Cloud Bigtable will delete the backup and free the resources used
              #     by the backup.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::CopyBackupRequest.new
              #
              #   # Call the copy_backup method.
              #   result = client.copy_backup request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def copy_backup request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::CopyBackupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.copy_backup.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.copy_backup.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.copy_backup.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :copy_backup, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the access control policy for a Bigtable resource.
              # Returns an empty policy if the resource exists but does not have a policy
              # set.
              #
              # @overload get_iam_policy(request, options = nil)
              #   Pass arguments to `get_iam_policy` via a request object, either of type
              #   {::Google::Iam::V1::GetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::GetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_iam_policy(resource: nil, options: nil)
              #   Pass arguments to `get_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param options [::Google::Iam::V1::GetPolicyOptions, ::Hash]
              #     OPTIONAL: A `GetPolicyOptions` object for specifying options to
              #     `GetIamPolicy`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Iam::V1::Policy]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::GetIamPolicyRequest.new
              #
              #   # Call the get_iam_policy method.
              #   result = client.get_iam_policy request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def get_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::GetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.resource
                  header_params["resource"] = request.resource
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_iam_policy.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :get_iam_policy, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Sets the access control policy on a Bigtable resource.
              # Replaces any existing policy.
              #
              # @overload set_iam_policy(request, options = nil)
              #   Pass arguments to `set_iam_policy` via a request object, either of type
              #   {::Google::Iam::V1::SetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::SetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload set_iam_policy(resource: nil, policy: nil, update_mask: nil)
              #   Pass arguments to `set_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being specified.
              #     See the operation documentation for the appropriate value for this field.
              #   @param policy [::Google::Iam::V1::Policy, ::Hash]
              #     REQUIRED: The complete policy to be applied to the `resource`. The size of
              #     the policy is limited to a few 10s of KB. An empty policy is a
              #     valid policy but certain Cloud Platform services (such as Projects)
              #     might reject them.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
              #     the fields in the mask will be modified. If no mask is provided, the
              #     following default mask is used:
              #
              #     `paths: "bindings, etag"`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Iam::V1::Policy]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::SetIamPolicyRequest.new
              #
              #   # Call the set_iam_policy method.
              #   result = client.set_iam_policy request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def set_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::SetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.set_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.resource
                  header_params["resource"] = request.resource
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.set_iam_policy.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.set_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :set_iam_policy, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns permissions that the caller has on the specified Bigtable
              # resource.
              #
              # @overload test_iam_permissions(request, options = nil)
              #   Pass arguments to `test_iam_permissions` via a request object, either of type
              #   {::Google::Iam::V1::TestIamPermissionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::TestIamPermissionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload test_iam_permissions(resource: nil, permissions: nil)
              #   Pass arguments to `test_iam_permissions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy detail is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param permissions [::Array<::String>]
              #     The set of permissions to check for the `resource`. Permissions with
              #     wildcards (such as '*' or 'storage.*') are not allowed. For more
              #     information see
              #     [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Iam::V1::TestIamPermissionsResponse]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Iam::V1::TestIamPermissionsResponse]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::TestIamPermissionsRequest.new
              #
              #   # Call the test_iam_permissions method.
              #   result = client.test_iam_permissions request
              #
              #   # The returned object is of type Google::Iam::V1::TestIamPermissionsResponse.
              #   p result
              #
              def test_iam_permissions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::TestIamPermissionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.test_iam_permissions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.resource
                  header_params["resource"] = request.resource
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.test_iam_permissions.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.test_iam_permissions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :test_iam_permissions, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new schema bundle in the specified table.
              #
              # @overload create_schema_bundle(request, options = nil)
              #   Pass arguments to `create_schema_bundle` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::CreateSchemaBundleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::CreateSchemaBundleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_schema_bundle(parent: nil, schema_bundle_id: nil, schema_bundle: nil)
              #   Pass arguments to `create_schema_bundle` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource where this schema bundle will be created.
              #     Values are of the form
              #     `projects/{project}/instances/{instance}/tables/{table}`.
              #   @param schema_bundle_id [::String]
              #     Required. The unique ID to use for the schema bundle, which will become the
              #     final component of the schema bundle's resource name.
              #   @param schema_bundle [::Google::Cloud::Bigtable::Admin::V2::SchemaBundle, ::Hash]
              #     Required. The schema bundle to create.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::CreateSchemaBundleRequest.new
              #
              #   # Call the create_schema_bundle method.
              #   result = client.create_schema_bundle request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_schema_bundle request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::CreateSchemaBundleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_schema_bundle.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_schema_bundle.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_schema_bundle.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :create_schema_bundle, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a schema bundle in the specified table.
              #
              # @overload update_schema_bundle(request, options = nil)
              #   Pass arguments to `update_schema_bundle` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::UpdateSchemaBundleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::UpdateSchemaBundleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_schema_bundle(schema_bundle: nil, update_mask: nil, ignore_warnings: nil)
              #   Pass arguments to `update_schema_bundle` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param schema_bundle [::Google::Cloud::Bigtable::Admin::V2::SchemaBundle, ::Hash]
              #     Required. The schema bundle to update.
              #
              #     The schema bundle's `name` field is used to identify the schema bundle to
              #     update. Values are of the form
              #     `projects/{project}/instances/{instance}/tables/{table}/schemaBundles/{schema_bundle}`
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. The list of fields to update.
              #   @param ignore_warnings [::Boolean]
              #     Optional. If set, ignore the safety checks when updating the Schema Bundle.
              #     The safety checks are:
              #     - The new Schema Bundle is backwards compatible with the existing Schema
              #     Bundle.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::UpdateSchemaBundleRequest.new
              #
              #   # Call the update_schema_bundle method.
              #   result = client.update_schema_bundle request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_schema_bundle request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::UpdateSchemaBundleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_schema_bundle.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.schema_bundle&.name
                  header_params["schema_bundle.name"] = request.schema_bundle.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_schema_bundle.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_schema_bundle.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :update_schema_bundle, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets metadata information about the specified schema bundle.
              #
              # @overload get_schema_bundle(request, options = nil)
              #   Pass arguments to `get_schema_bundle` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::GetSchemaBundleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::GetSchemaBundleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_schema_bundle(name: nil)
              #   Pass arguments to `get_schema_bundle` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The unique name of the schema bundle to retrieve.
              #     Values are of the form
              #     `projects/{project}/instances/{instance}/tables/{table}/schemaBundles/{schema_bundle}`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigtable::Admin::V2::SchemaBundle]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigtable::Admin::V2::SchemaBundle]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::GetSchemaBundleRequest.new
              #
              #   # Call the get_schema_bundle method.
              #   result = client.get_schema_bundle request
              #
              #   # The returned object is of type Google::Cloud::Bigtable::Admin::V2::SchemaBundle.
              #   p result
              #
              def get_schema_bundle request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::GetSchemaBundleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_schema_bundle.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_schema_bundle.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_schema_bundle.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :get_schema_bundle, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all schema bundles associated with the specified table.
              #
              # @overload list_schema_bundles(request, options = nil)
              #   Pass arguments to `list_schema_bundles` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::ListSchemaBundlesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::ListSchemaBundlesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_schema_bundles(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_schema_bundles` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of schema bundles.
              #     Values are of the form
              #     `projects/{project}/instances/{instance}/tables/{table}`.
              #   @param page_size [::Integer]
              #     The maximum number of schema bundles to return. If the value is positive,
              #     the server may return at most this value. If unspecified, the server will
              #     return the maximum allowed page size.
              #   @param page_token [::String]
              #     A page token, received from a previous `ListSchemaBundles` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListSchemaBundles` must
              #     match the call that provided the page token.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Bigtable::Admin::V2::SchemaBundle>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Bigtable::Admin::V2::SchemaBundle>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::ListSchemaBundlesRequest.new
              #
              #   # Call the list_schema_bundles method.
              #   result = client.list_schema_bundles request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Bigtable::Admin::V2::SchemaBundle.
              #     p item
              #   end
              #
              def list_schema_bundles request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::ListSchemaBundlesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_schema_bundles.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_schema_bundles.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_schema_bundles.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :list_schema_bundles, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @bigtable_table_admin_stub, :list_schema_bundles, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a schema bundle in the specified table.
              #
              # @overload delete_schema_bundle(request, options = nil)
              #   Pass arguments to `delete_schema_bundle` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::DeleteSchemaBundleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::DeleteSchemaBundleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_schema_bundle(name: nil, etag: nil)
              #   Pass arguments to `delete_schema_bundle` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The unique name of the schema bundle to delete.
              #     Values are of the form
              #     `projects/{project}/instances/{instance}/tables/{table}/schemaBundles/{schema_bundle}`
              #   @param etag [::String]
              #     Optional. The etag of the schema bundle.
              #     If this is provided, it must match the server's etag. The server
              #     returns an ABORTED error on a mismatched etag.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Protobuf::Empty]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::DeleteSchemaBundleRequest.new
              #
              #   # Call the delete_schema_bundle method.
              #   result = client.delete_schema_bundle request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_schema_bundle request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::DeleteSchemaBundleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_schema_bundle.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_schema_bundle.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_schema_bundle.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_table_admin_stub.call_rpc :delete_schema_bundle, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the BigtableTableAdmin API.
              #
              # This class represents the configuration for BigtableTableAdmin,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_table to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_table.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_table.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
              #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
              #    *  (`nil`) indicating no credentials
              #
              #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
              #     is deprecated. Providing an unvalidated credential configuration to
              #     Google APIs can compromise the security of your systems and data.
              #
              #   @example
              #
              #     # The recommended way to provide credentials is to use the `make_creds` method
              #     # on the appropriate credentials class for your environment.
              #
              #     require "googleauth"
              #
              #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
              #       json_key_io: ::File.open("/path/to/keyfile.json")
              #     )
              #
              #     client = ::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client.new do |config|
              #       config.credentials = credentials
              #     end
              #
              #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] channel_args
              #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
              #   `GRPC::Core::Channel` object is provided as the credential.
              #   @return [::Hash]
              # @!attribute [rw] interceptors
              #   An array of interceptors that are run before calls are executed.
              #   @return [::Array<::GRPC::ClientInterceptor>]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional gRPC headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "bigtableadmin.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
                config_attr :interceptors,  nil, ::Array, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration for the channel pool
                # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
                #
                def channel_pool
                  @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
                end

                ##
                # Configuration RPC class for the BigtableTableAdmin API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_table`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_table
                  ##
                  # RPC-specific configuration for `create_table_from_snapshot`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_table_from_snapshot
                  ##
                  # RPC-specific configuration for `list_tables`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_tables
                  ##
                  # RPC-specific configuration for `get_table`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_table
                  ##
                  # RPC-specific configuration for `update_table`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_table
                  ##
                  # RPC-specific configuration for `delete_table`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_table
                  ##
                  # RPC-specific configuration for `undelete_table`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :undelete_table
                  ##
                  # RPC-specific configuration for `create_authorized_view`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_authorized_view
                  ##
                  # RPC-specific configuration for `list_authorized_views`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_authorized_views
                  ##
                  # RPC-specific configuration for `get_authorized_view`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_authorized_view
                  ##
                  # RPC-specific configuration for `update_authorized_view`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_authorized_view
                  ##
                  # RPC-specific configuration for `delete_authorized_view`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_authorized_view
                  ##
                  # RPC-specific configuration for `modify_column_families`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :modify_column_families
                  ##
                  # RPC-specific configuration for `drop_row_range`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :drop_row_range
                  ##
                  # RPC-specific configuration for `generate_consistency_token`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :generate_consistency_token
                  ##
                  # RPC-specific configuration for `check_consistency`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :check_consistency
                  ##
                  # RPC-specific configuration for `snapshot_table`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :snapshot_table
                  ##
                  # RPC-specific configuration for `get_snapshot`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_snapshot
                  ##
                  # RPC-specific configuration for `list_snapshots`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_snapshots
                  ##
                  # RPC-specific configuration for `delete_snapshot`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_snapshot
                  ##
                  # RPC-specific configuration for `create_backup`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_backup
                  ##
                  # RPC-specific configuration for `get_backup`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_backup
                  ##
                  # RPC-specific configuration for `update_backup`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_backup
                  ##
                  # RPC-specific configuration for `delete_backup`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_backup
                  ##
                  # RPC-specific configuration for `list_backups`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_backups
                  ##
                  # RPC-specific configuration for `restore_table`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :restore_table
                  ##
                  # RPC-specific configuration for `copy_backup`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :copy_backup
                  ##
                  # RPC-specific configuration for `get_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_iam_policy
                  ##
                  # RPC-specific configuration for `set_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_iam_policy
                  ##
                  # RPC-specific configuration for `test_iam_permissions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :test_iam_permissions
                  ##
                  # RPC-specific configuration for `create_schema_bundle`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_schema_bundle
                  ##
                  # RPC-specific configuration for `update_schema_bundle`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_schema_bundle
                  ##
                  # RPC-specific configuration for `get_schema_bundle`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_schema_bundle
                  ##
                  # RPC-specific configuration for `list_schema_bundles`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_schema_bundles
                  ##
                  # RPC-specific configuration for `delete_schema_bundle`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_schema_bundle

                  # @private
                  def initialize parent_rpcs = nil
                    create_table_config = parent_rpcs.create_table if parent_rpcs.respond_to? :create_table
                    @create_table = ::Gapic::Config::Method.new create_table_config
                    create_table_from_snapshot_config = parent_rpcs.create_table_from_snapshot if parent_rpcs.respond_to? :create_table_from_snapshot
                    @create_table_from_snapshot = ::Gapic::Config::Method.new create_table_from_snapshot_config
                    list_tables_config = parent_rpcs.list_tables if parent_rpcs.respond_to? :list_tables
                    @list_tables = ::Gapic::Config::Method.new list_tables_config
                    get_table_config = parent_rpcs.get_table if parent_rpcs.respond_to? :get_table
                    @get_table = ::Gapic::Config::Method.new get_table_config
                    update_table_config = parent_rpcs.update_table if parent_rpcs.respond_to? :update_table
                    @update_table = ::Gapic::Config::Method.new update_table_config
                    delete_table_config = parent_rpcs.delete_table if parent_rpcs.respond_to? :delete_table
                    @delete_table = ::Gapic::Config::Method.new delete_table_config
                    undelete_table_config = parent_rpcs.undelete_table if parent_rpcs.respond_to? :undelete_table
                    @undelete_table = ::Gapic::Config::Method.new undelete_table_config
                    create_authorized_view_config = parent_rpcs.create_authorized_view if parent_rpcs.respond_to? :create_authorized_view
                    @create_authorized_view = ::Gapic::Config::Method.new create_authorized_view_config
                    list_authorized_views_config = parent_rpcs.list_authorized_views if parent_rpcs.respond_to? :list_authorized_views
                    @list_authorized_views = ::Gapic::Config::Method.new list_authorized_views_config
                    get_authorized_view_config = parent_rpcs.get_authorized_view if parent_rpcs.respond_to? :get_authorized_view
                    @get_authorized_view = ::Gapic::Config::Method.new get_authorized_view_config
                    update_authorized_view_config = parent_rpcs.update_authorized_view if parent_rpcs.respond_to? :update_authorized_view
                    @update_authorized_view = ::Gapic::Config::Method.new update_authorized_view_config
                    delete_authorized_view_config = parent_rpcs.delete_authorized_view if parent_rpcs.respond_to? :delete_authorized_view
                    @delete_authorized_view = ::Gapic::Config::Method.new delete_authorized_view_config
                    modify_column_families_config = parent_rpcs.modify_column_families if parent_rpcs.respond_to? :modify_column_families
                    @modify_column_families = ::Gapic::Config::Method.new modify_column_families_config
                    drop_row_range_config = parent_rpcs.drop_row_range if parent_rpcs.respond_to? :drop_row_range
                    @drop_row_range = ::Gapic::Config::Method.new drop_row_range_config
                    generate_consistency_token_config = parent_rpcs.generate_consistency_token if parent_rpcs.respond_to? :generate_consistency_token
                    @generate_consistency_token = ::Gapic::Config::Method.new generate_consistency_token_config
                    check_consistency_config = parent_rpcs.check_consistency if parent_rpcs.respond_to? :check_consistency
                    @check_consistency = ::Gapic::Config::Method.new check_consistency_config
                    snapshot_table_config = parent_rpcs.snapshot_table if parent_rpcs.respond_to? :snapshot_table
                    @snapshot_table = ::Gapic::Config::Method.new snapshot_table_config
                    get_snapshot_config = parent_rpcs.get_snapshot if parent_rpcs.respond_to? :get_snapshot
                    @get_snapshot = ::Gapic::Config::Method.new get_snapshot_config
                    list_snapshots_config = parent_rpcs.list_snapshots if parent_rpcs.respond_to? :list_snapshots
                    @list_snapshots = ::Gapic::Config::Method.new list_snapshots_config
                    delete_snapshot_config = parent_rpcs.delete_snapshot if parent_rpcs.respond_to? :delete_snapshot
                    @delete_snapshot = ::Gapic::Config::Method.new delete_snapshot_config
                    create_backup_config = parent_rpcs.create_backup if parent_rpcs.respond_to? :create_backup
                    @create_backup = ::Gapic::Config::Method.new create_backup_config
                    get_backup_config = parent_rpcs.get_backup if parent_rpcs.respond_to? :get_backup
                    @get_backup = ::Gapic::Config::Method.new get_backup_config
                    update_backup_config = parent_rpcs.update_backup if parent_rpcs.respond_to? :update_backup
                    @update_backup = ::Gapic::Config::Method.new update_backup_config
                    delete_backup_config = parent_rpcs.delete_backup if parent_rpcs.respond_to? :delete_backup
                    @delete_backup = ::Gapic::Config::Method.new delete_backup_config
                    list_backups_config = parent_rpcs.list_backups if parent_rpcs.respond_to? :list_backups
                    @list_backups = ::Gapic::Config::Method.new list_backups_config
                    restore_table_config = parent_rpcs.restore_table if parent_rpcs.respond_to? :restore_table
                    @restore_table = ::Gapic::Config::Method.new restore_table_config
                    copy_backup_config = parent_rpcs.copy_backup if parent_rpcs.respond_to? :copy_backup
                    @copy_backup = ::Gapic::Config::Method.new copy_backup_config
                    get_iam_policy_config = parent_rpcs.get_iam_policy if parent_rpcs.respond_to? :get_iam_policy
                    @get_iam_policy = ::Gapic::Config::Method.new get_iam_policy_config
                    set_iam_policy_config = parent_rpcs.set_iam_policy if parent_rpcs.respond_to? :set_iam_policy
                    @set_iam_policy = ::Gapic::Config::Method.new set_iam_policy_config
                    test_iam_permissions_config = parent_rpcs.test_iam_permissions if parent_rpcs.respond_to? :test_iam_permissions
                    @test_iam_permissions = ::Gapic::Config::Method.new test_iam_permissions_config
                    create_schema_bundle_config = parent_rpcs.create_schema_bundle if parent_rpcs.respond_to? :create_schema_bundle
                    @create_schema_bundle = ::Gapic::Config::Method.new create_schema_bundle_config
                    update_schema_bundle_config = parent_rpcs.update_schema_bundle if parent_rpcs.respond_to? :update_schema_bundle
                    @update_schema_bundle = ::Gapic::Config::Method.new update_schema_bundle_config
                    get_schema_bundle_config = parent_rpcs.get_schema_bundle if parent_rpcs.respond_to? :get_schema_bundle
                    @get_schema_bundle = ::Gapic::Config::Method.new get_schema_bundle_config
                    list_schema_bundles_config = parent_rpcs.list_schema_bundles if parent_rpcs.respond_to? :list_schema_bundles
                    @list_schema_bundles = ::Gapic::Config::Method.new list_schema_bundles_config
                    delete_schema_bundle_config = parent_rpcs.delete_schema_bundle if parent_rpcs.respond_to? :delete_schema_bundle
                    @delete_schema_bundle = ::Gapic::Config::Method.new delete_schema_bundle_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
