# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/bigtable/admin/v2/bigtable_instance_admin_pb"

module Google
  module Cloud
    module Bigtable
      module Admin
        module V2
          module BigtableInstanceAdmin
            ##
            # Client for the BigtableInstanceAdmin service.
            #
            # Service for creating, configuring, and deleting Cloud Bigtable Instances and
            # Clusters. Provides access to the Instance and Cluster schemas only, not the
            # tables' metadata or data stored in those tables.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "bigtableadmin.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :bigtable_instance_admin_stub

              ##
              # Configure the BigtableInstanceAdmin Client class.
              #
              # See {::Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all BigtableInstanceAdmin clients
              #   ::Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Bigtable", "Admin", "V2"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.create_instance.timeout = 300.0

                  default_config.rpcs.get_instance.timeout = 60.0
                  default_config.rpcs.get_instance.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_instances.timeout = 60.0
                  default_config.rpcs.list_instances.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [14, 4]
                  }

                  default_config.rpcs.update_instance.timeout = 60.0
                  default_config.rpcs.update_instance.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [14, 4]
                  }

                  default_config.rpcs.partial_update_instance.timeout = 60.0
                  default_config.rpcs.partial_update_instance.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [14, 4]
                  }

                  default_config.rpcs.delete_instance.timeout = 60.0

                  default_config.rpcs.create_cluster.timeout = 60.0

                  default_config.rpcs.get_cluster.timeout = 60.0
                  default_config.rpcs.get_cluster.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_clusters.timeout = 60.0
                  default_config.rpcs.list_clusters.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [14, 4]
                  }

                  default_config.rpcs.update_cluster.timeout = 60.0
                  default_config.rpcs.update_cluster.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [14, 4]
                  }

                  default_config.rpcs.delete_cluster.timeout = 60.0

                  default_config.rpcs.create_app_profile.timeout = 60.0

                  default_config.rpcs.get_app_profile.timeout = 60.0
                  default_config.rpcs.get_app_profile.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_app_profiles.timeout = 60.0
                  default_config.rpcs.list_app_profiles.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [14, 4]
                  }

                  default_config.rpcs.update_app_profile.timeout = 60.0
                  default_config.rpcs.update_app_profile.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [14, 4]
                  }

                  default_config.rpcs.delete_app_profile.timeout = 60.0

                  default_config.rpcs.get_iam_policy.timeout = 60.0
                  default_config.rpcs.get_iam_policy.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [14, 4]
                  }

                  default_config.rpcs.set_iam_policy.timeout = 60.0

                  default_config.rpcs.test_iam_permissions.timeout = 60.0
                  default_config.rpcs.test_iam_permissions.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_hot_tablets.timeout = 60.0
                  default_config.rpcs.list_hot_tablets.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 2, retry_codes: [14, 4]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the BigtableInstanceAdmin Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @bigtable_instance_admin_stub.universe_domain
              end

              ##
              # Create a new BigtableInstanceAdmin client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the BigtableInstanceAdmin client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # These require statements are intentionally placed here to initialize
                # the gRPC module only when it's required.
                # See https://github.com/googleapis/toolkit/issues/446
                require "gapic/grpc"
                require "google/bigtable/admin/v2/bigtable_instance_admin_services_pb"

                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end
                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @bigtable_instance_admin_stub = ::Gapic::ServiceStub.new(
                  ::Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Stub,
                  credentials: credentials,
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  channel_args: @config.channel_args,
                  interceptors: @config.interceptors,
                  channel_pool_config: @config.channel_pool,
                  logger: @config.logger
                )

                @bigtable_instance_admin_stub.stub_logger&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Operations]
              #
              attr_reader :operations_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @bigtable_instance_admin_stub.logger
              end

              # Service calls

              ##
              # Create an instance within a project.
              #
              # Note that exactly one of Cluster.serve_nodes and
              # Cluster.cluster_config.cluster_autoscaling_config can be set. If
              # serve_nodes is set to non-zero, then the cluster is manually scaled. If
              # cluster_config.cluster_autoscaling_config is non-empty, then autoscaling is
              # enabled.
              #
              # @overload create_instance(request, options = nil)
              #   Pass arguments to `create_instance` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::CreateInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::CreateInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_instance(parent: nil, instance_id: nil, instance: nil, clusters: nil)
              #   Pass arguments to `create_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The unique name of the project in which to create the new
              #     instance. Values are of the form `projects/{project}`.
              #   @param instance_id [::String]
              #     Required. The ID to be used when referring to the new instance within its
              #     project, e.g., just `myinstance` rather than
              #     `projects/myproject/instances/myinstance`.
              #   @param instance [::Google::Cloud::Bigtable::Admin::V2::Instance, ::Hash]
              #     Required. The instance to create.
              #     Fields marked `OutputOnly` must be left blank.
              #   @param clusters [::Hash{::String => ::Google::Cloud::Bigtable::Admin::V2::Cluster, ::Hash}]
              #     Required. The clusters to be created within the instance, mapped by desired
              #     cluster ID, e.g., just `mycluster` rather than
              #     `projects/myproject/instances/myinstance/clusters/mycluster`.
              #     Fields marked `OutputOnly` must be left blank.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::CreateInstanceRequest.new
              #
              #   # Call the create_instance method.
              #   result = client.create_instance request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::CreateInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_instance.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :create_instance, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets information about an instance.
              #
              # @overload get_instance(request, options = nil)
              #   Pass arguments to `get_instance` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::GetInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::GetInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_instance(name: nil)
              #   Pass arguments to `get_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The unique name of the requested instance. Values are of the form
              #     `projects/{project}/instances/{instance}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigtable::Admin::V2::Instance]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigtable::Admin::V2::Instance]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::GetInstanceRequest.new
              #
              #   # Call the get_instance method.
              #   result = client.get_instance request
              #
              #   # The returned object is of type Google::Cloud::Bigtable::Admin::V2::Instance.
              #   p result
              #
              def get_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::GetInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_instance.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :get_instance, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists information about instances in a project.
              #
              # @overload list_instances(request, options = nil)
              #   Pass arguments to `list_instances` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::ListInstancesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::ListInstancesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_instances(parent: nil, page_token: nil)
              #   Pass arguments to `list_instances` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The unique name of the project for which a list of instances is
              #     requested. Values are of the form `projects/{project}`.
              #   @param page_token [::String]
              #     DEPRECATED: This field is unused and ignored.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigtable::Admin::V2::ListInstancesResponse]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigtable::Admin::V2::ListInstancesResponse]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::ListInstancesRequest.new
              #
              #   # Call the list_instances method.
              #   result = client.list_instances request
              #
              #   # The returned object is of type Google::Cloud::Bigtable::Admin::V2::ListInstancesResponse.
              #   p result
              #
              def list_instances request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::ListInstancesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_instances.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_instances.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_instances.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :list_instances, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an instance within a project. This method updates only the display
              # name and type for an Instance. To update other Instance properties, such as
              # labels, use PartialUpdateInstance.
              #
              # @overload update_instance(request, options = nil)
              #   Pass arguments to `update_instance` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::Instance} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::Instance, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_instance(name: nil, display_name: nil, type: nil, labels: nil, tags: nil)
              #   Pass arguments to `update_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     The unique name of the instance. Values are of the form
              #     `projects/{project}/instances/[a-z][a-z0-9\\-]+[a-z0-9]`.
              #   @param display_name [::String]
              #     Required. The descriptive name for this instance as it appears in UIs.
              #     Can be changed at any time, but should be kept globally unique
              #     to avoid confusion.
              #   @param type [::Google::Cloud::Bigtable::Admin::V2::Instance::Type]
              #     The type of the instance. Defaults to `PRODUCTION`.
              #   @param labels [::Hash{::String => ::String}]
              #     Labels are a flexible and lightweight mechanism for organizing cloud
              #     resources into groups that reflect a customer's organizational needs and
              #     deployment strategies. They can be used to filter resources and aggregate
              #     metrics.
              #
              #     * Label keys must be between 1 and 63 characters long and must conform to
              #       the regular expression: `[\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}`.
              #     * Label values must be between 0 and 63 characters long and must conform to
              #       the regular expression: `[\p{Ll}\p{Lo}\p{N}_-]{0,63}`.
              #     * No more than 64 labels can be associated with a given resource.
              #     * Keys and values must both be under 128 bytes.
              #   @param tags [::Hash{::String => ::String}]
              #     Optional. Input only. Immutable. Tag keys/values directly bound to this
              #     resource. For example:
              #     - "123/environment": "production",
              #     - "123/costCenter": "marketing"
              #
              #     Tags and Labels (above) are both used to bind metadata to resources, with
              #     different use-cases. See
              #     https://cloud.google.com/resource-manager/docs/tags/tags-overview for an
              #     in-depth overview on the difference between tags and labels.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigtable::Admin::V2::Instance]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigtable::Admin::V2::Instance]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::Instance.new
              #
              #   # Call the update_instance method.
              #   result = client.update_instance request
              #
              #   # The returned object is of type Google::Cloud::Bigtable::Admin::V2::Instance.
              #   p result
              #
              def update_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::Instance

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_instance.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :update_instance, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Partially updates an instance within a project. This method can modify all
              # fields of an Instance and is the preferred way to update an Instance.
              #
              # @overload partial_update_instance(request, options = nil)
              #   Pass arguments to `partial_update_instance` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::PartialUpdateInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::PartialUpdateInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload partial_update_instance(instance: nil, update_mask: nil)
              #   Pass arguments to `partial_update_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::Google::Cloud::Bigtable::Admin::V2::Instance, ::Hash]
              #     Required. The Instance which will (partially) replace the current value.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The subset of Instance fields which should be replaced.
              #     Must be explicitly set.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::PartialUpdateInstanceRequest.new
              #
              #   # Call the partial_update_instance method.
              #   result = client.partial_update_instance request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def partial_update_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::PartialUpdateInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.partial_update_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.instance&.name
                  header_params["instance.name"] = request.instance.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.partial_update_instance.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.partial_update_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :partial_update_instance, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Delete an instance from a project.
              #
              # @overload delete_instance(request, options = nil)
              #   Pass arguments to `delete_instance` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::DeleteInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::DeleteInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_instance(name: nil)
              #   Pass arguments to `delete_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The unique name of the instance to be deleted.
              #     Values are of the form `projects/{project}/instances/{instance}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Protobuf::Empty]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::DeleteInstanceRequest.new
              #
              #   # Call the delete_instance method.
              #   result = client.delete_instance request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::DeleteInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_instance.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :delete_instance, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a cluster within an instance.
              #
              # Note that exactly one of Cluster.serve_nodes and
              # Cluster.cluster_config.cluster_autoscaling_config can be set. If
              # serve_nodes is set to non-zero, then the cluster is manually scaled. If
              # cluster_config.cluster_autoscaling_config is non-empty, then autoscaling is
              # enabled.
              #
              # @overload create_cluster(request, options = nil)
              #   Pass arguments to `create_cluster` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::CreateClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::CreateClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_cluster(parent: nil, cluster_id: nil, cluster: nil)
              #   Pass arguments to `create_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The unique name of the instance in which to create the new
              #     cluster. Values are of the form `projects/{project}/instances/{instance}`.
              #   @param cluster_id [::String]
              #     Required. The ID to be used when referring to the new cluster within its
              #     instance, e.g., just `mycluster` rather than
              #     `projects/myproject/instances/myinstance/clusters/mycluster`.
              #   @param cluster [::Google::Cloud::Bigtable::Admin::V2::Cluster, ::Hash]
              #     Required. The cluster to be created.
              #     Fields marked `OutputOnly` must be left blank.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::CreateClusterRequest.new
              #
              #   # Call the create_cluster method.
              #   result = client.create_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::CreateClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_cluster.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :create_cluster, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets information about a cluster.
              #
              # @overload get_cluster(request, options = nil)
              #   Pass arguments to `get_cluster` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::GetClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::GetClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_cluster(name: nil)
              #   Pass arguments to `get_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The unique name of the requested cluster. Values are of the form
              #     `projects/{project}/instances/{instance}/clusters/{cluster}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigtable::Admin::V2::Cluster]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigtable::Admin::V2::Cluster]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::GetClusterRequest.new
              #
              #   # Call the get_cluster method.
              #   result = client.get_cluster request
              #
              #   # The returned object is of type Google::Cloud::Bigtable::Admin::V2::Cluster.
              #   p result
              #
              def get_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::GetClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_cluster.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :get_cluster, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists information about clusters in an instance.
              #
              # @overload list_clusters(request, options = nil)
              #   Pass arguments to `list_clusters` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::ListClustersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::ListClustersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_clusters(parent: nil, page_token: nil)
              #   Pass arguments to `list_clusters` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The unique name of the instance for which a list of clusters is
              #     requested. Values are of the form
              #     `projects/{project}/instances/{instance}`. Use `{instance} = '-'` to list
              #     Clusters for all Instances in a project, e.g.,
              #     `projects/myproject/instances/-`.
              #   @param page_token [::String]
              #     DEPRECATED: This field is unused and ignored.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigtable::Admin::V2::ListClustersResponse]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigtable::Admin::V2::ListClustersResponse]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::ListClustersRequest.new
              #
              #   # Call the list_clusters method.
              #   result = client.list_clusters request
              #
              #   # The returned object is of type Google::Cloud::Bigtable::Admin::V2::ListClustersResponse.
              #   p result
              #
              def list_clusters request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::ListClustersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_clusters.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_clusters.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_clusters.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :list_clusters, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a cluster within an instance.
              #
              # Note that UpdateCluster does not support updating
              # cluster_config.cluster_autoscaling_config. In order to update it, you
              # must use PartialUpdateCluster.
              #
              # @overload update_cluster(request, options = nil)
              #   Pass arguments to `update_cluster` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::Cluster} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::Cluster, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_cluster(name: nil, location: nil, serve_nodes: nil, node_scaling_factor: nil, cluster_config: nil, default_storage_type: nil, encryption_config: nil)
              #   Pass arguments to `update_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     The unique name of the cluster. Values are of the form
              #     `projects/{project}/instances/{instance}/clusters/[a-z][-a-z0-9]*`.
              #   @param location [::String]
              #     Immutable. The location where this cluster's nodes and storage reside. For
              #     best performance, clients should be located as close as possible to this
              #     cluster. Currently only zones are supported, so values should be of the
              #     form `projects/{project}/locations/{zone}`.
              #   @param serve_nodes [::Integer]
              #     The number of nodes in the cluster. If no value is set,
              #     Cloud Bigtable automatically allocates nodes based on your data footprint
              #     and optimized for 50% storage utilization.
              #   @param node_scaling_factor [::Google::Cloud::Bigtable::Admin::V2::Cluster::NodeScalingFactor]
              #     Immutable. The node scaling factor of this cluster.
              #   @param cluster_config [::Google::Cloud::Bigtable::Admin::V2::Cluster::ClusterConfig, ::Hash]
              #     Configuration for this cluster.
              #   @param default_storage_type [::Google::Cloud::Bigtable::Admin::V2::StorageType]
              #     Immutable. The type of storage used by this cluster to serve its
              #     parent instance's tables, unless explicitly overridden.
              #   @param encryption_config [::Google::Cloud::Bigtable::Admin::V2::Cluster::EncryptionConfig, ::Hash]
              #     Immutable. The encryption configuration for CMEK-protected clusters.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::Cluster.new
              #
              #   # Call the update_cluster method.
              #   result = client.update_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::Cluster

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_cluster.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :update_cluster, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Partially updates a cluster within a project. This method is the preferred
              # way to update a Cluster.
              #
              # To enable and update autoscaling, set
              # cluster_config.cluster_autoscaling_config. When autoscaling is enabled,
              # serve_nodes is treated as an OUTPUT_ONLY field, meaning that updates to it
              # are ignored. Note that an update cannot simultaneously set serve_nodes to
              # non-zero and cluster_config.cluster_autoscaling_config to non-empty, and
              # also specify both in the update_mask.
              #
              # To disable autoscaling, clear cluster_config.cluster_autoscaling_config,
              # and explicitly set a serve_node count via the update_mask.
              #
              # @overload partial_update_cluster(request, options = nil)
              #   Pass arguments to `partial_update_cluster` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::PartialUpdateClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::PartialUpdateClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload partial_update_cluster(cluster: nil, update_mask: nil)
              #   Pass arguments to `partial_update_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param cluster [::Google::Cloud::Bigtable::Admin::V2::Cluster, ::Hash]
              #     Required. The Cluster which contains the partial updates to be applied,
              #     subject to the update_mask.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The subset of Cluster fields which should be replaced.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::PartialUpdateClusterRequest.new
              #
              #   # Call the partial_update_cluster method.
              #   result = client.partial_update_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def partial_update_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::PartialUpdateClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.partial_update_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.cluster&.name
                  header_params["cluster.name"] = request.cluster.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.partial_update_cluster.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.partial_update_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :partial_update_cluster, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a cluster from an instance.
              #
              # @overload delete_cluster(request, options = nil)
              #   Pass arguments to `delete_cluster` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::DeleteClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::DeleteClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_cluster(name: nil)
              #   Pass arguments to `delete_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The unique name of the cluster to be deleted. Values are of the
              #     form `projects/{project}/instances/{instance}/clusters/{cluster}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Protobuf::Empty]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::DeleteClusterRequest.new
              #
              #   # Call the delete_cluster method.
              #   result = client.delete_cluster request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::DeleteClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_cluster.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :delete_cluster, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an app profile within an instance.
              #
              # @overload create_app_profile(request, options = nil)
              #   Pass arguments to `create_app_profile` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::CreateAppProfileRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::CreateAppProfileRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_app_profile(parent: nil, app_profile_id: nil, app_profile: nil, ignore_warnings: nil)
              #   Pass arguments to `create_app_profile` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The unique name of the instance in which to create the new app
              #     profile. Values are of the form `projects/{project}/instances/{instance}`.
              #   @param app_profile_id [::String]
              #     Required. The ID to be used when referring to the new app profile within
              #     its instance, e.g., just `myprofile` rather than
              #     `projects/myproject/instances/myinstance/appProfiles/myprofile`.
              #   @param app_profile [::Google::Cloud::Bigtable::Admin::V2::AppProfile, ::Hash]
              #     Required. The app profile to be created.
              #     Fields marked `OutputOnly` will be ignored.
              #   @param ignore_warnings [::Boolean]
              #     If true, ignore safety checks when creating the app profile.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigtable::Admin::V2::AppProfile]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigtable::Admin::V2::AppProfile]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::CreateAppProfileRequest.new
              #
              #   # Call the create_app_profile method.
              #   result = client.create_app_profile request
              #
              #   # The returned object is of type Google::Cloud::Bigtable::Admin::V2::AppProfile.
              #   p result
              #
              def create_app_profile request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::CreateAppProfileRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_app_profile.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_app_profile.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_app_profile.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :create_app_profile, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets information about an app profile.
              #
              # @overload get_app_profile(request, options = nil)
              #   Pass arguments to `get_app_profile` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::GetAppProfileRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::GetAppProfileRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_app_profile(name: nil)
              #   Pass arguments to `get_app_profile` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The unique name of the requested app profile. Values are of the
              #     form `projects/{project}/instances/{instance}/appProfiles/{app_profile}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigtable::Admin::V2::AppProfile]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigtable::Admin::V2::AppProfile]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::GetAppProfileRequest.new
              #
              #   # Call the get_app_profile method.
              #   result = client.get_app_profile request
              #
              #   # The returned object is of type Google::Cloud::Bigtable::Admin::V2::AppProfile.
              #   p result
              #
              def get_app_profile request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::GetAppProfileRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_app_profile.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_app_profile.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_app_profile.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :get_app_profile, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists information about app profiles in an instance.
              #
              # @overload list_app_profiles(request, options = nil)
              #   Pass arguments to `list_app_profiles` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::ListAppProfilesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::ListAppProfilesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_app_profiles(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_app_profiles` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The unique name of the instance for which a list of app profiles
              #     is requested. Values are of the form
              #     `projects/{project}/instances/{instance}`.
              #     Use `{instance} = '-'` to list AppProfiles for all Instances in a project,
              #     e.g., `projects/myproject/instances/-`.
              #   @param page_size [::Integer]
              #     Maximum number of results per page.
              #
              #     A page_size of zero lets the server choose the number of items to return.
              #     A page_size which is strictly positive will return at most that many items.
              #     A negative page_size will cause an error.
              #
              #     Following the first request, subsequent paginated calls are not required
              #     to pass a page_size. If a page_size is set in subsequent calls, it must
              #     match the page_size given in the first request.
              #   @param page_token [::String]
              #     The value of `next_page_token` returned by a previous call.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Bigtable::Admin::V2::AppProfile>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Bigtable::Admin::V2::AppProfile>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::ListAppProfilesRequest.new
              #
              #   # Call the list_app_profiles method.
              #   result = client.list_app_profiles request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Bigtable::Admin::V2::AppProfile.
              #     p item
              #   end
              #
              def list_app_profiles request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::ListAppProfilesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_app_profiles.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_app_profiles.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_app_profiles.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :list_app_profiles, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @bigtable_instance_admin_stub, :list_app_profiles, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an app profile within an instance.
              #
              # @overload update_app_profile(request, options = nil)
              #   Pass arguments to `update_app_profile` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::UpdateAppProfileRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::UpdateAppProfileRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_app_profile(app_profile: nil, update_mask: nil, ignore_warnings: nil)
              #   Pass arguments to `update_app_profile` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param app_profile [::Google::Cloud::Bigtable::Admin::V2::AppProfile, ::Hash]
              #     Required. The app profile which will (partially) replace the current value.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The subset of app profile fields which should be replaced.
              #     If unset, all fields will be replaced.
              #   @param ignore_warnings [::Boolean]
              #     If true, ignore safety checks when updating the app profile.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::UpdateAppProfileRequest.new
              #
              #   # Call the update_app_profile method.
              #   result = client.update_app_profile request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_app_profile request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::UpdateAppProfileRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_app_profile.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.app_profile&.name
                  header_params["app_profile.name"] = request.app_profile.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_app_profile.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_app_profile.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :update_app_profile, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an app profile from an instance.
              #
              # @overload delete_app_profile(request, options = nil)
              #   Pass arguments to `delete_app_profile` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::DeleteAppProfileRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::DeleteAppProfileRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_app_profile(name: nil, ignore_warnings: nil)
              #   Pass arguments to `delete_app_profile` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The unique name of the app profile to be deleted. Values are of
              #     the form
              #     `projects/{project}/instances/{instance}/appProfiles/{app_profile}`.
              #   @param ignore_warnings [::Boolean]
              #     Required. If true, ignore safety checks when deleting the app profile.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Protobuf::Empty]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::DeleteAppProfileRequest.new
              #
              #   # Call the delete_app_profile method.
              #   result = client.delete_app_profile request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_app_profile request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::DeleteAppProfileRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_app_profile.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_app_profile.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_app_profile.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :delete_app_profile, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the access control policy for an instance resource. Returns an empty
              # policy if an instance exists but does not have a policy set.
              #
              # @overload get_iam_policy(request, options = nil)
              #   Pass arguments to `get_iam_policy` via a request object, either of type
              #   {::Google::Iam::V1::GetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::GetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_iam_policy(resource: nil, options: nil)
              #   Pass arguments to `get_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param options [::Google::Iam::V1::GetPolicyOptions, ::Hash]
              #     OPTIONAL: A `GetPolicyOptions` object for specifying options to
              #     `GetIamPolicy`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Iam::V1::Policy]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::GetIamPolicyRequest.new
              #
              #   # Call the get_iam_policy method.
              #   result = client.get_iam_policy request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def get_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::GetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.resource
                  header_params["resource"] = request.resource
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_iam_policy.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :get_iam_policy, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Sets the access control policy on an instance resource. Replaces any
              # existing policy.
              #
              # @overload set_iam_policy(request, options = nil)
              #   Pass arguments to `set_iam_policy` via a request object, either of type
              #   {::Google::Iam::V1::SetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::SetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload set_iam_policy(resource: nil, policy: nil, update_mask: nil)
              #   Pass arguments to `set_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being specified.
              #     See the operation documentation for the appropriate value for this field.
              #   @param policy [::Google::Iam::V1::Policy, ::Hash]
              #     REQUIRED: The complete policy to be applied to the `resource`. The size of
              #     the policy is limited to a few 10s of KB. An empty policy is a
              #     valid policy but certain Cloud Platform services (such as Projects)
              #     might reject them.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
              #     the fields in the mask will be modified. If no mask is provided, the
              #     following default mask is used:
              #
              #     `paths: "bindings, etag"`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Iam::V1::Policy]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::SetIamPolicyRequest.new
              #
              #   # Call the set_iam_policy method.
              #   result = client.set_iam_policy request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def set_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::SetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.set_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.resource
                  header_params["resource"] = request.resource
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.set_iam_policy.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.set_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :set_iam_policy, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns permissions that the caller has on the specified instance resource.
              #
              # @overload test_iam_permissions(request, options = nil)
              #   Pass arguments to `test_iam_permissions` via a request object, either of type
              #   {::Google::Iam::V1::TestIamPermissionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::TestIamPermissionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload test_iam_permissions(resource: nil, permissions: nil)
              #   Pass arguments to `test_iam_permissions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy detail is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param permissions [::Array<::String>]
              #     The set of permissions to check for the `resource`. Permissions with
              #     wildcards (such as '*' or 'storage.*') are not allowed. For more
              #     information see
              #     [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Iam::V1::TestIamPermissionsResponse]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Iam::V1::TestIamPermissionsResponse]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::TestIamPermissionsRequest.new
              #
              #   # Call the test_iam_permissions method.
              #   result = client.test_iam_permissions request
              #
              #   # The returned object is of type Google::Iam::V1::TestIamPermissionsResponse.
              #   p result
              #
              def test_iam_permissions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::TestIamPermissionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.test_iam_permissions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.resource
                  header_params["resource"] = request.resource
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.test_iam_permissions.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.test_iam_permissions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :test_iam_permissions, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists hot tablets in a cluster, within the time range provided. Hot
              # tablets are ordered based on CPU usage.
              #
              # @overload list_hot_tablets(request, options = nil)
              #   Pass arguments to `list_hot_tablets` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::ListHotTabletsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::ListHotTabletsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_hot_tablets(parent: nil, start_time: nil, end_time: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_hot_tablets` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The cluster name to list hot tablets.
              #     Value is in the following form:
              #     `projects/{project}/instances/{instance}/clusters/{cluster}`.
              #   @param start_time [::Google::Protobuf::Timestamp, ::Hash]
              #     The start time to list hot tablets. The hot tablets in the response will
              #     have start times between the requested start time and end time. Start time
              #     defaults to Now if it is unset, and end time defaults to Now - 24 hours if
              #     it is unset. The start time should be less than the end time, and the
              #     maximum allowed time range between start time and end time is 48 hours.
              #     Start time and end time should have values between Now and Now - 14 days.
              #   @param end_time [::Google::Protobuf::Timestamp, ::Hash]
              #     The end time to list hot tablets.
              #   @param page_size [::Integer]
              #     Maximum number of results per page.
              #
              #     A page_size that is empty or zero lets the server choose the number of
              #     items to return. A page_size which is strictly positive will return at most
              #     that many items. A negative page_size will cause an error.
              #
              #     Following the first request, subsequent paginated calls do not need a
              #     page_size field. If a page_size is set in subsequent calls, it must match
              #     the page_size given in the first request.
              #   @param page_token [::String]
              #     The value of `next_page_token` returned by a previous call.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Bigtable::Admin::V2::HotTablet>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Bigtable::Admin::V2::HotTablet>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::ListHotTabletsRequest.new
              #
              #   # Call the list_hot_tablets method.
              #   result = client.list_hot_tablets request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Bigtable::Admin::V2::HotTablet.
              #     p item
              #   end
              #
              def list_hot_tablets request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::ListHotTabletsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_hot_tablets.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_hot_tablets.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_hot_tablets.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :list_hot_tablets, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @bigtable_instance_admin_stub, :list_hot_tablets, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a logical view within an instance.
              #
              # @overload create_logical_view(request, options = nil)
              #   Pass arguments to `create_logical_view` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::CreateLogicalViewRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::CreateLogicalViewRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_logical_view(parent: nil, logical_view_id: nil, logical_view: nil)
              #   Pass arguments to `create_logical_view` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent instance where this logical view will be created.
              #     Format: `projects/{project}/instances/{instance}`.
              #   @param logical_view_id [::String]
              #     Required. The ID to use for the logical view, which will become the final
              #     component of the logical view's resource name.
              #   @param logical_view [::Google::Cloud::Bigtable::Admin::V2::LogicalView, ::Hash]
              #     Required. The logical view to create.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::CreateLogicalViewRequest.new
              #
              #   # Call the create_logical_view method.
              #   result = client.create_logical_view request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_logical_view request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::CreateLogicalViewRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_logical_view.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_logical_view.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_logical_view.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :create_logical_view, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets information about a logical view.
              #
              # @overload get_logical_view(request, options = nil)
              #   Pass arguments to `get_logical_view` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::GetLogicalViewRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::GetLogicalViewRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_logical_view(name: nil)
              #   Pass arguments to `get_logical_view` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The unique name of the requested logical view. Values are of the
              #     form `projects/{project}/instances/{instance}/logicalViews/{logical_view}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigtable::Admin::V2::LogicalView]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigtable::Admin::V2::LogicalView]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::GetLogicalViewRequest.new
              #
              #   # Call the get_logical_view method.
              #   result = client.get_logical_view request
              #
              #   # The returned object is of type Google::Cloud::Bigtable::Admin::V2::LogicalView.
              #   p result
              #
              def get_logical_view request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::GetLogicalViewRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_logical_view.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_logical_view.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_logical_view.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :get_logical_view, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists information about logical views in an instance.
              #
              # @overload list_logical_views(request, options = nil)
              #   Pass arguments to `list_logical_views` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::ListLogicalViewsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::ListLogicalViewsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_logical_views(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_logical_views` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The unique name of the instance for which the list of logical
              #     views is requested. Values are of the form
              #     `projects/{project}/instances/{instance}`.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of logical views to return. The service may
              #     return fewer than this value
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListLogicalViews` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListLogicalViews` must
              #     match the call that provided the page token.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Bigtable::Admin::V2::LogicalView>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Bigtable::Admin::V2::LogicalView>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::ListLogicalViewsRequest.new
              #
              #   # Call the list_logical_views method.
              #   result = client.list_logical_views request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Bigtable::Admin::V2::LogicalView.
              #     p item
              #   end
              #
              def list_logical_views request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::ListLogicalViewsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_logical_views.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_logical_views.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_logical_views.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :list_logical_views, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @bigtable_instance_admin_stub, :list_logical_views, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a logical view within an instance.
              #
              # @overload update_logical_view(request, options = nil)
              #   Pass arguments to `update_logical_view` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::UpdateLogicalViewRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::UpdateLogicalViewRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_logical_view(logical_view: nil, update_mask: nil)
              #   Pass arguments to `update_logical_view` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param logical_view [::Google::Cloud::Bigtable::Admin::V2::LogicalView, ::Hash]
              #     Required. The logical view to update.
              #
              #     The logical view's `name` field is used to identify the view to update.
              #     Format:
              #     `projects/{project}/instances/{instance}/logicalViews/{logical_view}`.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. The list of fields to update.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::UpdateLogicalViewRequest.new
              #
              #   # Call the update_logical_view method.
              #   result = client.update_logical_view request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_logical_view request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::UpdateLogicalViewRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_logical_view.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.logical_view&.name
                  header_params["logical_view.name"] = request.logical_view.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_logical_view.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_logical_view.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :update_logical_view, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a logical view from an instance.
              #
              # @overload delete_logical_view(request, options = nil)
              #   Pass arguments to `delete_logical_view` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::DeleteLogicalViewRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::DeleteLogicalViewRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_logical_view(name: nil, etag: nil)
              #   Pass arguments to `delete_logical_view` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The unique name of the logical view to be deleted.
              #     Format:
              #     `projects/{project}/instances/{instance}/logicalViews/{logical_view}`.
              #   @param etag [::String]
              #     Optional. The current etag of the logical view.
              #     If an etag is provided and does not match the current etag of the
              #     logical view, deletion will be blocked and an ABORTED error will be
              #     returned.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Protobuf::Empty]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::DeleteLogicalViewRequest.new
              #
              #   # Call the delete_logical_view method.
              #   result = client.delete_logical_view request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_logical_view request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::DeleteLogicalViewRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_logical_view.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_logical_view.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_logical_view.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :delete_logical_view, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a materialized view within an instance.
              #
              # @overload create_materialized_view(request, options = nil)
              #   Pass arguments to `create_materialized_view` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::CreateMaterializedViewRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::CreateMaterializedViewRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_materialized_view(parent: nil, materialized_view_id: nil, materialized_view: nil)
              #   Pass arguments to `create_materialized_view` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent instance where this materialized view will be created.
              #     Format: `projects/{project}/instances/{instance}`.
              #   @param materialized_view_id [::String]
              #     Required. The ID to use for the materialized view, which will become the
              #     final component of the materialized view's resource name.
              #   @param materialized_view [::Google::Cloud::Bigtable::Admin::V2::MaterializedView, ::Hash]
              #     Required. The materialized view to create.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::CreateMaterializedViewRequest.new
              #
              #   # Call the create_materialized_view method.
              #   result = client.create_materialized_view request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_materialized_view request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::CreateMaterializedViewRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_materialized_view.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_materialized_view.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_materialized_view.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :create_materialized_view, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets information about a materialized view.
              #
              # @overload get_materialized_view(request, options = nil)
              #   Pass arguments to `get_materialized_view` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::GetMaterializedViewRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::GetMaterializedViewRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_materialized_view(name: nil)
              #   Pass arguments to `get_materialized_view` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The unique name of the requested materialized view. Values are of
              #     the form
              #     `projects/{project}/instances/{instance}/materializedViews/{materialized_view}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigtable::Admin::V2::MaterializedView]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigtable::Admin::V2::MaterializedView]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::GetMaterializedViewRequest.new
              #
              #   # Call the get_materialized_view method.
              #   result = client.get_materialized_view request
              #
              #   # The returned object is of type Google::Cloud::Bigtable::Admin::V2::MaterializedView.
              #   p result
              #
              def get_materialized_view request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::GetMaterializedViewRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_materialized_view.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_materialized_view.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_materialized_view.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :get_materialized_view, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists information about materialized views in an instance.
              #
              # @overload list_materialized_views(request, options = nil)
              #   Pass arguments to `list_materialized_views` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::ListMaterializedViewsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::ListMaterializedViewsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_materialized_views(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_materialized_views` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The unique name of the instance for which the list of
              #     materialized views is requested. Values are of the form
              #     `projects/{project}/instances/{instance}`.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of materialized views to return. The service
              #     may return fewer than this value
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListMaterializedViews`
              #     call. Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListMaterializedViews`
              #     must match the call that provided the page token.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Bigtable::Admin::V2::MaterializedView>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Bigtable::Admin::V2::MaterializedView>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::ListMaterializedViewsRequest.new
              #
              #   # Call the list_materialized_views method.
              #   result = client.list_materialized_views request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Bigtable::Admin::V2::MaterializedView.
              #     p item
              #   end
              #
              def list_materialized_views request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::ListMaterializedViewsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_materialized_views.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_materialized_views.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_materialized_views.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :list_materialized_views, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @bigtable_instance_admin_stub, :list_materialized_views, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a materialized view within an instance.
              #
              # @overload update_materialized_view(request, options = nil)
              #   Pass arguments to `update_materialized_view` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::UpdateMaterializedViewRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::UpdateMaterializedViewRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_materialized_view(materialized_view: nil, update_mask: nil)
              #   Pass arguments to `update_materialized_view` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param materialized_view [::Google::Cloud::Bigtable::Admin::V2::MaterializedView, ::Hash]
              #     Required. The materialized view to update.
              #
              #     The materialized view's `name` field is used to identify the view to
              #     update. Format:
              #     `projects/{project}/instances/{instance}/materializedViews/{materialized_view}`.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. The list of fields to update.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::UpdateMaterializedViewRequest.new
              #
              #   # Call the update_materialized_view method.
              #   result = client.update_materialized_view request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_materialized_view request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::UpdateMaterializedViewRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_materialized_view.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.materialized_view&.name
                  header_params["materialized_view.name"] = request.materialized_view.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_materialized_view.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_materialized_view.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :update_materialized_view, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a materialized view from an instance.
              #
              # @overload delete_materialized_view(request, options = nil)
              #   Pass arguments to `delete_materialized_view` via a request object, either of type
              #   {::Google::Cloud::Bigtable::Admin::V2::DeleteMaterializedViewRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigtable::Admin::V2::DeleteMaterializedViewRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_materialized_view(name: nil, etag: nil)
              #   Pass arguments to `delete_materialized_view` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The unique name of the materialized view to be deleted.
              #     Format:
              #     `projects/{project}/instances/{instance}/materializedViews/{materialized_view}`.
              #   @param etag [::String]
              #     Optional. The current etag of the materialized view.
              #     If an etag is provided and does not match the current etag of the
              #     materialized view, deletion will be blocked and an ABORTED error will be
              #     returned.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Protobuf::Empty]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigtable/admin/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigtable::Admin::V2::DeleteMaterializedViewRequest.new
              #
              #   # Call the delete_materialized_view method.
              #   result = client.delete_materialized_view request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_materialized_view request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::Admin::V2::DeleteMaterializedViewRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_materialized_view.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigtable::Admin::V2::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_materialized_view.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_materialized_view.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bigtable_instance_admin_stub.call_rpc :delete_materialized_view, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the BigtableInstanceAdmin API.
              #
              # This class represents the configuration for BigtableInstanceAdmin,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_instance to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_instance.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_instance.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
              #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
              #    *  (`nil`) indicating no credentials
              #
              #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
              #     is deprecated. Providing an unvalidated credential configuration to
              #     Google APIs can compromise the security of your systems and data.
              #
              #   @example
              #
              #     # The recommended way to provide credentials is to use the `make_creds` method
              #     # on the appropriate credentials class for your environment.
              #
              #     require "googleauth"
              #
              #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
              #       json_key_io: ::File.open("/path/to/keyfile.json")
              #     )
              #
              #     client = ::Google::Cloud::Bigtable::Admin::V2::BigtableInstanceAdmin::Client.new do |config|
              #       config.credentials = credentials
              #     end
              #
              #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] channel_args
              #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
              #   `GRPC::Core::Channel` object is provided as the credential.
              #   @return [::Hash]
              # @!attribute [rw] interceptors
              #   An array of interceptors that are run before calls are executed.
              #   @return [::Array<::GRPC::ClientInterceptor>]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional gRPC headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "bigtableadmin.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
                config_attr :interceptors,  nil, ::Array, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration for the channel pool
                # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
                #
                def channel_pool
                  @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
                end

                ##
                # Configuration RPC class for the BigtableInstanceAdmin API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_instance
                  ##
                  # RPC-specific configuration for `get_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_instance
                  ##
                  # RPC-specific configuration for `list_instances`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_instances
                  ##
                  # RPC-specific configuration for `update_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_instance
                  ##
                  # RPC-specific configuration for `partial_update_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :partial_update_instance
                  ##
                  # RPC-specific configuration for `delete_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_instance
                  ##
                  # RPC-specific configuration for `create_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_cluster
                  ##
                  # RPC-specific configuration for `get_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_cluster
                  ##
                  # RPC-specific configuration for `list_clusters`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_clusters
                  ##
                  # RPC-specific configuration for `update_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_cluster
                  ##
                  # RPC-specific configuration for `partial_update_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :partial_update_cluster
                  ##
                  # RPC-specific configuration for `delete_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_cluster
                  ##
                  # RPC-specific configuration for `create_app_profile`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_app_profile
                  ##
                  # RPC-specific configuration for `get_app_profile`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_app_profile
                  ##
                  # RPC-specific configuration for `list_app_profiles`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_app_profiles
                  ##
                  # RPC-specific configuration for `update_app_profile`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_app_profile
                  ##
                  # RPC-specific configuration for `delete_app_profile`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_app_profile
                  ##
                  # RPC-specific configuration for `get_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_iam_policy
                  ##
                  # RPC-specific configuration for `set_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_iam_policy
                  ##
                  # RPC-specific configuration for `test_iam_permissions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :test_iam_permissions
                  ##
                  # RPC-specific configuration for `list_hot_tablets`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_hot_tablets
                  ##
                  # RPC-specific configuration for `create_logical_view`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_logical_view
                  ##
                  # RPC-specific configuration for `get_logical_view`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_logical_view
                  ##
                  # RPC-specific configuration for `list_logical_views`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_logical_views
                  ##
                  # RPC-specific configuration for `update_logical_view`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_logical_view
                  ##
                  # RPC-specific configuration for `delete_logical_view`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_logical_view
                  ##
                  # RPC-specific configuration for `create_materialized_view`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_materialized_view
                  ##
                  # RPC-specific configuration for `get_materialized_view`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_materialized_view
                  ##
                  # RPC-specific configuration for `list_materialized_views`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_materialized_views
                  ##
                  # RPC-specific configuration for `update_materialized_view`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_materialized_view
                  ##
                  # RPC-specific configuration for `delete_materialized_view`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_materialized_view

                  # @private
                  def initialize parent_rpcs = nil
                    create_instance_config = parent_rpcs.create_instance if parent_rpcs.respond_to? :create_instance
                    @create_instance = ::Gapic::Config::Method.new create_instance_config
                    get_instance_config = parent_rpcs.get_instance if parent_rpcs.respond_to? :get_instance
                    @get_instance = ::Gapic::Config::Method.new get_instance_config
                    list_instances_config = parent_rpcs.list_instances if parent_rpcs.respond_to? :list_instances
                    @list_instances = ::Gapic::Config::Method.new list_instances_config
                    update_instance_config = parent_rpcs.update_instance if parent_rpcs.respond_to? :update_instance
                    @update_instance = ::Gapic::Config::Method.new update_instance_config
                    partial_update_instance_config = parent_rpcs.partial_update_instance if parent_rpcs.respond_to? :partial_update_instance
                    @partial_update_instance = ::Gapic::Config::Method.new partial_update_instance_config
                    delete_instance_config = parent_rpcs.delete_instance if parent_rpcs.respond_to? :delete_instance
                    @delete_instance = ::Gapic::Config::Method.new delete_instance_config
                    create_cluster_config = parent_rpcs.create_cluster if parent_rpcs.respond_to? :create_cluster
                    @create_cluster = ::Gapic::Config::Method.new create_cluster_config
                    get_cluster_config = parent_rpcs.get_cluster if parent_rpcs.respond_to? :get_cluster
                    @get_cluster = ::Gapic::Config::Method.new get_cluster_config
                    list_clusters_config = parent_rpcs.list_clusters if parent_rpcs.respond_to? :list_clusters
                    @list_clusters = ::Gapic::Config::Method.new list_clusters_config
                    update_cluster_config = parent_rpcs.update_cluster if parent_rpcs.respond_to? :update_cluster
                    @update_cluster = ::Gapic::Config::Method.new update_cluster_config
                    partial_update_cluster_config = parent_rpcs.partial_update_cluster if parent_rpcs.respond_to? :partial_update_cluster
                    @partial_update_cluster = ::Gapic::Config::Method.new partial_update_cluster_config
                    delete_cluster_config = parent_rpcs.delete_cluster if parent_rpcs.respond_to? :delete_cluster
                    @delete_cluster = ::Gapic::Config::Method.new delete_cluster_config
                    create_app_profile_config = parent_rpcs.create_app_profile if parent_rpcs.respond_to? :create_app_profile
                    @create_app_profile = ::Gapic::Config::Method.new create_app_profile_config
                    get_app_profile_config = parent_rpcs.get_app_profile if parent_rpcs.respond_to? :get_app_profile
                    @get_app_profile = ::Gapic::Config::Method.new get_app_profile_config
                    list_app_profiles_config = parent_rpcs.list_app_profiles if parent_rpcs.respond_to? :list_app_profiles
                    @list_app_profiles = ::Gapic::Config::Method.new list_app_profiles_config
                    update_app_profile_config = parent_rpcs.update_app_profile if parent_rpcs.respond_to? :update_app_profile
                    @update_app_profile = ::Gapic::Config::Method.new update_app_profile_config
                    delete_app_profile_config = parent_rpcs.delete_app_profile if parent_rpcs.respond_to? :delete_app_profile
                    @delete_app_profile = ::Gapic::Config::Method.new delete_app_profile_config
                    get_iam_policy_config = parent_rpcs.get_iam_policy if parent_rpcs.respond_to? :get_iam_policy
                    @get_iam_policy = ::Gapic::Config::Method.new get_iam_policy_config
                    set_iam_policy_config = parent_rpcs.set_iam_policy if parent_rpcs.respond_to? :set_iam_policy
                    @set_iam_policy = ::Gapic::Config::Method.new set_iam_policy_config
                    test_iam_permissions_config = parent_rpcs.test_iam_permissions if parent_rpcs.respond_to? :test_iam_permissions
                    @test_iam_permissions = ::Gapic::Config::Method.new test_iam_permissions_config
                    list_hot_tablets_config = parent_rpcs.list_hot_tablets if parent_rpcs.respond_to? :list_hot_tablets
                    @list_hot_tablets = ::Gapic::Config::Method.new list_hot_tablets_config
                    create_logical_view_config = parent_rpcs.create_logical_view if parent_rpcs.respond_to? :create_logical_view
                    @create_logical_view = ::Gapic::Config::Method.new create_logical_view_config
                    get_logical_view_config = parent_rpcs.get_logical_view if parent_rpcs.respond_to? :get_logical_view
                    @get_logical_view = ::Gapic::Config::Method.new get_logical_view_config
                    list_logical_views_config = parent_rpcs.list_logical_views if parent_rpcs.respond_to? :list_logical_views
                    @list_logical_views = ::Gapic::Config::Method.new list_logical_views_config
                    update_logical_view_config = parent_rpcs.update_logical_view if parent_rpcs.respond_to? :update_logical_view
                    @update_logical_view = ::Gapic::Config::Method.new update_logical_view_config
                    delete_logical_view_config = parent_rpcs.delete_logical_view if parent_rpcs.respond_to? :delete_logical_view
                    @delete_logical_view = ::Gapic::Config::Method.new delete_logical_view_config
                    create_materialized_view_config = parent_rpcs.create_materialized_view if parent_rpcs.respond_to? :create_materialized_view
                    @create_materialized_view = ::Gapic::Config::Method.new create_materialized_view_config
                    get_materialized_view_config = parent_rpcs.get_materialized_view if parent_rpcs.respond_to? :get_materialized_view
                    @get_materialized_view = ::Gapic::Config::Method.new get_materialized_view_config
                    list_materialized_views_config = parent_rpcs.list_materialized_views if parent_rpcs.respond_to? :list_materialized_views
                    @list_materialized_views = ::Gapic::Config::Method.new list_materialized_views_config
                    update_materialized_view_config = parent_rpcs.update_materialized_view if parent_rpcs.respond_to? :update_materialized_view
                    @update_materialized_view = ::Gapic::Config::Method.new update_materialized_view_config
                    delete_materialized_view_config = parent_rpcs.delete_materialized_view if parent_rpcs.respond_to? :delete_materialized_view
                    @delete_materialized_view = ::Gapic::Config::Method.new delete_materialized_view_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
