# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/bigtable/admin/v2/bigtable_instance_admin.proto for package 'Google.Cloud.Bigtable.Admin.V2'
# Original file comments:
# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/bigtable/admin/v2/bigtable_instance_admin_pb'

module Google
  module Cloud
    module Bigtable
      module Admin
        module V2
          module BigtableInstanceAdmin
            # Service for creating, configuring, and deleting Cloud Bigtable Instances and
            # Clusters. Provides access to the Instance and Cluster schemas only, not the
            # tables' metadata or data stored in those tables.
            class Service

              include ::GRPC::GenericService

              self.marshal_class_method = :encode
              self.unmarshal_class_method = :decode
              self.service_name = 'google.bigtable.admin.v2.BigtableInstanceAdmin'

              # Create an instance within a project.
              #
              # Note that exactly one of Cluster.serve_nodes and
              # Cluster.cluster_config.cluster_autoscaling_config can be set. If
              # serve_nodes is set to non-zero, then the cluster is manually scaled. If
              # cluster_config.cluster_autoscaling_config is non-empty, then autoscaling is
              # enabled.
              rpc :CreateInstance, ::Google::Cloud::Bigtable::Admin::V2::CreateInstanceRequest, ::Google::Longrunning::Operation
              # Gets information about an instance.
              rpc :GetInstance, ::Google::Cloud::Bigtable::Admin::V2::GetInstanceRequest, ::Google::Cloud::Bigtable::Admin::V2::Instance
              # Lists information about instances in a project.
              rpc :ListInstances, ::Google::Cloud::Bigtable::Admin::V2::ListInstancesRequest, ::Google::Cloud::Bigtable::Admin::V2::ListInstancesResponse
              # Updates an instance within a project. This method updates only the display
              # name and type for an Instance. To update other Instance properties, such as
              # labels, use PartialUpdateInstance.
              rpc :UpdateInstance, ::Google::Cloud::Bigtable::Admin::V2::Instance, ::Google::Cloud::Bigtable::Admin::V2::Instance
              # Partially updates an instance within a project. This method can modify all
              # fields of an Instance and is the preferred way to update an Instance.
              rpc :PartialUpdateInstance, ::Google::Cloud::Bigtable::Admin::V2::PartialUpdateInstanceRequest, ::Google::Longrunning::Operation
              # Delete an instance from a project.
              rpc :DeleteInstance, ::Google::Cloud::Bigtable::Admin::V2::DeleteInstanceRequest, ::Google::Protobuf::Empty
              # Creates a cluster within an instance.
              #
              # Note that exactly one of Cluster.serve_nodes and
              # Cluster.cluster_config.cluster_autoscaling_config can be set. If
              # serve_nodes is set to non-zero, then the cluster is manually scaled. If
              # cluster_config.cluster_autoscaling_config is non-empty, then autoscaling is
              # enabled.
              rpc :CreateCluster, ::Google::Cloud::Bigtable::Admin::V2::CreateClusterRequest, ::Google::Longrunning::Operation
              # Gets information about a cluster.
              rpc :GetCluster, ::Google::Cloud::Bigtable::Admin::V2::GetClusterRequest, ::Google::Cloud::Bigtable::Admin::V2::Cluster
              # Lists information about clusters in an instance.
              rpc :ListClusters, ::Google::Cloud::Bigtable::Admin::V2::ListClustersRequest, ::Google::Cloud::Bigtable::Admin::V2::ListClustersResponse
              # Updates a cluster within an instance.
              #
              # Note that UpdateCluster does not support updating
              # cluster_config.cluster_autoscaling_config. In order to update it, you
              # must use PartialUpdateCluster.
              rpc :UpdateCluster, ::Google::Cloud::Bigtable::Admin::V2::Cluster, ::Google::Longrunning::Operation
              # Partially updates a cluster within a project. This method is the preferred
              # way to update a Cluster.
              #
              # To enable and update autoscaling, set
              # cluster_config.cluster_autoscaling_config. When autoscaling is enabled,
              # serve_nodes is treated as an OUTPUT_ONLY field, meaning that updates to it
              # are ignored. Note that an update cannot simultaneously set serve_nodes to
              # non-zero and cluster_config.cluster_autoscaling_config to non-empty, and
              # also specify both in the update_mask.
              #
              # To disable autoscaling, clear cluster_config.cluster_autoscaling_config,
              # and explicitly set a serve_node count via the update_mask.
              rpc :PartialUpdateCluster, ::Google::Cloud::Bigtable::Admin::V2::PartialUpdateClusterRequest, ::Google::Longrunning::Operation
              # Deletes a cluster from an instance.
              rpc :DeleteCluster, ::Google::Cloud::Bigtable::Admin::V2::DeleteClusterRequest, ::Google::Protobuf::Empty
              # Creates an app profile within an instance.
              rpc :CreateAppProfile, ::Google::Cloud::Bigtable::Admin::V2::CreateAppProfileRequest, ::Google::Cloud::Bigtable::Admin::V2::AppProfile
              # Gets information about an app profile.
              rpc :GetAppProfile, ::Google::Cloud::Bigtable::Admin::V2::GetAppProfileRequest, ::Google::Cloud::Bigtable::Admin::V2::AppProfile
              # Lists information about app profiles in an instance.
              rpc :ListAppProfiles, ::Google::Cloud::Bigtable::Admin::V2::ListAppProfilesRequest, ::Google::Cloud::Bigtable::Admin::V2::ListAppProfilesResponse
              # Updates an app profile within an instance.
              rpc :UpdateAppProfile, ::Google::Cloud::Bigtable::Admin::V2::UpdateAppProfileRequest, ::Google::Longrunning::Operation
              # Deletes an app profile from an instance.
              rpc :DeleteAppProfile, ::Google::Cloud::Bigtable::Admin::V2::DeleteAppProfileRequest, ::Google::Protobuf::Empty
              # Gets the access control policy for an instance resource. Returns an empty
              # policy if an instance exists but does not have a policy set.
              rpc :GetIamPolicy, ::Google::Iam::V1::GetIamPolicyRequest, ::Google::Iam::V1::Policy
              # Sets the access control policy on an instance resource. Replaces any
              # existing policy.
              rpc :SetIamPolicy, ::Google::Iam::V1::SetIamPolicyRequest, ::Google::Iam::V1::Policy
              # Returns permissions that the caller has on the specified instance resource.
              rpc :TestIamPermissions, ::Google::Iam::V1::TestIamPermissionsRequest, ::Google::Iam::V1::TestIamPermissionsResponse
              # Lists hot tablets in a cluster, within the time range provided. Hot
              # tablets are ordered based on CPU usage.
              rpc :ListHotTablets, ::Google::Cloud::Bigtable::Admin::V2::ListHotTabletsRequest, ::Google::Cloud::Bigtable::Admin::V2::ListHotTabletsResponse
              # Creates a logical view within an instance.
              rpc :CreateLogicalView, ::Google::Cloud::Bigtable::Admin::V2::CreateLogicalViewRequest, ::Google::Longrunning::Operation
              # Gets information about a logical view.
              rpc :GetLogicalView, ::Google::Cloud::Bigtable::Admin::V2::GetLogicalViewRequest, ::Google::Cloud::Bigtable::Admin::V2::LogicalView
              # Lists information about logical views in an instance.
              rpc :ListLogicalViews, ::Google::Cloud::Bigtable::Admin::V2::ListLogicalViewsRequest, ::Google::Cloud::Bigtable::Admin::V2::ListLogicalViewsResponse
              # Updates a logical view within an instance.
              rpc :UpdateLogicalView, ::Google::Cloud::Bigtable::Admin::V2::UpdateLogicalViewRequest, ::Google::Longrunning::Operation
              # Deletes a logical view from an instance.
              rpc :DeleteLogicalView, ::Google::Cloud::Bigtable::Admin::V2::DeleteLogicalViewRequest, ::Google::Protobuf::Empty
              # Creates a materialized view within an instance.
              rpc :CreateMaterializedView, ::Google::Cloud::Bigtable::Admin::V2::CreateMaterializedViewRequest, ::Google::Longrunning::Operation
              # Gets information about a materialized view.
              rpc :GetMaterializedView, ::Google::Cloud::Bigtable::Admin::V2::GetMaterializedViewRequest, ::Google::Cloud::Bigtable::Admin::V2::MaterializedView
              # Lists information about materialized views in an instance.
              rpc :ListMaterializedViews, ::Google::Cloud::Bigtable::Admin::V2::ListMaterializedViewsRequest, ::Google::Cloud::Bigtable::Admin::V2::ListMaterializedViewsResponse
              # Updates a materialized view within an instance.
              rpc :UpdateMaterializedView, ::Google::Cloud::Bigtable::Admin::V2::UpdateMaterializedViewRequest, ::Google::Longrunning::Operation
              # Deletes a materialized view from an instance.
              rpc :DeleteMaterializedView, ::Google::Cloud::Bigtable::Admin::V2::DeleteMaterializedViewRequest, ::Google::Protobuf::Empty
            end

            Stub = Service.rpc_stub_class
          end
        end
      end
    end
  end
end
