# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Bigquery
      module Storage
        module V1
          # ProtoSchema describes the schema of the serialized protocol buffer data rows.
          # @!attribute [rw] proto_descriptor
          #   @return [::Google::Protobuf::DescriptorProto]
          #     Descriptor for input message.  The provided descriptor must be self
          #     contained, such that data rows sent can be fully decoded using only the
          #     single descriptor.  For data rows that are compositions of multiple
          #     independent messages, this means the descriptor may need to be transformed
          #     to only use nested types:
          #     https://developers.google.com/protocol-buffers/docs/proto#nested
          #
          #     For additional information for how proto types and values map onto BigQuery
          #     see: https://cloud.google.com/bigquery/docs/write-api#data_type_conversions
          class ProtoSchema
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] serialized_rows
          #   @return [::Array<::String>]
          #     A sequence of rows serialized as a Protocol Buffer.
          #
          #     See https://developers.google.com/protocol-buffers/docs/overview for more
          #     information on deserializing this field.
          class ProtoRows
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
