# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Bigquery
      module Storage
        module V1
          # Avro schema.
          # @!attribute [rw] schema
          #   @return [::String]
          #     Json serialized schema, as described at
          #     https://avro.apache.org/docs/1.8.1/spec.html.
          class AvroSchema
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Avro rows.
          # @!attribute [rw] serialized_binary_rows
          #   @return [::String]
          #     Binary serialized rows in a block.
          # @!attribute [rw] row_count
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Integer]
          #     [Deprecated] The count of rows in the returning block.
          #     Please use the format-independent ReadRowsResponse.row_count instead.
          class AvroRows
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Contains options specific to Avro Serialization.
          # @!attribute [rw] enable_display_name_attribute
          #   @return [::Boolean]
          #     Enable displayName attribute in Avro schema.
          #
          #     The Avro specification requires field names to be alphanumeric.  By
          #     default, in cases when column names do not conform to these requirements
          #     (e.g. non-ascii unicode codepoints) and Avro is requested as an output
          #     format, the CreateReadSession call will fail.
          #
          #     Setting this field to true, populates avro field names with a placeholder
          #     value and populates a "displayName" attribute for every avro field with the
          #     original column name.
          # @!attribute [rw] picos_timestamp_precision
          #   @return [::Google::Cloud::Bigquery::Storage::V1::AvroSerializationOptions::PicosTimestampPrecision]
          #     Optional. Set timestamp precision option. If not set, the default precision
          #     is microseconds.
          class AvroSerializationOptions
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The precision of the timestamp value in the Avro message. This precision
            # will **only** be applied to the column(s) with the `TIMESTAMP_PICOS` type.
            module PicosTimestampPrecision
              # Unspecified timestamp precision. The default precision is microseconds.
              PICOS_TIMESTAMP_PRECISION_UNSPECIFIED = 0

              # Timestamp values returned by Read API will be truncated to microsecond
              # level precision. The value will be encoded as Avro TIMESTAMP type in a
              # 64 bit integer.
              TIMESTAMP_PRECISION_MICROS = 1

              # Timestamp values returned by Read API will be truncated to nanosecond
              # level precision. The value will be encoded as Avro TIMESTAMP type in a
              # 64 bit integer.
              TIMESTAMP_PRECISION_NANOS = 2

              # Read API will return full precision picosecond value. The value will be
              # encoded as a string which conforms to ISO 8601 format.
              TIMESTAMP_PRECISION_PICOS = 3
            end
          end
        end
      end
    end
  end
end
