# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/bigquery/storage/v1/version"

require "google/cloud/bigquery/storage/v1/big_query_write/credentials"
require "google/cloud/bigquery/storage/v1/big_query_write/paths"
require "google/cloud/bigquery/storage/v1/big_query_write/client"

module Google
  module Cloud
    module Bigquery
      module Storage
        module V1
          ##
          # BigQuery Write API.
          #
          # The Write API can be used to write data to BigQuery.
          #
          # For supplementary information about the Write API, see:
          # https://cloud.google.com/bigquery/docs/write-api
          #
          # @example Load this service and instantiate a gRPC client
          #
          #     require "google/cloud/bigquery/storage/v1/big_query_write"
          #     client = ::Google::Cloud::Bigquery::Storage::V1::BigQueryWrite::Client.new
          #
          module BigQueryWrite
          end
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "big_query_write", "helpers.rb"
require "google/cloud/bigquery/storage/v1/big_query_write/helpers" if ::File.file? helper_path
