# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/bigquery/reservation/v1/reservation_pb"
require "google/cloud/bigquery/reservation/v1/reservation_service"

class ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_reservation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::Reservation::V1::Reservation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    reservation_id = "hello world"
    reservation = {}

    create_reservation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_reservation, name
      assert_kind_of ::Google::Cloud::Bigquery::Reservation::V1::CreateReservationRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["reservation_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Bigquery::Reservation::V1::Reservation), request["reservation"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_reservation_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_reservation({ parent: parent, reservation_id: reservation_id, reservation: reservation }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_reservation parent: parent, reservation_id: reservation_id, reservation: reservation do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_reservation ::Google::Cloud::Bigquery::Reservation::V1::CreateReservationRequest.new(parent: parent, reservation_id: reservation_id, reservation: reservation) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_reservation({ parent: parent, reservation_id: reservation_id, reservation: reservation }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_reservation(::Google::Cloud::Bigquery::Reservation::V1::CreateReservationRequest.new(parent: parent, reservation_id: reservation_id, reservation: reservation), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_reservation_client_stub.call_rpc_count
    end
  end

  def test_list_reservations
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::Reservation::V1::ListReservationsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_reservations_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_reservations, name
      assert_kind_of ::Google::Cloud::Bigquery::Reservation::V1::ListReservationsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_reservations_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_reservations({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_reservations parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_reservations ::Google::Cloud::Bigquery::Reservation::V1::ListReservationsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_reservations({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_reservations(::Google::Cloud::Bigquery::Reservation::V1::ListReservationsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_reservations_client_stub.call_rpc_count
    end
  end

  def test_get_reservation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::Reservation::V1::Reservation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_reservation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_reservation, name
      assert_kind_of ::Google::Cloud::Bigquery::Reservation::V1::GetReservationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_reservation_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_reservation({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_reservation name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_reservation ::Google::Cloud::Bigquery::Reservation::V1::GetReservationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_reservation({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_reservation(::Google::Cloud::Bigquery::Reservation::V1::GetReservationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_reservation_client_stub.call_rpc_count
    end
  end

  def test_delete_reservation
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_reservation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_reservation, name
      assert_kind_of ::Google::Cloud::Bigquery::Reservation::V1::DeleteReservationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_reservation_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_reservation({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_reservation name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_reservation ::Google::Cloud::Bigquery::Reservation::V1::DeleteReservationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_reservation({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_reservation(::Google::Cloud::Bigquery::Reservation::V1::DeleteReservationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_reservation_client_stub.call_rpc_count
    end
  end

  def test_update_reservation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::Reservation::V1::Reservation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    reservation = {}
    update_mask = {}

    update_reservation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_reservation, name
      assert_kind_of ::Google::Cloud::Bigquery::Reservation::V1::UpdateReservationRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Bigquery::Reservation::V1::Reservation), request["reservation"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_reservation_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_reservation({ reservation: reservation, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_reservation reservation: reservation, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_reservation ::Google::Cloud::Bigquery::Reservation::V1::UpdateReservationRequest.new(reservation: reservation, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_reservation({ reservation: reservation, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_reservation(::Google::Cloud::Bigquery::Reservation::V1::UpdateReservationRequest.new(reservation: reservation, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_reservation_client_stub.call_rpc_count
    end
  end

  def test_failover_reservation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::Reservation::V1::Reservation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    failover_mode = :FAILOVER_MODE_UNSPECIFIED

    failover_reservation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :failover_reservation, name
      assert_kind_of ::Google::Cloud::Bigquery::Reservation::V1::FailoverReservationRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :FAILOVER_MODE_UNSPECIFIED, request["failover_mode"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, failover_reservation_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.failover_reservation({ name: name, failover_mode: failover_mode }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.failover_reservation name: name, failover_mode: failover_mode do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.failover_reservation ::Google::Cloud::Bigquery::Reservation::V1::FailoverReservationRequest.new(name: name, failover_mode: failover_mode) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.failover_reservation({ name: name, failover_mode: failover_mode }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.failover_reservation(::Google::Cloud::Bigquery::Reservation::V1::FailoverReservationRequest.new(name: name, failover_mode: failover_mode), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, failover_reservation_client_stub.call_rpc_count
    end
  end

  def test_create_capacity_commitment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    capacity_commitment = {}
    enforce_single_admin_project_per_org = true
    capacity_commitment_id = "hello world"

    create_capacity_commitment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_capacity_commitment, name
      assert_kind_of ::Google::Cloud::Bigquery::Reservation::V1::CreateCapacityCommitmentRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment), request["capacity_commitment"]
      assert_equal true, request["enforce_single_admin_project_per_org"]
      assert_equal "hello world", request["capacity_commitment_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_capacity_commitment_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_capacity_commitment({ parent: parent, capacity_commitment: capacity_commitment, enforce_single_admin_project_per_org: enforce_single_admin_project_per_org, capacity_commitment_id: capacity_commitment_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_capacity_commitment parent: parent, capacity_commitment: capacity_commitment, enforce_single_admin_project_per_org: enforce_single_admin_project_per_org, capacity_commitment_id: capacity_commitment_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_capacity_commitment ::Google::Cloud::Bigquery::Reservation::V1::CreateCapacityCommitmentRequest.new(parent: parent, capacity_commitment: capacity_commitment, enforce_single_admin_project_per_org: enforce_single_admin_project_per_org, capacity_commitment_id: capacity_commitment_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_capacity_commitment({ parent: parent, capacity_commitment: capacity_commitment, enforce_single_admin_project_per_org: enforce_single_admin_project_per_org, capacity_commitment_id: capacity_commitment_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_capacity_commitment(::Google::Cloud::Bigquery::Reservation::V1::CreateCapacityCommitmentRequest.new(parent: parent, capacity_commitment: capacity_commitment, enforce_single_admin_project_per_org: enforce_single_admin_project_per_org, capacity_commitment_id: capacity_commitment_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_capacity_commitment_client_stub.call_rpc_count
    end
  end

  def test_list_capacity_commitments
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::Reservation::V1::ListCapacityCommitmentsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_capacity_commitments_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_capacity_commitments, name
      assert_kind_of ::Google::Cloud::Bigquery::Reservation::V1::ListCapacityCommitmentsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_capacity_commitments_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_capacity_commitments({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_capacity_commitments parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_capacity_commitments ::Google::Cloud::Bigquery::Reservation::V1::ListCapacityCommitmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_capacity_commitments({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_capacity_commitments(::Google::Cloud::Bigquery::Reservation::V1::ListCapacityCommitmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_capacity_commitments_client_stub.call_rpc_count
    end
  end

  def test_get_capacity_commitment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_capacity_commitment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_capacity_commitment, name
      assert_kind_of ::Google::Cloud::Bigquery::Reservation::V1::GetCapacityCommitmentRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_capacity_commitment_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_capacity_commitment({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_capacity_commitment name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_capacity_commitment ::Google::Cloud::Bigquery::Reservation::V1::GetCapacityCommitmentRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_capacity_commitment({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_capacity_commitment(::Google::Cloud::Bigquery::Reservation::V1::GetCapacityCommitmentRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_capacity_commitment_client_stub.call_rpc_count
    end
  end

  def test_delete_capacity_commitment
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_capacity_commitment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_capacity_commitment, name
      assert_kind_of ::Google::Cloud::Bigquery::Reservation::V1::DeleteCapacityCommitmentRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_capacity_commitment_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_capacity_commitment({ name: name, force: force }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_capacity_commitment name: name, force: force do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_capacity_commitment ::Google::Cloud::Bigquery::Reservation::V1::DeleteCapacityCommitmentRequest.new(name: name, force: force) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_capacity_commitment({ name: name, force: force }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_capacity_commitment(::Google::Cloud::Bigquery::Reservation::V1::DeleteCapacityCommitmentRequest.new(name: name, force: force), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_capacity_commitment_client_stub.call_rpc_count
    end
  end

  def test_update_capacity_commitment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    capacity_commitment = {}
    update_mask = {}

    update_capacity_commitment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_capacity_commitment, name
      assert_kind_of ::Google::Cloud::Bigquery::Reservation::V1::UpdateCapacityCommitmentRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment), request["capacity_commitment"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_capacity_commitment_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_capacity_commitment({ capacity_commitment: capacity_commitment, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_capacity_commitment capacity_commitment: capacity_commitment, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_capacity_commitment ::Google::Cloud::Bigquery::Reservation::V1::UpdateCapacityCommitmentRequest.new(capacity_commitment: capacity_commitment, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_capacity_commitment({ capacity_commitment: capacity_commitment, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_capacity_commitment(::Google::Cloud::Bigquery::Reservation::V1::UpdateCapacityCommitmentRequest.new(capacity_commitment: capacity_commitment, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_capacity_commitment_client_stub.call_rpc_count
    end
  end

  def test_split_capacity_commitment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::Reservation::V1::SplitCapacityCommitmentResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    slot_count = 42

    split_capacity_commitment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :split_capacity_commitment, name
      assert_kind_of ::Google::Cloud::Bigquery::Reservation::V1::SplitCapacityCommitmentRequest, request
      assert_equal "hello world", request["name"]
      assert_equal 42, request["slot_count"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, split_capacity_commitment_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.split_capacity_commitment({ name: name, slot_count: slot_count }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.split_capacity_commitment name: name, slot_count: slot_count do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.split_capacity_commitment ::Google::Cloud::Bigquery::Reservation::V1::SplitCapacityCommitmentRequest.new(name: name, slot_count: slot_count) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.split_capacity_commitment({ name: name, slot_count: slot_count }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.split_capacity_commitment(::Google::Cloud::Bigquery::Reservation::V1::SplitCapacityCommitmentRequest.new(name: name, slot_count: slot_count), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, split_capacity_commitment_client_stub.call_rpc_count
    end
  end

  def test_merge_capacity_commitments
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    capacity_commitment_ids = ["hello world"]
    capacity_commitment_id = "hello world"

    merge_capacity_commitments_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :merge_capacity_commitments, name
      assert_kind_of ::Google::Cloud::Bigquery::Reservation::V1::MergeCapacityCommitmentsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal ["hello world"], request["capacity_commitment_ids"]
      assert_equal "hello world", request["capacity_commitment_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, merge_capacity_commitments_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.merge_capacity_commitments({ parent: parent, capacity_commitment_ids: capacity_commitment_ids, capacity_commitment_id: capacity_commitment_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.merge_capacity_commitments parent: parent, capacity_commitment_ids: capacity_commitment_ids, capacity_commitment_id: capacity_commitment_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.merge_capacity_commitments ::Google::Cloud::Bigquery::Reservation::V1::MergeCapacityCommitmentsRequest.new(parent: parent, capacity_commitment_ids: capacity_commitment_ids, capacity_commitment_id: capacity_commitment_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.merge_capacity_commitments({ parent: parent, capacity_commitment_ids: capacity_commitment_ids, capacity_commitment_id: capacity_commitment_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.merge_capacity_commitments(::Google::Cloud::Bigquery::Reservation::V1::MergeCapacityCommitmentsRequest.new(parent: parent, capacity_commitment_ids: capacity_commitment_ids, capacity_commitment_id: capacity_commitment_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, merge_capacity_commitments_client_stub.call_rpc_count
    end
  end

  def test_create_assignment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::Reservation::V1::Assignment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    assignment = {}
    assignment_id = "hello world"

    create_assignment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_assignment, name
      assert_kind_of ::Google::Cloud::Bigquery::Reservation::V1::CreateAssignmentRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Bigquery::Reservation::V1::Assignment), request["assignment"]
      assert_equal "hello world", request["assignment_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_assignment_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_assignment({ parent: parent, assignment: assignment, assignment_id: assignment_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_assignment parent: parent, assignment: assignment, assignment_id: assignment_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_assignment ::Google::Cloud::Bigquery::Reservation::V1::CreateAssignmentRequest.new(parent: parent, assignment: assignment, assignment_id: assignment_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_assignment({ parent: parent, assignment: assignment, assignment_id: assignment_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_assignment(::Google::Cloud::Bigquery::Reservation::V1::CreateAssignmentRequest.new(parent: parent, assignment: assignment, assignment_id: assignment_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_assignment_client_stub.call_rpc_count
    end
  end

  def test_list_assignments
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::Reservation::V1::ListAssignmentsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_assignments_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_assignments, name
      assert_kind_of ::Google::Cloud::Bigquery::Reservation::V1::ListAssignmentsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_assignments_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_assignments({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_assignments parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_assignments ::Google::Cloud::Bigquery::Reservation::V1::ListAssignmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_assignments({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_assignments(::Google::Cloud::Bigquery::Reservation::V1::ListAssignmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_assignments_client_stub.call_rpc_count
    end
  end

  def test_delete_assignment
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_assignment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_assignment, name
      assert_kind_of ::Google::Cloud::Bigquery::Reservation::V1::DeleteAssignmentRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_assignment_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_assignment({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_assignment name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_assignment ::Google::Cloud::Bigquery::Reservation::V1::DeleteAssignmentRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_assignment({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_assignment(::Google::Cloud::Bigquery::Reservation::V1::DeleteAssignmentRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_assignment_client_stub.call_rpc_count
    end
  end

  def test_search_assignments
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::Reservation::V1::SearchAssignmentsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    query = "hello world"
    page_size = 42
    page_token = "hello world"

    search_assignments_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :search_assignments, name
      assert_kind_of ::Google::Cloud::Bigquery::Reservation::V1::SearchAssignmentsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["query"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, search_assignments_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.search_assignments({ parent: parent, query: query, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.search_assignments parent: parent, query: query, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.search_assignments ::Google::Cloud::Bigquery::Reservation::V1::SearchAssignmentsRequest.new(parent: parent, query: query, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.search_assignments({ parent: parent, query: query, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.search_assignments(::Google::Cloud::Bigquery::Reservation::V1::SearchAssignmentsRequest.new(parent: parent, query: query, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, search_assignments_client_stub.call_rpc_count
    end
  end

  def test_search_all_assignments
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::Reservation::V1::SearchAllAssignmentsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    query = "hello world"
    page_size = 42
    page_token = "hello world"

    search_all_assignments_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :search_all_assignments, name
      assert_kind_of ::Google::Cloud::Bigquery::Reservation::V1::SearchAllAssignmentsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["query"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, search_all_assignments_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.search_all_assignments({ parent: parent, query: query, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.search_all_assignments parent: parent, query: query, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.search_all_assignments ::Google::Cloud::Bigquery::Reservation::V1::SearchAllAssignmentsRequest.new(parent: parent, query: query, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.search_all_assignments({ parent: parent, query: query, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.search_all_assignments(::Google::Cloud::Bigquery::Reservation::V1::SearchAllAssignmentsRequest.new(parent: parent, query: query, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, search_all_assignments_client_stub.call_rpc_count
    end
  end

  def test_move_assignment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::Reservation::V1::Assignment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    destination_id = "hello world"
    assignment_id = "hello world"

    move_assignment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :move_assignment, name
      assert_kind_of ::Google::Cloud::Bigquery::Reservation::V1::MoveAssignmentRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["destination_id"]
      assert_equal "hello world", request["assignment_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, move_assignment_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.move_assignment({ name: name, destination_id: destination_id, assignment_id: assignment_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.move_assignment name: name, destination_id: destination_id, assignment_id: assignment_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.move_assignment ::Google::Cloud::Bigquery::Reservation::V1::MoveAssignmentRequest.new(name: name, destination_id: destination_id, assignment_id: assignment_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.move_assignment({ name: name, destination_id: destination_id, assignment_id: assignment_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.move_assignment(::Google::Cloud::Bigquery::Reservation::V1::MoveAssignmentRequest.new(name: name, destination_id: destination_id, assignment_id: assignment_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, move_assignment_client_stub.call_rpc_count
    end
  end

  def test_update_assignment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::Reservation::V1::Assignment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    assignment = {}
    update_mask = {}

    update_assignment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_assignment, name
      assert_kind_of ::Google::Cloud::Bigquery::Reservation::V1::UpdateAssignmentRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Bigquery::Reservation::V1::Assignment), request["assignment"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_assignment_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_assignment({ assignment: assignment, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_assignment assignment: assignment, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_assignment ::Google::Cloud::Bigquery::Reservation::V1::UpdateAssignmentRequest.new(assignment: assignment, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_assignment({ assignment: assignment, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_assignment(::Google::Cloud::Bigquery::Reservation::V1::UpdateAssignmentRequest.new(assignment: assignment, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_assignment_client_stub.call_rpc_count
    end
  end

  def test_get_bi_reservation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::Reservation::V1::BiReservation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_bi_reservation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_bi_reservation, name
      assert_kind_of ::Google::Cloud::Bigquery::Reservation::V1::GetBiReservationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_bi_reservation_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_bi_reservation({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_bi_reservation name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_bi_reservation ::Google::Cloud::Bigquery::Reservation::V1::GetBiReservationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_bi_reservation({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_bi_reservation(::Google::Cloud::Bigquery::Reservation::V1::GetBiReservationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_bi_reservation_client_stub.call_rpc_count
    end
  end

  def test_update_bi_reservation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::Reservation::V1::BiReservation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    bi_reservation = {}
    update_mask = {}

    update_bi_reservation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_bi_reservation, name
      assert_kind_of ::Google::Cloud::Bigquery::Reservation::V1::UpdateBiReservationRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Bigquery::Reservation::V1::BiReservation), request["bi_reservation"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_bi_reservation_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_bi_reservation({ bi_reservation: bi_reservation, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_bi_reservation bi_reservation: bi_reservation, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_bi_reservation ::Google::Cloud::Bigquery::Reservation::V1::UpdateBiReservationRequest.new(bi_reservation: bi_reservation, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_bi_reservation({ bi_reservation: bi_reservation, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_bi_reservation(::Google::Cloud::Bigquery::Reservation::V1::UpdateBiReservationRequest.new(bi_reservation: bi_reservation, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_bi_reservation_client_stub.call_rpc_count
    end
  end

  def test_get_iam_policy
    # Create GRPC objects.
    grpc_response = ::Google::Iam::V1::Policy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    options = {}

    get_iam_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_iam_policy, name
      assert_kind_of ::Google::Iam::V1::GetIamPolicyRequest, request
      assert_equal "hello world", request["resource"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Iam::V1::GetPolicyOptions), request["options"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_iam_policy_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_iam_policy({ resource: resource, options: options }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_iam_policy resource: resource, options: options do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_iam_policy ::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_iam_policy({ resource: resource, options: options }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_iam_policy(::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_iam_policy_client_stub.call_rpc_count
    end
  end

  def test_set_iam_policy
    # Create GRPC objects.
    grpc_response = ::Google::Iam::V1::Policy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    policy = {}
    update_mask = {}

    set_iam_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :set_iam_policy, name
      assert_kind_of ::Google::Iam::V1::SetIamPolicyRequest, request
      assert_equal "hello world", request["resource"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Iam::V1::Policy), request["policy"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, set_iam_policy_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.set_iam_policy resource: resource, policy: policy, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.set_iam_policy ::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.set_iam_policy(::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, set_iam_policy_client_stub.call_rpc_count
    end
  end

  def test_test_iam_permissions
    # Create GRPC objects.
    grpc_response = ::Google::Iam::V1::TestIamPermissionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    permissions = ["hello world"]

    test_iam_permissions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :test_iam_permissions, name
      assert_kind_of ::Google::Iam::V1::TestIamPermissionsRequest, request
      assert_equal "hello world", request["resource"]
      assert_equal ["hello world"], request["permissions"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, test_iam_permissions_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.test_iam_permissions({ resource: resource, permissions: permissions }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.test_iam_permissions resource: resource, permissions: permissions do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.test_iam_permissions ::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.test_iam_permissions({ resource: resource, permissions: permissions }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.test_iam_permissions(::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, test_iam_permissions_client_stub.call_rpc_count
    end
  end

  def test_create_reservation_group
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::Reservation::V1::ReservationGroup.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    reservation_group_id = "hello world"
    reservation_group = {}

    create_reservation_group_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_reservation_group, name
      assert_kind_of ::Google::Cloud::Bigquery::Reservation::V1::CreateReservationGroupRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["reservation_group_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Bigquery::Reservation::V1::ReservationGroup), request["reservation_group"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_reservation_group_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_reservation_group({ parent: parent, reservation_group_id: reservation_group_id, reservation_group: reservation_group }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_reservation_group parent: parent, reservation_group_id: reservation_group_id, reservation_group: reservation_group do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_reservation_group ::Google::Cloud::Bigquery::Reservation::V1::CreateReservationGroupRequest.new(parent: parent, reservation_group_id: reservation_group_id, reservation_group: reservation_group) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_reservation_group({ parent: parent, reservation_group_id: reservation_group_id, reservation_group: reservation_group }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_reservation_group(::Google::Cloud::Bigquery::Reservation::V1::CreateReservationGroupRequest.new(parent: parent, reservation_group_id: reservation_group_id, reservation_group: reservation_group), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_reservation_group_client_stub.call_rpc_count
    end
  end

  def test_get_reservation_group
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::Reservation::V1::ReservationGroup.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_reservation_group_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_reservation_group, name
      assert_kind_of ::Google::Cloud::Bigquery::Reservation::V1::GetReservationGroupRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_reservation_group_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_reservation_group({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_reservation_group name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_reservation_group ::Google::Cloud::Bigquery::Reservation::V1::GetReservationGroupRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_reservation_group({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_reservation_group(::Google::Cloud::Bigquery::Reservation::V1::GetReservationGroupRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_reservation_group_client_stub.call_rpc_count
    end
  end

  def test_delete_reservation_group
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_reservation_group_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_reservation_group, name
      assert_kind_of ::Google::Cloud::Bigquery::Reservation::V1::DeleteReservationGroupRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_reservation_group_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_reservation_group({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_reservation_group name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_reservation_group ::Google::Cloud::Bigquery::Reservation::V1::DeleteReservationGroupRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_reservation_group({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_reservation_group(::Google::Cloud::Bigquery::Reservation::V1::DeleteReservationGroupRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_reservation_group_client_stub.call_rpc_count
    end
  end

  def test_list_reservation_groups
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::Reservation::V1::ListReservationGroupsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_reservation_groups_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_reservation_groups, name
      assert_kind_of ::Google::Cloud::Bigquery::Reservation::V1::ListReservationGroupsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_reservation_groups_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_reservation_groups({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_reservation_groups parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_reservation_groups ::Google::Cloud::Bigquery::Reservation::V1::ListReservationGroupsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_reservation_groups({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_reservation_groups(::Google::Cloud::Bigquery::Reservation::V1::ListReservationGroupsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_reservation_groups_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
