# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/bigquery/reservation/v1/reservation_pb"
require "google/cloud/bigquery/reservation/v1/reservation_service/rest"


class ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_reservation
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::Reservation::V1::Reservation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    reservation_id = "hello world"
    reservation = {}

    create_reservation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::ServiceStub.stub :transcode_create_reservation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_reservation_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_reservation({ parent: parent, reservation_id: reservation_id, reservation: reservation }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_reservation parent: parent, reservation_id: reservation_id, reservation: reservation do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_reservation ::Google::Cloud::Bigquery::Reservation::V1::CreateReservationRequest.new(parent: parent, reservation_id: reservation_id, reservation: reservation) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_reservation({ parent: parent, reservation_id: reservation_id, reservation: reservation }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_reservation(::Google::Cloud::Bigquery::Reservation::V1::CreateReservationRequest.new(parent: parent, reservation_id: reservation_id, reservation: reservation), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_reservation_client_stub.call_count
      end
    end
  end

  def test_list_reservations
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::Reservation::V1::ListReservationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_reservations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::ServiceStub.stub :transcode_list_reservations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_reservations_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_reservations({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_reservations parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_reservations ::Google::Cloud::Bigquery::Reservation::V1::ListReservationsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_reservations({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_reservations(::Google::Cloud::Bigquery::Reservation::V1::ListReservationsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_reservations_client_stub.call_count
      end
    end
  end

  def test_get_reservation
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::Reservation::V1::Reservation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_reservation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::ServiceStub.stub :transcode_get_reservation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_reservation_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_reservation({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_reservation name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_reservation ::Google::Cloud::Bigquery::Reservation::V1::GetReservationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_reservation({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_reservation(::Google::Cloud::Bigquery::Reservation::V1::GetReservationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_reservation_client_stub.call_count
      end
    end
  end

  def test_delete_reservation
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_reservation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::ServiceStub.stub :transcode_delete_reservation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_reservation_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_reservation({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_reservation name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_reservation ::Google::Cloud::Bigquery::Reservation::V1::DeleteReservationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_reservation({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_reservation(::Google::Cloud::Bigquery::Reservation::V1::DeleteReservationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_reservation_client_stub.call_count
      end
    end
  end

  def test_update_reservation
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::Reservation::V1::Reservation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    reservation = {}
    update_mask = {}

    update_reservation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::ServiceStub.stub :transcode_update_reservation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_reservation_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_reservation({ reservation: reservation, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_reservation reservation: reservation, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_reservation ::Google::Cloud::Bigquery::Reservation::V1::UpdateReservationRequest.new(reservation: reservation, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_reservation({ reservation: reservation, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_reservation(::Google::Cloud::Bigquery::Reservation::V1::UpdateReservationRequest.new(reservation: reservation, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_reservation_client_stub.call_count
      end
    end
  end

  def test_failover_reservation
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::Reservation::V1::Reservation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    failover_mode = :FAILOVER_MODE_UNSPECIFIED

    failover_reservation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::ServiceStub.stub :transcode_failover_reservation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, failover_reservation_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.failover_reservation({ name: name, failover_mode: failover_mode }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.failover_reservation name: name, failover_mode: failover_mode do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.failover_reservation ::Google::Cloud::Bigquery::Reservation::V1::FailoverReservationRequest.new(name: name, failover_mode: failover_mode) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.failover_reservation({ name: name, failover_mode: failover_mode }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.failover_reservation(::Google::Cloud::Bigquery::Reservation::V1::FailoverReservationRequest.new(name: name, failover_mode: failover_mode), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, failover_reservation_client_stub.call_count
      end
    end
  end

  def test_create_capacity_commitment
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    capacity_commitment = {}
    enforce_single_admin_project_per_org = true
    capacity_commitment_id = "hello world"

    create_capacity_commitment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::ServiceStub.stub :transcode_create_capacity_commitment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_capacity_commitment_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_capacity_commitment({ parent: parent, capacity_commitment: capacity_commitment, enforce_single_admin_project_per_org: enforce_single_admin_project_per_org, capacity_commitment_id: capacity_commitment_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_capacity_commitment parent: parent, capacity_commitment: capacity_commitment, enforce_single_admin_project_per_org: enforce_single_admin_project_per_org, capacity_commitment_id: capacity_commitment_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_capacity_commitment ::Google::Cloud::Bigquery::Reservation::V1::CreateCapacityCommitmentRequest.new(parent: parent, capacity_commitment: capacity_commitment, enforce_single_admin_project_per_org: enforce_single_admin_project_per_org, capacity_commitment_id: capacity_commitment_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_capacity_commitment({ parent: parent, capacity_commitment: capacity_commitment, enforce_single_admin_project_per_org: enforce_single_admin_project_per_org, capacity_commitment_id: capacity_commitment_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_capacity_commitment(::Google::Cloud::Bigquery::Reservation::V1::CreateCapacityCommitmentRequest.new(parent: parent, capacity_commitment: capacity_commitment, enforce_single_admin_project_per_org: enforce_single_admin_project_per_org, capacity_commitment_id: capacity_commitment_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_capacity_commitment_client_stub.call_count
      end
    end
  end

  def test_list_capacity_commitments
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::Reservation::V1::ListCapacityCommitmentsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_capacity_commitments_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::ServiceStub.stub :transcode_list_capacity_commitments_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_capacity_commitments_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_capacity_commitments({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_capacity_commitments parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_capacity_commitments ::Google::Cloud::Bigquery::Reservation::V1::ListCapacityCommitmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_capacity_commitments({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_capacity_commitments(::Google::Cloud::Bigquery::Reservation::V1::ListCapacityCommitmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_capacity_commitments_client_stub.call_count
      end
    end
  end

  def test_get_capacity_commitment
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_capacity_commitment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::ServiceStub.stub :transcode_get_capacity_commitment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_capacity_commitment_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_capacity_commitment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_capacity_commitment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_capacity_commitment ::Google::Cloud::Bigquery::Reservation::V1::GetCapacityCommitmentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_capacity_commitment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_capacity_commitment(::Google::Cloud::Bigquery::Reservation::V1::GetCapacityCommitmentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_capacity_commitment_client_stub.call_count
      end
    end
  end

  def test_delete_capacity_commitment
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_capacity_commitment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::ServiceStub.stub :transcode_delete_capacity_commitment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_capacity_commitment_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_capacity_commitment({ name: name, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_capacity_commitment name: name, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_capacity_commitment ::Google::Cloud::Bigquery::Reservation::V1::DeleteCapacityCommitmentRequest.new(name: name, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_capacity_commitment({ name: name, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_capacity_commitment(::Google::Cloud::Bigquery::Reservation::V1::DeleteCapacityCommitmentRequest.new(name: name, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_capacity_commitment_client_stub.call_count
      end
    end
  end

  def test_update_capacity_commitment
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    capacity_commitment = {}
    update_mask = {}

    update_capacity_commitment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::ServiceStub.stub :transcode_update_capacity_commitment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_capacity_commitment_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_capacity_commitment({ capacity_commitment: capacity_commitment, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_capacity_commitment capacity_commitment: capacity_commitment, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_capacity_commitment ::Google::Cloud::Bigquery::Reservation::V1::UpdateCapacityCommitmentRequest.new(capacity_commitment: capacity_commitment, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_capacity_commitment({ capacity_commitment: capacity_commitment, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_capacity_commitment(::Google::Cloud::Bigquery::Reservation::V1::UpdateCapacityCommitmentRequest.new(capacity_commitment: capacity_commitment, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_capacity_commitment_client_stub.call_count
      end
    end
  end

  def test_split_capacity_commitment
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::Reservation::V1::SplitCapacityCommitmentResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    slot_count = 42

    split_capacity_commitment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::ServiceStub.stub :transcode_split_capacity_commitment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, split_capacity_commitment_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.split_capacity_commitment({ name: name, slot_count: slot_count }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.split_capacity_commitment name: name, slot_count: slot_count do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.split_capacity_commitment ::Google::Cloud::Bigquery::Reservation::V1::SplitCapacityCommitmentRequest.new(name: name, slot_count: slot_count) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.split_capacity_commitment({ name: name, slot_count: slot_count }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.split_capacity_commitment(::Google::Cloud::Bigquery::Reservation::V1::SplitCapacityCommitmentRequest.new(name: name, slot_count: slot_count), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, split_capacity_commitment_client_stub.call_count
      end
    end
  end

  def test_merge_capacity_commitments
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    capacity_commitment_ids = ["hello world"]
    capacity_commitment_id = "hello world"

    merge_capacity_commitments_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::ServiceStub.stub :transcode_merge_capacity_commitments_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, merge_capacity_commitments_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.merge_capacity_commitments({ parent: parent, capacity_commitment_ids: capacity_commitment_ids, capacity_commitment_id: capacity_commitment_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.merge_capacity_commitments parent: parent, capacity_commitment_ids: capacity_commitment_ids, capacity_commitment_id: capacity_commitment_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.merge_capacity_commitments ::Google::Cloud::Bigquery::Reservation::V1::MergeCapacityCommitmentsRequest.new(parent: parent, capacity_commitment_ids: capacity_commitment_ids, capacity_commitment_id: capacity_commitment_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.merge_capacity_commitments({ parent: parent, capacity_commitment_ids: capacity_commitment_ids, capacity_commitment_id: capacity_commitment_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.merge_capacity_commitments(::Google::Cloud::Bigquery::Reservation::V1::MergeCapacityCommitmentsRequest.new(parent: parent, capacity_commitment_ids: capacity_commitment_ids, capacity_commitment_id: capacity_commitment_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, merge_capacity_commitments_client_stub.call_count
      end
    end
  end

  def test_create_assignment
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::Reservation::V1::Assignment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    assignment = {}
    assignment_id = "hello world"

    create_assignment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::ServiceStub.stub :transcode_create_assignment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_assignment_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_assignment({ parent: parent, assignment: assignment, assignment_id: assignment_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_assignment parent: parent, assignment: assignment, assignment_id: assignment_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_assignment ::Google::Cloud::Bigquery::Reservation::V1::CreateAssignmentRequest.new(parent: parent, assignment: assignment, assignment_id: assignment_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_assignment({ parent: parent, assignment: assignment, assignment_id: assignment_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_assignment(::Google::Cloud::Bigquery::Reservation::V1::CreateAssignmentRequest.new(parent: parent, assignment: assignment, assignment_id: assignment_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_assignment_client_stub.call_count
      end
    end
  end

  def test_list_assignments
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::Reservation::V1::ListAssignmentsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_assignments_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::ServiceStub.stub :transcode_list_assignments_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_assignments_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_assignments({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_assignments parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_assignments ::Google::Cloud::Bigquery::Reservation::V1::ListAssignmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_assignments({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_assignments(::Google::Cloud::Bigquery::Reservation::V1::ListAssignmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_assignments_client_stub.call_count
      end
    end
  end

  def test_delete_assignment
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_assignment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::ServiceStub.stub :transcode_delete_assignment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_assignment_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_assignment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_assignment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_assignment ::Google::Cloud::Bigquery::Reservation::V1::DeleteAssignmentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_assignment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_assignment(::Google::Cloud::Bigquery::Reservation::V1::DeleteAssignmentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_assignment_client_stub.call_count
      end
    end
  end

  def test_search_assignments
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::Reservation::V1::SearchAssignmentsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    query = "hello world"
    page_size = 42
    page_token = "hello world"

    search_assignments_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::ServiceStub.stub :transcode_search_assignments_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, search_assignments_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.search_assignments({ parent: parent, query: query, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.search_assignments parent: parent, query: query, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.search_assignments ::Google::Cloud::Bigquery::Reservation::V1::SearchAssignmentsRequest.new(parent: parent, query: query, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.search_assignments({ parent: parent, query: query, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.search_assignments(::Google::Cloud::Bigquery::Reservation::V1::SearchAssignmentsRequest.new(parent: parent, query: query, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, search_assignments_client_stub.call_count
      end
    end
  end

  def test_search_all_assignments
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::Reservation::V1::SearchAllAssignmentsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    query = "hello world"
    page_size = 42
    page_token = "hello world"

    search_all_assignments_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::ServiceStub.stub :transcode_search_all_assignments_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, search_all_assignments_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.search_all_assignments({ parent: parent, query: query, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.search_all_assignments parent: parent, query: query, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.search_all_assignments ::Google::Cloud::Bigquery::Reservation::V1::SearchAllAssignmentsRequest.new(parent: parent, query: query, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.search_all_assignments({ parent: parent, query: query, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.search_all_assignments(::Google::Cloud::Bigquery::Reservation::V1::SearchAllAssignmentsRequest.new(parent: parent, query: query, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, search_all_assignments_client_stub.call_count
      end
    end
  end

  def test_move_assignment
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::Reservation::V1::Assignment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    destination_id = "hello world"
    assignment_id = "hello world"

    move_assignment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::ServiceStub.stub :transcode_move_assignment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, move_assignment_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.move_assignment({ name: name, destination_id: destination_id, assignment_id: assignment_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.move_assignment name: name, destination_id: destination_id, assignment_id: assignment_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.move_assignment ::Google::Cloud::Bigquery::Reservation::V1::MoveAssignmentRequest.new(name: name, destination_id: destination_id, assignment_id: assignment_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.move_assignment({ name: name, destination_id: destination_id, assignment_id: assignment_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.move_assignment(::Google::Cloud::Bigquery::Reservation::V1::MoveAssignmentRequest.new(name: name, destination_id: destination_id, assignment_id: assignment_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, move_assignment_client_stub.call_count
      end
    end
  end

  def test_update_assignment
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::Reservation::V1::Assignment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    assignment = {}
    update_mask = {}

    update_assignment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::ServiceStub.stub :transcode_update_assignment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_assignment_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_assignment({ assignment: assignment, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_assignment assignment: assignment, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_assignment ::Google::Cloud::Bigquery::Reservation::V1::UpdateAssignmentRequest.new(assignment: assignment, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_assignment({ assignment: assignment, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_assignment(::Google::Cloud::Bigquery::Reservation::V1::UpdateAssignmentRequest.new(assignment: assignment, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_assignment_client_stub.call_count
      end
    end
  end

  def test_get_bi_reservation
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::Reservation::V1::BiReservation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_bi_reservation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::ServiceStub.stub :transcode_get_bi_reservation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_bi_reservation_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_bi_reservation({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_bi_reservation name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_bi_reservation ::Google::Cloud::Bigquery::Reservation::V1::GetBiReservationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_bi_reservation({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_bi_reservation(::Google::Cloud::Bigquery::Reservation::V1::GetBiReservationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_bi_reservation_client_stub.call_count
      end
    end
  end

  def test_update_bi_reservation
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::Reservation::V1::BiReservation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    bi_reservation = {}
    update_mask = {}

    update_bi_reservation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::ServiceStub.stub :transcode_update_bi_reservation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_bi_reservation_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_bi_reservation({ bi_reservation: bi_reservation, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_bi_reservation bi_reservation: bi_reservation, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_bi_reservation ::Google::Cloud::Bigquery::Reservation::V1::UpdateBiReservationRequest.new(bi_reservation: bi_reservation, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_bi_reservation({ bi_reservation: bi_reservation, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_bi_reservation(::Google::Cloud::Bigquery::Reservation::V1::UpdateBiReservationRequest.new(bi_reservation: bi_reservation, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_bi_reservation_client_stub.call_count
      end
    end
  end

  def test_get_iam_policy
    # Create test objects.
    client_result = ::Google::Iam::V1::Policy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    options = {}

    get_iam_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::ServiceStub.stub :transcode_get_iam_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_iam_policy_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_iam_policy({ resource: resource, options: options }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_iam_policy resource: resource, options: options do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_iam_policy ::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_iam_policy({ resource: resource, options: options }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_iam_policy(::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_iam_policy_client_stub.call_count
      end
    end
  end

  def test_set_iam_policy
    # Create test objects.
    client_result = ::Google::Iam::V1::Policy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    policy = {}
    update_mask = {}

    set_iam_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::ServiceStub.stub :transcode_set_iam_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_iam_policy_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_iam_policy resource: resource, policy: policy, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_iam_policy ::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_iam_policy(::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_iam_policy_client_stub.call_count
      end
    end
  end

  def test_test_iam_permissions
    # Create test objects.
    client_result = ::Google::Iam::V1::TestIamPermissionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    permissions = ["hello world"]

    test_iam_permissions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::ServiceStub.stub :transcode_test_iam_permissions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, test_iam_permissions_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.test_iam_permissions({ resource: resource, permissions: permissions }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.test_iam_permissions resource: resource, permissions: permissions do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.test_iam_permissions ::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.test_iam_permissions({ resource: resource, permissions: permissions }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.test_iam_permissions(::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, test_iam_permissions_client_stub.call_count
      end
    end
  end

  def test_create_reservation_group
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::Reservation::V1::ReservationGroup.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    reservation_group_id = "hello world"
    reservation_group = {}

    create_reservation_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::ServiceStub.stub :transcode_create_reservation_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_reservation_group_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_reservation_group({ parent: parent, reservation_group_id: reservation_group_id, reservation_group: reservation_group }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_reservation_group parent: parent, reservation_group_id: reservation_group_id, reservation_group: reservation_group do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_reservation_group ::Google::Cloud::Bigquery::Reservation::V1::CreateReservationGroupRequest.new(parent: parent, reservation_group_id: reservation_group_id, reservation_group: reservation_group) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_reservation_group({ parent: parent, reservation_group_id: reservation_group_id, reservation_group: reservation_group }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_reservation_group(::Google::Cloud::Bigquery::Reservation::V1::CreateReservationGroupRequest.new(parent: parent, reservation_group_id: reservation_group_id, reservation_group: reservation_group), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_reservation_group_client_stub.call_count
      end
    end
  end

  def test_get_reservation_group
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::Reservation::V1::ReservationGroup.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_reservation_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::ServiceStub.stub :transcode_get_reservation_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_reservation_group_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_reservation_group({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_reservation_group name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_reservation_group ::Google::Cloud::Bigquery::Reservation::V1::GetReservationGroupRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_reservation_group({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_reservation_group(::Google::Cloud::Bigquery::Reservation::V1::GetReservationGroupRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_reservation_group_client_stub.call_count
      end
    end
  end

  def test_delete_reservation_group
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_reservation_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::ServiceStub.stub :transcode_delete_reservation_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_reservation_group_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_reservation_group({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_reservation_group name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_reservation_group ::Google::Cloud::Bigquery::Reservation::V1::DeleteReservationGroupRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_reservation_group({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_reservation_group(::Google::Cloud::Bigquery::Reservation::V1::DeleteReservationGroupRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_reservation_group_client_stub.call_count
      end
    end
  end

  def test_list_reservation_groups
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::Reservation::V1::ListReservationGroupsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_reservation_groups_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::ServiceStub.stub :transcode_list_reservation_groups_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_reservation_groups_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_reservation_groups({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_reservation_groups parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_reservation_groups ::Google::Cloud::Bigquery::Reservation::V1::ListReservationGroupsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_reservation_groups({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_reservation_groups(::Google::Cloud::Bigquery::Reservation::V1::ListReservationGroupsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_reservation_groups_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Rest::Client::Configuration, config
  end
end
