# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Bigquery
      module Reservation
        module V1
          # A reservation is a mechanism used to guarantee slots to users.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name of the reservation, e.g.,
          #     `projects/*/locations/*/reservations/team1-prod`.
          #     The reservation_id must only contain lower case alphanumeric characters or
          #     dashes. It must start with a letter and must not end with a dash. Its
          #     maximum length is 64 characters.
          # @!attribute [rw] slot_capacity
          #   @return [::Integer]
          #     Optional. Baseline slots available to this reservation. A slot is a unit of
          #     computational power in BigQuery, and serves as the unit of parallelism.
          #
          #     Queries using this reservation might use more slots during runtime if
          #     ignore_idle_slots is set to false, or autoscaling is enabled.
          #
          #     The total slot_capacity of the reservation and its siblings
          #     may exceed the total slot_count of capacity commitments. In that case, the
          #     exceeding slots will be charged with the autoscale SKU. You can increase
          #     the number of baseline slots in a reservation every few minutes. If you
          #     want to decrease your baseline slots, you are limited to once an hour if
          #     you have recently changed your baseline slot capacity and your baseline
          #     slots exceed your committed slots. Otherwise, you can decrease your
          #     baseline slots every few minutes.
          # @!attribute [rw] ignore_idle_slots
          #   @return [::Boolean]
          #     Optional. If false, any query or pipeline job using this reservation will
          #     use idle slots from other reservations within the same admin project. If
          #     true, a query or pipeline job using this reservation will execute with the
          #     slot capacity specified in the slot_capacity field at most.
          # @!attribute [rw] autoscale
          #   @return [::Google::Cloud::Bigquery::Reservation::V1::Reservation::Autoscale]
          #     Optional. The configuration parameters for the auto scaling feature.
          # @!attribute [rw] concurrency
          #   @return [::Integer]
          #     Optional. Job concurrency target which sets a soft upper bound on the
          #     number of jobs that can run concurrently in this reservation. This is a
          #     soft target due to asynchronous nature of the system and various
          #     optimizations for small queries. Default value is 0 which means that
          #     concurrency target will be automatically computed by the system. NOTE: this
          #     field is exposed as target job concurrency in the Information Schema, DDL
          #     and BigQuery CLI.
          # @!attribute [r] creation_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. Creation time of the reservation.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. Last update time of the reservation.
          # @!attribute [rw] multi_region_auxiliary
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Boolean]
          #     Applicable only for reservations located within one of the BigQuery
          #     multi-regions (US or EU).
          #
          #     If set to true, this reservation is placed in the organization's
          #     secondary region which is designated for disaster recovery purposes.
          #     If false, this reservation is placed in the organization's default region.
          #
          #     NOTE: this is a preview feature. Project must be allow-listed in order to
          #     set this field.
          # @!attribute [rw] edition
          #   @return [::Google::Cloud::Bigquery::Reservation::V1::Edition]
          #     Optional. Edition of the reservation.
          # @!attribute [r] primary_location
          #   @return [::String]
          #     Output only. The current location of the reservation's primary replica.
          #     This field is only set for reservations using the managed disaster recovery
          #     feature.
          # @!attribute [rw] secondary_location
          #   @return [::String]
          #     Optional. The current location of the reservation's secondary replica. This
          #     field is only set for reservations using the managed disaster recovery
          #     feature. Users can set this in create reservation calls
          #     to create a failover reservation or in update reservation calls to convert
          #     a non-failover reservation to a failover reservation(or vice versa).
          # @!attribute [r] original_primary_location
          #   @return [::String]
          #     Output only. The location where the reservation was originally created.
          #     This is set only during the failover reservation's creation. All billing
          #     charges for the failover reservation will be applied to this location.
          # @!attribute [rw] max_slots
          #   @return [::Integer]
          #     Optional. The overall max slots for the reservation, covering slot_capacity
          #     (baseline), idle slots (if ignore_idle_slots is false) and scaled slots.
          #     If present, the reservation won't use more than the specified number of
          #     slots, even if there is demand and supply (from idle slots).
          #     NOTE: capping a reservation's idle slot usage is best effort and its
          #     usage may exceed the max_slots value. However, in terms of
          #     autoscale.current_slots (which accounts for the additional added slots), it
          #     will never exceed the max_slots - baseline.
          #
          #
          #     This field must be set together with the scaling_mode enum value,
          #     otherwise the request will be rejected with error code
          #     `google.rpc.Code.INVALID_ARGUMENT`.
          #
          #     If the max_slots and scaling_mode are set, the autoscale or
          #     autoscale.max_slots field must be unset. Otherwise the request will be
          #     rejected with error code `google.rpc.Code.INVALID_ARGUMENT`. However, the
          #     autoscale field may still be in the output. The autopscale.max_slots will
          #     always show as 0 and the autoscaler.current_slots will represent the
          #     current slots from autoscaler excluding idle slots.
          #     For example, if the max_slots is 1000 and scaling_mode is AUTOSCALE_ONLY,
          #     then in the output, the autoscaler.max_slots will be 0 and the
          #     autoscaler.current_slots may be any value between 0 and 1000.
          #
          #     If the max_slots is 1000, scaling_mode is ALL_SLOTS, the baseline is 100
          #     and idle slots usage is 200, then in the output, the autoscaler.max_slots
          #     will be 0 and the autoscaler.current_slots will not be higher than 700.
          #
          #     If the max_slots is 1000, scaling_mode is IDLE_SLOTS_ONLY, then in the
          #     output, the autoscaler field will be null.
          #
          #     If the max_slots and scaling_mode are set, then the ignore_idle_slots field
          #     must be aligned with the scaling_mode enum value.(See details in
          #     ScalingMode comments). Otherwise the request will be rejected with
          #     error code `google.rpc.Code.INVALID_ARGUMENT`.
          #
          #     Please note,  the max_slots is for user to manage the part of slots greater
          #     than the baseline. Therefore, we don't allow users to set max_slots smaller
          #     or equal to the baseline as it will not be meaningful. If the field is
          #     present and slot_capacity>=max_slots, requests will be rejected with error
          #     code `google.rpc.Code.INVALID_ARGUMENT`.
          #
          #     Please note that if max_slots is set to 0, we will treat it as unset.
          #     Customers can set max_slots to 0 and set scaling_mode to
          #     SCALING_MODE_UNSPECIFIED to disable the max_slots feature.
          # @!attribute [rw] scaling_mode
          #   @return [::Google::Cloud::Bigquery::Reservation::V1::Reservation::ScalingMode]
          #     Optional. The scaling mode for the reservation.
          #     If the field is present but max_slots is not present, requests will be
          #     rejected with error code `google.rpc.Code.INVALID_ARGUMENT`.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. The labels associated with this reservation. You can use these
          #     to organize and group your reservations.
          #     You can set this property when you create or update a reservation.
          # @!attribute [rw] reservation_group
          #   @return [::String]
          #     Optional. The reservation group that this reservation belongs to.
          #     You can set this property when you create or update a reservation.
          #     Reservations do not need to belong to a reservation group.
          #     Format:
          #     projects/\\{project}/locations/\\{location}/reservationGroups/\\{reservation_group}
          #     or just \\{reservation_group}
          # @!attribute [r] replication_status
          #   @return [::Google::Cloud::Bigquery::Reservation::V1::Reservation::ReplicationStatus]
          #     Output only. The Disaster Recovery(DR) replication status of the
          #     reservation. This is only available for the primary replicas of DR/failover
          #     reservations and provides information about the both the staleness of the
          #     secondary and the last error encountered while trying to replicate changes
          #     from the primary to the secondary. If this field is blank, it means that
          #     the reservation is either not a DR reservation or the reservation is a DR
          #     secondary or that any replication operations on the reservation have
          #     succeeded.
          # @!attribute [rw] scheduling_policy
          #   @return [::Google::Cloud::Bigquery::Reservation::V1::SchedulingPolicy]
          #     Optional. The scheduling policy to use for jobs and queries running under
          #     this reservation. The scheduling policy controls how the reservation's
          #     resources are distributed.
          #
          #     This feature is not yet generally available.
          class Reservation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Auto scaling settings.
            # @!attribute [r] current_slots
            #   @return [::Integer]
            #     Output only. The slot capacity added to this reservation when autoscale
            #     happens. Will be between [0, max_slots]. Note: after users reduce
            #     max_slots, it may take a while before it can be propagated, so
            #     current_slots may stay in the original value and could be larger than
            #     max_slots for that brief period (less than one minute)
            # @!attribute [rw] max_slots
            #   @return [::Integer]
            #     Optional. Number of slots to be scaled when needed.
            class Autoscale
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Disaster Recovery(DR) replication status of the reservation.
            # @!attribute [r] error
            #   @return [::Google::Rpc::Status]
            #     Output only. The last error encountered while trying to replicate changes
            #     from the primary to the secondary. This field is only available if the
            #     replication has not succeeded since.
            # @!attribute [r] last_error_time
            #   @return [::Google::Protobuf::Timestamp]
            #     Output only. The time at which the last error was encountered while
            #     trying to replicate changes from the primary to the secondary. This field
            #     is only available if the replication has not succeeded since.
            # @!attribute [r] last_replication_time
            #   @return [::Google::Protobuf::Timestamp]
            #     Output only. A timestamp corresponding to the last change on the primary
            #     that was successfully replicated to the secondary.
            # @!attribute [r] soft_failover_start_time
            #   @return [::Google::Protobuf::Timestamp]
            #     Output only. The time at which a soft failover for the reservation and
            #     its associated datasets was initiated. After this field is set, all
            #     subsequent changes to the reservation will be rejected unless a hard
            #     failover overrides this operation. This field will be cleared once the
            #     failover is complete.
            class ReplicationStatus
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The scaling mode for the reservation. This enum determines how the
            # reservation scales up and down.
            module ScalingMode
              # Default value of ScalingMode.
              SCALING_MODE_UNSPECIFIED = 0

              # The reservation will scale up only using slots from autoscaling. It will
              # not use any idle slots even if there may be some available. The upper
              # limit that autoscaling can scale up to will be max_slots - baseline.
              # For example, if max_slots is 1000, baseline is 200 and customer sets
              # ScalingMode to AUTOSCALE_ONLY, then autoscalerg will scale up to 800
              # slots and no idle slots will be used.
              #
              # Please note, in this mode, the ignore_idle_slots field must be set to
              # true. Otherwise the request will be rejected with error code
              # `google.rpc.Code.INVALID_ARGUMENT`.
              AUTOSCALE_ONLY = 1

              # The reservation will scale up using only idle slots contributed by
              # other reservations or from unassigned commitments. If no idle slots are
              # available it will not scale up further. If the idle slots which it is
              # using are reclaimed by the contributing reservation(s) it may be forced
              # to scale down. The max idle slots the reservation can be max_slots -
              # baseline capacity. For example, if max_slots is 1000, baseline is 200 and
              # customer sets ScalingMode to IDLE_SLOTS_ONLY,
              # 1. if there are 1000 idle slots available in other reservations, the
              # reservation will scale up to 1000 slots with 200 baseline and 800 idle
              # slots.
              # 2. if there are 500 idle slots available in other reservations, the
              # reservation will scale up to 700 slots with 200 baseline and 300 idle
              # slots.
              # Please note, in this mode, the reservation might not be able to scale up
              # to max_slots.
              #
              # Please note, in this mode, the ignore_idle_slots field must be set to
              # false. Otherwise the request will be rejected with error code
              # `google.rpc.Code.INVALID_ARGUMENT`.
              IDLE_SLOTS_ONLY = 2

              # The reservation will scale up using all slots available to it. It will
              # use idle slots contributed by other reservations or from unassigned
              # commitments first. If no idle slots are available it will scale up using
              # autoscaling. For example, if max_slots is 1000, baseline is 200 and
              # customer sets ScalingMode to ALL_SLOTS,
              # 1. if there are 800 idle slots available in other reservations, the
              # reservation will scale up to 1000 slots with 200 baseline and 800 idle
              # slots.
              # 2. if there are 500 idle slots available in other reservations, the
              # reservation will scale up to 1000 slots with 200 baseline, 500 idle
              # slots and 300 autoscaling slots.
              # 3. if there are no idle slots available in other reservations, it will
              # scale up to 1000 slots with 200 baseline and 800 autoscaling slots.
              #
              # Please note, in this mode, the ignore_idle_slots field must be set to
              # false. Otherwise the request will be rejected with error code
              # `google.rpc.Code.INVALID_ARGUMENT`.
              ALL_SLOTS = 3
            end
          end

          # The scheduling policy controls how a reservation's resources are distributed.
          # @!attribute [rw] concurrency
          #   @return [::Integer]
          #     Optional. If present and > 0, the reservation will attempt to limit the
          #     concurrency of jobs running for any particular project within it to the
          #     given value.
          #
          #     This feature is not yet generally available.
          # @!attribute [rw] max_slots
          #   @return [::Integer]
          #     Optional. If present and > 0, the reservation will attempt to limit the
          #     slot consumption of queries running for any particular project within it to
          #     the given value.
          #
          #     This feature is not yet generally available.
          class SchedulingPolicy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A reservation group is a container for reservations.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name of the reservation group, e.g.,
          #     `projects/*/locations/*/reservationGroups/team1-prod`.
          #     The reservation_group_id must only contain lower case alphanumeric
          #     characters or dashes. It must start with a letter and must not end with a
          #     dash. Its maximum length is 64 characters.
          class ReservationGroup
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Capacity commitment is a way to purchase compute capacity for BigQuery jobs
          # (in the form of slots) with some committed period of usage. Annual
          # commitments renew by default. Commitments can be removed after their
          # commitment end time passes.
          #
          # In order to remove annual commitment, its plan needs to be changed
          # to monthly or flex first.
          #
          # A capacity commitment resource exists as a child resource of the admin
          # project.
          # @!attribute [r] name
          #   @return [::String]
          #     Output only. The resource name of the capacity commitment, e.g.,
          #     `projects/myproject/locations/US/capacityCommitments/123`
          #     The commitment_id must only contain lower case alphanumeric characters or
          #     dashes. It must start with a letter and must not end
          #     with a dash. Its maximum length is 64 characters.
          # @!attribute [rw] slot_count
          #   @return [::Integer]
          #     Optional. Number of slots in this commitment.
          # @!attribute [rw] plan
          #   @return [::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment::CommitmentPlan]
          #     Optional. Capacity commitment commitment plan.
          # @!attribute [r] state
          #   @return [::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment::State]
          #     Output only. State of the commitment.
          # @!attribute [r] commitment_start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The start of the current commitment period. It is applicable
          #     only for ACTIVE capacity commitments. Note after the commitment is renewed,
          #     commitment_start_time won't be changed. It refers to the start time of the
          #     original commitment.
          # @!attribute [r] commitment_end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The end of the current commitment period. It is applicable
          #     only for ACTIVE capacity commitments. Note after renewal,
          #     commitment_end_time is the time the renewed commitment expires. So itwould
          #     be at a time after commitment_start_time + committed period, because we
          #     don't change commitment_start_time ,
          # @!attribute [r] failure_status
          #   @return [::Google::Rpc::Status]
          #     Output only. For FAILED commitment plan, provides the reason of failure.
          # @!attribute [rw] renewal_plan
          #   @return [::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment::CommitmentPlan]
          #     Optional. The plan this capacity commitment is converted to after
          #     commitment_end_time passes. Once the plan is changed, committed period is
          #     extended according to commitment plan. Only applicable for ANNUAL and TRIAL
          #     commitments.
          # @!attribute [rw] multi_region_auxiliary
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Boolean]
          #     Applicable only for commitments located within one of the BigQuery
          #     multi-regions (US or EU).
          #
          #     If set to true, this commitment is placed in the organization's
          #     secondary region which is designated for disaster recovery purposes.
          #     If false, this commitment is placed in the organization's default region.
          #
          #     NOTE: this is a preview feature. Project must be allow-listed in order to
          #     set this field.
          # @!attribute [rw] edition
          #   @return [::Google::Cloud::Bigquery::Reservation::V1::Edition]
          #     Optional. Edition of the capacity commitment.
          # @!attribute [r] is_flat_rate
          #   @return [::Boolean]
          #     Output only. If true, the commitment is a flat-rate commitment, otherwise,
          #     it's an edition commitment.
          class CapacityCommitment
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Commitment plan defines the current committed period. Capacity commitment
            # cannot be deleted during it's committed period.
            module CommitmentPlan
              # Invalid plan value. Requests with this value will be rejected with
              # error code `google.rpc.Code.INVALID_ARGUMENT`.
              COMMITMENT_PLAN_UNSPECIFIED = 0

              # Flex commitments have committed period of 1 minute after becoming ACTIVE.
              # After that, they are not in a committed period anymore and can be removed
              # any time.
              FLEX = 3

              # Same as FLEX, should only be used if flat-rate commitments are still
              # available.
              FLEX_FLAT_RATE = 7

              # Trial commitments have a committed period of 182 days after becoming
              # ACTIVE. After that, they are converted to a new commitment based on the
              # `renewal_plan`. Default `renewal_plan` for Trial commitment is Flex so
              # that it can be deleted right after committed period ends.
              TRIAL = 5

              # Monthly commitments have a committed period of 30 days after becoming
              # ACTIVE. After that, they are not in a committed period anymore and can be
              # removed any time.
              MONTHLY = 2

              # Same as MONTHLY, should only be used if flat-rate commitments are still
              # available.
              MONTHLY_FLAT_RATE = 8

              # Annual commitments have a committed period of 365 days after becoming
              # ACTIVE. After that they are converted to a new commitment based on the
              # renewal_plan.
              ANNUAL = 4

              # Same as ANNUAL, should only be used if flat-rate commitments are still
              # available.
              ANNUAL_FLAT_RATE = 9

              # 3-year commitments have a committed period of 1095(3 * 365) days after
              # becoming ACTIVE. After that they are converted to a new commitment based
              # on the renewal_plan.
              THREE_YEAR = 10

              # Should only be used for `renewal_plan` and is only meaningful if
              # edition is specified to values other than EDITION_UNSPECIFIED. Otherwise
              # CreateCapacityCommitmentRequest or UpdateCapacityCommitmentRequest will
              # be rejected with error code `google.rpc.Code.INVALID_ARGUMENT`. If the
              # renewal_plan is NONE, capacity commitment will be removed at the end of
              # its commitment period.
              NONE = 6
            end

            # Capacity commitment can either become ACTIVE right away or transition
            # from PENDING to ACTIVE or FAILED.
            module State
              # Invalid state value.
              STATE_UNSPECIFIED = 0

              # Capacity commitment is pending provisioning. Pending capacity commitment
              # does not contribute to the project's slot_capacity.
              PENDING = 1

              # Once slots are provisioned, capacity commitment becomes active.
              # slot_count is added to the project's slot_capacity.
              ACTIVE = 2

              # Capacity commitment is failed to be activated by the backend.
              FAILED = 3
            end
          end

          # The request for
          # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client#create_reservation ReservationService.CreateReservation}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. Project, location. E.g.,
          #     `projects/myproject/locations/US`
          # @!attribute [rw] reservation_id
          #   @return [::String]
          #     The reservation ID. It must only contain lower case alphanumeric
          #     characters or dashes. It must start with a letter and must not end
          #     with a dash. Its maximum length is 64 characters.
          # @!attribute [rw] reservation
          #   @return [::Google::Cloud::Bigquery::Reservation::V1::Reservation]
          #     Definition of the new reservation to create.
          class CreateReservationRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client#list_reservations ReservationService.ListReservations}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent resource name containing project and location, e.g.:
          #       `projects/myproject/locations/US`
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of items to return per page.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     The next_page_token value returned from a previous List request, if any.
          class ListReservationsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response for
          # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client#list_reservations ReservationService.ListReservations}.
          # @!attribute [rw] reservations
          #   @return [::Array<::Google::Cloud::Bigquery::Reservation::V1::Reservation>]
          #     List of reservations visible to the user.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     Token to retrieve the next page of results, or empty if there are no
          #     more results in the list.
          class ListReservationsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client#get_reservation ReservationService.GetReservation}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Resource name of the reservation to retrieve. E.g.,
          #        `projects/myproject/locations/US/reservations/team1-prod`
          class GetReservationRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client#delete_reservation ReservationService.DeleteReservation}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Resource name of the reservation to retrieve. E.g.,
          #        `projects/myproject/locations/US/reservations/team1-prod`
          class DeleteReservationRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client#update_reservation ReservationService.UpdateReservation}.
          # @!attribute [rw] reservation
          #   @return [::Google::Cloud::Bigquery::Reservation::V1::Reservation]
          #     Content of the reservation to update.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Standard field mask for the set of fields to be updated.
          class UpdateReservationRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for ReservationService.FailoverReservation.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Resource name of the reservation to failover. E.g.,
          #        `projects/myproject/locations/US/reservations/team1-prod`
          # @!attribute [rw] failover_mode
          #   @return [::Google::Cloud::Bigquery::Reservation::V1::FailoverMode]
          #     Optional. A parameter that determines how writes that are pending
          #     replication are handled after a failover is initiated. If not specified,
          #     HARD failover mode is used by default.
          class FailoverReservationRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client#create_reservation_group ReservationService.CreateReservationGroup}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. Project, location. E.g.,
          #     `projects/myproject/locations/US`
          # @!attribute [rw] reservation_group_id
          #   @return [::String]
          #     Required. The reservation group ID. It must only contain lower case
          #     alphanumeric characters or dashes. It must start with a letter and must not
          #     end with a dash. Its maximum length is 64 characters.
          # @!attribute [rw] reservation_group
          #   @return [::Google::Cloud::Bigquery::Reservation::V1::ReservationGroup]
          #     Required. New Reservation Group to create.
          class CreateReservationGroupRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client#get_reservation_group ReservationService.GetReservationGroup}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Resource name of the reservation group to retrieve. E.g.,
          #        `projects/myproject/locations/US/reservationGroups/team1-prod`
          class GetReservationGroupRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client#list_reservation_groups ReservationService.ListReservationGroups}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent resource name containing project and location, e.g.:
          #       `projects/myproject/locations/US`
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of items to return per page.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     The next_page_token value returned from a previous List request, if any.
          class ListReservationGroupsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response for
          # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client#list_reservation_groups ReservationService.ListReservationGroups}.
          # @!attribute [rw] reservation_groups
          #   @return [::Array<::Google::Cloud::Bigquery::Reservation::V1::ReservationGroup>]
          #     List of reservations visible to the user.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     Token to retrieve the next page of results, or empty if there are no
          #     more results in the list.
          class ListReservationGroupsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client#delete_reservation_group ReservationService.DeleteReservationGroup}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Resource name of the reservation group to retrieve. E.g.,
          #        `projects/myproject/locations/US/reservationGroups/team1-prod`
          class DeleteReservationGroupRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client#create_capacity_commitment ReservationService.CreateCapacityCommitment}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. Resource name of the parent reservation. E.g.,
          #        `projects/myproject/locations/US`
          # @!attribute [rw] capacity_commitment
          #   @return [::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment]
          #     Content of the capacity commitment to create.
          # @!attribute [rw] enforce_single_admin_project_per_org
          #   @return [::Boolean]
          #     If true, fail the request if another project in the organization has a
          #     capacity commitment.
          # @!attribute [rw] capacity_commitment_id
          #   @return [::String]
          #     The optional capacity commitment ID. Capacity commitment name will be
          #     generated automatically if this field is empty.
          #     This field must only contain lower case alphanumeric characters or dashes.
          #     The first and last character cannot be a dash. Max length is 64 characters.
          #     NOTE: this ID won't be kept if the capacity commitment is split or merged.
          class CreateCapacityCommitmentRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client#list_capacity_commitments ReservationService.ListCapacityCommitments}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. Resource name of the parent reservation. E.g.,
          #        `projects/myproject/locations/US`
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of items to return.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     The next_page_token value returned from a previous List request, if any.
          class ListCapacityCommitmentsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response for
          # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client#list_capacity_commitments ReservationService.ListCapacityCommitments}.
          # @!attribute [rw] capacity_commitments
          #   @return [::Array<::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment>]
          #     List of capacity commitments visible to the user.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     Token to retrieve the next page of results, or empty if there are no
          #     more results in the list.
          class ListCapacityCommitmentsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client#get_capacity_commitment ReservationService.GetCapacityCommitment}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Resource name of the capacity commitment to retrieve. E.g.,
          #        `projects/myproject/locations/US/capacityCommitments/123`
          class GetCapacityCommitmentRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client#delete_capacity_commitment ReservationService.DeleteCapacityCommitment}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Resource name of the capacity commitment to delete. E.g.,
          #        `projects/myproject/locations/US/capacityCommitments/123`
          # @!attribute [rw] force
          #   @return [::Boolean]
          #     Can be used to force delete commitments even if assignments exist. Deleting
          #     commitments with assignments may cause queries to fail if they no longer
          #     have access to slots.
          class DeleteCapacityCommitmentRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client#update_capacity_commitment ReservationService.UpdateCapacityCommitment}.
          # @!attribute [rw] capacity_commitment
          #   @return [::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment]
          #     Content of the capacity commitment to update.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Standard field mask for the set of fields to be updated.
          class UpdateCapacityCommitmentRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client#split_capacity_commitment ReservationService.SplitCapacityCommitment}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name e.g.,:
          #      `projects/myproject/locations/US/capacityCommitments/123`
          # @!attribute [rw] slot_count
          #   @return [::Integer]
          #     Number of slots in the capacity commitment after the split.
          class SplitCapacityCommitmentRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response for
          # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client#split_capacity_commitment ReservationService.SplitCapacityCommitment}.
          # @!attribute [rw] first
          #   @return [::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment]
          #     First capacity commitment, result of a split.
          # @!attribute [rw] second
          #   @return [::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment]
          #     Second capacity commitment, result of a split.
          class SplitCapacityCommitmentResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client#merge_capacity_commitments ReservationService.MergeCapacityCommitments}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Parent resource that identifies admin project and location e.g.,
          #      `projects/myproject/locations/us`
          # @!attribute [rw] capacity_commitment_ids
          #   @return [::Array<::String>]
          #     Ids of capacity commitments to merge.
          #     These capacity commitments must exist under admin project and location
          #     specified in the parent.
          #     ID is the last portion of capacity commitment name e.g., 'abc' for
          #     projects/myproject/locations/US/capacityCommitments/abc
          # @!attribute [rw] capacity_commitment_id
          #   @return [::String]
          #     Optional. The optional resulting capacity commitment ID. Capacity
          #     commitment name will be generated automatically if this field is empty.
          #     This field must only contain lower case alphanumeric characters or dashes.
          #     The first and last character cannot be a dash. Max length is 64 characters.
          class MergeCapacityCommitmentsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # An assignment allows a project to submit jobs
          # of a certain type using slots from the specified reservation.
          # @!attribute [r] name
          #   @return [::String]
          #     Output only. Name of the resource. E.g.:
          #     `projects/myproject/locations/US/reservations/team1-prod/assignments/123`.
          #     The assignment_id must only contain lower case alphanumeric characters or
          #     dashes and the max length is 64 characters.
          # @!attribute [rw] assignee
          #   @return [::String]
          #     Optional. The resource which will use the reservation. E.g.
          #     `projects/myproject`, `folders/123`, or `organizations/456`.
          # @!attribute [rw] job_type
          #   @return [::Google::Cloud::Bigquery::Reservation::V1::Assignment::JobType]
          #     Optional. Which type of jobs will use the reservation.
          # @!attribute [r] state
          #   @return [::Google::Cloud::Bigquery::Reservation::V1::Assignment::State]
          #     Output only. State of the assignment.
          # @!attribute [rw] enable_gemini_in_bigquery
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Boolean]
          #     Optional. Deprecated: "Gemini in BigQuery" is now available by
          #     default for all BigQuery editions and should not be explicitly set.
          #     Controls if "Gemini in BigQuery"
          #     (https://cloud.google.com/gemini/docs/bigquery/overview) features should be
          #     enabled for this reservation assignment.
          # @!attribute [rw] scheduling_policy
          #   @return [::Google::Cloud::Bigquery::Reservation::V1::SchedulingPolicy]
          #     Optional. The scheduling policy to use for jobs and queries of this
          #     assignee when running under the associated reservation. The scheduling
          #     policy controls how the reservation's resources are distributed. This
          #     overrides the default scheduling policy specified on the reservation.
          #
          #     This feature is not yet generally available.
          class Assignment
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Types of job, which could be specified when using the reservation.
            module JobType
              # Invalid type. Requests with this value will be rejected with
              # error code `google.rpc.Code.INVALID_ARGUMENT`.
              JOB_TYPE_UNSPECIFIED = 0

              # Pipeline (load/export) jobs from the project will use the reservation.
              PIPELINE = 1

              # Query jobs from the project will use the reservation.
              QUERY = 2

              # BigQuery ML jobs that use services external to BigQuery for model
              # training. These jobs will not utilize idle slots from other reservations.
              ML_EXTERNAL = 3

              # Background jobs that BigQuery runs for the customers in the background.
              BACKGROUND = 4

              # Continuous SQL jobs will use this reservation. Reservations with
              # continuous assignments cannot be mixed with non-continuous assignments.
              CONTINUOUS = 6

              # Finer granularity background jobs for capturing changes in a source
              # database and streaming them into BigQuery. Reservations with this job
              # type take priority over a default BACKGROUND reservation assignment (if
              # it exists).
              BACKGROUND_CHANGE_DATA_CAPTURE = 7

              # Finer granularity background jobs for refreshing cached metadata for
              # BigQuery tables. Reservations with this job type take priority over a
              # default BACKGROUND reservation assignment (if it exists).
              BACKGROUND_COLUMN_METADATA_INDEX = 8

              # Finer granularity background jobs for refreshing search indexes upon
              # BigQuery table columns. Reservations with this job type
              # take priority over a default BACKGROUND reservation assignment (if it
              # exists).
              BACKGROUND_SEARCH_INDEX_REFRESH = 9
            end

            # Assignment will remain in PENDING state if no active capacity commitment is
            # present. It will become ACTIVE when some capacity commitment becomes
            # active.
            module State
              # Invalid state value.
              STATE_UNSPECIFIED = 0

              # Queries from assignee will be executed as on-demand, if related
              # assignment is pending.
              PENDING = 1

              # Assignment is ready.
              ACTIVE = 2
            end
          end

          # The request for
          # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client#create_assignment ReservationService.CreateAssignment}.
          # Note: "bigquery.reservationAssignments.create" permission is required on the
          # related assignee.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent resource name of the assignment
          #     E.g. `projects/myproject/locations/US/reservations/team1-prod`
          # @!attribute [rw] assignment
          #   @return [::Google::Cloud::Bigquery::Reservation::V1::Assignment]
          #     Assignment resource to create.
          # @!attribute [rw] assignment_id
          #   @return [::String]
          #     The optional assignment ID. Assignment name will be generated automatically
          #     if this field is empty.
          #     This field must only contain lower case alphanumeric characters or dashes.
          #     Max length is 64 characters.
          class CreateAssignmentRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client#list_assignments ReservationService.ListAssignments}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent resource name e.g.:
          #
          #     `projects/myproject/locations/US/reservations/team1-prod`
          #
          #     Or:
          #
          #     `projects/myproject/locations/US/reservations/-`
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of items to return per page.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     The next_page_token value returned from a previous List request, if any.
          class ListAssignmentsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response for
          # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client#list_assignments ReservationService.ListAssignments}.
          # @!attribute [rw] assignments
          #   @return [::Array<::Google::Cloud::Bigquery::Reservation::V1::Assignment>]
          #     List of assignments visible to the user.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     Token to retrieve the next page of results, or empty if there are no
          #     more results in the list.
          class ListAssignmentsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client#delete_assignment ReservationService.DeleteAssignment}.
          # Note: "bigquery.reservationAssignments.delete" permission is required on the
          # related assignee.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Name of the resource, e.g.
          #       `projects/myproject/locations/US/reservations/team1-prod/assignments/123`
          class DeleteAssignmentRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client#search_assignments ReservationService.SearchAssignments}.
          # Note: "bigquery.reservationAssignments.search" permission is required on the
          # related assignee.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The resource name of the admin project(containing project and
          #     location), e.g.:
          #       `projects/myproject/locations/US`.
          # @!attribute [rw] query
          #   @return [::String]
          #     Please specify resource name as assignee in the query.
          #
          #     Examples:
          #
          #     * `assignee=projects/myproject`
          #     * `assignee=folders/123`
          #     * `assignee=organizations/456`
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of items to return per page.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     The next_page_token value returned from a previous List request, if any.
          class SearchAssignmentsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client#search_all_assignments ReservationService.SearchAllAssignments}.
          # Note: "bigquery.reservationAssignments.search" permission is required on the
          # related assignee.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The resource name with location (project name could be the
          #     wildcard '-'), e.g.:
          #       `projects/-/locations/US`.
          # @!attribute [rw] query
          #   @return [::String]
          #     Please specify resource name as assignee in the query.
          #
          #     Examples:
          #
          #     * `assignee=projects/myproject`
          #     * `assignee=folders/123`
          #     * `assignee=organizations/456`
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of items to return per page.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     The next_page_token value returned from a previous List request, if any.
          class SearchAllAssignmentsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response for
          # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client#search_assignments ReservationService.SearchAssignments}.
          # @!attribute [rw] assignments
          #   @return [::Array<::Google::Cloud::Bigquery::Reservation::V1::Assignment>]
          #     List of assignments visible to the user.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     Token to retrieve the next page of results, or empty if there are no
          #     more results in the list.
          class SearchAssignmentsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response for
          # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client#search_all_assignments ReservationService.SearchAllAssignments}.
          # @!attribute [rw] assignments
          #   @return [::Array<::Google::Cloud::Bigquery::Reservation::V1::Assignment>]
          #     List of assignments visible to the user.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     Token to retrieve the next page of results, or empty if there are no
          #     more results in the list.
          class SearchAllAssignmentsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client#move_assignment ReservationService.MoveAssignment}.
          #
          # **Note**: "bigquery.reservationAssignments.create" permission is required on
          # the destination_id.
          #
          # **Note**: "bigquery.reservationAssignments.create" and
          # "bigquery.reservationAssignments.delete" permission are required on the
          # related assignee.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the assignment,
          #     e.g.
          #     `projects/myproject/locations/US/reservations/team1-prod/assignments/123`
          # @!attribute [rw] destination_id
          #   @return [::String]
          #     The new reservation ID, e.g.:
          #       `projects/myotherproject/locations/US/reservations/team2-prod`
          # @!attribute [rw] assignment_id
          #   @return [::String]
          #     The optional assignment ID. A new assignment name is generated if this
          #     field is empty.
          #
          #     This field can contain only lowercase alphanumeric characters or dashes.
          #     Max length is 64 characters.
          class MoveAssignmentRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client#update_assignment ReservationService.UpdateAssignment}.
          # @!attribute [rw] assignment
          #   @return [::Google::Cloud::Bigquery::Reservation::V1::Assignment]
          #     Content of the assignment to update.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Standard field mask for the set of fields to be updated.
          class UpdateAssignmentRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Fully qualified reference to BigQuery table.
          # Internally stored as google.cloud.bi.v1.BqTableReference.
          # @!attribute [rw] project_id
          #   @return [::String]
          #     Optional. The assigned project ID of the project.
          # @!attribute [rw] dataset_id
          #   @return [::String]
          #     Optional. The ID of the dataset in the above project.
          # @!attribute [rw] table_id
          #   @return [::String]
          #     Optional. The ID of the table in the above dataset.
          class TableReference
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents a BI Reservation.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name of the singleton BI reservation.
          #     Reservation names have the form
          #     `projects/{project_id}/locations/{location_id}/biReservation`.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The last update timestamp of a reservation.
          # @!attribute [rw] size
          #   @return [::Integer]
          #     Optional. Size of a reservation, in bytes.
          # @!attribute [rw] preferred_tables
          #   @return [::Array<::Google::Cloud::Bigquery::Reservation::V1::TableReference>]
          #     Optional. Preferred tables to use BI capacity for.
          class BiReservation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A request to get a singleton BI reservation.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Name of the requested reservation, for example:
          #     `projects/{project_id}/locations/{location_id}/biReservation`
          class GetBiReservationRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A request to update a BI reservation.
          # @!attribute [rw] bi_reservation
          #   @return [::Google::Cloud::Bigquery::Reservation::V1::BiReservation]
          #     A reservation to update.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     A list of fields to be updated in this request.
          class UpdateBiReservationRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The type of editions.
          # Different features and behaviors are provided to different editions
          # Capacity commitments and reservations are linked to editions.
          module Edition
            # Default value, which will be treated as ENTERPRISE.
            EDITION_UNSPECIFIED = 0

            # Standard edition.
            STANDARD = 1

            # Enterprise edition.
            ENTERPRISE = 2

            # Enterprise Plus edition.
            ENTERPRISE_PLUS = 3
          end

          # The failover mode when a user initiates a failover on a reservation
          # determines how writes that are pending replication are handled after the
          # failover is initiated.
          module FailoverMode
            # Invalid value.
            FAILOVER_MODE_UNSPECIFIED = 0

            # When customers initiate a soft failover, BigQuery will wait until all
            # committed writes are replicated to the secondary. This mode requires both
            # regions to be available for the failover to succeed and prevents data loss.
            SOFT = 1

            # When customers initiate a hard failover, BigQuery will not wait until all
            # committed writes are replicated to the secondary. There can be data loss
            # for hard failover.
            HARD = 2
          end
        end
      end
    end
  end
end
