# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/bigquery/reservation/v1/reservation_pb"

module Google
  module Cloud
    module Bigquery
      module Reservation
        module V1
          module ReservationService
            ##
            # Client for the ReservationService service.
            #
            # This API allows users to manage their BigQuery reservations.
            #
            # A reservation provides computational resource guarantees, in the form of
            # [slots](https://cloud.google.com/bigquery/docs/slots), to users. A slot is a
            # unit of computational power in BigQuery, and serves as the basic unit of
            # parallelism. In a scan of a multi-partitioned table, a single slot operates
            # on a single partition of the table. A reservation resource exists as a child
            # resource of the admin project and location, e.g.:
            #   `projects/myproject/locations/US/reservations/reservationName`.
            #
            # A capacity commitment is a way to purchase compute capacity for BigQuery jobs
            # (in the form of slots) with some committed period of usage. A capacity
            # commitment resource exists as a child resource of the admin project and
            # location, e.g.:
            #   `projects/myproject/locations/US/capacityCommitments/id`.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "bigqueryreservation.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :reservation_service_stub

              ##
              # Configure the ReservationService Client class.
              #
              # See {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all ReservationService clients
              #   ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Bigquery", "Reservation", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.create_reservation.timeout = 300.0

                  default_config.rpcs.list_reservations.timeout = 300.0
                  default_config.rpcs.list_reservations.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.get_reservation.timeout = 300.0
                  default_config.rpcs.get_reservation.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.delete_reservation.timeout = 300.0
                  default_config.rpcs.delete_reservation.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.update_reservation.timeout = 300.0

                  default_config.rpcs.failover_reservation.timeout = 300.0

                  default_config.rpcs.create_capacity_commitment.timeout = 300.0

                  default_config.rpcs.list_capacity_commitments.timeout = 300.0
                  default_config.rpcs.list_capacity_commitments.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.get_capacity_commitment.timeout = 300.0
                  default_config.rpcs.get_capacity_commitment.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.delete_capacity_commitment.timeout = 300.0
                  default_config.rpcs.delete_capacity_commitment.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.update_capacity_commitment.timeout = 300.0

                  default_config.rpcs.split_capacity_commitment.timeout = 300.0

                  default_config.rpcs.merge_capacity_commitments.timeout = 300.0

                  default_config.rpcs.create_assignment.timeout = 300.0

                  default_config.rpcs.list_assignments.timeout = 300.0
                  default_config.rpcs.list_assignments.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.delete_assignment.timeout = 300.0
                  default_config.rpcs.delete_assignment.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.search_assignments.timeout = 300.0
                  default_config.rpcs.search_assignments.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.move_assignment.timeout = 300.0

                  default_config.rpcs.get_bi_reservation.timeout = 300.0
                  default_config.rpcs.get_bi_reservation.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.update_bi_reservation.timeout = 300.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the ReservationService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @reservation_service_stub.universe_domain
              end

              ##
              # Create a new ReservationService client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the ReservationService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # These require statements are intentionally placed here to initialize
                # the gRPC module only when it's required.
                # See https://github.com/googleapis/toolkit/issues/446
                require "gapic/grpc"
                require "google/cloud/bigquery/reservation/v1/reservation_services_pb"

                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end
                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @reservation_service_stub = ::Gapic::ServiceStub.new(
                  ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Stub,
                  credentials: credentials,
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  channel_args: @config.channel_args,
                  interceptors: @config.interceptors,
                  channel_pool_config: @config.channel_pool,
                  logger: @config.logger
                )

                @reservation_service_stub.stub_logger&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @reservation_service_stub.logger
              end

              # Service calls

              ##
              # Creates a new reservation resource.
              #
              # @overload create_reservation(request, options = nil)
              #   Pass arguments to `create_reservation` via a request object, either of type
              #   {::Google::Cloud::Bigquery::Reservation::V1::CreateReservationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::Reservation::V1::CreateReservationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_reservation(parent: nil, reservation_id: nil, reservation: nil)
              #   Pass arguments to `create_reservation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Project, location. E.g.,
              #     `projects/myproject/locations/US`
              #   @param reservation_id [::String]
              #     The reservation ID. It must only contain lower case alphanumeric
              #     characters or dashes. It must start with a letter and must not end
              #     with a dash. Its maximum length is 64 characters.
              #   @param reservation [::Google::Cloud::Bigquery::Reservation::V1::Reservation, ::Hash]
              #     Definition of the new reservation to create.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigquery::Reservation::V1::Reservation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigquery::Reservation::V1::Reservation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/reservation/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::Reservation::V1::CreateReservationRequest.new
              #
              #   # Call the create_reservation method.
              #   result = client.create_reservation request
              #
              #   # The returned object is of type Google::Cloud::Bigquery::Reservation::V1::Reservation.
              #   p result
              #
              def create_reservation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Reservation::V1::CreateReservationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_reservation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::Reservation::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_reservation.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_reservation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reservation_service_stub.call_rpc :create_reservation, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all the reservations for the project in the specified location.
              #
              # @overload list_reservations(request, options = nil)
              #   Pass arguments to `list_reservations` via a request object, either of type
              #   {::Google::Cloud::Bigquery::Reservation::V1::ListReservationsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::Reservation::V1::ListReservationsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_reservations(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_reservations` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource name containing project and location, e.g.:
              #       `projects/myproject/locations/US`
              #   @param page_size [::Integer]
              #     The maximum number of items to return per page.
              #   @param page_token [::String]
              #     The next_page_token value returned from a previous List request, if any.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Bigquery::Reservation::V1::Reservation>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Bigquery::Reservation::V1::Reservation>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/reservation/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::Reservation::V1::ListReservationsRequest.new
              #
              #   # Call the list_reservations method.
              #   result = client.list_reservations request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Bigquery::Reservation::V1::Reservation.
              #     p item
              #   end
              #
              def list_reservations request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Reservation::V1::ListReservationsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_reservations.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::Reservation::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_reservations.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_reservations.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reservation_service_stub.call_rpc :list_reservations, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @reservation_service_stub, :list_reservations, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns information about the reservation.
              #
              # @overload get_reservation(request, options = nil)
              #   Pass arguments to `get_reservation` via a request object, either of type
              #   {::Google::Cloud::Bigquery::Reservation::V1::GetReservationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::Reservation::V1::GetReservationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_reservation(name: nil)
              #   Pass arguments to `get_reservation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the reservation to retrieve. E.g.,
              #        `projects/myproject/locations/US/reservations/team1-prod`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigquery::Reservation::V1::Reservation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigquery::Reservation::V1::Reservation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/reservation/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::Reservation::V1::GetReservationRequest.new
              #
              #   # Call the get_reservation method.
              #   result = client.get_reservation request
              #
              #   # The returned object is of type Google::Cloud::Bigquery::Reservation::V1::Reservation.
              #   p result
              #
              def get_reservation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Reservation::V1::GetReservationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_reservation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::Reservation::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_reservation.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_reservation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reservation_service_stub.call_rpc :get_reservation, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a reservation.
              # Returns `google.rpc.Code.FAILED_PRECONDITION` when reservation has
              # assignments.
              #
              # @overload delete_reservation(request, options = nil)
              #   Pass arguments to `delete_reservation` via a request object, either of type
              #   {::Google::Cloud::Bigquery::Reservation::V1::DeleteReservationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::Reservation::V1::DeleteReservationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_reservation(name: nil)
              #   Pass arguments to `delete_reservation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the reservation to retrieve. E.g.,
              #        `projects/myproject/locations/US/reservations/team1-prod`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Protobuf::Empty]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/reservation/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::Reservation::V1::DeleteReservationRequest.new
              #
              #   # Call the delete_reservation method.
              #   result = client.delete_reservation request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_reservation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Reservation::V1::DeleteReservationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_reservation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::Reservation::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_reservation.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_reservation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reservation_service_stub.call_rpc :delete_reservation, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an existing reservation resource.
              #
              # @overload update_reservation(request, options = nil)
              #   Pass arguments to `update_reservation` via a request object, either of type
              #   {::Google::Cloud::Bigquery::Reservation::V1::UpdateReservationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::Reservation::V1::UpdateReservationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_reservation(reservation: nil, update_mask: nil)
              #   Pass arguments to `update_reservation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param reservation [::Google::Cloud::Bigquery::Reservation::V1::Reservation, ::Hash]
              #     Content of the reservation to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Standard field mask for the set of fields to be updated.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigquery::Reservation::V1::Reservation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigquery::Reservation::V1::Reservation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/reservation/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::Reservation::V1::UpdateReservationRequest.new
              #
              #   # Call the update_reservation method.
              #   result = client.update_reservation request
              #
              #   # The returned object is of type Google::Cloud::Bigquery::Reservation::V1::Reservation.
              #   p result
              #
              def update_reservation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Reservation::V1::UpdateReservationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_reservation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::Reservation::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.reservation&.name
                  header_params["reservation.name"] = request.reservation.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_reservation.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_reservation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reservation_service_stub.call_rpc :update_reservation, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Fail over a reservation to the secondary location. The operation should be
              # done in the current secondary location, which will be promoted to the
              # new primary location for the reservation.
              # Attempting to failover a reservation in the current primary location will
              # fail with the error code `google.rpc.Code.FAILED_PRECONDITION`.
              #
              # @overload failover_reservation(request, options = nil)
              #   Pass arguments to `failover_reservation` via a request object, either of type
              #   {::Google::Cloud::Bigquery::Reservation::V1::FailoverReservationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::Reservation::V1::FailoverReservationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload failover_reservation(name: nil, failover_mode: nil)
              #   Pass arguments to `failover_reservation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the reservation to failover. E.g.,
              #        `projects/myproject/locations/US/reservations/team1-prod`
              #   @param failover_mode [::Google::Cloud::Bigquery::Reservation::V1::FailoverMode]
              #     Optional. A parameter that determines how writes that are pending
              #     replication are handled after a failover is initiated. If not specified,
              #     HARD failover mode is used by default.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigquery::Reservation::V1::Reservation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigquery::Reservation::V1::Reservation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/reservation/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::Reservation::V1::FailoverReservationRequest.new
              #
              #   # Call the failover_reservation method.
              #   result = client.failover_reservation request
              #
              #   # The returned object is of type Google::Cloud::Bigquery::Reservation::V1::Reservation.
              #   p result
              #
              def failover_reservation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Reservation::V1::FailoverReservationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.failover_reservation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::Reservation::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.failover_reservation.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.failover_reservation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reservation_service_stub.call_rpc :failover_reservation, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new capacity commitment resource.
              #
              # @overload create_capacity_commitment(request, options = nil)
              #   Pass arguments to `create_capacity_commitment` via a request object, either of type
              #   {::Google::Cloud::Bigquery::Reservation::V1::CreateCapacityCommitmentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::Reservation::V1::CreateCapacityCommitmentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_capacity_commitment(parent: nil, capacity_commitment: nil, enforce_single_admin_project_per_org: nil, capacity_commitment_id: nil)
              #   Pass arguments to `create_capacity_commitment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Resource name of the parent reservation. E.g.,
              #        `projects/myproject/locations/US`
              #   @param capacity_commitment [::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment, ::Hash]
              #     Content of the capacity commitment to create.
              #   @param enforce_single_admin_project_per_org [::Boolean]
              #     If true, fail the request if another project in the organization has a
              #     capacity commitment.
              #   @param capacity_commitment_id [::String]
              #     The optional capacity commitment ID. Capacity commitment name will be
              #     generated automatically if this field is empty.
              #     This field must only contain lower case alphanumeric characters or dashes.
              #     The first and last character cannot be a dash. Max length is 64 characters.
              #     NOTE: this ID won't be kept if the capacity commitment is split or merged.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/reservation/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::Reservation::V1::CreateCapacityCommitmentRequest.new
              #
              #   # Call the create_capacity_commitment method.
              #   result = client.create_capacity_commitment request
              #
              #   # The returned object is of type Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment.
              #   p result
              #
              def create_capacity_commitment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Reservation::V1::CreateCapacityCommitmentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_capacity_commitment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::Reservation::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_capacity_commitment.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_capacity_commitment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reservation_service_stub.call_rpc :create_capacity_commitment, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all the capacity commitments for the admin project.
              #
              # @overload list_capacity_commitments(request, options = nil)
              #   Pass arguments to `list_capacity_commitments` via a request object, either of type
              #   {::Google::Cloud::Bigquery::Reservation::V1::ListCapacityCommitmentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::Reservation::V1::ListCapacityCommitmentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_capacity_commitments(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_capacity_commitments` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Resource name of the parent reservation. E.g.,
              #        `projects/myproject/locations/US`
              #   @param page_size [::Integer]
              #     The maximum number of items to return.
              #   @param page_token [::String]
              #     The next_page_token value returned from a previous List request, if any.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/reservation/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::Reservation::V1::ListCapacityCommitmentsRequest.new
              #
              #   # Call the list_capacity_commitments method.
              #   result = client.list_capacity_commitments request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment.
              #     p item
              #   end
              #
              def list_capacity_commitments request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Reservation::V1::ListCapacityCommitmentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_capacity_commitments.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::Reservation::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_capacity_commitments.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_capacity_commitments.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reservation_service_stub.call_rpc :list_capacity_commitments, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @reservation_service_stub, :list_capacity_commitments, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns information about the capacity commitment.
              #
              # @overload get_capacity_commitment(request, options = nil)
              #   Pass arguments to `get_capacity_commitment` via a request object, either of type
              #   {::Google::Cloud::Bigquery::Reservation::V1::GetCapacityCommitmentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::Reservation::V1::GetCapacityCommitmentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_capacity_commitment(name: nil)
              #   Pass arguments to `get_capacity_commitment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the capacity commitment to retrieve. E.g.,
              #        `projects/myproject/locations/US/capacityCommitments/123`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/reservation/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::Reservation::V1::GetCapacityCommitmentRequest.new
              #
              #   # Call the get_capacity_commitment method.
              #   result = client.get_capacity_commitment request
              #
              #   # The returned object is of type Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment.
              #   p result
              #
              def get_capacity_commitment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Reservation::V1::GetCapacityCommitmentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_capacity_commitment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::Reservation::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_capacity_commitment.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_capacity_commitment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reservation_service_stub.call_rpc :get_capacity_commitment, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a capacity commitment. Attempting to delete capacity commitment
              # before its commitment_end_time will fail with the error code
              # `google.rpc.Code.FAILED_PRECONDITION`.
              #
              # @overload delete_capacity_commitment(request, options = nil)
              #   Pass arguments to `delete_capacity_commitment` via a request object, either of type
              #   {::Google::Cloud::Bigquery::Reservation::V1::DeleteCapacityCommitmentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::Reservation::V1::DeleteCapacityCommitmentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_capacity_commitment(name: nil, force: nil)
              #   Pass arguments to `delete_capacity_commitment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the capacity commitment to delete. E.g.,
              #        `projects/myproject/locations/US/capacityCommitments/123`
              #   @param force [::Boolean]
              #     Can be used to force delete commitments even if assignments exist. Deleting
              #     commitments with assignments may cause queries to fail if they no longer
              #     have access to slots.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Protobuf::Empty]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/reservation/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::Reservation::V1::DeleteCapacityCommitmentRequest.new
              #
              #   # Call the delete_capacity_commitment method.
              #   result = client.delete_capacity_commitment request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_capacity_commitment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Reservation::V1::DeleteCapacityCommitmentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_capacity_commitment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::Reservation::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_capacity_commitment.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_capacity_commitment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reservation_service_stub.call_rpc :delete_capacity_commitment, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an existing capacity commitment.
              #
              # Only `plan` and `renewal_plan` fields can be updated.
              #
              # Plan can only be changed to a plan of a longer commitment period.
              # Attempting to change to a plan with shorter commitment period will fail
              # with the error code `google.rpc.Code.FAILED_PRECONDITION`.
              #
              # @overload update_capacity_commitment(request, options = nil)
              #   Pass arguments to `update_capacity_commitment` via a request object, either of type
              #   {::Google::Cloud::Bigquery::Reservation::V1::UpdateCapacityCommitmentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::Reservation::V1::UpdateCapacityCommitmentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_capacity_commitment(capacity_commitment: nil, update_mask: nil)
              #   Pass arguments to `update_capacity_commitment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param capacity_commitment [::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment, ::Hash]
              #     Content of the capacity commitment to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Standard field mask for the set of fields to be updated.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/reservation/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::Reservation::V1::UpdateCapacityCommitmentRequest.new
              #
              #   # Call the update_capacity_commitment method.
              #   result = client.update_capacity_commitment request
              #
              #   # The returned object is of type Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment.
              #   p result
              #
              def update_capacity_commitment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Reservation::V1::UpdateCapacityCommitmentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_capacity_commitment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::Reservation::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.capacity_commitment&.name
                  header_params["capacity_commitment.name"] = request.capacity_commitment.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_capacity_commitment.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_capacity_commitment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reservation_service_stub.call_rpc :update_capacity_commitment, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Splits capacity commitment to two commitments of the same plan and
              # `commitment_end_time`.
              #
              # A common use case is to enable downgrading commitments.
              #
              # For example, in order to downgrade from 10000 slots to 8000, you might
              # split a 10000 capacity commitment into commitments of 2000 and 8000. Then,
              # you delete the first one after the commitment end time passes.
              #
              # @overload split_capacity_commitment(request, options = nil)
              #   Pass arguments to `split_capacity_commitment` via a request object, either of type
              #   {::Google::Cloud::Bigquery::Reservation::V1::SplitCapacityCommitmentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::Reservation::V1::SplitCapacityCommitmentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload split_capacity_commitment(name: nil, slot_count: nil)
              #   Pass arguments to `split_capacity_commitment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name e.g.,:
              #      `projects/myproject/locations/US/capacityCommitments/123`
              #   @param slot_count [::Integer]
              #     Number of slots in the capacity commitment after the split.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigquery::Reservation::V1::SplitCapacityCommitmentResponse]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigquery::Reservation::V1::SplitCapacityCommitmentResponse]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/reservation/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::Reservation::V1::SplitCapacityCommitmentRequest.new
              #
              #   # Call the split_capacity_commitment method.
              #   result = client.split_capacity_commitment request
              #
              #   # The returned object is of type Google::Cloud::Bigquery::Reservation::V1::SplitCapacityCommitmentResponse.
              #   p result
              #
              def split_capacity_commitment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Reservation::V1::SplitCapacityCommitmentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.split_capacity_commitment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::Reservation::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.split_capacity_commitment.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.split_capacity_commitment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reservation_service_stub.call_rpc :split_capacity_commitment, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Merges capacity commitments of the same plan into a single commitment.
              #
              # The resulting capacity commitment has the greater commitment_end_time
              # out of the to-be-merged capacity commitments.
              #
              # Attempting to merge capacity commitments of different plan will fail
              # with the error code `google.rpc.Code.FAILED_PRECONDITION`.
              #
              # @overload merge_capacity_commitments(request, options = nil)
              #   Pass arguments to `merge_capacity_commitments` via a request object, either of type
              #   {::Google::Cloud::Bigquery::Reservation::V1::MergeCapacityCommitmentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::Reservation::V1::MergeCapacityCommitmentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload merge_capacity_commitments(parent: nil, capacity_commitment_ids: nil, capacity_commitment_id: nil)
              #   Pass arguments to `merge_capacity_commitments` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Parent resource that identifies admin project and location e.g.,
              #      `projects/myproject/locations/us`
              #   @param capacity_commitment_ids [::Array<::String>]
              #     Ids of capacity commitments to merge.
              #     These capacity commitments must exist under admin project and location
              #     specified in the parent.
              #     ID is the last portion of capacity commitment name e.g., 'abc' for
              #     projects/myproject/locations/US/capacityCommitments/abc
              #   @param capacity_commitment_id [::String]
              #     Optional. The optional resulting capacity commitment ID. Capacity
              #     commitment name will be generated automatically if this field is empty.
              #     This field must only contain lower case alphanumeric characters or dashes.
              #     The first and last character cannot be a dash. Max length is 64 characters.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/reservation/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::Reservation::V1::MergeCapacityCommitmentsRequest.new
              #
              #   # Call the merge_capacity_commitments method.
              #   result = client.merge_capacity_commitments request
              #
              #   # The returned object is of type Google::Cloud::Bigquery::Reservation::V1::CapacityCommitment.
              #   p result
              #
              def merge_capacity_commitments request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Reservation::V1::MergeCapacityCommitmentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.merge_capacity_commitments.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::Reservation::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.merge_capacity_commitments.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.merge_capacity_commitments.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reservation_service_stub.call_rpc :merge_capacity_commitments, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an assignment object which allows the given project to submit jobs
              # of a certain type using slots from the specified reservation.
              #
              # Currently a
              # resource (project, folder, organization) can only have one assignment per
              # each (job_type, location) combination, and that reservation will be used
              # for all jobs of the matching type.
              #
              # Different assignments can be created on different levels of the
              # projects, folders or organization hierarchy.  During query execution,
              # the assignment is looked up at the project, folder and organization levels
              # in that order. The first assignment found is applied to the query.
              #
              # When creating assignments, it does not matter if other assignments exist at
              # higher levels.
              #
              # Example:
              #
              # * The organization `organizationA` contains two projects, `project1`
              #   and `project2`.
              # * Assignments for all three entities (`organizationA`, `project1`, and
              #   `project2`) could all be created and mapped to the same or different
              #   reservations.
              #
              # "None" assignments represent an absence of the assignment. Projects
              # assigned to None use on-demand pricing. To create a "None" assignment, use
              # "none" as a reservation_id in the parent. Example parent:
              # `projects/myproject/locations/US/reservations/none`.
              #
              # Returns `google.rpc.Code.PERMISSION_DENIED` if user does not have
              # 'bigquery.admin' permissions on the project using the reservation
              # and the project that owns this reservation.
              #
              # Returns `google.rpc.Code.INVALID_ARGUMENT` when location of the assignment
              # does not match location of the reservation.
              #
              # @overload create_assignment(request, options = nil)
              #   Pass arguments to `create_assignment` via a request object, either of type
              #   {::Google::Cloud::Bigquery::Reservation::V1::CreateAssignmentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::Reservation::V1::CreateAssignmentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_assignment(parent: nil, assignment: nil, assignment_id: nil)
              #   Pass arguments to `create_assignment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource name of the assignment
              #     E.g. `projects/myproject/locations/US/reservations/team1-prod`
              #   @param assignment [::Google::Cloud::Bigquery::Reservation::V1::Assignment, ::Hash]
              #     Assignment resource to create.
              #   @param assignment_id [::String]
              #     The optional assignment ID. Assignment name will be generated automatically
              #     if this field is empty.
              #     This field must only contain lower case alphanumeric characters or dashes.
              #     Max length is 64 characters.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigquery::Reservation::V1::Assignment]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigquery::Reservation::V1::Assignment]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/reservation/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::Reservation::V1::CreateAssignmentRequest.new
              #
              #   # Call the create_assignment method.
              #   result = client.create_assignment request
              #
              #   # The returned object is of type Google::Cloud::Bigquery::Reservation::V1::Assignment.
              #   p result
              #
              def create_assignment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Reservation::V1::CreateAssignmentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_assignment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::Reservation::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_assignment.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_assignment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reservation_service_stub.call_rpc :create_assignment, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists assignments.
              #
              # Only explicitly created assignments will be returned.
              #
              # Example:
              #
              # * Organization `organizationA` contains two projects, `project1` and
              #   `project2`.
              # * Reservation `res1` exists and was created previously.
              # * CreateAssignment was used previously to define the following
              #   associations between entities and reservations: `<organizationA, res1>`
              #   and `<project1, res1>`
              #
              # In this example, ListAssignments will just return the above two assignments
              # for reservation `res1`, and no expansion/merge will happen.
              #
              # The wildcard "-" can be used for
              # reservations in the request. In that case all assignments belongs to the
              # specified project and location will be listed.
              #
              # **Note** "-" cannot be used for projects nor locations.
              #
              # @overload list_assignments(request, options = nil)
              #   Pass arguments to `list_assignments` via a request object, either of type
              #   {::Google::Cloud::Bigquery::Reservation::V1::ListAssignmentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::Reservation::V1::ListAssignmentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_assignments(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_assignments` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource name e.g.:
              #
              #     `projects/myproject/locations/US/reservations/team1-prod`
              #
              #     Or:
              #
              #     `projects/myproject/locations/US/reservations/-`
              #   @param page_size [::Integer]
              #     The maximum number of items to return per page.
              #   @param page_token [::String]
              #     The next_page_token value returned from a previous List request, if any.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Bigquery::Reservation::V1::Assignment>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Bigquery::Reservation::V1::Assignment>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/reservation/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::Reservation::V1::ListAssignmentsRequest.new
              #
              #   # Call the list_assignments method.
              #   result = client.list_assignments request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Bigquery::Reservation::V1::Assignment.
              #     p item
              #   end
              #
              def list_assignments request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Reservation::V1::ListAssignmentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_assignments.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::Reservation::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_assignments.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_assignments.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reservation_service_stub.call_rpc :list_assignments, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @reservation_service_stub, :list_assignments, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a assignment. No expansion will happen.
              #
              # Example:
              #
              # * Organization `organizationA` contains two projects, `project1` and
              #   `project2`.
              # * Reservation `res1` exists and was created previously.
              # * CreateAssignment was used previously to define the following
              #   associations between entities and reservations: `<organizationA, res1>`
              #   and `<project1, res1>`
              #
              # In this example, deletion of the `<organizationA, res1>` assignment won't
              # affect the other assignment `<project1, res1>`. After said deletion,
              # queries from `project1` will still use `res1` while queries from
              # `project2` will switch to use on-demand mode.
              #
              # @overload delete_assignment(request, options = nil)
              #   Pass arguments to `delete_assignment` via a request object, either of type
              #   {::Google::Cloud::Bigquery::Reservation::V1::DeleteAssignmentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::Reservation::V1::DeleteAssignmentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_assignment(name: nil)
              #   Pass arguments to `delete_assignment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource, e.g.
              #       `projects/myproject/locations/US/reservations/team1-prod/assignments/123`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Protobuf::Empty]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/reservation/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::Reservation::V1::DeleteAssignmentRequest.new
              #
              #   # Call the delete_assignment method.
              #   result = client.delete_assignment request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_assignment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Reservation::V1::DeleteAssignmentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_assignment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::Reservation::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_assignment.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_assignment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reservation_service_stub.call_rpc :delete_assignment, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deprecated: Looks up assignments for a specified resource for a particular
              # region. If the request is about a project:
              #
              # 1. Assignments created on the project will be returned if they exist.
              # 2. Otherwise assignments created on the closest ancestor will be
              #    returned.
              # 3. Assignments for different JobTypes will all be returned.
              #
              # The same logic applies if the request is about a folder.
              #
              # If the request is about an organization, then assignments created on the
              # organization will be returned (organization doesn't have ancestors).
              #
              # Comparing to ListAssignments, there are some behavior
              # differences:
              #
              # 1. permission on the assignee will be verified in this API.
              # 2. Hierarchy lookup (project->folder->organization) happens in this API.
              # 3. Parent here is `projects/*/locations/*`, instead of
              #    `projects/*/locations/*reservations/*`.
              #
              # **Note** "-" cannot be used for projects
              # nor locations.
              #
              # @deprecated This method is deprecated and may be removed in the next major version update.
              #
              # @overload search_assignments(request, options = nil)
              #   Pass arguments to `search_assignments` via a request object, either of type
              #   {::Google::Cloud::Bigquery::Reservation::V1::SearchAssignmentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::Reservation::V1::SearchAssignmentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload search_assignments(parent: nil, query: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `search_assignments` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the admin project(containing project and
              #     location), e.g.:
              #       `projects/myproject/locations/US`.
              #   @param query [::String]
              #     Please specify resource name as assignee in the query.
              #
              #     Examples:
              #
              #     * `assignee=projects/myproject`
              #     * `assignee=folders/123`
              #     * `assignee=organizations/456`
              #   @param page_size [::Integer]
              #     The maximum number of items to return per page.
              #   @param page_token [::String]
              #     The next_page_token value returned from a previous List request, if any.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Bigquery::Reservation::V1::Assignment>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Bigquery::Reservation::V1::Assignment>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/reservation/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::Reservation::V1::SearchAssignmentsRequest.new
              #
              #   # Call the search_assignments method.
              #   result = client.search_assignments request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Bigquery::Reservation::V1::Assignment.
              #     p item
              #   end
              #
              def search_assignments request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Reservation::V1::SearchAssignmentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.search_assignments.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::Reservation::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.search_assignments.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.search_assignments.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reservation_service_stub.call_rpc :search_assignments, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @reservation_service_stub, :search_assignments, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Looks up assignments for a specified resource for a particular region.
              # If the request is about a project:
              #
              # 1. Assignments created on the project will be returned if they exist.
              # 2. Otherwise assignments created on the closest ancestor will be
              #    returned.
              # 3. Assignments for different JobTypes will all be returned.
              #
              # The same logic applies if the request is about a folder.
              #
              # If the request is about an organization, then assignments created on the
              # organization will be returned (organization doesn't have ancestors).
              #
              # Comparing to ListAssignments, there are some behavior
              # differences:
              #
              # 1. permission on the assignee will be verified in this API.
              # 2. Hierarchy lookup (project->folder->organization) happens in this API.
              # 3. Parent here is `projects/*/locations/*`, instead of
              #    `projects/*/locations/*reservations/*`.
              #
              # @overload search_all_assignments(request, options = nil)
              #   Pass arguments to `search_all_assignments` via a request object, either of type
              #   {::Google::Cloud::Bigquery::Reservation::V1::SearchAllAssignmentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::Reservation::V1::SearchAllAssignmentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload search_all_assignments(parent: nil, query: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `search_all_assignments` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name with location (project name could be the
              #     wildcard '-'), e.g.:
              #       `projects/-/locations/US`.
              #   @param query [::String]
              #     Please specify resource name as assignee in the query.
              #
              #     Examples:
              #
              #     * `assignee=projects/myproject`
              #     * `assignee=folders/123`
              #     * `assignee=organizations/456`
              #   @param page_size [::Integer]
              #     The maximum number of items to return per page.
              #   @param page_token [::String]
              #     The next_page_token value returned from a previous List request, if any.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Bigquery::Reservation::V1::Assignment>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Bigquery::Reservation::V1::Assignment>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/reservation/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::Reservation::V1::SearchAllAssignmentsRequest.new
              #
              #   # Call the search_all_assignments method.
              #   result = client.search_all_assignments request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Bigquery::Reservation::V1::Assignment.
              #     p item
              #   end
              #
              def search_all_assignments request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Reservation::V1::SearchAllAssignmentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.search_all_assignments.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::Reservation::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.search_all_assignments.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.search_all_assignments.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reservation_service_stub.call_rpc :search_all_assignments, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @reservation_service_stub, :search_all_assignments, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Moves an assignment under a new reservation.
              #
              # This differs from removing an existing assignment and recreating a new one
              # by providing a transactional change that ensures an assignee always has an
              # associated reservation.
              #
              # @overload move_assignment(request, options = nil)
              #   Pass arguments to `move_assignment` via a request object, either of type
              #   {::Google::Cloud::Bigquery::Reservation::V1::MoveAssignmentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::Reservation::V1::MoveAssignmentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload move_assignment(name: nil, destination_id: nil, assignment_id: nil)
              #   Pass arguments to `move_assignment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the assignment,
              #     e.g.
              #     `projects/myproject/locations/US/reservations/team1-prod/assignments/123`
              #   @param destination_id [::String]
              #     The new reservation ID, e.g.:
              #       `projects/myotherproject/locations/US/reservations/team2-prod`
              #   @param assignment_id [::String]
              #     The optional assignment ID. A new assignment name is generated if this
              #     field is empty.
              #
              #     This field can contain only lowercase alphanumeric characters or dashes.
              #     Max length is 64 characters.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigquery::Reservation::V1::Assignment]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigquery::Reservation::V1::Assignment]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/reservation/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::Reservation::V1::MoveAssignmentRequest.new
              #
              #   # Call the move_assignment method.
              #   result = client.move_assignment request
              #
              #   # The returned object is of type Google::Cloud::Bigquery::Reservation::V1::Assignment.
              #   p result
              #
              def move_assignment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Reservation::V1::MoveAssignmentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.move_assignment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::Reservation::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.move_assignment.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.move_assignment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reservation_service_stub.call_rpc :move_assignment, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an existing assignment.
              #
              # Only the `priority` field can be updated.
              #
              # @overload update_assignment(request, options = nil)
              #   Pass arguments to `update_assignment` via a request object, either of type
              #   {::Google::Cloud::Bigquery::Reservation::V1::UpdateAssignmentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::Reservation::V1::UpdateAssignmentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_assignment(assignment: nil, update_mask: nil)
              #   Pass arguments to `update_assignment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param assignment [::Google::Cloud::Bigquery::Reservation::V1::Assignment, ::Hash]
              #     Content of the assignment to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Standard field mask for the set of fields to be updated.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigquery::Reservation::V1::Assignment]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigquery::Reservation::V1::Assignment]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/reservation/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::Reservation::V1::UpdateAssignmentRequest.new
              #
              #   # Call the update_assignment method.
              #   result = client.update_assignment request
              #
              #   # The returned object is of type Google::Cloud::Bigquery::Reservation::V1::Assignment.
              #   p result
              #
              def update_assignment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Reservation::V1::UpdateAssignmentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_assignment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::Reservation::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.assignment&.name
                  header_params["assignment.name"] = request.assignment.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_assignment.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_assignment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reservation_service_stub.call_rpc :update_assignment, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieves a BI reservation.
              #
              # @overload get_bi_reservation(request, options = nil)
              #   Pass arguments to `get_bi_reservation` via a request object, either of type
              #   {::Google::Cloud::Bigquery::Reservation::V1::GetBiReservationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::Reservation::V1::GetBiReservationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_bi_reservation(name: nil)
              #   Pass arguments to `get_bi_reservation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the requested reservation, for example:
              #     `projects/{project_id}/locations/{location_id}/biReservation`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigquery::Reservation::V1::BiReservation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigquery::Reservation::V1::BiReservation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/reservation/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::Reservation::V1::GetBiReservationRequest.new
              #
              #   # Call the get_bi_reservation method.
              #   result = client.get_bi_reservation request
              #
              #   # The returned object is of type Google::Cloud::Bigquery::Reservation::V1::BiReservation.
              #   p result
              #
              def get_bi_reservation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Reservation::V1::GetBiReservationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_bi_reservation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::Reservation::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_bi_reservation.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_bi_reservation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reservation_service_stub.call_rpc :get_bi_reservation, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a BI reservation.
              #
              # Only fields specified in the `field_mask` are updated.
              #
              # A singleton BI reservation always exists with default size 0.
              # In order to reserve BI capacity it needs to be updated to an amount
              # greater than 0. In order to release BI capacity reservation size
              # must be set to 0.
              #
              # @overload update_bi_reservation(request, options = nil)
              #   Pass arguments to `update_bi_reservation` via a request object, either of type
              #   {::Google::Cloud::Bigquery::Reservation::V1::UpdateBiReservationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::Reservation::V1::UpdateBiReservationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_bi_reservation(bi_reservation: nil, update_mask: nil)
              #   Pass arguments to `update_bi_reservation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param bi_reservation [::Google::Cloud::Bigquery::Reservation::V1::BiReservation, ::Hash]
              #     A reservation to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     A list of fields to be updated in this request.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigquery::Reservation::V1::BiReservation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigquery::Reservation::V1::BiReservation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/reservation/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::Reservation::V1::UpdateBiReservationRequest.new
              #
              #   # Call the update_bi_reservation method.
              #   result = client.update_bi_reservation request
              #
              #   # The returned object is of type Google::Cloud::Bigquery::Reservation::V1::BiReservation.
              #   p result
              #
              def update_bi_reservation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Reservation::V1::UpdateBiReservationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_bi_reservation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::Reservation::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.bi_reservation&.name
                  header_params["bi_reservation.name"] = request.bi_reservation.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_bi_reservation.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_bi_reservation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reservation_service_stub.call_rpc :update_bi_reservation, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the access control policy for a resource.
              # May return:
              #
              # * A`NOT_FOUND` error if the resource doesn't exist or you don't have the
              #   permission to view it.
              # * An empty policy if the resource exists but doesn't have a set policy.
              #
              # Supported resources are:
              # - Reservations
              # - ReservationAssignments
              #
              # To call this method, you must have the following Google IAM permissions:
              #
              # - `bigqueryreservation.reservations.getIamPolicy` to get policies on
              # reservations.
              #
              # @overload get_iam_policy(request, options = nil)
              #   Pass arguments to `get_iam_policy` via a request object, either of type
              #   {::Google::Iam::V1::GetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::GetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_iam_policy(resource: nil, options: nil)
              #   Pass arguments to `get_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param options [::Google::Iam::V1::GetPolicyOptions, ::Hash]
              #     OPTIONAL: A `GetPolicyOptions` object for specifying options to
              #     `GetIamPolicy`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Iam::V1::Policy]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/reservation/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::GetIamPolicyRequest.new
              #
              #   # Call the get_iam_policy method.
              #   result = client.get_iam_policy request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def get_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::GetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::Reservation::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.resource
                  header_params["resource"] = request.resource
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_iam_policy.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reservation_service_stub.call_rpc :get_iam_policy, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Sets an access control policy for a resource. Replaces any existing
              # policy.
              #
              # Supported resources are:
              # - Reservations
              #
              # To call this method, you must have the following Google IAM permissions:
              #
              # - `bigqueryreservation.reservations.setIamPolicy` to set policies on
              # reservations.
              #
              # @overload set_iam_policy(request, options = nil)
              #   Pass arguments to `set_iam_policy` via a request object, either of type
              #   {::Google::Iam::V1::SetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::SetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload set_iam_policy(resource: nil, policy: nil, update_mask: nil)
              #   Pass arguments to `set_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being specified.
              #     See the operation documentation for the appropriate value for this field.
              #   @param policy [::Google::Iam::V1::Policy, ::Hash]
              #     REQUIRED: The complete policy to be applied to the `resource`. The size of
              #     the policy is limited to a few 10s of KB. An empty policy is a
              #     valid policy but certain Cloud Platform services (such as Projects)
              #     might reject them.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
              #     the fields in the mask will be modified. If no mask is provided, the
              #     following default mask is used:
              #
              #     `paths: "bindings, etag"`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Iam::V1::Policy]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/reservation/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::SetIamPolicyRequest.new
              #
              #   # Call the set_iam_policy method.
              #   result = client.set_iam_policy request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def set_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::SetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.set_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::Reservation::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.resource
                  header_params["resource"] = request.resource
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.set_iam_policy.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.set_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reservation_service_stub.call_rpc :set_iam_policy, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets your permissions on a resource. Returns an empty set of permissions if
              # the resource doesn't exist.
              #
              # Supported resources are:
              # - Reservations
              #
              # No Google IAM permissions are required to call this method.
              #
              # @overload test_iam_permissions(request, options = nil)
              #   Pass arguments to `test_iam_permissions` via a request object, either of type
              #   {::Google::Iam::V1::TestIamPermissionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::TestIamPermissionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload test_iam_permissions(resource: nil, permissions: nil)
              #   Pass arguments to `test_iam_permissions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy detail is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param permissions [::Array<::String>]
              #     The set of permissions to check for the `resource`. Permissions with
              #     wildcards (such as '*' or 'storage.*') are not allowed. For more
              #     information see
              #     [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Iam::V1::TestIamPermissionsResponse]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Iam::V1::TestIamPermissionsResponse]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/reservation/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::TestIamPermissionsRequest.new
              #
              #   # Call the test_iam_permissions method.
              #   result = client.test_iam_permissions request
              #
              #   # The returned object is of type Google::Iam::V1::TestIamPermissionsResponse.
              #   p result
              #
              def test_iam_permissions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::TestIamPermissionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.test_iam_permissions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::Reservation::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.resource
                  header_params["resource"] = request.resource
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.test_iam_permissions.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.test_iam_permissions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reservation_service_stub.call_rpc :test_iam_permissions, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new reservation group.
              #
              # @overload create_reservation_group(request, options = nil)
              #   Pass arguments to `create_reservation_group` via a request object, either of type
              #   {::Google::Cloud::Bigquery::Reservation::V1::CreateReservationGroupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::Reservation::V1::CreateReservationGroupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_reservation_group(parent: nil, reservation_group_id: nil, reservation_group: nil)
              #   Pass arguments to `create_reservation_group` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Project, location. E.g.,
              #     `projects/myproject/locations/US`
              #   @param reservation_group_id [::String]
              #     Required. The reservation group ID. It must only contain lower case
              #     alphanumeric characters or dashes. It must start with a letter and must not
              #     end with a dash. Its maximum length is 64 characters.
              #   @param reservation_group [::Google::Cloud::Bigquery::Reservation::V1::ReservationGroup, ::Hash]
              #     Required. New Reservation Group to create.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigquery::Reservation::V1::ReservationGroup]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigquery::Reservation::V1::ReservationGroup]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/reservation/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::Reservation::V1::CreateReservationGroupRequest.new
              #
              #   # Call the create_reservation_group method.
              #   result = client.create_reservation_group request
              #
              #   # The returned object is of type Google::Cloud::Bigquery::Reservation::V1::ReservationGroup.
              #   p result
              #
              def create_reservation_group request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Reservation::V1::CreateReservationGroupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_reservation_group.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::Reservation::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_reservation_group.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_reservation_group.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reservation_service_stub.call_rpc :create_reservation_group, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns information about the reservation group.
              #
              # @overload get_reservation_group(request, options = nil)
              #   Pass arguments to `get_reservation_group` via a request object, either of type
              #   {::Google::Cloud::Bigquery::Reservation::V1::GetReservationGroupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::Reservation::V1::GetReservationGroupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_reservation_group(name: nil)
              #   Pass arguments to `get_reservation_group` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the reservation group to retrieve. E.g.,
              #        `projects/myproject/locations/US/reservationGroups/team1-prod`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigquery::Reservation::V1::ReservationGroup]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigquery::Reservation::V1::ReservationGroup]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/reservation/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::Reservation::V1::GetReservationGroupRequest.new
              #
              #   # Call the get_reservation_group method.
              #   result = client.get_reservation_group request
              #
              #   # The returned object is of type Google::Cloud::Bigquery::Reservation::V1::ReservationGroup.
              #   p result
              #
              def get_reservation_group request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Reservation::V1::GetReservationGroupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_reservation_group.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::Reservation::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_reservation_group.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_reservation_group.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reservation_service_stub.call_rpc :get_reservation_group, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a reservation.
              # Returns `google.rpc.Code.FAILED_PRECONDITION` when reservation has
              # assignments.
              #
              # @overload delete_reservation_group(request, options = nil)
              #   Pass arguments to `delete_reservation_group` via a request object, either of type
              #   {::Google::Cloud::Bigquery::Reservation::V1::DeleteReservationGroupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::Reservation::V1::DeleteReservationGroupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_reservation_group(name: nil)
              #   Pass arguments to `delete_reservation_group` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the reservation group to retrieve. E.g.,
              #        `projects/myproject/locations/US/reservationGroups/team1-prod`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Protobuf::Empty]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/reservation/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::Reservation::V1::DeleteReservationGroupRequest.new
              #
              #   # Call the delete_reservation_group method.
              #   result = client.delete_reservation_group request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_reservation_group request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Reservation::V1::DeleteReservationGroupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_reservation_group.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::Reservation::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_reservation_group.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_reservation_group.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reservation_service_stub.call_rpc :delete_reservation_group, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all the reservation groups for the project in the specified location.
              #
              # @overload list_reservation_groups(request, options = nil)
              #   Pass arguments to `list_reservation_groups` via a request object, either of type
              #   {::Google::Cloud::Bigquery::Reservation::V1::ListReservationGroupsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::Reservation::V1::ListReservationGroupsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_reservation_groups(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_reservation_groups` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource name containing project and location, e.g.:
              #       `projects/myproject/locations/US`
              #   @param page_size [::Integer]
              #     The maximum number of items to return per page.
              #   @param page_token [::String]
              #     The next_page_token value returned from a previous List request, if any.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Bigquery::Reservation::V1::ReservationGroup>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Bigquery::Reservation::V1::ReservationGroup>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/reservation/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::Reservation::V1::ListReservationGroupsRequest.new
              #
              #   # Call the list_reservation_groups method.
              #   result = client.list_reservation_groups request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Bigquery::Reservation::V1::ReservationGroup.
              #     p item
              #   end
              #
              def list_reservation_groups request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Reservation::V1::ListReservationGroupsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_reservation_groups.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::Reservation::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_reservation_groups.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_reservation_groups.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reservation_service_stub.call_rpc :list_reservation_groups, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @reservation_service_stub, :list_reservation_groups, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the ReservationService API.
              #
              # This class represents the configuration for ReservationService,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_reservation to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_reservation.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_reservation.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
              #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
              #    *  (`nil`) indicating no credentials
              #
              #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
              #     is deprecated. Providing an unvalidated credential configuration to
              #     Google APIs can compromise the security of your systems and data.
              #
              #   @example
              #
              #     # The recommended way to provide credentials is to use the `make_creds` method
              #     # on the appropriate credentials class for your environment.
              #
              #     require "googleauth"
              #
              #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
              #       json_key_io: ::File.open("/path/to/keyfile.json")
              #     )
              #
              #     client = ::Google::Cloud::Bigquery::Reservation::V1::ReservationService::Client.new do |config|
              #       config.credentials = credentials
              #     end
              #
              #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] channel_args
              #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
              #   `GRPC::Core::Channel` object is provided as the credential.
              #   @return [::Hash]
              # @!attribute [rw] interceptors
              #   An array of interceptors that are run before calls are executed.
              #   @return [::Array<::GRPC::ClientInterceptor>]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional gRPC headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "bigqueryreservation.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
                config_attr :interceptors,  nil, ::Array, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration for the channel pool
                # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
                #
                def channel_pool
                  @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
                end

                ##
                # Configuration RPC class for the ReservationService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_reservation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_reservation
                  ##
                  # RPC-specific configuration for `list_reservations`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_reservations
                  ##
                  # RPC-specific configuration for `get_reservation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_reservation
                  ##
                  # RPC-specific configuration for `delete_reservation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_reservation
                  ##
                  # RPC-specific configuration for `update_reservation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_reservation
                  ##
                  # RPC-specific configuration for `failover_reservation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :failover_reservation
                  ##
                  # RPC-specific configuration for `create_capacity_commitment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_capacity_commitment
                  ##
                  # RPC-specific configuration for `list_capacity_commitments`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_capacity_commitments
                  ##
                  # RPC-specific configuration for `get_capacity_commitment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_capacity_commitment
                  ##
                  # RPC-specific configuration for `delete_capacity_commitment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_capacity_commitment
                  ##
                  # RPC-specific configuration for `update_capacity_commitment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_capacity_commitment
                  ##
                  # RPC-specific configuration for `split_capacity_commitment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :split_capacity_commitment
                  ##
                  # RPC-specific configuration for `merge_capacity_commitments`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :merge_capacity_commitments
                  ##
                  # RPC-specific configuration for `create_assignment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_assignment
                  ##
                  # RPC-specific configuration for `list_assignments`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_assignments
                  ##
                  # RPC-specific configuration for `delete_assignment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_assignment
                  ##
                  # RPC-specific configuration for `search_assignments`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :search_assignments
                  ##
                  # RPC-specific configuration for `search_all_assignments`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :search_all_assignments
                  ##
                  # RPC-specific configuration for `move_assignment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :move_assignment
                  ##
                  # RPC-specific configuration for `update_assignment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_assignment
                  ##
                  # RPC-specific configuration for `get_bi_reservation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_bi_reservation
                  ##
                  # RPC-specific configuration for `update_bi_reservation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_bi_reservation
                  ##
                  # RPC-specific configuration for `get_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_iam_policy
                  ##
                  # RPC-specific configuration for `set_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_iam_policy
                  ##
                  # RPC-specific configuration for `test_iam_permissions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :test_iam_permissions
                  ##
                  # RPC-specific configuration for `create_reservation_group`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_reservation_group
                  ##
                  # RPC-specific configuration for `get_reservation_group`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_reservation_group
                  ##
                  # RPC-specific configuration for `delete_reservation_group`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_reservation_group
                  ##
                  # RPC-specific configuration for `list_reservation_groups`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_reservation_groups

                  # @private
                  def initialize parent_rpcs = nil
                    create_reservation_config = parent_rpcs.create_reservation if parent_rpcs.respond_to? :create_reservation
                    @create_reservation = ::Gapic::Config::Method.new create_reservation_config
                    list_reservations_config = parent_rpcs.list_reservations if parent_rpcs.respond_to? :list_reservations
                    @list_reservations = ::Gapic::Config::Method.new list_reservations_config
                    get_reservation_config = parent_rpcs.get_reservation if parent_rpcs.respond_to? :get_reservation
                    @get_reservation = ::Gapic::Config::Method.new get_reservation_config
                    delete_reservation_config = parent_rpcs.delete_reservation if parent_rpcs.respond_to? :delete_reservation
                    @delete_reservation = ::Gapic::Config::Method.new delete_reservation_config
                    update_reservation_config = parent_rpcs.update_reservation if parent_rpcs.respond_to? :update_reservation
                    @update_reservation = ::Gapic::Config::Method.new update_reservation_config
                    failover_reservation_config = parent_rpcs.failover_reservation if parent_rpcs.respond_to? :failover_reservation
                    @failover_reservation = ::Gapic::Config::Method.new failover_reservation_config
                    create_capacity_commitment_config = parent_rpcs.create_capacity_commitment if parent_rpcs.respond_to? :create_capacity_commitment
                    @create_capacity_commitment = ::Gapic::Config::Method.new create_capacity_commitment_config
                    list_capacity_commitments_config = parent_rpcs.list_capacity_commitments if parent_rpcs.respond_to? :list_capacity_commitments
                    @list_capacity_commitments = ::Gapic::Config::Method.new list_capacity_commitments_config
                    get_capacity_commitment_config = parent_rpcs.get_capacity_commitment if parent_rpcs.respond_to? :get_capacity_commitment
                    @get_capacity_commitment = ::Gapic::Config::Method.new get_capacity_commitment_config
                    delete_capacity_commitment_config = parent_rpcs.delete_capacity_commitment if parent_rpcs.respond_to? :delete_capacity_commitment
                    @delete_capacity_commitment = ::Gapic::Config::Method.new delete_capacity_commitment_config
                    update_capacity_commitment_config = parent_rpcs.update_capacity_commitment if parent_rpcs.respond_to? :update_capacity_commitment
                    @update_capacity_commitment = ::Gapic::Config::Method.new update_capacity_commitment_config
                    split_capacity_commitment_config = parent_rpcs.split_capacity_commitment if parent_rpcs.respond_to? :split_capacity_commitment
                    @split_capacity_commitment = ::Gapic::Config::Method.new split_capacity_commitment_config
                    merge_capacity_commitments_config = parent_rpcs.merge_capacity_commitments if parent_rpcs.respond_to? :merge_capacity_commitments
                    @merge_capacity_commitments = ::Gapic::Config::Method.new merge_capacity_commitments_config
                    create_assignment_config = parent_rpcs.create_assignment if parent_rpcs.respond_to? :create_assignment
                    @create_assignment = ::Gapic::Config::Method.new create_assignment_config
                    list_assignments_config = parent_rpcs.list_assignments if parent_rpcs.respond_to? :list_assignments
                    @list_assignments = ::Gapic::Config::Method.new list_assignments_config
                    delete_assignment_config = parent_rpcs.delete_assignment if parent_rpcs.respond_to? :delete_assignment
                    @delete_assignment = ::Gapic::Config::Method.new delete_assignment_config
                    search_assignments_config = parent_rpcs.search_assignments if parent_rpcs.respond_to? :search_assignments
                    @search_assignments = ::Gapic::Config::Method.new search_assignments_config
                    search_all_assignments_config = parent_rpcs.search_all_assignments if parent_rpcs.respond_to? :search_all_assignments
                    @search_all_assignments = ::Gapic::Config::Method.new search_all_assignments_config
                    move_assignment_config = parent_rpcs.move_assignment if parent_rpcs.respond_to? :move_assignment
                    @move_assignment = ::Gapic::Config::Method.new move_assignment_config
                    update_assignment_config = parent_rpcs.update_assignment if parent_rpcs.respond_to? :update_assignment
                    @update_assignment = ::Gapic::Config::Method.new update_assignment_config
                    get_bi_reservation_config = parent_rpcs.get_bi_reservation if parent_rpcs.respond_to? :get_bi_reservation
                    @get_bi_reservation = ::Gapic::Config::Method.new get_bi_reservation_config
                    update_bi_reservation_config = parent_rpcs.update_bi_reservation if parent_rpcs.respond_to? :update_bi_reservation
                    @update_bi_reservation = ::Gapic::Config::Method.new update_bi_reservation_config
                    get_iam_policy_config = parent_rpcs.get_iam_policy if parent_rpcs.respond_to? :get_iam_policy
                    @get_iam_policy = ::Gapic::Config::Method.new get_iam_policy_config
                    set_iam_policy_config = parent_rpcs.set_iam_policy if parent_rpcs.respond_to? :set_iam_policy
                    @set_iam_policy = ::Gapic::Config::Method.new set_iam_policy_config
                    test_iam_permissions_config = parent_rpcs.test_iam_permissions if parent_rpcs.respond_to? :test_iam_permissions
                    @test_iam_permissions = ::Gapic::Config::Method.new test_iam_permissions_config
                    create_reservation_group_config = parent_rpcs.create_reservation_group if parent_rpcs.respond_to? :create_reservation_group
                    @create_reservation_group = ::Gapic::Config::Method.new create_reservation_group_config
                    get_reservation_group_config = parent_rpcs.get_reservation_group if parent_rpcs.respond_to? :get_reservation_group
                    @get_reservation_group = ::Gapic::Config::Method.new get_reservation_group_config
                    delete_reservation_group_config = parent_rpcs.delete_reservation_group if parent_rpcs.respond_to? :delete_reservation_group
                    @delete_reservation_group = ::Gapic::Config::Method.new delete_reservation_group_config
                    list_reservation_groups_config = parent_rpcs.list_reservation_groups if parent_rpcs.respond_to? :list_reservation_groups
                    @list_reservation_groups = ::Gapic::Config::Method.new list_reservation_groups_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
