# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Bigquery
      module Migration
        module V2
          # The translation details to capture the necessary settings for a translation
          # job.
          # @!attribute [rw] source_target_mapping
          #   @return [::Array<::Google::Cloud::Bigquery::Migration::V2::SourceTargetMapping>]
          #     The mapping from source to target SQL.
          # @!attribute [rw] target_base_uri
          #   @return [::String]
          #     The base URI for all writes to persistent storage.
          # @!attribute [rw] source_environment
          #   @return [::Google::Cloud::Bigquery::Migration::V2::SourceEnvironment]
          #     The default source environment values for the translation.
          # @!attribute [rw] target_return_literals
          #   @return [::Array<::String>]
          #     The list of literal targets that will be directly returned to the response.
          #     Each entry consists of the constructed path, EXCLUDING the base path. Not
          #     providing a target_base_uri will prevent writing to persistent storage.
          # @!attribute [rw] target_types
          #   @return [::Array<::String>]
          #     The types of output to generate, e.g. sql, metadata,
          #     lineage_from_sql_scripts, etc. If not specified, a default set of
          #     targets will be generated. Some additional target types may be slower to
          #     generate. See the documentation for the set of available target types.
          class TranslationDetails
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents one mapping from a source SQL to a target SQL.
          # @!attribute [rw] source_spec
          #   @return [::Google::Cloud::Bigquery::Migration::V2::SourceSpec]
          #     The source SQL or the path to it.
          # @!attribute [rw] target_spec
          #   @return [::Google::Cloud::Bigquery::Migration::V2::TargetSpec]
          #     The target SQL or the path for it.
          class SourceTargetMapping
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents one path to the location that holds source data.
          # @!attribute [rw] base_uri
          #   @return [::String]
          #     The base URI for all files to be read in as sources for translation.
          #
          #     Note: The following fields are mutually exclusive: `base_uri`, `literal`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] literal
          #   @return [::Google::Cloud::Bigquery::Migration::V2::Literal]
          #     Source literal.
          #
          #     Note: The following fields are mutually exclusive: `literal`, `base_uri`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] encoding
          #   @return [::String]
          #     Optional. The optional field to specify the encoding of the sql bytes.
          class SourceSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents one path to the location that holds target data.
          # @!attribute [rw] relative_path
          #   @return [::String]
          #     The relative path for the target data. Given source file
          #     `base_uri/input/sql`, the output would be
          #     `target_base_uri/sql/relative_path/input.sql`.
          class TargetSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Literal data.
          # @!attribute [rw] literal_string
          #   @return [::String]
          #     Literal string data.
          #
          #     Note: The following fields are mutually exclusive: `literal_string`, `literal_bytes`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] literal_bytes
          #   @return [::String]
          #     Literal byte data.
          #
          #     Note: The following fields are mutually exclusive: `literal_bytes`, `literal_string`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] relative_path
          #   @return [::String]
          #     Required. The identifier of the literal entry.
          class Literal
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents the default source environment values for the translation.
          # @!attribute [rw] default_database
          #   @return [::String]
          #     The default database name to fully qualify SQL objects when their database
          #     name is missing.
          # @!attribute [rw] schema_search_path
          #   @return [::Array<::String>]
          #     The schema search path. When SQL objects are missing schema name,
          #     translation engine will search through this list to find the value.
          # @!attribute [rw] metadata_store_dataset
          #   @return [::String]
          #     Optional. Expects a validQ BigQuery dataset ID that exists, e.g.,
          #     project-123.metadata_store_123.  If specified, translation will search and
          #     read the required schema information from a metadata store in this dataset.
          #     If metadata store doesn't exist, translation will parse the metadata file
          #     and upload the schema info to a temp table in the dataset to speed up
          #     future translation jobs.
          class SourceEnvironment
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
