# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Bigquery
      module Migration
        module V2
          # Request to create a migration workflow resource.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The name of the project to which this migration workflow belongs.
          #     Example: `projects/foo/locations/bar`
          # @!attribute [rw] migration_workflow
          #   @return [::Google::Cloud::Bigquery::Migration::V2::MigrationWorkflow]
          #     Required. The migration workflow to create.
          class CreateMigrationWorkflowRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A request to get a previously created migration workflow.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The unique identifier for the migration workflow.
          #     Example: `projects/123/locations/us/workflows/1234`
          # @!attribute [rw] read_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     The list of fields to be retrieved.
          class GetMigrationWorkflowRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A request to list previously created migration workflows.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The project and location of the migration workflows to list.
          #     Example: `projects/123/locations/us`
          # @!attribute [rw] read_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     The list of fields to be retrieved.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of migration workflows to return. The service may return
          #     fewer than this number.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     A page token, received from previous `ListMigrationWorkflows` call.
          #     Provide this to retrieve the subsequent page.
          #
          #     When paginating, all other parameters provided to `ListMigrationWorkflows`
          #     must match the call that provided the page token.
          class ListMigrationWorkflowsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response object for a `ListMigrationWorkflows` call.
          # @!attribute [rw] migration_workflows
          #   @return [::Array<::Google::Cloud::Bigquery::Migration::V2::MigrationWorkflow>]
          #     The migration workflows for the specified project / location.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token, which can be sent as `page_token` to retrieve the next page.
          #     If this field is omitted, there are no subsequent pages.
          class ListMigrationWorkflowsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A request to delete a previously created migration workflow.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The unique identifier for the migration workflow.
          #     Example: `projects/123/locations/us/workflows/1234`
          class DeleteMigrationWorkflowRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A request to start a previously created migration workflow.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The unique identifier for the migration workflow.
          #     Example: `projects/123/locations/us/workflows/1234`
          class StartMigrationWorkflowRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A request to get a previously created migration subtasks.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The unique identifier for the migration subtask.
          #     Example: `projects/123/locations/us/workflows/1234/subtasks/543`
          # @!attribute [rw] read_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Optional. The list of fields to be retrieved.
          class GetMigrationSubtaskRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A request to list previously created migration subtasks.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The migration task of the subtasks to list.
          #     Example: `projects/123/locations/us/workflows/1234`
          # @!attribute [rw] read_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Optional. The list of fields to be retrieved.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. The maximum number of migration tasks to return. The service may
          #     return fewer than this number.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. A page token, received from previous `ListMigrationSubtasks`
          #     call. Provide this to retrieve the subsequent page.
          #
          #     When paginating, all other parameters provided to `ListMigrationSubtasks`
          #     must match the call that provided the page token.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Optional. The filter to apply. This can be used to get the subtasks of a
          #     specific tasks in a workflow, e.g. `migration_task = "ab012"` where
          #     `"ab012"` is the task ID (not the name in the named map).
          class ListMigrationSubtasksRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response object for a `ListMigrationSubtasks` call.
          # @!attribute [rw] migration_subtasks
          #   @return [::Array<::Google::Cloud::Bigquery::Migration::V2::MigrationSubtask>]
          #     The migration subtasks for the specified task.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token, which can be sent as `page_token` to retrieve the next page.
          #     If this field is omitted, there are no subsequent pages.
          class ListMigrationSubtasksResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
