# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Bigquery
      module Migration
        module V2
          # Provides details for errors and the corresponding resources.
          # @!attribute [rw] resource_info
          #   @return [::Google::Rpc::ResourceInfo]
          #     Required. Information about the resource where the error is located.
          # @!attribute [rw] error_details
          #   @return [::Array<::Google::Cloud::Bigquery::Migration::V2::ErrorDetail>]
          #     Required. The error details for the resource.
          # @!attribute [rw] error_count
          #   @return [::Integer]
          #     Required. How many errors there are in total for the resource. Truncation
          #     can be indicated by having an `error_count` that is higher than the size of
          #     `error_details`.
          class ResourceErrorDetail
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Provides details for errors, e.g. issues that where encountered when
          # processing a subtask.
          # @!attribute [rw] location
          #   @return [::Google::Cloud::Bigquery::Migration::V2::ErrorLocation]
          #     Optional. The exact location within the resource (if applicable).
          # @!attribute [rw] error_info
          #   @return [::Google::Rpc::ErrorInfo]
          #     Required. Describes the cause of the error with structured detail.
          class ErrorDetail
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Holds information about where the error is located.
          # @!attribute [rw] line
          #   @return [::Integer]
          #     Optional. If applicable, denotes the line where the error occurred. A zero
          #     value means that there is no line information.
          # @!attribute [rw] column
          #   @return [::Integer]
          #     Optional. If applicable, denotes the column where the error occurred. A
          #     zero value means that there is no columns information.
          class ErrorLocation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
