# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/bigquery/migration/v2/migration_service_pb"
require "google/cloud/bigquery/migration/v2/migration_service/rest/service_stub"

module Google
  module Cloud
    module Bigquery
      module Migration
        module V2
          module MigrationService
            module Rest
              ##
              # REST client for the MigrationService service.
              #
              # Service to handle EDW migrations.
              #
              class Client
                # @private
                API_VERSION = ""

                # @private
                DEFAULT_ENDPOINT_TEMPLATE = "bigquerymigration.$UNIVERSE_DOMAIN$"

                include Paths

                # @private
                attr_reader :migration_service_stub

                ##
                # Configure the MigrationService Client class.
                #
                # See {::Google::Cloud::Bigquery::Migration::V2::MigrationService::Rest::Client::Configuration}
                # for a description of the configuration fields.
                #
                # @example
                #
                #   # Modify the configuration for all MigrationService clients
                #   ::Google::Cloud::Bigquery::Migration::V2::MigrationService::Rest::Client.configure do |config|
                #     config.timeout = 10.0
                #   end
                #
                # @yield [config] Configure the Client client.
                # @yieldparam config [Client::Configuration]
                #
                # @return [Client::Configuration]
                #
                def self.configure
                  @configure ||= begin
                    namespace = ["Google", "Cloud", "Bigquery", "Migration", "V2"]
                    parent_config = while namespace.any?
                                      parent_name = namespace.join "::"
                                      parent_const = const_get parent_name
                                      break parent_const.configure if parent_const.respond_to? :configure
                                      namespace.pop
                                    end
                    default_config = Client::Configuration.new parent_config

                    default_config.rpcs.create_migration_workflow.timeout = 60.0

                    default_config.rpcs.get_migration_workflow.timeout = 60.0
                    default_config.rpcs.get_migration_workflow.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.list_migration_workflows.timeout = 60.0
                    default_config.rpcs.list_migration_workflows.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.delete_migration_workflow.timeout = 60.0

                    default_config.rpcs.start_migration_workflow.timeout = 60.0
                    default_config.rpcs.start_migration_workflow.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config
                  end
                  yield @configure if block_given?
                  @configure
                end

                ##
                # Configure the MigrationService Client instance.
                #
                # The configuration is set to the derived mode, meaning that values can be changed,
                # but structural changes (adding new fields, etc.) are not allowed. Structural changes
                # should be made on {Client.configure}.
                #
                # See {::Google::Cloud::Bigquery::Migration::V2::MigrationService::Rest::Client::Configuration}
                # for a description of the configuration fields.
                #
                # @yield [config] Configure the Client client.
                # @yieldparam config [Client::Configuration]
                #
                # @return [Client::Configuration]
                #
                def configure
                  yield @config if block_given?
                  @config
                end

                ##
                # The effective universe domain
                #
                # @return [String]
                #
                def universe_domain
                  @migration_service_stub.universe_domain
                end

                ##
                # Create a new MigrationService REST client object.
                #
                # @example
                #
                #   # Create a client using the default configuration
                #   client = ::Google::Cloud::Bigquery::Migration::V2::MigrationService::Rest::Client.new
                #
                #   # Create a client using a custom configuration
                #   client = ::Google::Cloud::Bigquery::Migration::V2::MigrationService::Rest::Client.new do |config|
                #     config.timeout = 10.0
                #   end
                #
                # @yield [config] Configure the MigrationService client.
                # @yieldparam config [Client::Configuration]
                #
                def initialize
                  # Create the configuration object
                  @config = Configuration.new Client.configure

                  # Yield the configuration if needed
                  yield @config if block_given?

                  # Create credentials
                  credentials = @config.credentials
                  # Use self-signed JWT if the endpoint is unchanged from default,
                  # but only if the default endpoint does not have a region prefix.
                  enable_self_signed_jwt = @config.endpoint.nil? ||
                                           (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                           !@config.endpoint.split(".").first.include?("-"))
                  credentials ||= Credentials.default scope: @config.scope,
                                                      enable_self_signed_jwt: enable_self_signed_jwt
                  if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                    credentials = Credentials.new credentials, scope: @config.scope
                  end

                  @quota_project_id = @config.quota_project
                  @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                  @migration_service_stub = ::Google::Cloud::Bigquery::Migration::V2::MigrationService::Rest::ServiceStub.new(
                    endpoint: @config.endpoint,
                    endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                    universe_domain: @config.universe_domain,
                    credentials: credentials,
                    logger: @config.logger
                  )

                  @migration_service_stub.logger(stub: true)&.info do |entry|
                    entry.set_system_name
                    entry.set_service
                    entry.message = "Created client for #{entry.service}"
                    entry.set_credentials_fields credentials
                    entry.set "customEndpoint", @config.endpoint if @config.endpoint
                    entry.set "defaultTimeout", @config.timeout if @config.timeout
                    entry.set "quotaProject", @quota_project_id if @quota_project_id
                  end
                end

                ##
                # The logger used for request/response debug logging.
                #
                # @return [Logger]
                #
                def logger
                  @migration_service_stub.logger
                end

                # Service calls

                ##
                # Creates a migration workflow.
                #
                # @overload create_migration_workflow(request, options = nil)
                #   Pass arguments to `create_migration_workflow` via a request object, either of type
                #   {::Google::Cloud::Bigquery::Migration::V2::CreateMigrationWorkflowRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Bigquery::Migration::V2::CreateMigrationWorkflowRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload create_migration_workflow(parent: nil, migration_workflow: nil)
                #   Pass arguments to `create_migration_workflow` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The name of the project to which this migration workflow belongs.
                #     Example: `projects/foo/locations/bar`
                #   @param migration_workflow [::Google::Cloud::Bigquery::Migration::V2::MigrationWorkflow, ::Hash]
                #     Required. The migration workflow to create.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Bigquery::Migration::V2::MigrationWorkflow]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Bigquery::Migration::V2::MigrationWorkflow]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/bigquery/migration/v2"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Bigquery::Migration::V2::MigrationService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Bigquery::Migration::V2::CreateMigrationWorkflowRequest.new
                #
                #   # Call the create_migration_workflow method.
                #   result = client.create_migration_workflow request
                #
                #   # The returned object is of type Google::Cloud::Bigquery::Migration::V2::MigrationWorkflow.
                #   p result
                #
                def create_migration_workflow request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Migration::V2::CreateMigrationWorkflowRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.create_migration_workflow.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Bigquery::Migration::V2::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.create_migration_workflow.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.create_migration_workflow.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @migration_service_stub.create_migration_workflow request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Gets a previously created migration workflow.
                #
                # @overload get_migration_workflow(request, options = nil)
                #   Pass arguments to `get_migration_workflow` via a request object, either of type
                #   {::Google::Cloud::Bigquery::Migration::V2::GetMigrationWorkflowRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Bigquery::Migration::V2::GetMigrationWorkflowRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_migration_workflow(name: nil, read_mask: nil)
                #   Pass arguments to `get_migration_workflow` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The unique identifier for the migration workflow.
                #     Example: `projects/123/locations/us/workflows/1234`
                #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     The list of fields to be retrieved.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Bigquery::Migration::V2::MigrationWorkflow]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Bigquery::Migration::V2::MigrationWorkflow]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/bigquery/migration/v2"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Bigquery::Migration::V2::MigrationService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Bigquery::Migration::V2::GetMigrationWorkflowRequest.new
                #
                #   # Call the get_migration_workflow method.
                #   result = client.get_migration_workflow request
                #
                #   # The returned object is of type Google::Cloud::Bigquery::Migration::V2::MigrationWorkflow.
                #   p result
                #
                def get_migration_workflow request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Migration::V2::GetMigrationWorkflowRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_migration_workflow.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Bigquery::Migration::V2::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_migration_workflow.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_migration_workflow.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @migration_service_stub.get_migration_workflow request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Lists previously created migration workflow.
                #
                # @overload list_migration_workflows(request, options = nil)
                #   Pass arguments to `list_migration_workflows` via a request object, either of type
                #   {::Google::Cloud::Bigquery::Migration::V2::ListMigrationWorkflowsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Bigquery::Migration::V2::ListMigrationWorkflowsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_migration_workflows(parent: nil, read_mask: nil, page_size: nil, page_token: nil)
                #   Pass arguments to `list_migration_workflows` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The project and location of the migration workflows to list.
                #     Example: `projects/123/locations/us`
                #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     The list of fields to be retrieved.
                #   @param page_size [::Integer]
                #     The maximum number of migration workflows to return. The service may return
                #     fewer than this number.
                #   @param page_token [::String]
                #     A page token, received from previous `ListMigrationWorkflows` call.
                #     Provide this to retrieve the subsequent page.
                #
                #     When paginating, all other parameters provided to `ListMigrationWorkflows`
                #     must match the call that provided the page token.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Bigquery::Migration::V2::MigrationWorkflow>]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Bigquery::Migration::V2::MigrationWorkflow>]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/bigquery/migration/v2"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Bigquery::Migration::V2::MigrationService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Bigquery::Migration::V2::ListMigrationWorkflowsRequest.new
                #
                #   # Call the list_migration_workflows method.
                #   result = client.list_migration_workflows request
                #
                #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                #   # over elements, and API calls will be issued to fetch pages as needed.
                #   result.each do |item|
                #     # Each element is of type ::Google::Cloud::Bigquery::Migration::V2::MigrationWorkflow.
                #     p item
                #   end
                #
                def list_migration_workflows request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Migration::V2::ListMigrationWorkflowsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_migration_workflows.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Bigquery::Migration::V2::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_migration_workflows.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_migration_workflows.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @migration_service_stub.list_migration_workflows request, options do |result, operation|
                    result = ::Gapic::Rest::PagedEnumerable.new @migration_service_stub, :list_migration_workflows, "migration_workflows", request, result, options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Deletes a migration workflow by name.
                #
                # @overload delete_migration_workflow(request, options = nil)
                #   Pass arguments to `delete_migration_workflow` via a request object, either of type
                #   {::Google::Cloud::Bigquery::Migration::V2::DeleteMigrationWorkflowRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Bigquery::Migration::V2::DeleteMigrationWorkflowRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload delete_migration_workflow(name: nil)
                #   Pass arguments to `delete_migration_workflow` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The unique identifier for the migration workflow.
                #     Example: `projects/123/locations/us/workflows/1234`
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Protobuf::Empty]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Protobuf::Empty]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/bigquery/migration/v2"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Bigquery::Migration::V2::MigrationService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Bigquery::Migration::V2::DeleteMigrationWorkflowRequest.new
                #
                #   # Call the delete_migration_workflow method.
                #   result = client.delete_migration_workflow request
                #
                #   # The returned object is of type Google::Protobuf::Empty.
                #   p result
                #
                def delete_migration_workflow request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Migration::V2::DeleteMigrationWorkflowRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.delete_migration_workflow.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Bigquery::Migration::V2::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.delete_migration_workflow.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.delete_migration_workflow.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @migration_service_stub.delete_migration_workflow request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Starts a previously created migration workflow. I.e., the state transitions
                # from DRAFT to RUNNING. This is a no-op if the state is already RUNNING.
                # An error will be signaled if the state is anything other than DRAFT or
                # RUNNING.
                #
                # @overload start_migration_workflow(request, options = nil)
                #   Pass arguments to `start_migration_workflow` via a request object, either of type
                #   {::Google::Cloud::Bigquery::Migration::V2::StartMigrationWorkflowRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Bigquery::Migration::V2::StartMigrationWorkflowRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload start_migration_workflow(name: nil)
                #   Pass arguments to `start_migration_workflow` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The unique identifier for the migration workflow.
                #     Example: `projects/123/locations/us/workflows/1234`
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Protobuf::Empty]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Protobuf::Empty]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/bigquery/migration/v2"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Bigquery::Migration::V2::MigrationService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Bigquery::Migration::V2::StartMigrationWorkflowRequest.new
                #
                #   # Call the start_migration_workflow method.
                #   result = client.start_migration_workflow request
                #
                #   # The returned object is of type Google::Protobuf::Empty.
                #   p result
                #
                def start_migration_workflow request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Migration::V2::StartMigrationWorkflowRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.start_migration_workflow.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Bigquery::Migration::V2::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.start_migration_workflow.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.start_migration_workflow.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @migration_service_stub.start_migration_workflow request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Gets a previously created migration subtask.
                #
                # @overload get_migration_subtask(request, options = nil)
                #   Pass arguments to `get_migration_subtask` via a request object, either of type
                #   {::Google::Cloud::Bigquery::Migration::V2::GetMigrationSubtaskRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Bigquery::Migration::V2::GetMigrationSubtaskRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_migration_subtask(name: nil, read_mask: nil)
                #   Pass arguments to `get_migration_subtask` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The unique identifier for the migration subtask.
                #     Example: `projects/123/locations/us/workflows/1234/subtasks/543`
                #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     Optional. The list of fields to be retrieved.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Bigquery::Migration::V2::MigrationSubtask]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Bigquery::Migration::V2::MigrationSubtask]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/bigquery/migration/v2"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Bigquery::Migration::V2::MigrationService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Bigquery::Migration::V2::GetMigrationSubtaskRequest.new
                #
                #   # Call the get_migration_subtask method.
                #   result = client.get_migration_subtask request
                #
                #   # The returned object is of type Google::Cloud::Bigquery::Migration::V2::MigrationSubtask.
                #   p result
                #
                def get_migration_subtask request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Migration::V2::GetMigrationSubtaskRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_migration_subtask.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Bigquery::Migration::V2::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_migration_subtask.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_migration_subtask.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @migration_service_stub.get_migration_subtask request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Lists previously created migration subtasks.
                #
                # @overload list_migration_subtasks(request, options = nil)
                #   Pass arguments to `list_migration_subtasks` via a request object, either of type
                #   {::Google::Cloud::Bigquery::Migration::V2::ListMigrationSubtasksRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Bigquery::Migration::V2::ListMigrationSubtasksRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_migration_subtasks(parent: nil, read_mask: nil, page_size: nil, page_token: nil, filter: nil)
                #   Pass arguments to `list_migration_subtasks` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The migration task of the subtasks to list.
                #     Example: `projects/123/locations/us/workflows/1234`
                #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     Optional. The list of fields to be retrieved.
                #   @param page_size [::Integer]
                #     Optional. The maximum number of migration tasks to return. The service may
                #     return fewer than this number.
                #   @param page_token [::String]
                #     Optional. A page token, received from previous `ListMigrationSubtasks`
                #     call. Provide this to retrieve the subsequent page.
                #
                #     When paginating, all other parameters provided to `ListMigrationSubtasks`
                #     must match the call that provided the page token.
                #   @param filter [::String]
                #     Optional. The filter to apply. This can be used to get the subtasks of a
                #     specific tasks in a workflow, e.g. `migration_task = "ab012"` where
                #     `"ab012"` is the task ID (not the name in the named map).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Bigquery::Migration::V2::MigrationSubtask>]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Bigquery::Migration::V2::MigrationSubtask>]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/bigquery/migration/v2"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Bigquery::Migration::V2::MigrationService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Bigquery::Migration::V2::ListMigrationSubtasksRequest.new
                #
                #   # Call the list_migration_subtasks method.
                #   result = client.list_migration_subtasks request
                #
                #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                #   # over elements, and API calls will be issued to fetch pages as needed.
                #   result.each do |item|
                #     # Each element is of type ::Google::Cloud::Bigquery::Migration::V2::MigrationSubtask.
                #     p item
                #   end
                #
                def list_migration_subtasks request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::Migration::V2::ListMigrationSubtasksRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_migration_subtasks.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Bigquery::Migration::V2::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_migration_subtasks.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_migration_subtasks.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @migration_service_stub.list_migration_subtasks request, options do |result, operation|
                    result = ::Gapic::Rest::PagedEnumerable.new @migration_service_stub, :list_migration_subtasks, "migration_subtasks", request, result, options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Configuration class for the MigrationService REST API.
                #
                # This class represents the configuration for MigrationService REST,
                # providing control over timeouts, retry behavior, logging, transport
                # parameters, and other low-level controls. Certain parameters can also be
                # applied individually to specific RPCs. See
                # {::Google::Cloud::Bigquery::Migration::V2::MigrationService::Rest::Client::Configuration::Rpcs}
                # for a list of RPCs that can be configured independently.
                #
                # Configuration can be applied globally to all clients, or to a single client
                # on construction.
                #
                # @example
                #
                #   # Modify the global config, setting the timeout for
                #   # create_migration_workflow to 20 seconds,
                #   # and all remaining timeouts to 10 seconds.
                #   ::Google::Cloud::Bigquery::Migration::V2::MigrationService::Rest::Client.configure do |config|
                #     config.timeout = 10.0
                #     config.rpcs.create_migration_workflow.timeout = 20.0
                #   end
                #
                #   # Apply the above configuration only to a new client.
                #   client = ::Google::Cloud::Bigquery::Migration::V2::MigrationService::Rest::Client.new do |config|
                #     config.timeout = 10.0
                #     config.rpcs.create_migration_workflow.timeout = 20.0
                #   end
                #
                # @!attribute [rw] endpoint
                #   A custom service endpoint, as a hostname or hostname:port. The default is
                #   nil, indicating to use the default endpoint in the current universe domain.
                #   @return [::String,nil]
                # @!attribute [rw] credentials
                #   Credentials to send with calls. You may provide any of the following types:
                #    *  (`String`) The path to a service account key file in JSON format
                #    *  (`Hash`) A service account key as a Hash
                #    *  (`Google::Auth::Credentials`) A googleauth credentials object
                #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
                #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
                #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
                #    *  (`nil`) indicating no credentials
                #
                #   Warning: If you accept a credential configuration (JSON file or Hash) from an
                #   external source for authentication to Google Cloud, you must validate it before
                #   providing it to a Google API client library. Providing an unvalidated credential
                #   configuration to Google APIs can compromise the security of your systems and data.
                #   For more information, refer to [Validate credential configurations from external
                #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
                #   @return [::Object]
                # @!attribute [rw] scope
                #   The OAuth scopes
                #   @return [::Array<::String>]
                # @!attribute [rw] lib_name
                #   The library name as recorded in instrumentation and logging
                #   @return [::String]
                # @!attribute [rw] lib_version
                #   The library version as recorded in instrumentation and logging
                #   @return [::String]
                # @!attribute [rw] timeout
                #   The call timeout in seconds.
                #   @return [::Numeric]
                # @!attribute [rw] metadata
                #   Additional headers to be sent with the call.
                #   @return [::Hash{::Symbol=>::String}]
                # @!attribute [rw] retry_policy
                #   The retry policy. The value is a hash with the following keys:
                #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #       trigger a retry.
                #   @return [::Hash]
                # @!attribute [rw] quota_project
                #   A separate project against which to charge quota.
                #   @return [::String]
                # @!attribute [rw] universe_domain
                #   The universe domain within which to make requests. This determines the
                #   default endpoint URL. The default value of nil uses the environment
                #   universe (usually the default "googleapis.com" universe).
                #   @return [::String,nil]
                # @!attribute [rw] logger
                #   A custom logger to use for request/response debug logging, or the value
                #   `:default` (the default) to construct a default logger, or `nil` to
                #   explicitly disable logging.
                #   @return [::Logger,:default,nil]
                #
                class Configuration
                  extend ::Gapic::Config

                  # @private
                  # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                  DEFAULT_ENDPOINT = "bigquerymigration.googleapis.com"

                  config_attr :endpoint,      nil, ::String, nil
                  config_attr :credentials,   nil do |value|
                    allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                    allowed.any? { |klass| klass === value }
                  end
                  config_attr :scope,         nil, ::String, ::Array, nil
                  config_attr :lib_name,      nil, ::String, nil
                  config_attr :lib_version,   nil, ::String, nil
                  config_attr :timeout,       nil, ::Numeric, nil
                  config_attr :metadata,      nil, ::Hash, nil
                  config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                  config_attr :quota_project, nil, ::String, nil
                  config_attr :universe_domain, nil, ::String, nil
                  config_attr :logger, :default, ::Logger, nil, :default

                  # @private
                  def initialize parent_config = nil
                    @parent_config = parent_config unless parent_config.nil?

                    yield self if block_given?
                  end

                  ##
                  # Configurations for individual RPCs
                  # @return [Rpcs]
                  #
                  def rpcs
                    @rpcs ||= begin
                      parent_rpcs = nil
                      parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                      Rpcs.new parent_rpcs
                    end
                  end

                  ##
                  # Configuration RPC class for the MigrationService API.
                  #
                  # Includes fields providing the configuration for each RPC in this service.
                  # Each configuration object is of type `Gapic::Config::Method` and includes
                  # the following configuration fields:
                  #
                  #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                  #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                  #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                  #     include the following keys:
                  #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                  #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                  #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                  #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                  #         trigger a retry.
                  #
                  class Rpcs
                    ##
                    # RPC-specific configuration for `create_migration_workflow`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :create_migration_workflow
                    ##
                    # RPC-specific configuration for `get_migration_workflow`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_migration_workflow
                    ##
                    # RPC-specific configuration for `list_migration_workflows`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_migration_workflows
                    ##
                    # RPC-specific configuration for `delete_migration_workflow`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :delete_migration_workflow
                    ##
                    # RPC-specific configuration for `start_migration_workflow`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :start_migration_workflow
                    ##
                    # RPC-specific configuration for `get_migration_subtask`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_migration_subtask
                    ##
                    # RPC-specific configuration for `list_migration_subtasks`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_migration_subtasks

                    # @private
                    def initialize parent_rpcs = nil
                      create_migration_workflow_config = parent_rpcs.create_migration_workflow if parent_rpcs.respond_to? :create_migration_workflow
                      @create_migration_workflow = ::Gapic::Config::Method.new create_migration_workflow_config
                      get_migration_workflow_config = parent_rpcs.get_migration_workflow if parent_rpcs.respond_to? :get_migration_workflow
                      @get_migration_workflow = ::Gapic::Config::Method.new get_migration_workflow_config
                      list_migration_workflows_config = parent_rpcs.list_migration_workflows if parent_rpcs.respond_to? :list_migration_workflows
                      @list_migration_workflows = ::Gapic::Config::Method.new list_migration_workflows_config
                      delete_migration_workflow_config = parent_rpcs.delete_migration_workflow if parent_rpcs.respond_to? :delete_migration_workflow
                      @delete_migration_workflow = ::Gapic::Config::Method.new delete_migration_workflow_config
                      start_migration_workflow_config = parent_rpcs.start_migration_workflow if parent_rpcs.respond_to? :start_migration_workflow
                      @start_migration_workflow = ::Gapic::Config::Method.new start_migration_workflow_config
                      get_migration_subtask_config = parent_rpcs.get_migration_subtask if parent_rpcs.respond_to? :get_migration_subtask
                      @get_migration_subtask = ::Gapic::Config::Method.new get_migration_subtask_config
                      list_migration_subtasks_config = parent_rpcs.list_migration_subtasks if parent_rpcs.respond_to? :list_migration_subtasks
                      @list_migration_subtasks = ::Gapic::Config::Method.new list_migration_subtasks_config

                      yield self if block_given?
                    end
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
