# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Bigquery
      module Migration
        module V2
          module MigrationService
            # Path helper methods for the MigrationService API.
            module Paths
              ##
              # Create a fully-qualified Location resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}`
              #
              # @param project [String]
              # @param location [String]
              #
              # @return [::String]
              def location_path project:, location:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                "projects/#{project}/locations/#{location}"
              end

              ##
              # Create a fully-qualified MigrationSubtask resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}/workflows/{workflow}/subtasks/{subtask}`
              #
              # @param project [String]
              # @param location [String]
              # @param workflow [String]
              # @param subtask [String]
              #
              # @return [::String]
              def migration_subtask_path project:, location:, workflow:, subtask:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                raise ::ArgumentError, "workflow cannot contain /" if workflow.to_s.include? "/"

                "projects/#{project}/locations/#{location}/workflows/#{workflow}/subtasks/#{subtask}"
              end

              ##
              # Create a fully-qualified MigrationWorkflow resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}/workflows/{workflow}`
              #
              # @param project [String]
              # @param location [String]
              # @param workflow [String]
              #
              # @return [::String]
              def migration_workflow_path project:, location:, workflow:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                "projects/#{project}/locations/#{location}/workflows/#{workflow}"
              end

              extend self
            end
          end
        end
      end
    end
  end
end
