# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/bigquery/datatransfer/v1/datatransfer_pb"
require "google/cloud/bigquery/data_transfer/v1/data_transfer_service/rest"


class ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_data_source
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::DataTransfer::V1::DataSource.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_data_source_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::ServiceStub.stub :transcode_get_data_source_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_data_source_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_data_source({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_data_source name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_data_source ::Google::Cloud::Bigquery::DataTransfer::V1::GetDataSourceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_data_source({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_data_source(::Google::Cloud::Bigquery::DataTransfer::V1::GetDataSourceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_data_source_client_stub.call_count
      end
    end
  end

  def test_list_data_sources
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::DataTransfer::V1::ListDataSourcesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_token = "hello world"
    page_size = 42

    list_data_sources_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::ServiceStub.stub :transcode_list_data_sources_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_data_sources_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_data_sources({ parent: parent, page_token: page_token, page_size: page_size }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_data_sources parent: parent, page_token: page_token, page_size: page_size do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_data_sources ::Google::Cloud::Bigquery::DataTransfer::V1::ListDataSourcesRequest.new(parent: parent, page_token: page_token, page_size: page_size) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_data_sources({ parent: parent, page_token: page_token, page_size: page_size }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_data_sources(::Google::Cloud::Bigquery::DataTransfer::V1::ListDataSourcesRequest.new(parent: parent, page_token: page_token, page_size: page_size), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_data_sources_client_stub.call_count
      end
    end
  end

  def test_create_transfer_config
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::DataTransfer::V1::TransferConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    transfer_config = {}
    authorization_code = "hello world"
    version_info = "hello world"
    service_account_name = "hello world"

    create_transfer_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::ServiceStub.stub :transcode_create_transfer_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_transfer_config_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_transfer_config({ parent: parent, transfer_config: transfer_config, authorization_code: authorization_code, version_info: version_info, service_account_name: service_account_name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_transfer_config parent: parent, transfer_config: transfer_config, authorization_code: authorization_code, version_info: version_info, service_account_name: service_account_name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_transfer_config ::Google::Cloud::Bigquery::DataTransfer::V1::CreateTransferConfigRequest.new(parent: parent, transfer_config: transfer_config, authorization_code: authorization_code, version_info: version_info, service_account_name: service_account_name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_transfer_config({ parent: parent, transfer_config: transfer_config, authorization_code: authorization_code, version_info: version_info, service_account_name: service_account_name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_transfer_config(::Google::Cloud::Bigquery::DataTransfer::V1::CreateTransferConfigRequest.new(parent: parent, transfer_config: transfer_config, authorization_code: authorization_code, version_info: version_info, service_account_name: service_account_name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_transfer_config_client_stub.call_count
      end
    end
  end

  def test_update_transfer_config
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::DataTransfer::V1::TransferConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    transfer_config = {}
    authorization_code = "hello world"
    update_mask = {}
    version_info = "hello world"
    service_account_name = "hello world"

    update_transfer_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::ServiceStub.stub :transcode_update_transfer_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_transfer_config_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_transfer_config({ transfer_config: transfer_config, authorization_code: authorization_code, update_mask: update_mask, version_info: version_info, service_account_name: service_account_name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_transfer_config transfer_config: transfer_config, authorization_code: authorization_code, update_mask: update_mask, version_info: version_info, service_account_name: service_account_name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_transfer_config ::Google::Cloud::Bigquery::DataTransfer::V1::UpdateTransferConfigRequest.new(transfer_config: transfer_config, authorization_code: authorization_code, update_mask: update_mask, version_info: version_info, service_account_name: service_account_name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_transfer_config({ transfer_config: transfer_config, authorization_code: authorization_code, update_mask: update_mask, version_info: version_info, service_account_name: service_account_name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_transfer_config(::Google::Cloud::Bigquery::DataTransfer::V1::UpdateTransferConfigRequest.new(transfer_config: transfer_config, authorization_code: authorization_code, update_mask: update_mask, version_info: version_info, service_account_name: service_account_name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_transfer_config_client_stub.call_count
      end
    end
  end

  def test_delete_transfer_config
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_transfer_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::ServiceStub.stub :transcode_delete_transfer_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_transfer_config_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_transfer_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_transfer_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_transfer_config ::Google::Cloud::Bigquery::DataTransfer::V1::DeleteTransferConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_transfer_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_transfer_config(::Google::Cloud::Bigquery::DataTransfer::V1::DeleteTransferConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_transfer_config_client_stub.call_count
      end
    end
  end

  def test_get_transfer_config
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::DataTransfer::V1::TransferConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_transfer_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::ServiceStub.stub :transcode_get_transfer_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_transfer_config_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_transfer_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_transfer_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_transfer_config ::Google::Cloud::Bigquery::DataTransfer::V1::GetTransferConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_transfer_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_transfer_config(::Google::Cloud::Bigquery::DataTransfer::V1::GetTransferConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_transfer_config_client_stub.call_count
      end
    end
  end

  def test_list_transfer_configs
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::DataTransfer::V1::ListTransferConfigsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    data_source_ids = ["hello world"]
    page_token = "hello world"
    page_size = 42

    list_transfer_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::ServiceStub.stub :transcode_list_transfer_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_transfer_configs_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_transfer_configs({ parent: parent, data_source_ids: data_source_ids, page_token: page_token, page_size: page_size }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_transfer_configs parent: parent, data_source_ids: data_source_ids, page_token: page_token, page_size: page_size do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_transfer_configs ::Google::Cloud::Bigquery::DataTransfer::V1::ListTransferConfigsRequest.new(parent: parent, data_source_ids: data_source_ids, page_token: page_token, page_size: page_size) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_transfer_configs({ parent: parent, data_source_ids: data_source_ids, page_token: page_token, page_size: page_size }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_transfer_configs(::Google::Cloud::Bigquery::DataTransfer::V1::ListTransferConfigsRequest.new(parent: parent, data_source_ids: data_source_ids, page_token: page_token, page_size: page_size), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_transfer_configs_client_stub.call_count
      end
    end
  end

  def test_schedule_transfer_runs
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::DataTransfer::V1::ScheduleTransferRunsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    start_time = {}
    end_time = {}

    schedule_transfer_runs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::ServiceStub.stub :transcode_schedule_transfer_runs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, schedule_transfer_runs_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.schedule_transfer_runs({ parent: parent, start_time: start_time, end_time: end_time }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.schedule_transfer_runs parent: parent, start_time: start_time, end_time: end_time do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.schedule_transfer_runs ::Google::Cloud::Bigquery::DataTransfer::V1::ScheduleTransferRunsRequest.new(parent: parent, start_time: start_time, end_time: end_time) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.schedule_transfer_runs({ parent: parent, start_time: start_time, end_time: end_time }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.schedule_transfer_runs(::Google::Cloud::Bigquery::DataTransfer::V1::ScheduleTransferRunsRequest.new(parent: parent, start_time: start_time, end_time: end_time), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, schedule_transfer_runs_client_stub.call_count
      end
    end
  end

  def test_start_manual_transfer_runs
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::DataTransfer::V1::StartManualTransferRunsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requested_time_range = {}

    start_manual_transfer_runs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::ServiceStub.stub :transcode_start_manual_transfer_runs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, start_manual_transfer_runs_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.start_manual_transfer_runs({ parent: parent, requested_time_range: requested_time_range }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.start_manual_transfer_runs parent: parent, requested_time_range: requested_time_range do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.start_manual_transfer_runs ::Google::Cloud::Bigquery::DataTransfer::V1::StartManualTransferRunsRequest.new(parent: parent, requested_time_range: requested_time_range) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.start_manual_transfer_runs({ parent: parent, requested_time_range: requested_time_range }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.start_manual_transfer_runs(::Google::Cloud::Bigquery::DataTransfer::V1::StartManualTransferRunsRequest.new(parent: parent, requested_time_range: requested_time_range), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, start_manual_transfer_runs_client_stub.call_count
      end
    end
  end

  def test_get_transfer_run
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::DataTransfer::V1::TransferRun.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_transfer_run_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::ServiceStub.stub :transcode_get_transfer_run_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_transfer_run_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_transfer_run({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_transfer_run name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_transfer_run ::Google::Cloud::Bigquery::DataTransfer::V1::GetTransferRunRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_transfer_run({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_transfer_run(::Google::Cloud::Bigquery::DataTransfer::V1::GetTransferRunRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_transfer_run_client_stub.call_count
      end
    end
  end

  def test_delete_transfer_run
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_transfer_run_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::ServiceStub.stub :transcode_delete_transfer_run_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_transfer_run_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_transfer_run({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_transfer_run name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_transfer_run ::Google::Cloud::Bigquery::DataTransfer::V1::DeleteTransferRunRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_transfer_run({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_transfer_run(::Google::Cloud::Bigquery::DataTransfer::V1::DeleteTransferRunRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_transfer_run_client_stub.call_count
      end
    end
  end

  def test_list_transfer_runs
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::DataTransfer::V1::ListTransferRunsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    states = [:TRANSFER_STATE_UNSPECIFIED]
    page_token = "hello world"
    page_size = 42
    run_attempt = :RUN_ATTEMPT_UNSPECIFIED

    list_transfer_runs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::ServiceStub.stub :transcode_list_transfer_runs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_transfer_runs_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_transfer_runs({ parent: parent, states: states, page_token: page_token, page_size: page_size, run_attempt: run_attempt }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_transfer_runs parent: parent, states: states, page_token: page_token, page_size: page_size, run_attempt: run_attempt do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_transfer_runs ::Google::Cloud::Bigquery::DataTransfer::V1::ListTransferRunsRequest.new(parent: parent, states: states, page_token: page_token, page_size: page_size, run_attempt: run_attempt) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_transfer_runs({ parent: parent, states: states, page_token: page_token, page_size: page_size, run_attempt: run_attempt }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_transfer_runs(::Google::Cloud::Bigquery::DataTransfer::V1::ListTransferRunsRequest.new(parent: parent, states: states, page_token: page_token, page_size: page_size, run_attempt: run_attempt), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_transfer_runs_client_stub.call_count
      end
    end
  end

  def test_list_transfer_logs
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::DataTransfer::V1::ListTransferLogsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_token = "hello world"
    page_size = 42
    message_types = [:MESSAGE_SEVERITY_UNSPECIFIED]

    list_transfer_logs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::ServiceStub.stub :transcode_list_transfer_logs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_transfer_logs_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_transfer_logs({ parent: parent, page_token: page_token, page_size: page_size, message_types: message_types }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_transfer_logs parent: parent, page_token: page_token, page_size: page_size, message_types: message_types do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_transfer_logs ::Google::Cloud::Bigquery::DataTransfer::V1::ListTransferLogsRequest.new(parent: parent, page_token: page_token, page_size: page_size, message_types: message_types) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_transfer_logs({ parent: parent, page_token: page_token, page_size: page_size, message_types: message_types }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_transfer_logs(::Google::Cloud::Bigquery::DataTransfer::V1::ListTransferLogsRequest.new(parent: parent, page_token: page_token, page_size: page_size, message_types: message_types), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_transfer_logs_client_stub.call_count
      end
    end
  end

  def test_check_valid_creds
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::DataTransfer::V1::CheckValidCredsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    check_valid_creds_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::ServiceStub.stub :transcode_check_valid_creds_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, check_valid_creds_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.check_valid_creds({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.check_valid_creds name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.check_valid_creds ::Google::Cloud::Bigquery::DataTransfer::V1::CheckValidCredsRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.check_valid_creds({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.check_valid_creds(::Google::Cloud::Bigquery::DataTransfer::V1::CheckValidCredsRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, check_valid_creds_client_stub.call_count
      end
    end
  end

  def test_enroll_data_sources
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    data_source_ids = ["hello world"]

    enroll_data_sources_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::ServiceStub.stub :transcode_enroll_data_sources_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, enroll_data_sources_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.enroll_data_sources({ name: name, data_source_ids: data_source_ids }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.enroll_data_sources name: name, data_source_ids: data_source_ids do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.enroll_data_sources ::Google::Cloud::Bigquery::DataTransfer::V1::EnrollDataSourcesRequest.new(name: name, data_source_ids: data_source_ids) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.enroll_data_sources({ name: name, data_source_ids: data_source_ids }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.enroll_data_sources(::Google::Cloud::Bigquery::DataTransfer::V1::EnrollDataSourcesRequest.new(name: name, data_source_ids: data_source_ids), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, enroll_data_sources_client_stub.call_count
      end
    end
  end

  def test_unenroll_data_sources
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    data_source_ids = ["hello world"]

    unenroll_data_sources_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::ServiceStub.stub :transcode_unenroll_data_sources_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, unenroll_data_sources_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.unenroll_data_sources({ name: name, data_source_ids: data_source_ids }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.unenroll_data_sources name: name, data_source_ids: data_source_ids do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.unenroll_data_sources ::Google::Cloud::Bigquery::DataTransfer::V1::UnenrollDataSourcesRequest.new(name: name, data_source_ids: data_source_ids) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.unenroll_data_sources({ name: name, data_source_ids: data_source_ids }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.unenroll_data_sources(::Google::Cloud::Bigquery::DataTransfer::V1::UnenrollDataSourcesRequest.new(name: name, data_source_ids: data_source_ids), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, unenroll_data_sources_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client::Configuration, config
  end
end
