# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Bigquery
      module DataTransfer
        module V1
          # A parameter used to define custom fields in a data source definition.
          # @!attribute [rw] param_id
          #   @return [::String]
          #     Parameter identifier.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     Parameter display name in the user interface.
          # @!attribute [rw] description
          #   @return [::String]
          #     Parameter description.
          # @!attribute [rw] type
          #   @return [::Google::Cloud::Bigquery::DataTransfer::V1::DataSourceParameter::Type]
          #     Parameter type.
          # @!attribute [rw] required
          #   @return [::Boolean]
          #     Is parameter required.
          # @!attribute [rw] repeated
          #   @return [::Boolean]
          #     Deprecated. This field has no effect.
          # @!attribute [rw] validation_regex
          #   @return [::String]
          #     Regular expression which can be used for parameter validation.
          # @!attribute [rw] allowed_values
          #   @return [::Array<::String>]
          #     All possible values for the parameter.
          # @!attribute [rw] min_value
          #   @return [::Google::Protobuf::DoubleValue]
          #     For integer and double values specifies minimum allowed value.
          # @!attribute [rw] max_value
          #   @return [::Google::Protobuf::DoubleValue]
          #     For integer and double values specifies maximum allowed value.
          # @!attribute [rw] fields
          #   @return [::Array<::Google::Cloud::Bigquery::DataTransfer::V1::DataSourceParameter>]
          #     Deprecated. This field has no effect.
          # @!attribute [rw] validation_description
          #   @return [::String]
          #     Description of the requirements for this field, in case the user input does
          #     not fulfill the regex pattern or min/max values.
          # @!attribute [rw] validation_help_url
          #   @return [::String]
          #     URL to a help document to further explain the naming requirements.
          # @!attribute [rw] immutable
          #   @return [::Boolean]
          #     Cannot be changed after initial creation.
          # @!attribute [rw] recurse
          #   @return [::Boolean]
          #     Deprecated. This field has no effect.
          # @!attribute [rw] deprecated
          #   @return [::Boolean]
          #     If true, it should not be used in new transfers, and it should not be
          #     visible to users.
          class DataSourceParameter
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Parameter type.
            module Type
              # Type unspecified.
              TYPE_UNSPECIFIED = 0

              # String parameter.
              STRING = 1

              # Integer parameter (64-bits).
              # Will be serialized to json as string.
              INTEGER = 2

              # Double precision floating point parameter.
              DOUBLE = 3

              # Boolean parameter.
              BOOLEAN = 4

              # Deprecated. This field has no effect.
              RECORD = 5

              # Page ID for a Google+ Page.
              PLUS_PAGE = 6

              # List of strings parameter.
              LIST = 7
            end
          end

          # Defines the properties and custom parameters for a data source.
          # @!attribute [r] name
          #   @return [::String]
          #     Output only. Data source resource name.
          # @!attribute [rw] data_source_id
          #   @return [::String]
          #     Data source id.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     User friendly data source name.
          # @!attribute [rw] description
          #   @return [::String]
          #     User friendly data source description string.
          # @!attribute [rw] client_id
          #   @return [::String]
          #     Data source client id which should be used to receive refresh token.
          # @!attribute [rw] scopes
          #   @return [::Array<::String>]
          #     Api auth scopes for which refresh token needs to be obtained. These are
          #     scopes needed by a data source to prepare data and ingest them into
          #     BigQuery, e.g., https://www.googleapis.com/auth/bigquery
          # @!attribute [rw] transfer_type
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Google::Cloud::Bigquery::DataTransfer::V1::TransferType]
          #     Deprecated. This field has no effect.
          # @!attribute [rw] supports_multiple_transfers
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Boolean]
          #     Deprecated. This field has no effect.
          # @!attribute [rw] update_deadline_seconds
          #   @return [::Integer]
          #     The number of seconds to wait for an update from the data source
          #     before the Data Transfer Service marks the transfer as FAILED.
          # @!attribute [rw] default_schedule
          #   @return [::String]
          #     Default data transfer schedule.
          #     Examples of valid schedules include:
          #     `1st,3rd monday of month 15:30`,
          #     `every wed,fri of jan,jun 13:15`, and
          #     `first sunday of quarter 00:00`.
          # @!attribute [rw] supports_custom_schedule
          #   @return [::Boolean]
          #     Specifies whether the data source supports a user defined schedule, or
          #     operates on the default schedule.
          #     When set to `true`, user can override default schedule.
          # @!attribute [rw] parameters
          #   @return [::Array<::Google::Cloud::Bigquery::DataTransfer::V1::DataSourceParameter>]
          #     Data source parameters.
          # @!attribute [rw] help_url
          #   @return [::String]
          #     Url for the help document for this data source.
          # @!attribute [rw] authorization_type
          #   @return [::Google::Cloud::Bigquery::DataTransfer::V1::DataSource::AuthorizationType]
          #     Indicates the type of authorization.
          # @!attribute [rw] data_refresh_type
          #   @return [::Google::Cloud::Bigquery::DataTransfer::V1::DataSource::DataRefreshType]
          #     Specifies whether the data source supports automatic data refresh for the
          #     past few days, and how it's supported.
          #     For some data sources, data might not be complete until a few days later,
          #     so it's useful to refresh data automatically.
          # @!attribute [rw] default_data_refresh_window_days
          #   @return [::Integer]
          #     Default data refresh window on days.
          #     Only meaningful when `data_refresh_type` = `SLIDING_WINDOW`.
          # @!attribute [rw] manual_runs_disabled
          #   @return [::Boolean]
          #     Disables backfilling and manual run scheduling
          #     for the data source.
          # @!attribute [rw] minimum_schedule_interval
          #   @return [::Google::Protobuf::Duration]
          #     The minimum interval for scheduler to schedule runs.
          class DataSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The type of authorization needed for this data source.
            module AuthorizationType
              # Type unspecified.
              AUTHORIZATION_TYPE_UNSPECIFIED = 0

              # Use OAuth 2 authorization codes that can be exchanged
              # for a refresh token on the backend.
              AUTHORIZATION_CODE = 1

              # Return an authorization code for a given Google+ page that can then be
              # exchanged for a refresh token on the backend.
              GOOGLE_PLUS_AUTHORIZATION_CODE = 2

              # Use First Party OAuth.
              FIRST_PARTY_OAUTH = 3
            end

            # Represents how the data source supports data auto refresh.
            module DataRefreshType
              # The data source won't support data auto refresh, which is default value.
              DATA_REFRESH_TYPE_UNSPECIFIED = 0

              # The data source supports data auto refresh, and runs will be scheduled
              # for the past few days. Does not allow custom values to be set for each
              # transfer config.
              SLIDING_WINDOW = 1

              # The data source supports data auto refresh, and runs will be scheduled
              # for the past few days. Allows custom values to be set for each transfer
              # config.
              CUSTOM_SLIDING_WINDOW = 2
            end
          end

          # A request to get data source info.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The field will contain name of the resource requested, for
          #     example: `projects/{project_id}/dataSources/{data_source_id}` or
          #     `projects/{project_id}/locations/{location_id}/dataSources/{data_source_id}`
          class GetDataSourceRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request to list supported data sources and their data transfer settings.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The BigQuery project id for which data sources should be
          #     returned. Must be in the form: `projects/{project_id}` or
          #     `projects/{project_id}/locations/{location_id}`
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Pagination token, which can be used to request a specific page
          #     of `ListDataSourcesRequest` list results. For multiple-page
          #     results, `ListDataSourcesResponse` outputs
          #     a `next_page` token, which can be used as the
          #     `page_token` value to request the next page of list results.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Page size. The default page size is the maximum value of 1000 results.
          class ListDataSourcesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Returns list of supported data sources and their metadata.
          # @!attribute [rw] data_sources
          #   @return [::Array<::Google::Cloud::Bigquery::DataTransfer::V1::DataSource>]
          #     List of supported data sources and their transfer settings.
          # @!attribute [r] next_page_token
          #   @return [::String]
          #     Output only. The next-pagination token. For multiple-page list results,
          #     this token can be used as the
          #     `ListDataSourcesRequest.page_token`
          #     to request the next page of list results.
          class ListDataSourcesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A request to create a data transfer configuration. If new credentials are
          # needed for this transfer configuration, authorization info must be provided.
          # If authorization info is provided, the transfer configuration will be
          # associated with the user id corresponding to the authorization info.
          # Otherwise, the transfer configuration will be associated with the calling
          # user.
          #
          # When using a cross project service account for creating a transfer config,
          # you must enable cross project service account usage. For more information,
          # see [Disable attachment of service accounts to resources in other
          # projects](https://cloud.google.com/resource-manager/docs/organization-policy/restricting-service-accounts#disable_cross_project_service_accounts).
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The BigQuery project id where the transfer configuration should
          #     be created. Must be in the format
          #     projects/\\{project_id}/locations/\\{location_id} or projects/\\{project_id}. If
          #     specified location and location of the destination bigquery dataset do not
          #     match - the request will fail.
          # @!attribute [rw] transfer_config
          #   @return [::Google::Cloud::Bigquery::DataTransfer::V1::TransferConfig]
          #     Required. Data transfer configuration to create.
          # @!attribute [rw] authorization_code
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::String]
          #     Deprecated: Authorization code was required when
          #     `transferConfig.dataSourceId` is 'youtube_channel' but it is no longer used
          #     in any data sources. Use `version_info` instead.
          #
          #     Optional OAuth2 authorization code to use with this transfer configuration.
          #     This is required only if `transferConfig.dataSourceId` is 'youtube_channel'
          #     and new credentials are needed, as indicated by `CheckValidCreds`. In order
          #     to obtain authorization_code, make a request to the following URL:
          #     <pre class="prettyprint" suppresswarning="true">
          #     https://bigquery.cloud.google.com/datatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&response_type=authorization_code&client_id=<var>client_id</var>&scope=<var>data_source_scopes</var>
          #     </pre>
          #     * The <var>client_id</var> is the OAuth client_id of the data source as
          #     returned by ListDataSources method.
          #     * <var>data_source_scopes</var> are the scopes returned by ListDataSources
          #     method.
          #
          #     Note that this should not be set when `service_account_name` is used to
          #     create the transfer config.
          # @!attribute [rw] version_info
          #   @return [::String]
          #     Optional version info. This parameter replaces `authorization_code` which
          #     is no longer used in any data sources. This is required only if
          #     `transferConfig.dataSourceId` is 'youtube_channel' *or* new credentials
          #     are needed, as indicated by `CheckValidCreds`. In order to obtain version
          #     info, make a request to the following URL:
          #     <pre class="prettyprint" suppresswarning="true">
          #     https://bigquery.cloud.google.com/datatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&response_type=version_info&client_id=<var>client_id</var>&scope=<var>data_source_scopes</var>
          #     </pre>
          #     * The <var>client_id</var> is the OAuth client_id of the data source as
          #     returned by ListDataSources method.
          #     * <var>data_source_scopes</var> are the scopes returned by ListDataSources
          #     method.
          #
          #     Note that this should not be set when `service_account_name` is used to
          #     create the transfer config.
          # @!attribute [rw] service_account_name
          #   @return [::String]
          #     Optional service account email. If this field is set, the transfer config
          #     will be created with this service account's credentials. It requires that
          #     the requesting user calling this API has permissions to act as this service
          #     account.
          #
          #     Note that not all data sources support service account credentials when
          #     creating a transfer config. For the latest list of data sources, read about
          #     [using service
          #     accounts](https://cloud.google.com/bigquery-transfer/docs/use-service-accounts).
          class CreateTransferConfigRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A request to update a transfer configuration. To update the user id of the
          # transfer configuration, authorization info needs to be provided.
          #
          # When using a cross project service account for updating a transfer config,
          # you must enable cross project service account usage. For more information,
          # see [Disable attachment of service accounts to resources in other
          # projects](https://cloud.google.com/resource-manager/docs/organization-policy/restricting-service-accounts#disable_cross_project_service_accounts).
          # @!attribute [rw] transfer_config
          #   @return [::Google::Cloud::Bigquery::DataTransfer::V1::TransferConfig]
          #     Required. Data transfer configuration to create.
          # @!attribute [rw] authorization_code
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::String]
          #     Deprecated: Authorization code was required when
          #     `transferConfig.dataSourceId` is 'youtube_channel' but it is no longer used
          #     in any data sources. Use `version_info` instead.
          #
          #     Optional OAuth2 authorization code to use with this transfer configuration.
          #     This is required only if `transferConfig.dataSourceId` is 'youtube_channel'
          #     and new credentials are needed, as indicated by `CheckValidCreds`. In order
          #     to obtain authorization_code, make a request to the following URL:
          #     <pre class="prettyprint" suppresswarning="true">
          #     https://bigquery.cloud.google.com/datatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&response_type=authorization_code&client_id=<var>client_id</var>&scope=<var>data_source_scopes</var>
          #     </pre>
          #     * The <var>client_id</var> is the OAuth client_id of the data source as
          #     returned by ListDataSources method.
          #     * <var>data_source_scopes</var> are the scopes returned by ListDataSources
          #     method.
          #
          #     Note that this should not be set when `service_account_name` is used to
          #     update the transfer config.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Required. Required list of fields to be updated in this request.
          # @!attribute [rw] version_info
          #   @return [::String]
          #     Optional version info. This parameter replaces `authorization_code` which
          #     is no longer used in any data sources. This is required only if
          #     `transferConfig.dataSourceId` is 'youtube_channel' *or* new credentials
          #     are needed, as indicated by `CheckValidCreds`. In order to obtain version
          #     info, make a request to the following URL:
          #     <pre class="prettyprint" suppresswarning="true">
          #     https://bigquery.cloud.google.com/datatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&response_type=version_info&client_id=<var>client_id</var>&scope=<var>data_source_scopes</var>
          #     </pre>
          #     * The <var>client_id</var> is the OAuth client_id of the data source as
          #     returned by ListDataSources method.
          #     * <var>data_source_scopes</var> are the scopes returned by ListDataSources
          #     method.
          #
          #     Note that this should not be set when `service_account_name` is used to
          #     update the transfer config.
          # @!attribute [rw] service_account_name
          #   @return [::String]
          #     Optional service account email. If this field is set, the transfer config
          #     will be created with this service account's credentials. It requires that
          #     the requesting user calling this API has permissions to act as this service
          #     account.
          #
          #     Note that not all data sources support service account credentials when
          #     creating a transfer config. For the latest list of data sources, read about
          #     [using service
          #     accounts](https://cloud.google.com/bigquery-transfer/docs/use-service-accounts).
          class UpdateTransferConfigRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A request to get data transfer information.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The field will contain name of the resource requested, for
          #     example: `projects/{project_id}/transferConfigs/{config_id}` or
          #     `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`
          class GetTransferConfigRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A request to delete data transfer information. All associated transfer runs
          # and log messages will be deleted as well.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The field will contain name of the resource requested, for
          #     example: `projects/{project_id}/transferConfigs/{config_id}` or
          #     `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`
          class DeleteTransferConfigRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A request to get data transfer run information.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The field will contain name of the resource requested, for
          #     example: `projects/{project_id}/transferConfigs/{config_id}/runs/{run_id}`
          #     or
          #     `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}/runs/{run_id}`
          class GetTransferRunRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A request to delete data transfer run information.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The field will contain name of the resource requested, for
          #     example: `projects/{project_id}/transferConfigs/{config_id}/runs/{run_id}`
          #     or
          #     `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}/runs/{run_id}`
          class DeleteTransferRunRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A request to list data transfers configured for a BigQuery project.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The BigQuery project id for which transfer configs
          #     should be returned: `projects/{project_id}` or
          #     `projects/{project_id}/locations/{location_id}`
          # @!attribute [rw] data_source_ids
          #   @return [::Array<::String>]
          #     When specified, only configurations of requested data sources are returned.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Pagination token, which can be used to request a specific page
          #     of `ListTransfersRequest` list results. For multiple-page
          #     results, `ListTransfersResponse` outputs
          #     a `next_page` token, which can be used as the
          #     `page_token` value to request the next page of list results.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Page size. The default page size is the maximum value of 1000 results.
          class ListTransferConfigsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The returned list of pipelines in the project.
          # @!attribute [r] transfer_configs
          #   @return [::Array<::Google::Cloud::Bigquery::DataTransfer::V1::TransferConfig>]
          #     Output only. The stored pipeline transfer configurations.
          # @!attribute [r] next_page_token
          #   @return [::String]
          #     Output only. The next-pagination token. For multiple-page list results,
          #     this token can be used as the
          #     `ListTransferConfigsRequest.page_token`
          #     to request the next page of list results.
          class ListTransferConfigsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A request to list data transfer runs.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. Name of transfer configuration for which transfer runs should be
          #     retrieved. Format of transfer configuration resource name is:
          #     `projects/{project_id}/transferConfigs/{config_id}` or
          #     `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`.
          # @!attribute [rw] states
          #   @return [::Array<::Google::Cloud::Bigquery::DataTransfer::V1::TransferState>]
          #     When specified, only transfer runs with requested states are returned.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Pagination token, which can be used to request a specific page
          #     of `ListTransferRunsRequest` list results. For multiple-page
          #     results, `ListTransferRunsResponse` outputs
          #     a `next_page` token, which can be used as the
          #     `page_token` value to request the next page of list results.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Page size. The default page size is the maximum value of 1000 results.
          # @!attribute [rw] run_attempt
          #   @return [::Google::Cloud::Bigquery::DataTransfer::V1::ListTransferRunsRequest::RunAttempt]
          #     Indicates how run attempts are to be pulled.
          class ListTransferRunsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Represents which runs should be pulled.
            module RunAttempt
              # All runs should be returned.
              RUN_ATTEMPT_UNSPECIFIED = 0

              # Only latest run per day should be returned.
              LATEST = 1
            end
          end

          # The returned list of pipelines in the project.
          # @!attribute [r] transfer_runs
          #   @return [::Array<::Google::Cloud::Bigquery::DataTransfer::V1::TransferRun>]
          #     Output only. The stored pipeline transfer runs.
          # @!attribute [r] next_page_token
          #   @return [::String]
          #     Output only. The next-pagination token. For multiple-page list results,
          #     this token can be used as the
          #     `ListTransferRunsRequest.page_token`
          #     to request the next page of list results.
          class ListTransferRunsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A request to get user facing log messages associated with data transfer run.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. Transfer run name in the form:
          #     `projects/{project_id}/transferConfigs/{config_id}/runs/{run_id}` or
          #     `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}/runs/{run_id}`
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Pagination token, which can be used to request a specific page
          #     of `ListTransferLogsRequest` list results. For multiple-page
          #     results, `ListTransferLogsResponse` outputs
          #     a `next_page` token, which can be used as the
          #     `page_token` value to request the next page of list results.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Page size. The default page size is the maximum value of 1000 results.
          # @!attribute [rw] message_types
          #   @return [::Array<::Google::Cloud::Bigquery::DataTransfer::V1::TransferMessage::MessageSeverity>]
          #     Message types to return. If not populated - INFO, WARNING and ERROR
          #     messages are returned.
          class ListTransferLogsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The returned list transfer run messages.
          # @!attribute [r] transfer_messages
          #   @return [::Array<::Google::Cloud::Bigquery::DataTransfer::V1::TransferMessage>]
          #     Output only. The stored pipeline transfer messages.
          # @!attribute [r] next_page_token
          #   @return [::String]
          #     Output only. The next-pagination token. For multiple-page list results,
          #     this token can be used as the
          #     `GetTransferRunLogRequest.page_token`
          #     to request the next page of list results.
          class ListTransferLogsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A request to determine whether the user has valid credentials. This method
          # is used to limit the number of OAuth popups in the user interface. The
          # user id is inferred from the API call context.
          # If the data source has the Google+ authorization type, this method
          # returns false, as it cannot be determined whether the credentials are
          # already valid merely based on the user id.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The data source in the form:
          #     `projects/{project_id}/dataSources/{data_source_id}` or
          #     `projects/{project_id}/locations/{location_id}/dataSources/{data_source_id}`.
          class CheckValidCredsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A response indicating whether the credentials exist and are valid.
          # @!attribute [rw] has_valid_creds
          #   @return [::Boolean]
          #     If set to `true`, the credentials exist and are valid.
          class CheckValidCredsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A request to schedule transfer runs for a time range.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. Transfer configuration name in the form:
          #     `projects/{project_id}/transferConfigs/{config_id}` or
          #     `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`.
          # @!attribute [rw] start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Required. Start time of the range of transfer runs. For example,
          #     `"2017-05-25T00:00:00+00:00"`.
          # @!attribute [rw] end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Required. End time of the range of transfer runs. For example,
          #     `"2017-05-30T00:00:00+00:00"`.
          class ScheduleTransferRunsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A response to schedule transfer runs for a time range.
          # @!attribute [rw] runs
          #   @return [::Array<::Google::Cloud::Bigquery::DataTransfer::V1::TransferRun>]
          #     The transfer runs that were scheduled.
          class ScheduleTransferRunsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A request to start manual transfer runs.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. Transfer configuration name in the form:
          #     `projects/{project_id}/transferConfigs/{config_id}` or
          #     `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`.
          # @!attribute [rw] requested_time_range
          #   @return [::Google::Cloud::Bigquery::DataTransfer::V1::StartManualTransferRunsRequest::TimeRange]
          #     A time_range start and end timestamp for historical data files or reports
          #     that are scheduled to be transferred by the scheduled transfer run.
          #     requested_time_range must be a past time and cannot include future time
          #     values.
          #
          #     Note: The following fields are mutually exclusive: `requested_time_range`, `requested_run_time`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] requested_run_time
          #   @return [::Google::Protobuf::Timestamp]
          #     A run_time timestamp for historical data files or reports
          #     that are scheduled to be transferred by the scheduled transfer run.
          #     requested_run_time must be a past time and cannot include future time
          #     values.
          #
          #     Note: The following fields are mutually exclusive: `requested_run_time`, `requested_time_range`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class StartManualTransferRunsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # A specification for a time range, this will request transfer runs with
            # run_time between start_time (inclusive) and end_time (exclusive).
            # @!attribute [rw] start_time
            #   @return [::Google::Protobuf::Timestamp]
            #     Start time of the range of transfer runs. For example,
            #     `"2017-05-25T00:00:00+00:00"`. The start_time must be strictly less than
            #     the end_time. Creates transfer runs where run_time is in the range
            #     between start_time (inclusive) and end_time (exclusive).
            # @!attribute [rw] end_time
            #   @return [::Google::Protobuf::Timestamp]
            #     End time of the range of transfer runs. For example,
            #     `"2017-05-30T00:00:00+00:00"`. The end_time must not be in the future.
            #     Creates transfer runs where run_time is in the range between start_time
            #     (inclusive) and end_time (exclusive).
            class TimeRange
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # A response to start manual transfer runs.
          # @!attribute [rw] runs
          #   @return [::Array<::Google::Cloud::Bigquery::DataTransfer::V1::TransferRun>]
          #     The transfer runs that were created.
          class StartManualTransferRunsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A request to enroll a set of data sources so they are visible in the
          # BigQuery UI's `Transfer` tab.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the project resource in the form:
          #     `projects/{project_id}`
          # @!attribute [rw] data_source_ids
          #   @return [::Array<::String>]
          #     Data sources that are enrolled. It is required to provide at least one
          #     data source id.
          class EnrollDataSourcesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A request to unenroll a set of data sources so they are no longer visible in
          # the BigQuery UI's `Transfer` tab.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the project resource in the form:
          #     `projects/{project_id}`
          # @!attribute [rw] data_source_ids
          #   @return [::Array<::String>]
          #     Data sources that are unenrolled. It is required to provide at least one
          #     data source id.
          class UnenrollDataSourcesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
