# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/bigquery/datatransfer/v1/datatransfer_pb"
require "google/cloud/bigquery/data_transfer/v1/data_transfer_service/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module Bigquery
      module DataTransfer
        module V1
          module DataTransferService
            module Rest
              ##
              # REST client for the DataTransferService service.
              #
              # This API allows users to manage their data transfers into BigQuery.
              #
              class Client
                # @private
                API_VERSION = ""

                # @private
                DEFAULT_ENDPOINT_TEMPLATE = "bigquerydatatransfer.$UNIVERSE_DOMAIN$"

                include Paths

                # @private
                attr_reader :data_transfer_service_stub

                ##
                # Configure the DataTransferService Client class.
                #
                # See {::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client::Configuration}
                # for a description of the configuration fields.
                #
                # @example
                #
                #   # Modify the configuration for all DataTransferService clients
                #   ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.configure do |config|
                #     config.timeout = 10.0
                #   end
                #
                # @yield [config] Configure the Client client.
                # @yieldparam config [Client::Configuration]
                #
                # @return [Client::Configuration]
                #
                def self.configure
                  @configure ||= begin
                    namespace = ["Google", "Cloud", "Bigquery", "DataTransfer", "V1"]
                    parent_config = while namespace.any?
                                      parent_name = namespace.join "::"
                                      parent_const = const_get parent_name
                                      break parent_const.configure if parent_const.respond_to? :configure
                                      namespace.pop
                                    end
                    default_config = Client::Configuration.new parent_config

                    default_config.rpcs.get_data_source.timeout = 20.0
                    default_config.rpcs.get_data_source.retry_policy = {
                      initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                    }

                    default_config.rpcs.list_data_sources.timeout = 20.0
                    default_config.rpcs.list_data_sources.retry_policy = {
                      initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                    }

                    default_config.rpcs.create_transfer_config.timeout = 30.0

                    default_config.rpcs.update_transfer_config.timeout = 30.0

                    default_config.rpcs.delete_transfer_config.timeout = 20.0
                    default_config.rpcs.delete_transfer_config.retry_policy = {
                      initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                    }

                    default_config.rpcs.get_transfer_config.timeout = 20.0
                    default_config.rpcs.get_transfer_config.retry_policy = {
                      initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                    }

                    default_config.rpcs.list_transfer_configs.timeout = 20.0
                    default_config.rpcs.list_transfer_configs.retry_policy = {
                      initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                    }

                    default_config.rpcs.schedule_transfer_runs.timeout = 30.0

                    default_config.rpcs.get_transfer_run.timeout = 20.0
                    default_config.rpcs.get_transfer_run.retry_policy = {
                      initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                    }

                    default_config.rpcs.delete_transfer_run.timeout = 20.0
                    default_config.rpcs.delete_transfer_run.retry_policy = {
                      initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                    }

                    default_config.rpcs.list_transfer_runs.timeout = 20.0
                    default_config.rpcs.list_transfer_runs.retry_policy = {
                      initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                    }

                    default_config.rpcs.list_transfer_logs.timeout = 20.0
                    default_config.rpcs.list_transfer_logs.retry_policy = {
                      initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                    }

                    default_config.rpcs.check_valid_creds.timeout = 20.0
                    default_config.rpcs.check_valid_creds.retry_policy = {
                      initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                    }

                    default_config
                  end
                  yield @configure if block_given?
                  @configure
                end

                ##
                # Configure the DataTransferService Client instance.
                #
                # The configuration is set to the derived mode, meaning that values can be changed,
                # but structural changes (adding new fields, etc.) are not allowed. Structural changes
                # should be made on {Client.configure}.
                #
                # See {::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client::Configuration}
                # for a description of the configuration fields.
                #
                # @yield [config] Configure the Client client.
                # @yieldparam config [Client::Configuration]
                #
                # @return [Client::Configuration]
                #
                def configure
                  yield @config if block_given?
                  @config
                end

                ##
                # The effective universe domain
                #
                # @return [String]
                #
                def universe_domain
                  @data_transfer_service_stub.universe_domain
                end

                ##
                # Create a new DataTransferService REST client object.
                #
                # @example
                #
                #   # Create a client using the default configuration
                #   client = ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new
                #
                #   # Create a client using a custom configuration
                #   client = ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new do |config|
                #     config.timeout = 10.0
                #   end
                #
                # @yield [config] Configure the DataTransferService client.
                # @yieldparam config [Client::Configuration]
                #
                def initialize
                  # Create the configuration object
                  @config = Configuration.new Client.configure

                  # Yield the configuration if needed
                  yield @config if block_given?

                  # Create credentials
                  credentials = @config.credentials
                  # Use self-signed JWT if the endpoint is unchanged from default,
                  # but only if the default endpoint does not have a region prefix.
                  enable_self_signed_jwt = @config.endpoint.nil? ||
                                           (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                           !@config.endpoint.split(".").first.include?("-"))
                  credentials ||= Credentials.default scope: @config.scope,
                                                      enable_self_signed_jwt: enable_self_signed_jwt
                  if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                    credentials = Credentials.new credentials, scope: @config.scope
                  end

                  @quota_project_id = @config.quota_project
                  @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                  @data_transfer_service_stub = ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::ServiceStub.new(
                    endpoint: @config.endpoint,
                    endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                    universe_domain: @config.universe_domain,
                    credentials: credentials,
                    logger: @config.logger
                  )

                  @data_transfer_service_stub.logger(stub: true)&.info do |entry|
                    entry.set_system_name
                    entry.set_service
                    entry.message = "Created client for #{entry.service}"
                    entry.set_credentials_fields credentials
                    entry.set "customEndpoint", @config.endpoint if @config.endpoint
                    entry.set "defaultTimeout", @config.timeout if @config.timeout
                    entry.set "quotaProject", @quota_project_id if @quota_project_id
                  end

                  @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                    config.credentials = credentials
                    config.quota_project = @quota_project_id
                    config.endpoint = @data_transfer_service_stub.endpoint
                    config.universe_domain = @data_transfer_service_stub.universe_domain
                    config.bindings_override = @config.bindings_override
                    config.logger = @data_transfer_service_stub.logger if config.respond_to? :logger=
                  end
                end

                ##
                # Get the associated client for mix-in of the Locations.
                #
                # @return [Google::Cloud::Location::Locations::Rest::Client]
                #
                attr_reader :location_client

                ##
                # The logger used for request/response debug logging.
                #
                # @return [Logger]
                #
                def logger
                  @data_transfer_service_stub.logger
                end

                # Service calls

                ##
                # Retrieves a supported data source and returns its settings.
                #
                # @overload get_data_source(request, options = nil)
                #   Pass arguments to `get_data_source` via a request object, either of type
                #   {::Google::Cloud::Bigquery::DataTransfer::V1::GetDataSourceRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Bigquery::DataTransfer::V1::GetDataSourceRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_data_source(name: nil)
                #   Pass arguments to `get_data_source` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The field will contain name of the resource requested, for
                #     example: `projects/{project_id}/dataSources/{data_source_id}` or
                #     `projects/{project_id}/locations/{location_id}/dataSources/{data_source_id}`
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Bigquery::DataTransfer::V1::DataSource]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Bigquery::DataTransfer::V1::DataSource]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/bigquery/data_transfer/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Bigquery::DataTransfer::V1::GetDataSourceRequest.new
                #
                #   # Call the get_data_source method.
                #   result = client.get_data_source request
                #
                #   # The returned object is of type Google::Cloud::Bigquery::DataTransfer::V1::DataSource.
                #   p result
                #
                def get_data_source request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::DataTransfer::V1::GetDataSourceRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_data_source.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Bigquery::DataTransfer::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_data_source.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_data_source.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @data_transfer_service_stub.get_data_source request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Lists supported data sources and returns their settings.
                #
                # @overload list_data_sources(request, options = nil)
                #   Pass arguments to `list_data_sources` via a request object, either of type
                #   {::Google::Cloud::Bigquery::DataTransfer::V1::ListDataSourcesRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Bigquery::DataTransfer::V1::ListDataSourcesRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_data_sources(parent: nil, page_token: nil, page_size: nil)
                #   Pass arguments to `list_data_sources` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The BigQuery project id for which data sources should be
                #     returned. Must be in the form: `projects/{project_id}` or
                #     `projects/{project_id}/locations/{location_id}`
                #   @param page_token [::String]
                #     Pagination token, which can be used to request a specific page
                #     of `ListDataSourcesRequest` list results. For multiple-page
                #     results, `ListDataSourcesResponse` outputs
                #     a `next_page` token, which can be used as the
                #     `page_token` value to request the next page of list results.
                #   @param page_size [::Integer]
                #     Page size. The default page size is the maximum value of 1000 results.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Bigquery::DataTransfer::V1::DataSource>]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Bigquery::DataTransfer::V1::DataSource>]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/bigquery/data_transfer/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Bigquery::DataTransfer::V1::ListDataSourcesRequest.new
                #
                #   # Call the list_data_sources method.
                #   result = client.list_data_sources request
                #
                #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                #   # over elements, and API calls will be issued to fetch pages as needed.
                #   result.each do |item|
                #     # Each element is of type ::Google::Cloud::Bigquery::DataTransfer::V1::DataSource.
                #     p item
                #   end
                #
                def list_data_sources request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::DataTransfer::V1::ListDataSourcesRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_data_sources.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Bigquery::DataTransfer::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_data_sources.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_data_sources.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @data_transfer_service_stub.list_data_sources request, options do |result, operation|
                    result = ::Gapic::Rest::PagedEnumerable.new @data_transfer_service_stub, :list_data_sources, "data_sources", request, result, options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Creates a new data transfer configuration.
                #
                # @overload create_transfer_config(request, options = nil)
                #   Pass arguments to `create_transfer_config` via a request object, either of type
                #   {::Google::Cloud::Bigquery::DataTransfer::V1::CreateTransferConfigRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Bigquery::DataTransfer::V1::CreateTransferConfigRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload create_transfer_config(parent: nil, transfer_config: nil, authorization_code: nil, version_info: nil, service_account_name: nil)
                #   Pass arguments to `create_transfer_config` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The BigQuery project id where the transfer configuration should
                #     be created. Must be in the format
                #     projects/\\{project_id}/locations/\\{location_id} or projects/\\{project_id}. If
                #     specified location and location of the destination bigquery dataset do not
                #     match - the request will fail.
                #   @param transfer_config [::Google::Cloud::Bigquery::DataTransfer::V1::TransferConfig, ::Hash]
                #     Required. Data transfer configuration to create.
                #   @param authorization_code [::String]
                #     Deprecated: Authorization code was required when
                #     `transferConfig.dataSourceId` is 'youtube_channel' but it is no longer used
                #     in any data sources. Use `version_info` instead.
                #
                #     Optional OAuth2 authorization code to use with this transfer configuration.
                #     This is required only if `transferConfig.dataSourceId` is 'youtube_channel'
                #     and new credentials are needed, as indicated by `CheckValidCreds`. In order
                #     to obtain authorization_code, make a request to the following URL:
                #     <pre class="prettyprint" suppresswarning="true">
                #     https://bigquery.cloud.google.com/datatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&response_type=authorization_code&client_id=<var>client_id</var>&scope=<var>data_source_scopes</var>
                #     </pre>
                #     * The <var>client_id</var> is the OAuth client_id of the data source as
                #     returned by ListDataSources method.
                #     * <var>data_source_scopes</var> are the scopes returned by ListDataSources
                #     method.
                #
                #     Note that this should not be set when `service_account_name` is used to
                #     create the transfer config.
                #   @param version_info [::String]
                #     Optional version info. This parameter replaces `authorization_code` which
                #     is no longer used in any data sources. This is required only if
                #     `transferConfig.dataSourceId` is 'youtube_channel' *or* new credentials
                #     are needed, as indicated by `CheckValidCreds`. In order to obtain version
                #     info, make a request to the following URL:
                #     <pre class="prettyprint" suppresswarning="true">
                #     https://bigquery.cloud.google.com/datatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&response_type=version_info&client_id=<var>client_id</var>&scope=<var>data_source_scopes</var>
                #     </pre>
                #     * The <var>client_id</var> is the OAuth client_id of the data source as
                #     returned by ListDataSources method.
                #     * <var>data_source_scopes</var> are the scopes returned by ListDataSources
                #     method.
                #
                #     Note that this should not be set when `service_account_name` is used to
                #     create the transfer config.
                #   @param service_account_name [::String]
                #     Optional service account email. If this field is set, the transfer config
                #     will be created with this service account's credentials. It requires that
                #     the requesting user calling this API has permissions to act as this service
                #     account.
                #
                #     Note that not all data sources support service account credentials when
                #     creating a transfer config. For the latest list of data sources, read about
                #     [using service
                #     accounts](https://cloud.google.com/bigquery-transfer/docs/use-service-accounts).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Bigquery::DataTransfer::V1::TransferConfig]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Bigquery::DataTransfer::V1::TransferConfig]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/bigquery/data_transfer/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Bigquery::DataTransfer::V1::CreateTransferConfigRequest.new
                #
                #   # Call the create_transfer_config method.
                #   result = client.create_transfer_config request
                #
                #   # The returned object is of type Google::Cloud::Bigquery::DataTransfer::V1::TransferConfig.
                #   p result
                #
                def create_transfer_config request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::DataTransfer::V1::CreateTransferConfigRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.create_transfer_config.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Bigquery::DataTransfer::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.create_transfer_config.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.create_transfer_config.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @data_transfer_service_stub.create_transfer_config request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Updates a data transfer configuration.
                # All fields must be set, even if they are not updated.
                #
                # @overload update_transfer_config(request, options = nil)
                #   Pass arguments to `update_transfer_config` via a request object, either of type
                #   {::Google::Cloud::Bigquery::DataTransfer::V1::UpdateTransferConfigRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Bigquery::DataTransfer::V1::UpdateTransferConfigRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload update_transfer_config(transfer_config: nil, authorization_code: nil, update_mask: nil, version_info: nil, service_account_name: nil)
                #   Pass arguments to `update_transfer_config` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param transfer_config [::Google::Cloud::Bigquery::DataTransfer::V1::TransferConfig, ::Hash]
                #     Required. Data transfer configuration to create.
                #   @param authorization_code [::String]
                #     Deprecated: Authorization code was required when
                #     `transferConfig.dataSourceId` is 'youtube_channel' but it is no longer used
                #     in any data sources. Use `version_info` instead.
                #
                #     Optional OAuth2 authorization code to use with this transfer configuration.
                #     This is required only if `transferConfig.dataSourceId` is 'youtube_channel'
                #     and new credentials are needed, as indicated by `CheckValidCreds`. In order
                #     to obtain authorization_code, make a request to the following URL:
                #     <pre class="prettyprint" suppresswarning="true">
                #     https://bigquery.cloud.google.com/datatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&response_type=authorization_code&client_id=<var>client_id</var>&scope=<var>data_source_scopes</var>
                #     </pre>
                #     * The <var>client_id</var> is the OAuth client_id of the data source as
                #     returned by ListDataSources method.
                #     * <var>data_source_scopes</var> are the scopes returned by ListDataSources
                #     method.
                #
                #     Note that this should not be set when `service_account_name` is used to
                #     update the transfer config.
                #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     Required. Required list of fields to be updated in this request.
                #   @param version_info [::String]
                #     Optional version info. This parameter replaces `authorization_code` which
                #     is no longer used in any data sources. This is required only if
                #     `transferConfig.dataSourceId` is 'youtube_channel' *or* new credentials
                #     are needed, as indicated by `CheckValidCreds`. In order to obtain version
                #     info, make a request to the following URL:
                #     <pre class="prettyprint" suppresswarning="true">
                #     https://bigquery.cloud.google.com/datatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&response_type=version_info&client_id=<var>client_id</var>&scope=<var>data_source_scopes</var>
                #     </pre>
                #     * The <var>client_id</var> is the OAuth client_id of the data source as
                #     returned by ListDataSources method.
                #     * <var>data_source_scopes</var> are the scopes returned by ListDataSources
                #     method.
                #
                #     Note that this should not be set when `service_account_name` is used to
                #     update the transfer config.
                #   @param service_account_name [::String]
                #     Optional service account email. If this field is set, the transfer config
                #     will be created with this service account's credentials. It requires that
                #     the requesting user calling this API has permissions to act as this service
                #     account.
                #
                #     Note that not all data sources support service account credentials when
                #     creating a transfer config. For the latest list of data sources, read about
                #     [using service
                #     accounts](https://cloud.google.com/bigquery-transfer/docs/use-service-accounts).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Bigquery::DataTransfer::V1::TransferConfig]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Bigquery::DataTransfer::V1::TransferConfig]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/bigquery/data_transfer/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Bigquery::DataTransfer::V1::UpdateTransferConfigRequest.new
                #
                #   # Call the update_transfer_config method.
                #   result = client.update_transfer_config request
                #
                #   # The returned object is of type Google::Cloud::Bigquery::DataTransfer::V1::TransferConfig.
                #   p result
                #
                def update_transfer_config request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::DataTransfer::V1::UpdateTransferConfigRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.update_transfer_config.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Bigquery::DataTransfer::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.update_transfer_config.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.update_transfer_config.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @data_transfer_service_stub.update_transfer_config request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Deletes a data transfer configuration, including any associated transfer
                # runs and logs.
                #
                # @overload delete_transfer_config(request, options = nil)
                #   Pass arguments to `delete_transfer_config` via a request object, either of type
                #   {::Google::Cloud::Bigquery::DataTransfer::V1::DeleteTransferConfigRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Bigquery::DataTransfer::V1::DeleteTransferConfigRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload delete_transfer_config(name: nil)
                #   Pass arguments to `delete_transfer_config` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The field will contain name of the resource requested, for
                #     example: `projects/{project_id}/transferConfigs/{config_id}` or
                #     `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Protobuf::Empty]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Protobuf::Empty]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/bigquery/data_transfer/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Bigquery::DataTransfer::V1::DeleteTransferConfigRequest.new
                #
                #   # Call the delete_transfer_config method.
                #   result = client.delete_transfer_config request
                #
                #   # The returned object is of type Google::Protobuf::Empty.
                #   p result
                #
                def delete_transfer_config request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::DataTransfer::V1::DeleteTransferConfigRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.delete_transfer_config.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Bigquery::DataTransfer::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.delete_transfer_config.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.delete_transfer_config.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @data_transfer_service_stub.delete_transfer_config request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Returns information about a data transfer config.
                #
                # @overload get_transfer_config(request, options = nil)
                #   Pass arguments to `get_transfer_config` via a request object, either of type
                #   {::Google::Cloud::Bigquery::DataTransfer::V1::GetTransferConfigRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Bigquery::DataTransfer::V1::GetTransferConfigRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_transfer_config(name: nil)
                #   Pass arguments to `get_transfer_config` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The field will contain name of the resource requested, for
                #     example: `projects/{project_id}/transferConfigs/{config_id}` or
                #     `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Bigquery::DataTransfer::V1::TransferConfig]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Bigquery::DataTransfer::V1::TransferConfig]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/bigquery/data_transfer/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Bigquery::DataTransfer::V1::GetTransferConfigRequest.new
                #
                #   # Call the get_transfer_config method.
                #   result = client.get_transfer_config request
                #
                #   # The returned object is of type Google::Cloud::Bigquery::DataTransfer::V1::TransferConfig.
                #   p result
                #
                def get_transfer_config request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::DataTransfer::V1::GetTransferConfigRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_transfer_config.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Bigquery::DataTransfer::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_transfer_config.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_transfer_config.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @data_transfer_service_stub.get_transfer_config request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Returns information about all transfer configs owned by a project in the
                # specified location.
                #
                # @overload list_transfer_configs(request, options = nil)
                #   Pass arguments to `list_transfer_configs` via a request object, either of type
                #   {::Google::Cloud::Bigquery::DataTransfer::V1::ListTransferConfigsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Bigquery::DataTransfer::V1::ListTransferConfigsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_transfer_configs(parent: nil, data_source_ids: nil, page_token: nil, page_size: nil)
                #   Pass arguments to `list_transfer_configs` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The BigQuery project id for which transfer configs
                #     should be returned: `projects/{project_id}` or
                #     `projects/{project_id}/locations/{location_id}`
                #   @param data_source_ids [::Array<::String>]
                #     When specified, only configurations of requested data sources are returned.
                #   @param page_token [::String]
                #     Pagination token, which can be used to request a specific page
                #     of `ListTransfersRequest` list results. For multiple-page
                #     results, `ListTransfersResponse` outputs
                #     a `next_page` token, which can be used as the
                #     `page_token` value to request the next page of list results.
                #   @param page_size [::Integer]
                #     Page size. The default page size is the maximum value of 1000 results.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Bigquery::DataTransfer::V1::TransferConfig>]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Bigquery::DataTransfer::V1::TransferConfig>]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/bigquery/data_transfer/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Bigquery::DataTransfer::V1::ListTransferConfigsRequest.new
                #
                #   # Call the list_transfer_configs method.
                #   result = client.list_transfer_configs request
                #
                #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                #   # over elements, and API calls will be issued to fetch pages as needed.
                #   result.each do |item|
                #     # Each element is of type ::Google::Cloud::Bigquery::DataTransfer::V1::TransferConfig.
                #     p item
                #   end
                #
                def list_transfer_configs request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::DataTransfer::V1::ListTransferConfigsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_transfer_configs.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Bigquery::DataTransfer::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_transfer_configs.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_transfer_configs.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @data_transfer_service_stub.list_transfer_configs request, options do |result, operation|
                    result = ::Gapic::Rest::PagedEnumerable.new @data_transfer_service_stub, :list_transfer_configs, "transfer_configs", request, result, options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Creates transfer runs for a time range [start_time, end_time].
                # For each date - or whatever granularity the data source supports - in the
                # range, one transfer run is created.
                # Note that runs are created per UTC time in the time range.
                # DEPRECATED: use StartManualTransferRuns instead.
                #
                # @overload schedule_transfer_runs(request, options = nil)
                #   Pass arguments to `schedule_transfer_runs` via a request object, either of type
                #   {::Google::Cloud::Bigquery::DataTransfer::V1::ScheduleTransferRunsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Bigquery::DataTransfer::V1::ScheduleTransferRunsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload schedule_transfer_runs(parent: nil, start_time: nil, end_time: nil)
                #   Pass arguments to `schedule_transfer_runs` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. Transfer configuration name in the form:
                #     `projects/{project_id}/transferConfigs/{config_id}` or
                #     `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`.
                #   @param start_time [::Google::Protobuf::Timestamp, ::Hash]
                #     Required. Start time of the range of transfer runs. For example,
                #     `"2017-05-25T00:00:00+00:00"`.
                #   @param end_time [::Google::Protobuf::Timestamp, ::Hash]
                #     Required. End time of the range of transfer runs. For example,
                #     `"2017-05-30T00:00:00+00:00"`.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Bigquery::DataTransfer::V1::ScheduleTransferRunsResponse]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Bigquery::DataTransfer::V1::ScheduleTransferRunsResponse]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/bigquery/data_transfer/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Bigquery::DataTransfer::V1::ScheduleTransferRunsRequest.new
                #
                #   # Call the schedule_transfer_runs method.
                #   result = client.schedule_transfer_runs request
                #
                #   # The returned object is of type Google::Cloud::Bigquery::DataTransfer::V1::ScheduleTransferRunsResponse.
                #   p result
                #
                def schedule_transfer_runs request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::DataTransfer::V1::ScheduleTransferRunsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.schedule_transfer_runs.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Bigquery::DataTransfer::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.schedule_transfer_runs.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.schedule_transfer_runs.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @data_transfer_service_stub.schedule_transfer_runs request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Start manual transfer runs to be executed now with schedule_time equal to
                # current time. The transfer runs can be created for a time range where the
                # run_time is between start_time (inclusive) and end_time (exclusive), or for
                # a specific run_time.
                #
                # @overload start_manual_transfer_runs(request, options = nil)
                #   Pass arguments to `start_manual_transfer_runs` via a request object, either of type
                #   {::Google::Cloud::Bigquery::DataTransfer::V1::StartManualTransferRunsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Bigquery::DataTransfer::V1::StartManualTransferRunsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload start_manual_transfer_runs(parent: nil, requested_time_range: nil, requested_run_time: nil)
                #   Pass arguments to `start_manual_transfer_runs` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. Transfer configuration name in the form:
                #     `projects/{project_id}/transferConfigs/{config_id}` or
                #     `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`.
                #   @param requested_time_range [::Google::Cloud::Bigquery::DataTransfer::V1::StartManualTransferRunsRequest::TimeRange, ::Hash]
                #     A time_range start and end timestamp for historical data files or reports
                #     that are scheduled to be transferred by the scheduled transfer run.
                #     requested_time_range must be a past time and cannot include future time
                #     values.
                #
                #     Note: The following parameters are mutually exclusive: `requested_time_range`, `requested_run_time`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
                #   @param requested_run_time [::Google::Protobuf::Timestamp, ::Hash]
                #     A run_time timestamp for historical data files or reports
                #     that are scheduled to be transferred by the scheduled transfer run.
                #     requested_run_time must be a past time and cannot include future time
                #     values.
                #
                #     Note: The following parameters are mutually exclusive: `requested_run_time`, `requested_time_range`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Bigquery::DataTransfer::V1::StartManualTransferRunsResponse]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Bigquery::DataTransfer::V1::StartManualTransferRunsResponse]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/bigquery/data_transfer/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Bigquery::DataTransfer::V1::StartManualTransferRunsRequest.new
                #
                #   # Call the start_manual_transfer_runs method.
                #   result = client.start_manual_transfer_runs request
                #
                #   # The returned object is of type Google::Cloud::Bigquery::DataTransfer::V1::StartManualTransferRunsResponse.
                #   p result
                #
                def start_manual_transfer_runs request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::DataTransfer::V1::StartManualTransferRunsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.start_manual_transfer_runs.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Bigquery::DataTransfer::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.start_manual_transfer_runs.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.start_manual_transfer_runs.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @data_transfer_service_stub.start_manual_transfer_runs request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Returns information about the particular transfer run.
                #
                # @overload get_transfer_run(request, options = nil)
                #   Pass arguments to `get_transfer_run` via a request object, either of type
                #   {::Google::Cloud::Bigquery::DataTransfer::V1::GetTransferRunRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Bigquery::DataTransfer::V1::GetTransferRunRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_transfer_run(name: nil)
                #   Pass arguments to `get_transfer_run` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The field will contain name of the resource requested, for
                #     example: `projects/{project_id}/transferConfigs/{config_id}/runs/{run_id}`
                #     or
                #     `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}/runs/{run_id}`
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Bigquery::DataTransfer::V1::TransferRun]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Bigquery::DataTransfer::V1::TransferRun]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/bigquery/data_transfer/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Bigquery::DataTransfer::V1::GetTransferRunRequest.new
                #
                #   # Call the get_transfer_run method.
                #   result = client.get_transfer_run request
                #
                #   # The returned object is of type Google::Cloud::Bigquery::DataTransfer::V1::TransferRun.
                #   p result
                #
                def get_transfer_run request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::DataTransfer::V1::GetTransferRunRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_transfer_run.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Bigquery::DataTransfer::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_transfer_run.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_transfer_run.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @data_transfer_service_stub.get_transfer_run request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Deletes the specified transfer run.
                #
                # @overload delete_transfer_run(request, options = nil)
                #   Pass arguments to `delete_transfer_run` via a request object, either of type
                #   {::Google::Cloud::Bigquery::DataTransfer::V1::DeleteTransferRunRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Bigquery::DataTransfer::V1::DeleteTransferRunRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload delete_transfer_run(name: nil)
                #   Pass arguments to `delete_transfer_run` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The field will contain name of the resource requested, for
                #     example: `projects/{project_id}/transferConfigs/{config_id}/runs/{run_id}`
                #     or
                #     `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}/runs/{run_id}`
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Protobuf::Empty]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Protobuf::Empty]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/bigquery/data_transfer/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Bigquery::DataTransfer::V1::DeleteTransferRunRequest.new
                #
                #   # Call the delete_transfer_run method.
                #   result = client.delete_transfer_run request
                #
                #   # The returned object is of type Google::Protobuf::Empty.
                #   p result
                #
                def delete_transfer_run request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::DataTransfer::V1::DeleteTransferRunRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.delete_transfer_run.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Bigquery::DataTransfer::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.delete_transfer_run.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.delete_transfer_run.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @data_transfer_service_stub.delete_transfer_run request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Returns information about running and completed transfer runs.
                #
                # @overload list_transfer_runs(request, options = nil)
                #   Pass arguments to `list_transfer_runs` via a request object, either of type
                #   {::Google::Cloud::Bigquery::DataTransfer::V1::ListTransferRunsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Bigquery::DataTransfer::V1::ListTransferRunsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_transfer_runs(parent: nil, states: nil, page_token: nil, page_size: nil, run_attempt: nil)
                #   Pass arguments to `list_transfer_runs` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. Name of transfer configuration for which transfer runs should be
                #     retrieved. Format of transfer configuration resource name is:
                #     `projects/{project_id}/transferConfigs/{config_id}` or
                #     `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`.
                #   @param states [::Array<::Google::Cloud::Bigquery::DataTransfer::V1::TransferState>]
                #     When specified, only transfer runs with requested states are returned.
                #   @param page_token [::String]
                #     Pagination token, which can be used to request a specific page
                #     of `ListTransferRunsRequest` list results. For multiple-page
                #     results, `ListTransferRunsResponse` outputs
                #     a `next_page` token, which can be used as the
                #     `page_token` value to request the next page of list results.
                #   @param page_size [::Integer]
                #     Page size. The default page size is the maximum value of 1000 results.
                #   @param run_attempt [::Google::Cloud::Bigquery::DataTransfer::V1::ListTransferRunsRequest::RunAttempt]
                #     Indicates how run attempts are to be pulled.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Bigquery::DataTransfer::V1::TransferRun>]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Bigquery::DataTransfer::V1::TransferRun>]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/bigquery/data_transfer/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Bigquery::DataTransfer::V1::ListTransferRunsRequest.new
                #
                #   # Call the list_transfer_runs method.
                #   result = client.list_transfer_runs request
                #
                #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                #   # over elements, and API calls will be issued to fetch pages as needed.
                #   result.each do |item|
                #     # Each element is of type ::Google::Cloud::Bigquery::DataTransfer::V1::TransferRun.
                #     p item
                #   end
                #
                def list_transfer_runs request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::DataTransfer::V1::ListTransferRunsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_transfer_runs.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Bigquery::DataTransfer::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_transfer_runs.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_transfer_runs.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @data_transfer_service_stub.list_transfer_runs request, options do |result, operation|
                    result = ::Gapic::Rest::PagedEnumerable.new @data_transfer_service_stub, :list_transfer_runs, "transfer_runs", request, result, options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Returns log messages for the transfer run.
                #
                # @overload list_transfer_logs(request, options = nil)
                #   Pass arguments to `list_transfer_logs` via a request object, either of type
                #   {::Google::Cloud::Bigquery::DataTransfer::V1::ListTransferLogsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Bigquery::DataTransfer::V1::ListTransferLogsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_transfer_logs(parent: nil, page_token: nil, page_size: nil, message_types: nil)
                #   Pass arguments to `list_transfer_logs` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. Transfer run name in the form:
                #     `projects/{project_id}/transferConfigs/{config_id}/runs/{run_id}` or
                #     `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}/runs/{run_id}`
                #   @param page_token [::String]
                #     Pagination token, which can be used to request a specific page
                #     of `ListTransferLogsRequest` list results. For multiple-page
                #     results, `ListTransferLogsResponse` outputs
                #     a `next_page` token, which can be used as the
                #     `page_token` value to request the next page of list results.
                #   @param page_size [::Integer]
                #     Page size. The default page size is the maximum value of 1000 results.
                #   @param message_types [::Array<::Google::Cloud::Bigquery::DataTransfer::V1::TransferMessage::MessageSeverity>]
                #     Message types to return. If not populated - INFO, WARNING and ERROR
                #     messages are returned.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Bigquery::DataTransfer::V1::TransferMessage>]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Bigquery::DataTransfer::V1::TransferMessage>]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/bigquery/data_transfer/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Bigquery::DataTransfer::V1::ListTransferLogsRequest.new
                #
                #   # Call the list_transfer_logs method.
                #   result = client.list_transfer_logs request
                #
                #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                #   # over elements, and API calls will be issued to fetch pages as needed.
                #   result.each do |item|
                #     # Each element is of type ::Google::Cloud::Bigquery::DataTransfer::V1::TransferMessage.
                #     p item
                #   end
                #
                def list_transfer_logs request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::DataTransfer::V1::ListTransferLogsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_transfer_logs.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Bigquery::DataTransfer::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_transfer_logs.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_transfer_logs.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @data_transfer_service_stub.list_transfer_logs request, options do |result, operation|
                    result = ::Gapic::Rest::PagedEnumerable.new @data_transfer_service_stub, :list_transfer_logs, "transfer_messages", request, result, options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Returns true if valid credentials exist for the given data source and
                # requesting user.
                #
                # @overload check_valid_creds(request, options = nil)
                #   Pass arguments to `check_valid_creds` via a request object, either of type
                #   {::Google::Cloud::Bigquery::DataTransfer::V1::CheckValidCredsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Bigquery::DataTransfer::V1::CheckValidCredsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload check_valid_creds(name: nil)
                #   Pass arguments to `check_valid_creds` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The data source in the form:
                #     `projects/{project_id}/dataSources/{data_source_id}` or
                #     `projects/{project_id}/locations/{location_id}/dataSources/{data_source_id}`.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Bigquery::DataTransfer::V1::CheckValidCredsResponse]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Bigquery::DataTransfer::V1::CheckValidCredsResponse]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/bigquery/data_transfer/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Bigquery::DataTransfer::V1::CheckValidCredsRequest.new
                #
                #   # Call the check_valid_creds method.
                #   result = client.check_valid_creds request
                #
                #   # The returned object is of type Google::Cloud::Bigquery::DataTransfer::V1::CheckValidCredsResponse.
                #   p result
                #
                def check_valid_creds request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::DataTransfer::V1::CheckValidCredsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.check_valid_creds.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Bigquery::DataTransfer::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.check_valid_creds.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.check_valid_creds.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @data_transfer_service_stub.check_valid_creds request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Enroll data sources in a user project. This allows users to create transfer
                # configurations for these data sources. They will also appear in the
                # ListDataSources RPC and as such, will appear in the
                # [BigQuery UI](https://console.cloud.google.com/bigquery), and the documents
                # can be found in the public guide for
                # [BigQuery Web UI](https://cloud.google.com/bigquery/bigquery-web-ui) and
                # [Data Transfer
                # Service](https://cloud.google.com/bigquery/docs/working-with-transfers).
                #
                # @overload enroll_data_sources(request, options = nil)
                #   Pass arguments to `enroll_data_sources` via a request object, either of type
                #   {::Google::Cloud::Bigquery::DataTransfer::V1::EnrollDataSourcesRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Bigquery::DataTransfer::V1::EnrollDataSourcesRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload enroll_data_sources(name: nil, data_source_ids: nil)
                #   Pass arguments to `enroll_data_sources` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The name of the project resource in the form:
                #     `projects/{project_id}`
                #   @param data_source_ids [::Array<::String>]
                #     Data sources that are enrolled. It is required to provide at least one
                #     data source id.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Protobuf::Empty]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Protobuf::Empty]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/bigquery/data_transfer/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Bigquery::DataTransfer::V1::EnrollDataSourcesRequest.new
                #
                #   # Call the enroll_data_sources method.
                #   result = client.enroll_data_sources request
                #
                #   # The returned object is of type Google::Protobuf::Empty.
                #   p result
                #
                def enroll_data_sources request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::DataTransfer::V1::EnrollDataSourcesRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.enroll_data_sources.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Bigquery::DataTransfer::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.enroll_data_sources.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.enroll_data_sources.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @data_transfer_service_stub.enroll_data_sources request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Unenroll data sources in a user project. This allows users to remove
                # transfer configurations for these data sources. They will no longer appear
                # in the ListDataSources RPC and will also no longer appear in the [BigQuery
                # UI](https://console.cloud.google.com/bigquery). Data transfers
                # configurations of unenrolled data sources will not be scheduled.
                #
                # @overload unenroll_data_sources(request, options = nil)
                #   Pass arguments to `unenroll_data_sources` via a request object, either of type
                #   {::Google::Cloud::Bigquery::DataTransfer::V1::UnenrollDataSourcesRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Bigquery::DataTransfer::V1::UnenrollDataSourcesRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload unenroll_data_sources(name: nil, data_source_ids: nil)
                #   Pass arguments to `unenroll_data_sources` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The name of the project resource in the form:
                #     `projects/{project_id}`
                #   @param data_source_ids [::Array<::String>]
                #     Data sources that are unenrolled. It is required to provide at least one
                #     data source id.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Protobuf::Empty]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Protobuf::Empty]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/bigquery/data_transfer/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Bigquery::DataTransfer::V1::UnenrollDataSourcesRequest.new
                #
                #   # Call the unenroll_data_sources method.
                #   result = client.unenroll_data_sources request
                #
                #   # The returned object is of type Google::Protobuf::Empty.
                #   p result
                #
                def unenroll_data_sources request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::DataTransfer::V1::UnenrollDataSourcesRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.unenroll_data_sources.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Bigquery::DataTransfer::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.unenroll_data_sources.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.unenroll_data_sources.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @data_transfer_service_stub.unenroll_data_sources request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Configuration class for the DataTransferService REST API.
                #
                # This class represents the configuration for DataTransferService REST,
                # providing control over timeouts, retry behavior, logging, transport
                # parameters, and other low-level controls. Certain parameters can also be
                # applied individually to specific RPCs. See
                # {::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client::Configuration::Rpcs}
                # for a list of RPCs that can be configured independently.
                #
                # Configuration can be applied globally to all clients, or to a single client
                # on construction.
                #
                # @example
                #
                #   # Modify the global config, setting the timeout for
                #   # get_data_source to 20 seconds,
                #   # and all remaining timeouts to 10 seconds.
                #   ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.configure do |config|
                #     config.timeout = 10.0
                #     config.rpcs.get_data_source.timeout = 20.0
                #   end
                #
                #   # Apply the above configuration only to a new client.
                #   client = ::Google::Cloud::Bigquery::DataTransfer::V1::DataTransferService::Rest::Client.new do |config|
                #     config.timeout = 10.0
                #     config.rpcs.get_data_source.timeout = 20.0
                #   end
                #
                # @!attribute [rw] endpoint
                #   A custom service endpoint, as a hostname or hostname:port. The default is
                #   nil, indicating to use the default endpoint in the current universe domain.
                #   @return [::String,nil]
                # @!attribute [rw] credentials
                #   Credentials to send with calls. You may provide any of the following types:
                #    *  (`String`) The path to a service account key file in JSON format
                #    *  (`Hash`) A service account key as a Hash
                #    *  (`Google::Auth::Credentials`) A googleauth credentials object
                #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
                #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
                #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
                #    *  (`nil`) indicating no credentials
                #
                #   Warning: If you accept a credential configuration (JSON file or Hash) from an
                #   external source for authentication to Google Cloud, you must validate it before
                #   providing it to a Google API client library. Providing an unvalidated credential
                #   configuration to Google APIs can compromise the security of your systems and data.
                #   For more information, refer to [Validate credential configurations from external
                #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
                #   @return [::Object]
                # @!attribute [rw] scope
                #   The OAuth scopes
                #   @return [::Array<::String>]
                # @!attribute [rw] lib_name
                #   The library name as recorded in instrumentation and logging
                #   @return [::String]
                # @!attribute [rw] lib_version
                #   The library version as recorded in instrumentation and logging
                #   @return [::String]
                # @!attribute [rw] timeout
                #   The call timeout in seconds.
                #   @return [::Numeric]
                # @!attribute [rw] metadata
                #   Additional headers to be sent with the call.
                #   @return [::Hash{::Symbol=>::String}]
                # @!attribute [rw] retry_policy
                #   The retry policy. The value is a hash with the following keys:
                #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #       trigger a retry.
                #   @return [::Hash]
                # @!attribute [rw] quota_project
                #   A separate project against which to charge quota.
                #   @return [::String]
                # @!attribute [rw] universe_domain
                #   The universe domain within which to make requests. This determines the
                #   default endpoint URL. The default value of nil uses the environment
                #   universe (usually the default "googleapis.com" universe).
                #   @return [::String,nil]
                # @!attribute [rw] logger
                #   A custom logger to use for request/response debug logging, or the value
                #   `:default` (the default) to construct a default logger, or `nil` to
                #   explicitly disable logging.
                #   @return [::Logger,:default,nil]
                #
                class Configuration
                  extend ::Gapic::Config

                  # @private
                  # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                  DEFAULT_ENDPOINT = "bigquerydatatransfer.googleapis.com"

                  config_attr :endpoint,      nil, ::String, nil
                  config_attr :credentials,   nil do |value|
                    allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                    allowed.any? { |klass| klass === value }
                  end
                  config_attr :scope,         nil, ::String, ::Array, nil
                  config_attr :lib_name,      nil, ::String, nil
                  config_attr :lib_version,   nil, ::String, nil
                  config_attr :timeout,       nil, ::Numeric, nil
                  config_attr :metadata,      nil, ::Hash, nil
                  config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                  config_attr :quota_project, nil, ::String, nil
                  config_attr :universe_domain, nil, ::String, nil

                  # @private
                  # Overrides for http bindings for the RPCs of this service
                  # are only used when this service is used as mixin, and only
                  # by the host service.
                  # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                  config_attr :bindings_override, {}, ::Hash, nil
                  config_attr :logger, :default, ::Logger, nil, :default

                  # @private
                  def initialize parent_config = nil
                    @parent_config = parent_config unless parent_config.nil?

                    yield self if block_given?
                  end

                  ##
                  # Configurations for individual RPCs
                  # @return [Rpcs]
                  #
                  def rpcs
                    @rpcs ||= begin
                      parent_rpcs = nil
                      parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                      Rpcs.new parent_rpcs
                    end
                  end

                  ##
                  # Configuration RPC class for the DataTransferService API.
                  #
                  # Includes fields providing the configuration for each RPC in this service.
                  # Each configuration object is of type `Gapic::Config::Method` and includes
                  # the following configuration fields:
                  #
                  #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                  #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                  #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                  #     include the following keys:
                  #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                  #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                  #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                  #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                  #         trigger a retry.
                  #
                  class Rpcs
                    ##
                    # RPC-specific configuration for `get_data_source`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_data_source
                    ##
                    # RPC-specific configuration for `list_data_sources`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_data_sources
                    ##
                    # RPC-specific configuration for `create_transfer_config`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :create_transfer_config
                    ##
                    # RPC-specific configuration for `update_transfer_config`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :update_transfer_config
                    ##
                    # RPC-specific configuration for `delete_transfer_config`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :delete_transfer_config
                    ##
                    # RPC-specific configuration for `get_transfer_config`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_transfer_config
                    ##
                    # RPC-specific configuration for `list_transfer_configs`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_transfer_configs
                    ##
                    # RPC-specific configuration for `schedule_transfer_runs`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :schedule_transfer_runs
                    ##
                    # RPC-specific configuration for `start_manual_transfer_runs`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :start_manual_transfer_runs
                    ##
                    # RPC-specific configuration for `get_transfer_run`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_transfer_run
                    ##
                    # RPC-specific configuration for `delete_transfer_run`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :delete_transfer_run
                    ##
                    # RPC-specific configuration for `list_transfer_runs`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_transfer_runs
                    ##
                    # RPC-specific configuration for `list_transfer_logs`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_transfer_logs
                    ##
                    # RPC-specific configuration for `check_valid_creds`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :check_valid_creds
                    ##
                    # RPC-specific configuration for `enroll_data_sources`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :enroll_data_sources
                    ##
                    # RPC-specific configuration for `unenroll_data_sources`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :unenroll_data_sources

                    # @private
                    def initialize parent_rpcs = nil
                      get_data_source_config = parent_rpcs.get_data_source if parent_rpcs.respond_to? :get_data_source
                      @get_data_source = ::Gapic::Config::Method.new get_data_source_config
                      list_data_sources_config = parent_rpcs.list_data_sources if parent_rpcs.respond_to? :list_data_sources
                      @list_data_sources = ::Gapic::Config::Method.new list_data_sources_config
                      create_transfer_config_config = parent_rpcs.create_transfer_config if parent_rpcs.respond_to? :create_transfer_config
                      @create_transfer_config = ::Gapic::Config::Method.new create_transfer_config_config
                      update_transfer_config_config = parent_rpcs.update_transfer_config if parent_rpcs.respond_to? :update_transfer_config
                      @update_transfer_config = ::Gapic::Config::Method.new update_transfer_config_config
                      delete_transfer_config_config = parent_rpcs.delete_transfer_config if parent_rpcs.respond_to? :delete_transfer_config
                      @delete_transfer_config = ::Gapic::Config::Method.new delete_transfer_config_config
                      get_transfer_config_config = parent_rpcs.get_transfer_config if parent_rpcs.respond_to? :get_transfer_config
                      @get_transfer_config = ::Gapic::Config::Method.new get_transfer_config_config
                      list_transfer_configs_config = parent_rpcs.list_transfer_configs if parent_rpcs.respond_to? :list_transfer_configs
                      @list_transfer_configs = ::Gapic::Config::Method.new list_transfer_configs_config
                      schedule_transfer_runs_config = parent_rpcs.schedule_transfer_runs if parent_rpcs.respond_to? :schedule_transfer_runs
                      @schedule_transfer_runs = ::Gapic::Config::Method.new schedule_transfer_runs_config
                      start_manual_transfer_runs_config = parent_rpcs.start_manual_transfer_runs if parent_rpcs.respond_to? :start_manual_transfer_runs
                      @start_manual_transfer_runs = ::Gapic::Config::Method.new start_manual_transfer_runs_config
                      get_transfer_run_config = parent_rpcs.get_transfer_run if parent_rpcs.respond_to? :get_transfer_run
                      @get_transfer_run = ::Gapic::Config::Method.new get_transfer_run_config
                      delete_transfer_run_config = parent_rpcs.delete_transfer_run if parent_rpcs.respond_to? :delete_transfer_run
                      @delete_transfer_run = ::Gapic::Config::Method.new delete_transfer_run_config
                      list_transfer_runs_config = parent_rpcs.list_transfer_runs if parent_rpcs.respond_to? :list_transfer_runs
                      @list_transfer_runs = ::Gapic::Config::Method.new list_transfer_runs_config
                      list_transfer_logs_config = parent_rpcs.list_transfer_logs if parent_rpcs.respond_to? :list_transfer_logs
                      @list_transfer_logs = ::Gapic::Config::Method.new list_transfer_logs_config
                      check_valid_creds_config = parent_rpcs.check_valid_creds if parent_rpcs.respond_to? :check_valid_creds
                      @check_valid_creds = ::Gapic::Config::Method.new check_valid_creds_config
                      enroll_data_sources_config = parent_rpcs.enroll_data_sources if parent_rpcs.respond_to? :enroll_data_sources
                      @enroll_data_sources = ::Gapic::Config::Method.new enroll_data_sources_config
                      unenroll_data_sources_config = parent_rpcs.unenroll_data_sources if parent_rpcs.respond_to? :unenroll_data_sources
                      @unenroll_data_sources = ::Gapic::Config::Method.new unenroll_data_sources_config

                      yield self if block_given?
                    end
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
