# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Bigquery
      module DataTransfer
        module V1
          module DataTransferService
            # Path helper methods for the DataTransferService API.
            module Paths
              ##
              # Create a fully-qualified DataSource resource string.
              #
              # @overload data_source_path(project:, data_source:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/dataSources/{data_source}`
              #
              #   @param project [String]
              #   @param data_source [String]
              #
              # @overload data_source_path(project:, location:, data_source:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/locations/{location}/dataSources/{data_source}`
              #
              #   @param project [String]
              #   @param location [String]
              #   @param data_source [String]
              #
              # @return [::String]
              def data_source_path **args
                resources = {
                  "data_source:project" => (proc do |project:, data_source:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                    "projects/#{project}/dataSources/#{data_source}"
                  end),
                  "data_source:location:project" => (proc do |project:, location:, data_source:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                    raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                    "projects/#{project}/locations/#{location}/dataSources/#{data_source}"
                  end)
                }

                resource = resources[args.keys.sort.join(":")]
                raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
                resource.call(**args)
              end

              ##
              # Create a fully-qualified Location resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}`
              #
              # @param project [String]
              # @param location [String]
              #
              # @return [::String]
              def location_path project:, location:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                "projects/#{project}/locations/#{location}"
              end

              ##
              # Create a fully-qualified Project resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}`
              #
              # @param project [String]
              #
              # @return [::String]
              def project_path project:
                "projects/#{project}"
              end

              ##
              # Create a fully-qualified Run resource string.
              #
              # @overload run_path(project:, transfer_config:, run:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/transferConfigs/{transfer_config}/runs/{run}`
              #
              #   @param project [String]
              #   @param transfer_config [String]
              #   @param run [String]
              #
              # @overload run_path(project:, location:, transfer_config:, run:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/locations/{location}/transferConfigs/{transfer_config}/runs/{run}`
              #
              #   @param project [String]
              #   @param location [String]
              #   @param transfer_config [String]
              #   @param run [String]
              #
              # @return [::String]
              def run_path **args
                resources = {
                  "project:run:transfer_config" => (proc do |project:, transfer_config:, run:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                    raise ::ArgumentError, "transfer_config cannot contain /" if transfer_config.to_s.include? "/"

                    "projects/#{project}/transferConfigs/#{transfer_config}/runs/#{run}"
                  end),
                  "location:project:run:transfer_config" => (proc do |project:, location:, transfer_config:, run:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                    raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                    raise ::ArgumentError, "transfer_config cannot contain /" if transfer_config.to_s.include? "/"

                    "projects/#{project}/locations/#{location}/transferConfigs/#{transfer_config}/runs/#{run}"
                  end)
                }

                resource = resources[args.keys.sort.join(":")]
                raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
                resource.call(**args)
              end

              ##
              # Create a fully-qualified TransferConfig resource string.
              #
              # @overload transfer_config_path(project:, transfer_config:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/transferConfigs/{transfer_config}`
              #
              #   @param project [String]
              #   @param transfer_config [String]
              #
              # @overload transfer_config_path(project:, location:, transfer_config:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/locations/{location}/transferConfigs/{transfer_config}`
              #
              #   @param project [String]
              #   @param location [String]
              #   @param transfer_config [String]
              #
              # @return [::String]
              def transfer_config_path **args
                resources = {
                  "project:transfer_config" => (proc do |project:, transfer_config:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                    "projects/#{project}/transferConfigs/#{transfer_config}"
                  end),
                  "location:project:transfer_config" => (proc do |project:, location:, transfer_config:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                    raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                    "projects/#{project}/locations/#{location}/transferConfigs/#{transfer_config}"
                  end)
                }

                resource = resources[args.keys.sort.join(":")]
                raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
                resource.call(**args)
              end

              extend self
            end
          end
        end
      end
    end
  end
end
