# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/bigquery/dataexchange/v1beta1/dataexchange_pb"
require "google/cloud/bigquery/data_exchange/v1beta1/analytics_hub_service"

class ::Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_data_exchanges
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::DataExchange::V1beta1::ListDataExchangesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_data_exchanges_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_data_exchanges, name
      assert_kind_of ::Google::Cloud::Bigquery::DataExchange::V1beta1::ListDataExchangesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_data_exchanges_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_data_exchanges({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_data_exchanges parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_data_exchanges ::Google::Cloud::Bigquery::DataExchange::V1beta1::ListDataExchangesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_data_exchanges({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_data_exchanges(::Google::Cloud::Bigquery::DataExchange::V1beta1::ListDataExchangesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_data_exchanges_client_stub.call_rpc_count
    end
  end

  def test_list_org_data_exchanges
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::DataExchange::V1beta1::ListOrgDataExchangesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    organization = "hello world"
    page_size = 42
    page_token = "hello world"

    list_org_data_exchanges_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_org_data_exchanges, name
      assert_kind_of ::Google::Cloud::Bigquery::DataExchange::V1beta1::ListOrgDataExchangesRequest, request
      assert_equal "hello world", request["organization"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_org_data_exchanges_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_org_data_exchanges({ organization: organization, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_org_data_exchanges organization: organization, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_org_data_exchanges ::Google::Cloud::Bigquery::DataExchange::V1beta1::ListOrgDataExchangesRequest.new(organization: organization, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_org_data_exchanges({ organization: organization, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_org_data_exchanges(::Google::Cloud::Bigquery::DataExchange::V1beta1::ListOrgDataExchangesRequest.new(organization: organization, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_org_data_exchanges_client_stub.call_rpc_count
    end
  end

  def test_get_data_exchange
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::DataExchange::V1beta1::DataExchange.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_data_exchange_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_data_exchange, name
      assert_kind_of ::Google::Cloud::Bigquery::DataExchange::V1beta1::GetDataExchangeRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_data_exchange_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_data_exchange({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_data_exchange name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_data_exchange ::Google::Cloud::Bigquery::DataExchange::V1beta1::GetDataExchangeRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_data_exchange({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_data_exchange(::Google::Cloud::Bigquery::DataExchange::V1beta1::GetDataExchangeRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_data_exchange_client_stub.call_rpc_count
    end
  end

  def test_create_data_exchange
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::DataExchange::V1beta1::DataExchange.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    data_exchange_id = "hello world"
    data_exchange = {}

    create_data_exchange_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_data_exchange, name
      assert_kind_of ::Google::Cloud::Bigquery::DataExchange::V1beta1::CreateDataExchangeRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["data_exchange_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Bigquery::DataExchange::V1beta1::DataExchange), request["data_exchange"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_data_exchange_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_data_exchange({ parent: parent, data_exchange_id: data_exchange_id, data_exchange: data_exchange }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_data_exchange parent: parent, data_exchange_id: data_exchange_id, data_exchange: data_exchange do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_data_exchange ::Google::Cloud::Bigquery::DataExchange::V1beta1::CreateDataExchangeRequest.new(parent: parent, data_exchange_id: data_exchange_id, data_exchange: data_exchange) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_data_exchange({ parent: parent, data_exchange_id: data_exchange_id, data_exchange: data_exchange }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_data_exchange(::Google::Cloud::Bigquery::DataExchange::V1beta1::CreateDataExchangeRequest.new(parent: parent, data_exchange_id: data_exchange_id, data_exchange: data_exchange), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_data_exchange_client_stub.call_rpc_count
    end
  end

  def test_update_data_exchange
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::DataExchange::V1beta1::DataExchange.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    data_exchange = {}

    update_data_exchange_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_data_exchange, name
      assert_kind_of ::Google::Cloud::Bigquery::DataExchange::V1beta1::UpdateDataExchangeRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Bigquery::DataExchange::V1beta1::DataExchange), request["data_exchange"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_data_exchange_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_data_exchange({ update_mask: update_mask, data_exchange: data_exchange }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_data_exchange update_mask: update_mask, data_exchange: data_exchange do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_data_exchange ::Google::Cloud::Bigquery::DataExchange::V1beta1::UpdateDataExchangeRequest.new(update_mask: update_mask, data_exchange: data_exchange) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_data_exchange({ update_mask: update_mask, data_exchange: data_exchange }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_data_exchange(::Google::Cloud::Bigquery::DataExchange::V1beta1::UpdateDataExchangeRequest.new(update_mask: update_mask, data_exchange: data_exchange), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_data_exchange_client_stub.call_rpc_count
    end
  end

  def test_delete_data_exchange
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_data_exchange_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_data_exchange, name
      assert_kind_of ::Google::Cloud::Bigquery::DataExchange::V1beta1::DeleteDataExchangeRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_data_exchange_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_data_exchange({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_data_exchange name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_data_exchange ::Google::Cloud::Bigquery::DataExchange::V1beta1::DeleteDataExchangeRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_data_exchange({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_data_exchange(::Google::Cloud::Bigquery::DataExchange::V1beta1::DeleteDataExchangeRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_data_exchange_client_stub.call_rpc_count
    end
  end

  def test_list_listings
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::DataExchange::V1beta1::ListListingsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_listings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_listings, name
      assert_kind_of ::Google::Cloud::Bigquery::DataExchange::V1beta1::ListListingsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_listings_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_listings({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_listings parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_listings ::Google::Cloud::Bigquery::DataExchange::V1beta1::ListListingsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_listings({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_listings(::Google::Cloud::Bigquery::DataExchange::V1beta1::ListListingsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_listings_client_stub.call_rpc_count
    end
  end

  def test_get_listing
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::DataExchange::V1beta1::Listing.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_listing_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_listing, name
      assert_kind_of ::Google::Cloud::Bigquery::DataExchange::V1beta1::GetListingRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_listing_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_listing({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_listing name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_listing ::Google::Cloud::Bigquery::DataExchange::V1beta1::GetListingRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_listing({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_listing(::Google::Cloud::Bigquery::DataExchange::V1beta1::GetListingRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_listing_client_stub.call_rpc_count
    end
  end

  def test_create_listing
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::DataExchange::V1beta1::Listing.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    listing_id = "hello world"
    listing = {}

    create_listing_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_listing, name
      assert_kind_of ::Google::Cloud::Bigquery::DataExchange::V1beta1::CreateListingRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["listing_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Bigquery::DataExchange::V1beta1::Listing), request["listing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_listing_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_listing({ parent: parent, listing_id: listing_id, listing: listing }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_listing parent: parent, listing_id: listing_id, listing: listing do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_listing ::Google::Cloud::Bigquery::DataExchange::V1beta1::CreateListingRequest.new(parent: parent, listing_id: listing_id, listing: listing) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_listing({ parent: parent, listing_id: listing_id, listing: listing }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_listing(::Google::Cloud::Bigquery::DataExchange::V1beta1::CreateListingRequest.new(parent: parent, listing_id: listing_id, listing: listing), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_listing_client_stub.call_rpc_count
    end
  end

  def test_update_listing
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::DataExchange::V1beta1::Listing.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    listing = {}

    update_listing_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_listing, name
      assert_kind_of ::Google::Cloud::Bigquery::DataExchange::V1beta1::UpdateListingRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Bigquery::DataExchange::V1beta1::Listing), request["listing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_listing_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_listing({ update_mask: update_mask, listing: listing }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_listing update_mask: update_mask, listing: listing do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_listing ::Google::Cloud::Bigquery::DataExchange::V1beta1::UpdateListingRequest.new(update_mask: update_mask, listing: listing) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_listing({ update_mask: update_mask, listing: listing }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_listing(::Google::Cloud::Bigquery::DataExchange::V1beta1::UpdateListingRequest.new(update_mask: update_mask, listing: listing), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_listing_client_stub.call_rpc_count
    end
  end

  def test_delete_listing
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_listing_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_listing, name
      assert_kind_of ::Google::Cloud::Bigquery::DataExchange::V1beta1::DeleteListingRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_listing_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_listing({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_listing name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_listing ::Google::Cloud::Bigquery::DataExchange::V1beta1::DeleteListingRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_listing({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_listing(::Google::Cloud::Bigquery::DataExchange::V1beta1::DeleteListingRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_listing_client_stub.call_rpc_count
    end
  end

  def test_subscribe_listing
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::DataExchange::V1beta1::SubscribeListingResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    destination_dataset = {}
    name = "hello world"

    subscribe_listing_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :subscribe_listing, name
      assert_kind_of ::Google::Cloud::Bigquery::DataExchange::V1beta1::SubscribeListingRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Bigquery::DataExchange::V1beta1::DestinationDataset), request["destination_dataset"]
      assert_equal :destination_dataset, request.destination
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, subscribe_listing_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.subscribe_listing({ destination_dataset: destination_dataset, name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.subscribe_listing destination_dataset: destination_dataset, name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.subscribe_listing ::Google::Cloud::Bigquery::DataExchange::V1beta1::SubscribeListingRequest.new(destination_dataset: destination_dataset, name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.subscribe_listing({ destination_dataset: destination_dataset, name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.subscribe_listing(::Google::Cloud::Bigquery::DataExchange::V1beta1::SubscribeListingRequest.new(destination_dataset: destination_dataset, name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, subscribe_listing_client_stub.call_rpc_count
    end
  end

  def test_get_iam_policy
    # Create GRPC objects.
    grpc_response = ::Google::Iam::V1::Policy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    options = {}

    get_iam_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_iam_policy, name
      assert_kind_of ::Google::Iam::V1::GetIamPolicyRequest, request
      assert_equal "hello world", request["resource"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Iam::V1::GetPolicyOptions), request["options"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_iam_policy_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_iam_policy({ resource: resource, options: options }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_iam_policy resource: resource, options: options do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_iam_policy ::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_iam_policy({ resource: resource, options: options }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_iam_policy(::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_iam_policy_client_stub.call_rpc_count
    end
  end

  def test_set_iam_policy
    # Create GRPC objects.
    grpc_response = ::Google::Iam::V1::Policy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    policy = {}
    update_mask = {}

    set_iam_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :set_iam_policy, name
      assert_kind_of ::Google::Iam::V1::SetIamPolicyRequest, request
      assert_equal "hello world", request["resource"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Iam::V1::Policy), request["policy"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, set_iam_policy_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.set_iam_policy resource: resource, policy: policy, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.set_iam_policy ::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.set_iam_policy(::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, set_iam_policy_client_stub.call_rpc_count
    end
  end

  def test_test_iam_permissions
    # Create GRPC objects.
    grpc_response = ::Google::Iam::V1::TestIamPermissionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    permissions = ["hello world"]

    test_iam_permissions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :test_iam_permissions, name
      assert_kind_of ::Google::Iam::V1::TestIamPermissionsRequest, request
      assert_equal "hello world", request["resource"]
      assert_equal ["hello world"], request["permissions"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, test_iam_permissions_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.test_iam_permissions({ resource: resource, permissions: permissions }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.test_iam_permissions resource: resource, permissions: permissions do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.test_iam_permissions ::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.test_iam_permissions({ resource: resource, permissions: permissions }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.test_iam_permissions(::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, test_iam_permissions_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
