# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Bigquery
      module DataExchange
        module V1beta1
          # A data exchange is a container that lets you share data. Along with the
          # descriptive information about the data exchange, it contains listings that
          # reference shared datasets.
          # @!attribute [r] name
          #   @return [::String]
          #     Output only. The resource name of the data exchange.
          #     e.g. `projects/myproject/locations/US/dataExchanges/123`.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     Required. Human-readable display name of the data exchange. The display name must
          #     contain only Unicode letters, numbers (0-9), underscores (_), dashes (-),
          #     spaces ( ), ampersands (&) and must not start or end with spaces.
          #     Default value is an empty string.
          #     Max length: 63 bytes.
          # @!attribute [rw] description
          #   @return [::String]
          #     Optional. Description of the data exchange. The description must not contain Unicode
          #     non-characters as well as C0 and C1 control codes except tabs (HT),
          #     new lines (LF), carriage returns (CR), and page breaks (FF).
          #     Default value is an empty string.
          #     Max length: 2000 bytes.
          # @!attribute [rw] primary_contact
          #   @return [::String]
          #     Optional. Email or URL of the primary point of contact of the data exchange.
          #     Max Length: 1000 bytes.
          # @!attribute [rw] documentation
          #   @return [::String]
          #     Optional. Documentation describing the data exchange.
          # @!attribute [r] listing_count
          #   @return [::Integer]
          #     Output only. Number of listings contained in the data exchange.
          # @!attribute [rw] icon
          #   @return [::String]
          #     Optional. Base64 encoded image representing the data exchange. Max Size: 3.0MiB
          #     Expected image dimensions are 512x512 pixels, however the API only
          #     performs validation on size of the encoded data.
          #     Note: For byte fields, the content of the fields are base64-encoded (which
          #     increases the size of the data by 33-36%) when using JSON on the wire.
          class DataExchange
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Contains details of the data provider.
          # @!attribute [rw] name
          #   @return [::String]
          #     Optional. Name of the data provider.
          # @!attribute [rw] primary_contact
          #   @return [::String]
          #     Optional. Email or URL of the data provider.
          #     Max Length: 1000 bytes.
          class DataProvider
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Contains details of the listing publisher.
          # @!attribute [rw] name
          #   @return [::String]
          #     Optional. Name of the listing publisher.
          # @!attribute [rw] primary_contact
          #   @return [::String]
          #     Optional. Email or URL of the listing publisher.
          #     Max Length: 1000 bytes.
          class Publisher
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Contains the reference that identifies a destination bigquery dataset.
          # @!attribute [rw] dataset_id
          #   @return [::String]
          #     Required. A unique ID for this dataset, without the project name. The ID
          #     must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_).
          #     The maximum length is 1,024 characters.
          # @!attribute [rw] project_id
          #   @return [::String]
          #     Required. The ID of the project containing this dataset.
          class DestinationDatasetReference
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Defines the destination bigquery dataset.
          # @!attribute [rw] dataset_reference
          #   @return [::Google::Cloud::Bigquery::DataExchange::V1beta1::DestinationDatasetReference]
          #     Required. A reference that identifies the destination dataset.
          # @!attribute [rw] friendly_name
          #   @return [::Google::Protobuf::StringValue]
          #     Optional. A descriptive name for the dataset.
          # @!attribute [rw] description
          #   @return [::Google::Protobuf::StringValue]
          #     Optional. A user-friendly description of the dataset.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. The labels associated with this dataset. You can use these
          #     to organize and group your datasets.
          #     You can set this property when inserting or updating a dataset.
          #     See https://cloud.google.com/resource-manager/docs/creating-managing-labels
          #     for more information.
          # @!attribute [rw] location
          #   @return [::String]
          #     Required. The geographic location where the dataset should reside. See
          #     https://cloud.google.com/bigquery/docs/locations for supported
          #     locations.
          class DestinationDataset
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # A listing is what gets published into a data exchange that a subscriber can
          # subscribe to. It contains a reference to the data source along with
          # descriptive information that will help subscribers find and subscribe the
          # data.
          # @!attribute [rw] bigquery_dataset
          #   @return [::Google::Cloud::Bigquery::DataExchange::V1beta1::Listing::BigQueryDatasetSource]
          #     Required. Shared dataset i.e. BigQuery dataset source.
          # @!attribute [r] name
          #   @return [::String]
          #     Output only. The resource name of the listing.
          #     e.g. `projects/myproject/locations/US/dataExchanges/123/listings/456`
          # @!attribute [rw] display_name
          #   @return [::String]
          #     Required. Human-readable display name of the listing. The display name must contain
          #     only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces
          #     ( ), ampersands (&) and can't start or end with spaces.
          #     Default value is an empty string.
          #     Max length: 63 bytes.
          # @!attribute [rw] description
          #   @return [::String]
          #     Optional. Short description of the listing. The description must not contain
          #     Unicode non-characters and C0 and C1 control codes except tabs (HT),
          #     new lines (LF), carriage returns (CR), and page breaks (FF).
          #     Default value is an empty string.
          #     Max length: 2000 bytes.
          # @!attribute [rw] primary_contact
          #   @return [::String]
          #     Optional. Email or URL of the primary point of contact of the listing.
          #     Max Length: 1000 bytes.
          # @!attribute [rw] documentation
          #   @return [::String]
          #     Optional. Documentation describing the listing.
          # @!attribute [r] state
          #   @return [::Google::Cloud::Bigquery::DataExchange::V1beta1::Listing::State]
          #     Output only. Current state of the listing.
          # @!attribute [rw] icon
          #   @return [::String]
          #     Optional. Base64 encoded image representing the listing. Max Size: 3.0MiB
          #     Expected image dimensions are 512x512 pixels, however the API only
          #     performs validation on size of the encoded data.
          #     Note: For byte fields, the contents of the field are base64-encoded (which
          #     increases the size of the data by 33-36%) when using JSON on the wire.
          # @!attribute [rw] data_provider
          #   @return [::Google::Cloud::Bigquery::DataExchange::V1beta1::DataProvider]
          #     Optional. Details of the data provider who owns the source data.
          # @!attribute [rw] categories
          #   @return [::Array<::Google::Cloud::Bigquery::DataExchange::V1beta1::Listing::Category>]
          #     Optional. Categories of the listing. Up to two categories are allowed.
          # @!attribute [rw] publisher
          #   @return [::Google::Cloud::Bigquery::DataExchange::V1beta1::Publisher]
          #     Optional. Details of the publisher who owns the listing and who can share
          #     the source data.
          # @!attribute [rw] request_access
          #   @return [::String]
          #     Optional. Email or URL of the request access of the listing.
          #     Subscribers can use this reference to request access.
          #     Max Length: 1000 bytes.
          class Listing
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # A reference to a shared dataset. It is an existing BigQuery dataset with a
            # collection of objects such as tables and views that you want to share
            # with subscribers.
            # When subscriber's subscribe to a listing, Analytics Hub creates a linked
            # dataset in
            # the subscriber's project. A Linked dataset is an opaque, read-only BigQuery
            # dataset that serves as a _symbolic link_ to a shared dataset.
            # @!attribute [rw] dataset
            #   @return [::String]
            #     Resource name of the dataset source for this listing.
            #     e.g. `projects/myproject/datasets/123`
            class BigQueryDatasetSource
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # State of the listing.
            module State
              # Default value. This value is unused.
              STATE_UNSPECIFIED = 0

              # Subscribable state. Users with dataexchange.listings.subscribe permission
              # can subscribe to this listing.
              ACTIVE = 1
            end

            # Listing categories.
            module Category
              CATEGORY_UNSPECIFIED = 0

              CATEGORY_OTHERS = 1

              CATEGORY_ADVERTISING_AND_MARKETING = 2

              CATEGORY_COMMERCE = 3

              CATEGORY_CLIMATE_AND_ENVIRONMENT = 4

              CATEGORY_DEMOGRAPHICS = 5

              CATEGORY_ECONOMICS = 6

              CATEGORY_EDUCATION = 7

              CATEGORY_ENERGY = 8

              CATEGORY_FINANCIAL = 9

              CATEGORY_GAMING = 10

              CATEGORY_GEOSPATIAL = 11

              CATEGORY_HEALTHCARE_AND_LIFE_SCIENCE = 12

              CATEGORY_MEDIA = 13

              CATEGORY_PUBLIC_SECTOR = 14

              CATEGORY_RETAIL = 15

              CATEGORY_SPORTS = 16

              CATEGORY_SCIENCE_AND_RESEARCH = 17

              CATEGORY_TRANSPORTATION_AND_LOGISTICS = 18

              CATEGORY_TRAVEL_AND_TOURISM = 19
            end
          end

          # Message for requesting the list of data exchanges.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent resource path of the data exchanges.
          #     e.g. `projects/myproject/locations/US`.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of results to return in a single response page. Leverage
          #     the page tokens to iterate through the entire collection.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Page token, returned by a previous call, to request the next page of
          #     results.
          class ListDataExchangesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for response to the list of data exchanges.
          # @!attribute [rw] data_exchanges
          #   @return [::Array<::Google::Cloud::Bigquery::DataExchange::V1beta1::DataExchange>]
          #     The list of data exchanges.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token to request the next page of results.
          class ListDataExchangesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for requesting the list of data exchanges from projects in an
          # organization and location.
          # @!attribute [rw] organization
          #   @return [::String]
          #     Required. The organization resource path of the projects containing DataExchanges.
          #     e.g. `organizations/myorg/locations/US`.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of results to return in a single response page. Leverage
          #     the page tokens to iterate through the entire collection.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Page token, returned by a previous call, to request the next page of
          #     results.
          class ListOrgDataExchangesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for response to listing data exchanges in an organization and
          # location.
          # @!attribute [rw] data_exchanges
          #   @return [::Array<::Google::Cloud::Bigquery::DataExchange::V1beta1::DataExchange>]
          #     The list of data exchanges.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token to request the next page of results.
          class ListOrgDataExchangesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for getting a data exchange.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the data exchange.
          #     e.g. `projects/myproject/locations/US/dataExchanges/123`.
          class GetDataExchangeRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for creating a data exchange.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent resource path of the data exchange.
          #     e.g. `projects/myproject/locations/US`.
          # @!attribute [rw] data_exchange_id
          #   @return [::String]
          #     Required. The ID of the data exchange.
          #     Must contain only Unicode letters, numbers (0-9), underscores (_).
          #     Should not use characters that require URL-escaping, or characters
          #     outside of ASCII, spaces.
          #     Max length: 100 bytes.
          # @!attribute [rw] data_exchange
          #   @return [::Google::Cloud::Bigquery::DataExchange::V1beta1::DataExchange]
          #     Required. The data exchange to create.
          class CreateDataExchangeRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for updating a data exchange.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Required. Field mask specifies the fields to update in the data exchange
          #     resource. The fields specified in the
          #     `updateMask` are relative to the resource and are not a full request.
          # @!attribute [rw] data_exchange
          #   @return [::Google::Cloud::Bigquery::DataExchange::V1beta1::DataExchange]
          #     Required. The data exchange to update.
          class UpdateDataExchangeRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for deleting a data exchange.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The full name of the data exchange resource that you want to delete.
          #     For example, `projects/myproject/locations/US/dataExchanges/123`.
          class DeleteDataExchangeRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for requesting the list of listings.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent resource path of the listing.
          #     e.g. `projects/myproject/locations/US/dataExchanges/123`.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of results to return in a single response page. Leverage
          #     the page tokens to iterate through the entire collection.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Page token, returned by a previous call, to request the next page of
          #     results.
          class ListListingsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for response to the list of Listings.
          # @!attribute [rw] listings
          #   @return [::Array<::Google::Cloud::Bigquery::DataExchange::V1beta1::Listing>]
          #     The list of Listing.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token to request the next page of results.
          class ListListingsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for getting a listing.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the listing.
          #     e.g. `projects/myproject/locations/US/dataExchanges/123/listings/456`.
          class GetListingRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for creating a listing.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent resource path of the listing.
          #     e.g. `projects/myproject/locations/US/dataExchanges/123`.
          # @!attribute [rw] listing_id
          #   @return [::String]
          #     Required. The ID of the listing to create.
          #     Must contain only Unicode letters, numbers (0-9), underscores (_).
          #     Should not use characters that require URL-escaping, or characters
          #     outside of ASCII, spaces.
          #     Max length: 100 bytes.
          # @!attribute [rw] listing
          #   @return [::Google::Cloud::Bigquery::DataExchange::V1beta1::Listing]
          #     Required. The listing to create.
          class CreateListingRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for updating a Listing.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Required. Field mask specifies the fields to update in the listing resource. The
          #     fields specified in the `updateMask` are relative to the resource and are
          #     not a full request.
          # @!attribute [rw] listing
          #   @return [::Google::Cloud::Bigquery::DataExchange::V1beta1::Listing]
          #     Required. The listing to update.
          class UpdateListingRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for deleting a listing.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Resource name of the listing to delete.
          #     e.g. `projects/myproject/locations/US/dataExchanges/123/listings/456`.
          class DeleteListingRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for subscribing to a listing.
          # @!attribute [rw] destination_dataset
          #   @return [::Google::Cloud::Bigquery::DataExchange::V1beta1::DestinationDataset]
          #     BigQuery destination dataset to create for the subscriber.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Resource name of the listing that you want to subscribe to.
          #     e.g. `projects/myproject/locations/US/dataExchanges/123/listings/456`.
          class SubscribeListingRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for response when you subscribe to a listing.
          class SubscribeListingResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
