# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/bigquery/dataexchange/v1beta1/dataexchange_pb"
require "google/cloud/location"

module Google
  module Cloud
    module Bigquery
      module DataExchange
        module V1beta1
          module AnalyticsHubService
            ##
            # Client for the AnalyticsHubService service.
            #
            # The `AnalyticsHubService` API facilitates data sharing within and across
            # organizations. It allows data providers to publish listings that reference
            # shared datasets. With Analytics Hub, users can discover and search for
            # listings that they have access to. Subscribers can view and subscribe to
            # listings. When you subscribe to a listing, Analytics Hub creates a linked
            # dataset in your project.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "analyticshub.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :analytics_hub_service_stub

              ##
              # Configure the AnalyticsHubService Client class.
              #
              # See {::Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all AnalyticsHubService clients
              #   ::Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Bigquery", "DataExchange", "V1beta1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0
                  default_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the AnalyticsHubService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @analytics_hub_service_stub.universe_domain
              end

              ##
              # Create a new AnalyticsHubService client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the AnalyticsHubService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # These require statements are intentionally placed here to initialize
                # the gRPC module only when it's required.
                # See https://github.com/googleapis/toolkit/issues/446
                require "gapic/grpc"
                require "google/cloud/bigquery/dataexchange/v1beta1/dataexchange_services_pb"

                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end
                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @analytics_hub_service_stub = ::Gapic::ServiceStub.new(
                  ::Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Stub,
                  credentials: credentials,
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  channel_args: @config.channel_args,
                  interceptors: @config.interceptors,
                  channel_pool_config: @config.channel_pool,
                  logger: @config.logger
                )

                @analytics_hub_service_stub.stub_logger&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @analytics_hub_service_stub.endpoint
                  config.universe_domain = @analytics_hub_service_stub.universe_domain
                  config.logger = @analytics_hub_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @analytics_hub_service_stub.logger
              end

              # Service calls

              ##
              # Lists all data exchanges in a given project and location.
              #
              # @overload list_data_exchanges(request, options = nil)
              #   Pass arguments to `list_data_exchanges` via a request object, either of type
              #   {::Google::Cloud::Bigquery::DataExchange::V1beta1::ListDataExchangesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::DataExchange::V1beta1::ListDataExchangesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_data_exchanges(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_data_exchanges` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource path of the data exchanges.
              #     e.g. `projects/myproject/locations/US`.
              #   @param page_size [::Integer]
              #     The maximum number of results to return in a single response page. Leverage
              #     the page tokens to iterate through the entire collection.
              #   @param page_token [::String]
              #     Page token, returned by a previous call, to request the next page of
              #     results.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Bigquery::DataExchange::V1beta1::DataExchange>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Bigquery::DataExchange::V1beta1::DataExchange>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/data_exchange/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::DataExchange::V1beta1::ListDataExchangesRequest.new
              #
              #   # Call the list_data_exchanges method.
              #   result = client.list_data_exchanges request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Bigquery::DataExchange::V1beta1::DataExchange.
              #     p item
              #   end
              #
              def list_data_exchanges request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::DataExchange::V1beta1::ListDataExchangesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_data_exchanges.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::DataExchange::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_data_exchanges.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_data_exchanges.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_hub_service_stub.call_rpc :list_data_exchanges, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @analytics_hub_service_stub, :list_data_exchanges, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all data exchanges from projects in a given organization and
              # location.
              #
              # @overload list_org_data_exchanges(request, options = nil)
              #   Pass arguments to `list_org_data_exchanges` via a request object, either of type
              #   {::Google::Cloud::Bigquery::DataExchange::V1beta1::ListOrgDataExchangesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::DataExchange::V1beta1::ListOrgDataExchangesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_org_data_exchanges(organization: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_org_data_exchanges` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param organization [::String]
              #     Required. The organization resource path of the projects containing DataExchanges.
              #     e.g. `organizations/myorg/locations/US`.
              #   @param page_size [::Integer]
              #     The maximum number of results to return in a single response page. Leverage
              #     the page tokens to iterate through the entire collection.
              #   @param page_token [::String]
              #     Page token, returned by a previous call, to request the next page of
              #     results.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Bigquery::DataExchange::V1beta1::DataExchange>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Bigquery::DataExchange::V1beta1::DataExchange>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/data_exchange/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::DataExchange::V1beta1::ListOrgDataExchangesRequest.new
              #
              #   # Call the list_org_data_exchanges method.
              #   result = client.list_org_data_exchanges request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Bigquery::DataExchange::V1beta1::DataExchange.
              #     p item
              #   end
              #
              def list_org_data_exchanges request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::DataExchange::V1beta1::ListOrgDataExchangesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_org_data_exchanges.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::DataExchange::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.organization
                  header_params["organization"] = request.organization
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_org_data_exchanges.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_org_data_exchanges.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_hub_service_stub.call_rpc :list_org_data_exchanges, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @analytics_hub_service_stub, :list_org_data_exchanges, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the details of a data exchange.
              #
              # @overload get_data_exchange(request, options = nil)
              #   Pass arguments to `get_data_exchange` via a request object, either of type
              #   {::Google::Cloud::Bigquery::DataExchange::V1beta1::GetDataExchangeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::DataExchange::V1beta1::GetDataExchangeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_data_exchange(name: nil)
              #   Pass arguments to `get_data_exchange` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the data exchange.
              #     e.g. `projects/myproject/locations/US/dataExchanges/123`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigquery::DataExchange::V1beta1::DataExchange]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigquery::DataExchange::V1beta1::DataExchange]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/data_exchange/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::DataExchange::V1beta1::GetDataExchangeRequest.new
              #
              #   # Call the get_data_exchange method.
              #   result = client.get_data_exchange request
              #
              #   # The returned object is of type Google::Cloud::Bigquery::DataExchange::V1beta1::DataExchange.
              #   p result
              #
              def get_data_exchange request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::DataExchange::V1beta1::GetDataExchangeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_data_exchange.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::DataExchange::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_data_exchange.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_data_exchange.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_hub_service_stub.call_rpc :get_data_exchange, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new data exchange.
              #
              # @overload create_data_exchange(request, options = nil)
              #   Pass arguments to `create_data_exchange` via a request object, either of type
              #   {::Google::Cloud::Bigquery::DataExchange::V1beta1::CreateDataExchangeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::DataExchange::V1beta1::CreateDataExchangeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_data_exchange(parent: nil, data_exchange_id: nil, data_exchange: nil)
              #   Pass arguments to `create_data_exchange` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource path of the data exchange.
              #     e.g. `projects/myproject/locations/US`.
              #   @param data_exchange_id [::String]
              #     Required. The ID of the data exchange.
              #     Must contain only Unicode letters, numbers (0-9), underscores (_).
              #     Should not use characters that require URL-escaping, or characters
              #     outside of ASCII, spaces.
              #     Max length: 100 bytes.
              #   @param data_exchange [::Google::Cloud::Bigquery::DataExchange::V1beta1::DataExchange, ::Hash]
              #     Required. The data exchange to create.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigquery::DataExchange::V1beta1::DataExchange]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigquery::DataExchange::V1beta1::DataExchange]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/data_exchange/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::DataExchange::V1beta1::CreateDataExchangeRequest.new
              #
              #   # Call the create_data_exchange method.
              #   result = client.create_data_exchange request
              #
              #   # The returned object is of type Google::Cloud::Bigquery::DataExchange::V1beta1::DataExchange.
              #   p result
              #
              def create_data_exchange request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::DataExchange::V1beta1::CreateDataExchangeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_data_exchange.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::DataExchange::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_data_exchange.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_data_exchange.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_hub_service_stub.call_rpc :create_data_exchange, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an existing data exchange.
              #
              # @overload update_data_exchange(request, options = nil)
              #   Pass arguments to `update_data_exchange` via a request object, either of type
              #   {::Google::Cloud::Bigquery::DataExchange::V1beta1::UpdateDataExchangeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::DataExchange::V1beta1::UpdateDataExchangeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_data_exchange(update_mask: nil, data_exchange: nil)
              #   Pass arguments to `update_data_exchange` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask specifies the fields to update in the data exchange
              #     resource. The fields specified in the
              #     `updateMask` are relative to the resource and are not a full request.
              #   @param data_exchange [::Google::Cloud::Bigquery::DataExchange::V1beta1::DataExchange, ::Hash]
              #     Required. The data exchange to update.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigquery::DataExchange::V1beta1::DataExchange]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigquery::DataExchange::V1beta1::DataExchange]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/data_exchange/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::DataExchange::V1beta1::UpdateDataExchangeRequest.new
              #
              #   # Call the update_data_exchange method.
              #   result = client.update_data_exchange request
              #
              #   # The returned object is of type Google::Cloud::Bigquery::DataExchange::V1beta1::DataExchange.
              #   p result
              #
              def update_data_exchange request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::DataExchange::V1beta1::UpdateDataExchangeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_data_exchange.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::DataExchange::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.data_exchange&.name
                  header_params["data_exchange.name"] = request.data_exchange.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_data_exchange.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_data_exchange.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_hub_service_stub.call_rpc :update_data_exchange, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an existing data exchange.
              #
              # @overload delete_data_exchange(request, options = nil)
              #   Pass arguments to `delete_data_exchange` via a request object, either of type
              #   {::Google::Cloud::Bigquery::DataExchange::V1beta1::DeleteDataExchangeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::DataExchange::V1beta1::DeleteDataExchangeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_data_exchange(name: nil)
              #   Pass arguments to `delete_data_exchange` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The full name of the data exchange resource that you want to delete.
              #     For example, `projects/myproject/locations/US/dataExchanges/123`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Protobuf::Empty]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/data_exchange/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::DataExchange::V1beta1::DeleteDataExchangeRequest.new
              #
              #   # Call the delete_data_exchange method.
              #   result = client.delete_data_exchange request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_data_exchange request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::DataExchange::V1beta1::DeleteDataExchangeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_data_exchange.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::DataExchange::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_data_exchange.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_data_exchange.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_hub_service_stub.call_rpc :delete_data_exchange, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all listings in a given project and location.
              #
              # @overload list_listings(request, options = nil)
              #   Pass arguments to `list_listings` via a request object, either of type
              #   {::Google::Cloud::Bigquery::DataExchange::V1beta1::ListListingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::DataExchange::V1beta1::ListListingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_listings(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_listings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource path of the listing.
              #     e.g. `projects/myproject/locations/US/dataExchanges/123`.
              #   @param page_size [::Integer]
              #     The maximum number of results to return in a single response page. Leverage
              #     the page tokens to iterate through the entire collection.
              #   @param page_token [::String]
              #     Page token, returned by a previous call, to request the next page of
              #     results.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Bigquery::DataExchange::V1beta1::Listing>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Bigquery::DataExchange::V1beta1::Listing>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/data_exchange/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::DataExchange::V1beta1::ListListingsRequest.new
              #
              #   # Call the list_listings method.
              #   result = client.list_listings request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Bigquery::DataExchange::V1beta1::Listing.
              #     p item
              #   end
              #
              def list_listings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::DataExchange::V1beta1::ListListingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_listings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::DataExchange::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_listings.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_listings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_hub_service_stub.call_rpc :list_listings, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @analytics_hub_service_stub, :list_listings, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the details of a listing.
              #
              # @overload get_listing(request, options = nil)
              #   Pass arguments to `get_listing` via a request object, either of type
              #   {::Google::Cloud::Bigquery::DataExchange::V1beta1::GetListingRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::DataExchange::V1beta1::GetListingRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_listing(name: nil)
              #   Pass arguments to `get_listing` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the listing.
              #     e.g. `projects/myproject/locations/US/dataExchanges/123/listings/456`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigquery::DataExchange::V1beta1::Listing]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigquery::DataExchange::V1beta1::Listing]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/data_exchange/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::DataExchange::V1beta1::GetListingRequest.new
              #
              #   # Call the get_listing method.
              #   result = client.get_listing request
              #
              #   # The returned object is of type Google::Cloud::Bigquery::DataExchange::V1beta1::Listing.
              #   p result
              #
              def get_listing request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::DataExchange::V1beta1::GetListingRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_listing.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::DataExchange::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_listing.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_listing.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_hub_service_stub.call_rpc :get_listing, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new listing.
              #
              # @overload create_listing(request, options = nil)
              #   Pass arguments to `create_listing` via a request object, either of type
              #   {::Google::Cloud::Bigquery::DataExchange::V1beta1::CreateListingRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::DataExchange::V1beta1::CreateListingRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_listing(parent: nil, listing_id: nil, listing: nil)
              #   Pass arguments to `create_listing` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource path of the listing.
              #     e.g. `projects/myproject/locations/US/dataExchanges/123`.
              #   @param listing_id [::String]
              #     Required. The ID of the listing to create.
              #     Must contain only Unicode letters, numbers (0-9), underscores (_).
              #     Should not use characters that require URL-escaping, or characters
              #     outside of ASCII, spaces.
              #     Max length: 100 bytes.
              #   @param listing [::Google::Cloud::Bigquery::DataExchange::V1beta1::Listing, ::Hash]
              #     Required. The listing to create.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigquery::DataExchange::V1beta1::Listing]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigquery::DataExchange::V1beta1::Listing]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/data_exchange/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::DataExchange::V1beta1::CreateListingRequest.new
              #
              #   # Call the create_listing method.
              #   result = client.create_listing request
              #
              #   # The returned object is of type Google::Cloud::Bigquery::DataExchange::V1beta1::Listing.
              #   p result
              #
              def create_listing request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::DataExchange::V1beta1::CreateListingRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_listing.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::DataExchange::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_listing.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_listing.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_hub_service_stub.call_rpc :create_listing, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an existing listing.
              #
              # @overload update_listing(request, options = nil)
              #   Pass arguments to `update_listing` via a request object, either of type
              #   {::Google::Cloud::Bigquery::DataExchange::V1beta1::UpdateListingRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::DataExchange::V1beta1::UpdateListingRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_listing(update_mask: nil, listing: nil)
              #   Pass arguments to `update_listing` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask specifies the fields to update in the listing resource. The
              #     fields specified in the `updateMask` are relative to the resource and are
              #     not a full request.
              #   @param listing [::Google::Cloud::Bigquery::DataExchange::V1beta1::Listing, ::Hash]
              #     Required. The listing to update.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigquery::DataExchange::V1beta1::Listing]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigquery::DataExchange::V1beta1::Listing]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/data_exchange/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::DataExchange::V1beta1::UpdateListingRequest.new
              #
              #   # Call the update_listing method.
              #   result = client.update_listing request
              #
              #   # The returned object is of type Google::Cloud::Bigquery::DataExchange::V1beta1::Listing.
              #   p result
              #
              def update_listing request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::DataExchange::V1beta1::UpdateListingRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_listing.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::DataExchange::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.listing&.name
                  header_params["listing.name"] = request.listing.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_listing.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_listing.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_hub_service_stub.call_rpc :update_listing, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a listing.
              #
              # @overload delete_listing(request, options = nil)
              #   Pass arguments to `delete_listing` via a request object, either of type
              #   {::Google::Cloud::Bigquery::DataExchange::V1beta1::DeleteListingRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::DataExchange::V1beta1::DeleteListingRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_listing(name: nil)
              #   Pass arguments to `delete_listing` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the listing to delete.
              #     e.g. `projects/myproject/locations/US/dataExchanges/123/listings/456`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Protobuf::Empty]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/data_exchange/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::DataExchange::V1beta1::DeleteListingRequest.new
              #
              #   # Call the delete_listing method.
              #   result = client.delete_listing request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_listing request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::DataExchange::V1beta1::DeleteListingRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_listing.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::DataExchange::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_listing.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_listing.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_hub_service_stub.call_rpc :delete_listing, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Subscribes to a listing.
              #
              # Currently, with Analytics Hub, you can create listings that
              # reference only BigQuery datasets.
              # Upon subscription to a listing for a BigQuery dataset, Analytics Hub
              # creates a linked dataset in the subscriber's project.
              #
              # @overload subscribe_listing(request, options = nil)
              #   Pass arguments to `subscribe_listing` via a request object, either of type
              #   {::Google::Cloud::Bigquery::DataExchange::V1beta1::SubscribeListingRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Bigquery::DataExchange::V1beta1::SubscribeListingRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload subscribe_listing(destination_dataset: nil, name: nil)
              #   Pass arguments to `subscribe_listing` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param destination_dataset [::Google::Cloud::Bigquery::DataExchange::V1beta1::DestinationDataset, ::Hash]
              #     BigQuery destination dataset to create for the subscriber.
              #   @param name [::String]
              #     Required. Resource name of the listing that you want to subscribe to.
              #     e.g. `projects/myproject/locations/US/dataExchanges/123/listings/456`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Bigquery::DataExchange::V1beta1::SubscribeListingResponse]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Bigquery::DataExchange::V1beta1::SubscribeListingResponse]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/data_exchange/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Bigquery::DataExchange::V1beta1::SubscribeListingRequest.new
              #
              #   # Call the subscribe_listing method.
              #   result = client.subscribe_listing request
              #
              #   # The returned object is of type Google::Cloud::Bigquery::DataExchange::V1beta1::SubscribeListingResponse.
              #   p result
              #
              def subscribe_listing request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigquery::DataExchange::V1beta1::SubscribeListingRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.subscribe_listing.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::DataExchange::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.subscribe_listing.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.subscribe_listing.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_hub_service_stub.call_rpc :subscribe_listing, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the IAM policy.
              #
              # @overload get_iam_policy(request, options = nil)
              #   Pass arguments to `get_iam_policy` via a request object, either of type
              #   {::Google::Iam::V1::GetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::GetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_iam_policy(resource: nil, options: nil)
              #   Pass arguments to `get_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param options [::Google::Iam::V1::GetPolicyOptions, ::Hash]
              #     OPTIONAL: A `GetPolicyOptions` object for specifying options to
              #     `GetIamPolicy`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Iam::V1::Policy]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/data_exchange/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::GetIamPolicyRequest.new
              #
              #   # Call the get_iam_policy method.
              #   result = client.get_iam_policy request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def get_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::GetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::DataExchange::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.resource
                  header_params["resource"] = request.resource
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_iam_policy.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_hub_service_stub.call_rpc :get_iam_policy, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Sets the IAM policy.
              #
              # @overload set_iam_policy(request, options = nil)
              #   Pass arguments to `set_iam_policy` via a request object, either of type
              #   {::Google::Iam::V1::SetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::SetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload set_iam_policy(resource: nil, policy: nil, update_mask: nil)
              #   Pass arguments to `set_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being specified.
              #     See the operation documentation for the appropriate value for this field.
              #   @param policy [::Google::Iam::V1::Policy, ::Hash]
              #     REQUIRED: The complete policy to be applied to the `resource`. The size of
              #     the policy is limited to a few 10s of KB. An empty policy is a
              #     valid policy but certain Cloud Platform services (such as Projects)
              #     might reject them.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
              #     the fields in the mask will be modified. If no mask is provided, the
              #     following default mask is used:
              #
              #     `paths: "bindings, etag"`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Iam::V1::Policy]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/data_exchange/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::SetIamPolicyRequest.new
              #
              #   # Call the set_iam_policy method.
              #   result = client.set_iam_policy request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def set_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::SetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.set_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::DataExchange::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.resource
                  header_params["resource"] = request.resource
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.set_iam_policy.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.set_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_hub_service_stub.call_rpc :set_iam_policy, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the permissions that a caller has.
              #
              # @overload test_iam_permissions(request, options = nil)
              #   Pass arguments to `test_iam_permissions` via a request object, either of type
              #   {::Google::Iam::V1::TestIamPermissionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::TestIamPermissionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload test_iam_permissions(resource: nil, permissions: nil)
              #   Pass arguments to `test_iam_permissions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy detail is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param permissions [::Array<::String>]
              #     The set of permissions to check for the `resource`. Permissions with
              #     wildcards (such as '*' or 'storage.*') are not allowed. For more
              #     information see
              #     [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Iam::V1::TestIamPermissionsResponse]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Iam::V1::TestIamPermissionsResponse]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bigquery/data_exchange/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::TestIamPermissionsRequest.new
              #
              #   # Call the test_iam_permissions method.
              #   result = client.test_iam_permissions request
              #
              #   # The returned object is of type Google::Iam::V1::TestIamPermissionsResponse.
              #   p result
              #
              def test_iam_permissions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::TestIamPermissionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.test_iam_permissions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Bigquery::DataExchange::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.resource
                  header_params["resource"] = request.resource
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.test_iam_permissions.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.test_iam_permissions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @analytics_hub_service_stub.call_rpc :test_iam_permissions, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the AnalyticsHubService API.
              #
              # This class represents the configuration for AnalyticsHubService,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_data_exchanges to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_data_exchanges.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_data_exchanges.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
              #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
              #    *  (`nil`) indicating no credentials
              #
              #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
              #     is deprecated. Providing an unvalidated credential configuration to
              #     Google APIs can compromise the security of your systems and data.
              #
              #   @example
              #
              #     # The recommended way to provide credentials is to use the `make_creds` method
              #     # on the appropriate credentials class for your environment.
              #
              #     require "googleauth"
              #
              #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
              #       json_key_io: ::File.open("/path/to/keyfile.json")
              #     )
              #
              #     client = ::Google::Cloud::Bigquery::DataExchange::V1beta1::AnalyticsHubService::Client.new do |config|
              #       config.credentials = credentials
              #     end
              #
              #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] channel_args
              #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
              #   `GRPC::Core::Channel` object is provided as the credential.
              #   @return [::Hash]
              # @!attribute [rw] interceptors
              #   An array of interceptors that are run before calls are executed.
              #   @return [::Array<::GRPC::ClientInterceptor>]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional gRPC headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "analyticshub.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
                config_attr :interceptors,  nil, ::Array, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration for the channel pool
                # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
                #
                def channel_pool
                  @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
                end

                ##
                # Configuration RPC class for the AnalyticsHubService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_data_exchanges`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_data_exchanges
                  ##
                  # RPC-specific configuration for `list_org_data_exchanges`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_org_data_exchanges
                  ##
                  # RPC-specific configuration for `get_data_exchange`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_data_exchange
                  ##
                  # RPC-specific configuration for `create_data_exchange`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_data_exchange
                  ##
                  # RPC-specific configuration for `update_data_exchange`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_data_exchange
                  ##
                  # RPC-specific configuration for `delete_data_exchange`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_data_exchange
                  ##
                  # RPC-specific configuration for `list_listings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_listings
                  ##
                  # RPC-specific configuration for `get_listing`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_listing
                  ##
                  # RPC-specific configuration for `create_listing`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_listing
                  ##
                  # RPC-specific configuration for `update_listing`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_listing
                  ##
                  # RPC-specific configuration for `delete_listing`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_listing
                  ##
                  # RPC-specific configuration for `subscribe_listing`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :subscribe_listing
                  ##
                  # RPC-specific configuration for `get_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_iam_policy
                  ##
                  # RPC-specific configuration for `set_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_iam_policy
                  ##
                  # RPC-specific configuration for `test_iam_permissions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :test_iam_permissions

                  # @private
                  def initialize parent_rpcs = nil
                    list_data_exchanges_config = parent_rpcs.list_data_exchanges if parent_rpcs.respond_to? :list_data_exchanges
                    @list_data_exchanges = ::Gapic::Config::Method.new list_data_exchanges_config
                    list_org_data_exchanges_config = parent_rpcs.list_org_data_exchanges if parent_rpcs.respond_to? :list_org_data_exchanges
                    @list_org_data_exchanges = ::Gapic::Config::Method.new list_org_data_exchanges_config
                    get_data_exchange_config = parent_rpcs.get_data_exchange if parent_rpcs.respond_to? :get_data_exchange
                    @get_data_exchange = ::Gapic::Config::Method.new get_data_exchange_config
                    create_data_exchange_config = parent_rpcs.create_data_exchange if parent_rpcs.respond_to? :create_data_exchange
                    @create_data_exchange = ::Gapic::Config::Method.new create_data_exchange_config
                    update_data_exchange_config = parent_rpcs.update_data_exchange if parent_rpcs.respond_to? :update_data_exchange
                    @update_data_exchange = ::Gapic::Config::Method.new update_data_exchange_config
                    delete_data_exchange_config = parent_rpcs.delete_data_exchange if parent_rpcs.respond_to? :delete_data_exchange
                    @delete_data_exchange = ::Gapic::Config::Method.new delete_data_exchange_config
                    list_listings_config = parent_rpcs.list_listings if parent_rpcs.respond_to? :list_listings
                    @list_listings = ::Gapic::Config::Method.new list_listings_config
                    get_listing_config = parent_rpcs.get_listing if parent_rpcs.respond_to? :get_listing
                    @get_listing = ::Gapic::Config::Method.new get_listing_config
                    create_listing_config = parent_rpcs.create_listing if parent_rpcs.respond_to? :create_listing
                    @create_listing = ::Gapic::Config::Method.new create_listing_config
                    update_listing_config = parent_rpcs.update_listing if parent_rpcs.respond_to? :update_listing
                    @update_listing = ::Gapic::Config::Method.new update_listing_config
                    delete_listing_config = parent_rpcs.delete_listing if parent_rpcs.respond_to? :delete_listing
                    @delete_listing = ::Gapic::Config::Method.new delete_listing_config
                    subscribe_listing_config = parent_rpcs.subscribe_listing if parent_rpcs.respond_to? :subscribe_listing
                    @subscribe_listing = ::Gapic::Config::Method.new subscribe_listing_config
                    get_iam_policy_config = parent_rpcs.get_iam_policy if parent_rpcs.respond_to? :get_iam_policy
                    @get_iam_policy = ::Gapic::Config::Method.new get_iam_policy_config
                    set_iam_policy_config = parent_rpcs.set_iam_policy if parent_rpcs.respond_to? :set_iam_policy
                    @set_iam_policy = ::Gapic::Config::Method.new set_iam_policy_config
                    test_iam_permissions_config = parent_rpcs.test_iam_permissions if parent_rpcs.respond_to? :test_iam_permissions
                    @test_iam_permissions = ::Gapic::Config::Method.new test_iam_permissions_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
