# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Bigquery
      module Connection
        module V1
          # The request for
          # {::Google::Cloud::Bigquery::Connection::V1::ConnectionService::Client#create_connection ConnectionService.CreateConnection}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. Parent resource name.
          #     Must be in the format `projects/{project_id}/locations/{location_id}`
          # @!attribute [rw] connection_id
          #   @return [::String]
          #     Optional. Connection id that should be assigned to the created connection.
          # @!attribute [rw] connection
          #   @return [::Google::Cloud::Bigquery::Connection::V1::Connection]
          #     Required. Connection to create.
          class CreateConnectionRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigquery::Connection::V1::ConnectionService::Client#get_connection ConnectionService.GetConnection}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Name of the requested connection, for example:
          #     `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
          class GetConnectionRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigquery::Connection::V1::ConnectionService::Client#list_connections ConnectionService.ListConnections}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. Parent resource name.
          #     Must be in the form: `projects/{project_id}/locations/{location_id}`
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Required. Page size.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Page token.
          class ListConnectionsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response for
          # {::Google::Cloud::Bigquery::Connection::V1::ConnectionService::Client#list_connections ConnectionService.ListConnections}.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     Next page token.
          # @!attribute [rw] connections
          #   @return [::Array<::Google::Cloud::Bigquery::Connection::V1::Connection>]
          #     List of connections.
          class ListConnectionsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigquery::Connection::V1::ConnectionService::Client#update_connection ConnectionService.UpdateConnection}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Name of the connection to update, for example:
          #     `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
          # @!attribute [rw] connection
          #   @return [::Google::Cloud::Bigquery::Connection::V1::Connection]
          #     Required. Connection containing the updated fields.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Required. Update mask for the connection fields to be updated.
          class UpdateConnectionRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for [ConnectionService.DeleteConnectionRequest][].
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Name of the deleted connection, for example:
          #     `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
          class DeleteConnectionRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration parameters to establish connection with an external data
          # source, except the credential attributes.
          # @!attribute [rw] name
          #   @return [::String]
          #     The resource name of the connection in the form of:
          #     `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
          # @!attribute [rw] friendly_name
          #   @return [::String]
          #     User provided display name for the connection.
          # @!attribute [rw] description
          #   @return [::String]
          #     User provided description.
          # @!attribute [rw] cloud_sql
          #   @return [::Google::Cloud::Bigquery::Connection::V1::CloudSqlProperties]
          #     Cloud SQL properties.
          #
          #     Note: The following fields are mutually exclusive: `cloud_sql`, `aws`, `azure`, `cloud_spanner`, `cloud_resource`, `spark`, `salesforce_data_cloud`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] aws
          #   @return [::Google::Cloud::Bigquery::Connection::V1::AwsProperties]
          #     Amazon Web Services (AWS) properties.
          #
          #     Note: The following fields are mutually exclusive: `aws`, `cloud_sql`, `azure`, `cloud_spanner`, `cloud_resource`, `spark`, `salesforce_data_cloud`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] azure
          #   @return [::Google::Cloud::Bigquery::Connection::V1::AzureProperties]
          #     Azure properties.
          #
          #     Note: The following fields are mutually exclusive: `azure`, `cloud_sql`, `aws`, `cloud_spanner`, `cloud_resource`, `spark`, `salesforce_data_cloud`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] cloud_spanner
          #   @return [::Google::Cloud::Bigquery::Connection::V1::CloudSpannerProperties]
          #     Cloud Spanner properties.
          #
          #     Note: The following fields are mutually exclusive: `cloud_spanner`, `cloud_sql`, `aws`, `azure`, `cloud_resource`, `spark`, `salesforce_data_cloud`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] cloud_resource
          #   @return [::Google::Cloud::Bigquery::Connection::V1::CloudResourceProperties]
          #     Cloud Resource properties.
          #
          #     Note: The following fields are mutually exclusive: `cloud_resource`, `cloud_sql`, `aws`, `azure`, `cloud_spanner`, `spark`, `salesforce_data_cloud`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] spark
          #   @return [::Google::Cloud::Bigquery::Connection::V1::SparkProperties]
          #     Spark properties.
          #
          #     Note: The following fields are mutually exclusive: `spark`, `cloud_sql`, `aws`, `azure`, `cloud_spanner`, `cloud_resource`, `salesforce_data_cloud`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] salesforce_data_cloud
          #   @return [::Google::Cloud::Bigquery::Connection::V1::SalesforceDataCloudProperties]
          #     Optional. Salesforce DataCloud properties. This field is intended for
          #     use only by Salesforce partner projects. This field contains properties
          #     for your Salesforce DataCloud connection.
          #
          #     Note: The following fields are mutually exclusive: `salesforce_data_cloud`, `cloud_sql`, `aws`, `azure`, `cloud_spanner`, `cloud_resource`, `spark`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [r] creation_time
          #   @return [::Integer]
          #     Output only. The creation timestamp of the connection.
          # @!attribute [r] last_modified_time
          #   @return [::Integer]
          #     Output only. The last update timestamp of the connection.
          # @!attribute [r] has_credential
          #   @return [::Boolean]
          #     Output only. True, if credential is configured for this connection.
          class Connection
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Connection properties specific to the Cloud SQL.
          # @!attribute [rw] instance_id
          #   @return [::String]
          #     Cloud SQL instance ID in the form `project:location:instance`.
          # @!attribute [rw] database
          #   @return [::String]
          #     Database name.
          # @!attribute [rw] type
          #   @return [::Google::Cloud::Bigquery::Connection::V1::CloudSqlProperties::DatabaseType]
          #     Type of the Cloud SQL database.
          # @!attribute [rw] credential
          #   @return [::Google::Cloud::Bigquery::Connection::V1::CloudSqlCredential]
          #     Input only. Cloud SQL credential.
          # @!attribute [r] service_account_id
          #   @return [::String]
          #     Output only. The account ID of the service used for the purpose of this
          #     connection.
          #
          #     When the connection is used in the context of an operation in
          #     BigQuery, this service account will serve as the identity being used for
          #     connecting to the CloudSQL instance specified in this connection.
          class CloudSqlProperties
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Supported Cloud SQL database types.
            module DatabaseType
              # Unspecified database type.
              DATABASE_TYPE_UNSPECIFIED = 0

              # Cloud SQL for PostgreSQL.
              POSTGRES = 1

              # Cloud SQL for MySQL.
              MYSQL = 2
            end
          end

          # Credential info for the Cloud SQL.
          # @!attribute [rw] username
          #   @return [::String]
          #     The username for the credential.
          # @!attribute [rw] password
          #   @return [::String]
          #     The password for the credential.
          class CloudSqlCredential
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Connection properties specific to Cloud Spanner.
          # @!attribute [rw] database
          #   @return [::String]
          #     Cloud Spanner database in the form `project/instance/database'
          # @!attribute [rw] use_parallelism
          #   @return [::Boolean]
          #     If parallelism should be used when reading from Cloud Spanner
          # @!attribute [rw] max_parallelism
          #   @return [::Integer]
          #     Allows setting max parallelism per query when executing on Spanner
          #     independent compute resources. If unspecified, default values of
          #     parallelism are chosen that are dependent on the Cloud Spanner instance
          #     configuration.
          #
          #     REQUIRES: `use_parallelism` must be set.
          #     REQUIRES: Either `use_data_boost` or `use_serverless_analytics` must be
          #     set.
          # @!attribute [rw] use_serverless_analytics
          #   @return [::Boolean]
          #     If the serverless analytics service should be used to read data from Cloud
          #     Spanner.
          #     Note: `use_parallelism` must be set when using serverless analytics.
          # @!attribute [rw] use_data_boost
          #   @return [::Boolean]
          #     If set, the request will be executed via Spanner independent compute
          #     resources.
          #     REQUIRES: `use_parallelism` must be set.
          #
          #     NOTE: `use_serverless_analytics` will be deprecated. Prefer
          #     `use_data_boost` over `use_serverless_analytics`.
          # @!attribute [rw] database_role
          #   @return [::String]
          #     Optional. Cloud Spanner database role for fine-grained access control.
          #     The Cloud Spanner admin should have provisioned the database role with
          #     appropriate permissions, such as `SELECT` and `INSERT`. Other users should
          #     only use roles provided by their Cloud Spanner admins.
          #
          #     For more details, see [About fine-grained access control]
          #     (https://cloud.google.com/spanner/docs/fgac-about).
          #
          #     REQUIRES: The database role name must start with a letter, and can only
          #     contain letters, numbers, and underscores.
          class CloudSpannerProperties
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Connection properties specific to Amazon Web Services (AWS).
          # @!attribute [rw] cross_account_role
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Google::Cloud::Bigquery::Connection::V1::AwsCrossAccountRole]
          #     Authentication using Google owned AWS IAM user's access key to assume
          #     into customer's AWS IAM Role.
          #     Deprecated, do not use.
          #
          #     Note: The following fields are mutually exclusive: `cross_account_role`, `access_role`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] access_role
          #   @return [::Google::Cloud::Bigquery::Connection::V1::AwsAccessRole]
          #     Authentication using Google owned service account to assume into
          #     customer's AWS IAM Role.
          #
          #     Note: The following fields are mutually exclusive: `access_role`, `cross_account_role`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class AwsProperties
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Authentication method for Amazon Web Services (AWS) that uses Google owned
          # AWS IAM user's access key to assume into customer's AWS IAM Role.
          # @!attribute [rw] iam_role_id
          #   @return [::String]
          #     The user’s AWS IAM Role that trusts the Google-owned AWS IAM user
          #     Connection.
          # @!attribute [r] iam_user_id
          #   @return [::String]
          #     Output only. Google-owned AWS IAM User for a Connection.
          # @!attribute [r] external_id
          #   @return [::String]
          #     Output only. A Google-generated id for representing Connection’s identity
          #     in AWS. External Id is also used for preventing the Confused Deputy
          #     Problem. See
          #     https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html
          class AwsCrossAccountRole
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Authentication method for Amazon Web Services (AWS) that uses Google owned
          # Google service account to assume into customer's AWS IAM Role.
          # @!attribute [rw] iam_role_id
          #   @return [::String]
          #     The user’s AWS IAM Role that trusts the Google-owned AWS IAM user
          #     Connection.
          # @!attribute [rw] identity
          #   @return [::String]
          #     A unique Google-owned and Google-generated identity for the Connection.
          #     This identity will be used to access the user's AWS IAM Role.
          class AwsAccessRole
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Container for connection properties specific to Azure.
          # @!attribute [r] application
          #   @return [::String]
          #     Output only. The name of the Azure Active Directory Application.
          # @!attribute [r] client_id
          #   @return [::String]
          #     Output only. The client id of the Azure Active Directory Application.
          # @!attribute [r] object_id
          #   @return [::String]
          #     Output only. The object id of the Azure Active Directory Application.
          # @!attribute [rw] customer_tenant_id
          #   @return [::String]
          #     The id of customer's directory that host the data.
          # @!attribute [rw] redirect_uri
          #   @return [::String]
          #     The URL user will be redirected to after granting consent during connection
          #     setup.
          # @!attribute [rw] federated_application_client_id
          #   @return [::String]
          #     The client ID of the user's Azure Active Directory Application used for a
          #     federated connection.
          # @!attribute [r] identity
          #   @return [::String]
          #     Output only. A unique Google-owned and Google-generated identity for the
          #     Connection. This identity will be used to access the user's Azure Active
          #     Directory Application.
          class AzureProperties
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Container for connection properties for delegation of access to GCP
          # resources.
          # @!attribute [r] service_account_id
          #   @return [::String]
          #     Output only. The account ID of the service created for the purpose of this
          #     connection.
          #
          #     The service account does not have any permissions associated with it
          #     when it is created. After creation, customers delegate permissions
          #     to the service account. When the connection is used in the context of an
          #     operation in BigQuery, the service account will be used to connect to the
          #     desired resources in GCP.
          #
          #     The account ID is in the form of:
          #       <service-1234>@gcp-sa-bigquery-cloudresource.iam.gserviceaccount.com
          class CloudResourceProperties
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration of the Dataproc Metastore Service.
          # @!attribute [rw] metastore_service
          #   @return [::String]
          #     Optional. Resource name of an existing Dataproc Metastore service.
          #
          #     Example:
          #
          #     * `projects/[project_id]/locations/[region]/services/[service_id]`
          class MetastoreServiceConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration of the Spark History Server.
          # @!attribute [rw] dataproc_cluster
          #   @return [::String]
          #     Optional. Resource name of an existing Dataproc Cluster to act as a Spark
          #     History Server for the connection.
          #
          #     Example:
          #
          #     * `projects/[project_id]/regions/[region]/clusters/[cluster_name]`
          class SparkHistoryServerConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Container for connection properties to execute stored procedures for Apache
          # Spark.
          # @!attribute [r] service_account_id
          #   @return [::String]
          #     Output only. The account ID of the service created for the purpose of this
          #     connection.
          #
          #     The service account does not have any permissions associated with it when
          #     it is created. After creation, customers delegate permissions to the
          #     service account. When the connection is used in the context of a stored
          #     procedure for Apache Spark in BigQuery, the service account is used to
          #     connect to the desired resources in Google Cloud.
          #
          #     The account ID is in the form of:
          #     bqcx-<projectnumber>-<uniqueid>@gcp-sa-bigquery-consp.iam.gserviceaccount.com
          # @!attribute [rw] metastore_service_config
          #   @return [::Google::Cloud::Bigquery::Connection::V1::MetastoreServiceConfig]
          #     Optional. Dataproc Metastore Service configuration for the connection.
          # @!attribute [rw] spark_history_server_config
          #   @return [::Google::Cloud::Bigquery::Connection::V1::SparkHistoryServerConfig]
          #     Optional. Spark History Server configuration for the connection.
          class SparkProperties
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Connection properties specific to Salesforce DataCloud. This is intended for
          # use only by Salesforce partner projects.
          # @!attribute [rw] instance_uri
          #   @return [::String]
          #     The URL to the user's Salesforce DataCloud instance.
          # @!attribute [r] identity
          #   @return [::String]
          #     Output only. A unique Google-owned and Google-generated service account
          #     identity for the connection.
          # @!attribute [rw] tenant_id
          #   @return [::String]
          #     The ID of the user's Salesforce tenant.
          class SalesforceDataCloudProperties
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
