# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/bigquery/analyticshub/v1/analyticshub_pb"
require "google/cloud/bigquery/analytics_hub/v1/analytics_hub_service"

class ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_data_exchanges
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::AnalyticsHub::V1::ListDataExchangesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_data_exchanges_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_data_exchanges, name
      assert_kind_of ::Google::Cloud::Bigquery::AnalyticsHub::V1::ListDataExchangesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_data_exchanges_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_data_exchanges({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_data_exchanges parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_data_exchanges ::Google::Cloud::Bigquery::AnalyticsHub::V1::ListDataExchangesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_data_exchanges({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_data_exchanges(::Google::Cloud::Bigquery::AnalyticsHub::V1::ListDataExchangesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_data_exchanges_client_stub.call_rpc_count
    end
  end

  def test_list_org_data_exchanges
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::AnalyticsHub::V1::ListOrgDataExchangesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    organization = "hello world"
    page_size = 42
    page_token = "hello world"

    list_org_data_exchanges_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_org_data_exchanges, name
      assert_kind_of ::Google::Cloud::Bigquery::AnalyticsHub::V1::ListOrgDataExchangesRequest, request
      assert_equal "hello world", request["organization"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_org_data_exchanges_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_org_data_exchanges({ organization: organization, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_org_data_exchanges organization: organization, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_org_data_exchanges ::Google::Cloud::Bigquery::AnalyticsHub::V1::ListOrgDataExchangesRequest.new(organization: organization, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_org_data_exchanges({ organization: organization, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_org_data_exchanges(::Google::Cloud::Bigquery::AnalyticsHub::V1::ListOrgDataExchangesRequest.new(organization: organization, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_org_data_exchanges_client_stub.call_rpc_count
    end
  end

  def test_get_data_exchange
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::AnalyticsHub::V1::DataExchange.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_data_exchange_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_data_exchange, name
      assert_kind_of ::Google::Cloud::Bigquery::AnalyticsHub::V1::GetDataExchangeRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_data_exchange_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_data_exchange({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_data_exchange name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_data_exchange ::Google::Cloud::Bigquery::AnalyticsHub::V1::GetDataExchangeRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_data_exchange({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_data_exchange(::Google::Cloud::Bigquery::AnalyticsHub::V1::GetDataExchangeRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_data_exchange_client_stub.call_rpc_count
    end
  end

  def test_create_data_exchange
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::AnalyticsHub::V1::DataExchange.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    data_exchange_id = "hello world"
    data_exchange = {}

    create_data_exchange_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_data_exchange, name
      assert_kind_of ::Google::Cloud::Bigquery::AnalyticsHub::V1::CreateDataExchangeRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["data_exchange_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Bigquery::AnalyticsHub::V1::DataExchange), request["data_exchange"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_data_exchange_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_data_exchange({ parent: parent, data_exchange_id: data_exchange_id, data_exchange: data_exchange }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_data_exchange parent: parent, data_exchange_id: data_exchange_id, data_exchange: data_exchange do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_data_exchange ::Google::Cloud::Bigquery::AnalyticsHub::V1::CreateDataExchangeRequest.new(parent: parent, data_exchange_id: data_exchange_id, data_exchange: data_exchange) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_data_exchange({ parent: parent, data_exchange_id: data_exchange_id, data_exchange: data_exchange }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_data_exchange(::Google::Cloud::Bigquery::AnalyticsHub::V1::CreateDataExchangeRequest.new(parent: parent, data_exchange_id: data_exchange_id, data_exchange: data_exchange), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_data_exchange_client_stub.call_rpc_count
    end
  end

  def test_update_data_exchange
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::AnalyticsHub::V1::DataExchange.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    data_exchange = {}

    update_data_exchange_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_data_exchange, name
      assert_kind_of ::Google::Cloud::Bigquery::AnalyticsHub::V1::UpdateDataExchangeRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Bigquery::AnalyticsHub::V1::DataExchange), request["data_exchange"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_data_exchange_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_data_exchange({ update_mask: update_mask, data_exchange: data_exchange }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_data_exchange update_mask: update_mask, data_exchange: data_exchange do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_data_exchange ::Google::Cloud::Bigquery::AnalyticsHub::V1::UpdateDataExchangeRequest.new(update_mask: update_mask, data_exchange: data_exchange) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_data_exchange({ update_mask: update_mask, data_exchange: data_exchange }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_data_exchange(::Google::Cloud::Bigquery::AnalyticsHub::V1::UpdateDataExchangeRequest.new(update_mask: update_mask, data_exchange: data_exchange), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_data_exchange_client_stub.call_rpc_count
    end
  end

  def test_delete_data_exchange
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_data_exchange_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_data_exchange, name
      assert_kind_of ::Google::Cloud::Bigquery::AnalyticsHub::V1::DeleteDataExchangeRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_data_exchange_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_data_exchange({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_data_exchange name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_data_exchange ::Google::Cloud::Bigquery::AnalyticsHub::V1::DeleteDataExchangeRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_data_exchange({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_data_exchange(::Google::Cloud::Bigquery::AnalyticsHub::V1::DeleteDataExchangeRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_data_exchange_client_stub.call_rpc_count
    end
  end

  def test_list_listings
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::AnalyticsHub::V1::ListListingsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_listings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_listings, name
      assert_kind_of ::Google::Cloud::Bigquery::AnalyticsHub::V1::ListListingsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_listings_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_listings({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_listings parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_listings ::Google::Cloud::Bigquery::AnalyticsHub::V1::ListListingsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_listings({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_listings(::Google::Cloud::Bigquery::AnalyticsHub::V1::ListListingsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_listings_client_stub.call_rpc_count
    end
  end

  def test_get_listing
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::AnalyticsHub::V1::Listing.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_listing_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_listing, name
      assert_kind_of ::Google::Cloud::Bigquery::AnalyticsHub::V1::GetListingRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_listing_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_listing({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_listing name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_listing ::Google::Cloud::Bigquery::AnalyticsHub::V1::GetListingRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_listing({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_listing(::Google::Cloud::Bigquery::AnalyticsHub::V1::GetListingRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_listing_client_stub.call_rpc_count
    end
  end

  def test_create_listing
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::AnalyticsHub::V1::Listing.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    listing_id = "hello world"
    listing = {}

    create_listing_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_listing, name
      assert_kind_of ::Google::Cloud::Bigquery::AnalyticsHub::V1::CreateListingRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["listing_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Bigquery::AnalyticsHub::V1::Listing), request["listing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_listing_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_listing({ parent: parent, listing_id: listing_id, listing: listing }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_listing parent: parent, listing_id: listing_id, listing: listing do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_listing ::Google::Cloud::Bigquery::AnalyticsHub::V1::CreateListingRequest.new(parent: parent, listing_id: listing_id, listing: listing) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_listing({ parent: parent, listing_id: listing_id, listing: listing }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_listing(::Google::Cloud::Bigquery::AnalyticsHub::V1::CreateListingRequest.new(parent: parent, listing_id: listing_id, listing: listing), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_listing_client_stub.call_rpc_count
    end
  end

  def test_update_listing
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::AnalyticsHub::V1::Listing.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    listing = {}

    update_listing_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_listing, name
      assert_kind_of ::Google::Cloud::Bigquery::AnalyticsHub::V1::UpdateListingRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Bigquery::AnalyticsHub::V1::Listing), request["listing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_listing_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_listing({ update_mask: update_mask, listing: listing }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_listing update_mask: update_mask, listing: listing do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_listing ::Google::Cloud::Bigquery::AnalyticsHub::V1::UpdateListingRequest.new(update_mask: update_mask, listing: listing) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_listing({ update_mask: update_mask, listing: listing }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_listing(::Google::Cloud::Bigquery::AnalyticsHub::V1::UpdateListingRequest.new(update_mask: update_mask, listing: listing), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_listing_client_stub.call_rpc_count
    end
  end

  def test_delete_listing
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    delete_commercial = true

    delete_listing_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_listing, name
      assert_kind_of ::Google::Cloud::Bigquery::AnalyticsHub::V1::DeleteListingRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["delete_commercial"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_listing_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_listing({ name: name, delete_commercial: delete_commercial }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_listing name: name, delete_commercial: delete_commercial do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_listing ::Google::Cloud::Bigquery::AnalyticsHub::V1::DeleteListingRequest.new(name: name, delete_commercial: delete_commercial) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_listing({ name: name, delete_commercial: delete_commercial }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_listing(::Google::Cloud::Bigquery::AnalyticsHub::V1::DeleteListingRequest.new(name: name, delete_commercial: delete_commercial), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_listing_client_stub.call_rpc_count
    end
  end

  def test_subscribe_listing
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::AnalyticsHub::V1::SubscribeListingResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    destination_dataset = {}
    name = "hello world"

    subscribe_listing_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :subscribe_listing, name
      assert_kind_of ::Google::Cloud::Bigquery::AnalyticsHub::V1::SubscribeListingRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Bigquery::AnalyticsHub::V1::DestinationDataset), request["destination_dataset"]
      assert_equal :destination_dataset, request.destination
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, subscribe_listing_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.subscribe_listing({ destination_dataset: destination_dataset, name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.subscribe_listing destination_dataset: destination_dataset, name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.subscribe_listing ::Google::Cloud::Bigquery::AnalyticsHub::V1::SubscribeListingRequest.new(destination_dataset: destination_dataset, name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.subscribe_listing({ destination_dataset: destination_dataset, name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.subscribe_listing(::Google::Cloud::Bigquery::AnalyticsHub::V1::SubscribeListingRequest.new(destination_dataset: destination_dataset, name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, subscribe_listing_client_stub.call_rpc_count
    end
  end

  def test_subscribe_data_exchange
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    destination = "hello world"
    destination_dataset = {}
    subscription = "hello world"
    subscriber_contact = "hello world"

    subscribe_data_exchange_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :subscribe_data_exchange, name
      assert_kind_of ::Google::Cloud::Bigquery::AnalyticsHub::V1::SubscribeDataExchangeRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["destination"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Bigquery::AnalyticsHub::V1::DestinationDataset), request["destination_dataset"]
      assert_equal "hello world", request["subscription"]
      assert_equal "hello world", request["subscriber_contact"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, subscribe_data_exchange_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.subscribe_data_exchange({ name: name, destination: destination, destination_dataset: destination_dataset, subscription: subscription, subscriber_contact: subscriber_contact }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.subscribe_data_exchange name: name, destination: destination, destination_dataset: destination_dataset, subscription: subscription, subscriber_contact: subscriber_contact do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.subscribe_data_exchange ::Google::Cloud::Bigquery::AnalyticsHub::V1::SubscribeDataExchangeRequest.new(name: name, destination: destination, destination_dataset: destination_dataset, subscription: subscription, subscriber_contact: subscriber_contact) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.subscribe_data_exchange({ name: name, destination: destination, destination_dataset: destination_dataset, subscription: subscription, subscriber_contact: subscriber_contact }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.subscribe_data_exchange(::Google::Cloud::Bigquery::AnalyticsHub::V1::SubscribeDataExchangeRequest.new(name: name, destination: destination, destination_dataset: destination_dataset, subscription: subscription, subscriber_contact: subscriber_contact), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, subscribe_data_exchange_client_stub.call_rpc_count
    end
  end

  def test_refresh_subscription
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    refresh_subscription_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :refresh_subscription, name
      assert_kind_of ::Google::Cloud::Bigquery::AnalyticsHub::V1::RefreshSubscriptionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, refresh_subscription_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.refresh_subscription({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.refresh_subscription name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.refresh_subscription ::Google::Cloud::Bigquery::AnalyticsHub::V1::RefreshSubscriptionRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.refresh_subscription({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.refresh_subscription(::Google::Cloud::Bigquery::AnalyticsHub::V1::RefreshSubscriptionRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, refresh_subscription_client_stub.call_rpc_count
    end
  end

  def test_get_subscription
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::AnalyticsHub::V1::Subscription.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_subscription_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_subscription, name
      assert_kind_of ::Google::Cloud::Bigquery::AnalyticsHub::V1::GetSubscriptionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_subscription_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_subscription({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_subscription name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_subscription ::Google::Cloud::Bigquery::AnalyticsHub::V1::GetSubscriptionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_subscription({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_subscription(::Google::Cloud::Bigquery::AnalyticsHub::V1::GetSubscriptionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_subscription_client_stub.call_rpc_count
    end
  end

  def test_list_subscriptions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::AnalyticsHub::V1::ListSubscriptionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_subscriptions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_subscriptions, name
      assert_kind_of ::Google::Cloud::Bigquery::AnalyticsHub::V1::ListSubscriptionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_subscriptions_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_subscriptions({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_subscriptions parent: parent, filter: filter, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_subscriptions ::Google::Cloud::Bigquery::AnalyticsHub::V1::ListSubscriptionsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_subscriptions({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_subscriptions(::Google::Cloud::Bigquery::AnalyticsHub::V1::ListSubscriptionsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_subscriptions_client_stub.call_rpc_count
    end
  end

  def test_list_shared_resource_subscriptions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::AnalyticsHub::V1::ListSharedResourceSubscriptionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    include_deleted_subscriptions = true
    page_size = 42
    page_token = "hello world"

    list_shared_resource_subscriptions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_shared_resource_subscriptions, name
      assert_kind_of ::Google::Cloud::Bigquery::AnalyticsHub::V1::ListSharedResourceSubscriptionsRequest, request
      assert_equal "hello world", request["resource"]
      assert_equal true, request["include_deleted_subscriptions"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_shared_resource_subscriptions_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_shared_resource_subscriptions({ resource: resource, include_deleted_subscriptions: include_deleted_subscriptions, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_shared_resource_subscriptions resource: resource, include_deleted_subscriptions: include_deleted_subscriptions, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_shared_resource_subscriptions ::Google::Cloud::Bigquery::AnalyticsHub::V1::ListSharedResourceSubscriptionsRequest.new(resource: resource, include_deleted_subscriptions: include_deleted_subscriptions, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_shared_resource_subscriptions({ resource: resource, include_deleted_subscriptions: include_deleted_subscriptions, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_shared_resource_subscriptions(::Google::Cloud::Bigquery::AnalyticsHub::V1::ListSharedResourceSubscriptionsRequest.new(resource: resource, include_deleted_subscriptions: include_deleted_subscriptions, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_shared_resource_subscriptions_client_stub.call_rpc_count
    end
  end

  def test_revoke_subscription
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::AnalyticsHub::V1::RevokeSubscriptionResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    revoke_commercial = true

    revoke_subscription_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :revoke_subscription, name
      assert_kind_of ::Google::Cloud::Bigquery::AnalyticsHub::V1::RevokeSubscriptionRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["revoke_commercial"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, revoke_subscription_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.revoke_subscription({ name: name, revoke_commercial: revoke_commercial }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.revoke_subscription name: name, revoke_commercial: revoke_commercial do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.revoke_subscription ::Google::Cloud::Bigquery::AnalyticsHub::V1::RevokeSubscriptionRequest.new(name: name, revoke_commercial: revoke_commercial) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.revoke_subscription({ name: name, revoke_commercial: revoke_commercial }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.revoke_subscription(::Google::Cloud::Bigquery::AnalyticsHub::V1::RevokeSubscriptionRequest.new(name: name, revoke_commercial: revoke_commercial), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, revoke_subscription_client_stub.call_rpc_count
    end
  end

  def test_delete_subscription
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_subscription_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_subscription, name
      assert_kind_of ::Google::Cloud::Bigquery::AnalyticsHub::V1::DeleteSubscriptionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_subscription_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_subscription({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_subscription name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_subscription ::Google::Cloud::Bigquery::AnalyticsHub::V1::DeleteSubscriptionRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_subscription({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_subscription(::Google::Cloud::Bigquery::AnalyticsHub::V1::DeleteSubscriptionRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_subscription_client_stub.call_rpc_count
    end
  end

  def test_get_iam_policy
    # Create GRPC objects.
    grpc_response = ::Google::Iam::V1::Policy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    options = {}

    get_iam_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_iam_policy, name
      assert_kind_of ::Google::Iam::V1::GetIamPolicyRequest, request
      assert_equal "hello world", request["resource"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Iam::V1::GetPolicyOptions), request["options"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_iam_policy_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_iam_policy({ resource: resource, options: options }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_iam_policy resource: resource, options: options do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_iam_policy ::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_iam_policy({ resource: resource, options: options }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_iam_policy(::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_iam_policy_client_stub.call_rpc_count
    end
  end

  def test_set_iam_policy
    # Create GRPC objects.
    grpc_response = ::Google::Iam::V1::Policy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    policy = {}
    update_mask = {}

    set_iam_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :set_iam_policy, name
      assert_kind_of ::Google::Iam::V1::SetIamPolicyRequest, request
      assert_equal "hello world", request["resource"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Iam::V1::Policy), request["policy"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, set_iam_policy_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.set_iam_policy resource: resource, policy: policy, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.set_iam_policy ::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.set_iam_policy(::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, set_iam_policy_client_stub.call_rpc_count
    end
  end

  def test_test_iam_permissions
    # Create GRPC objects.
    grpc_response = ::Google::Iam::V1::TestIamPermissionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    permissions = ["hello world"]

    test_iam_permissions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :test_iam_permissions, name
      assert_kind_of ::Google::Iam::V1::TestIamPermissionsRequest, request
      assert_equal "hello world", request["resource"]
      assert_equal ["hello world"], request["permissions"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, test_iam_permissions_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.test_iam_permissions({ resource: resource, permissions: permissions }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.test_iam_permissions resource: resource, permissions: permissions do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.test_iam_permissions ::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.test_iam_permissions({ resource: resource, permissions: permissions }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.test_iam_permissions(::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, test_iam_permissions_client_stub.call_rpc_count
    end
  end

  def test_create_query_template
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::AnalyticsHub::V1::QueryTemplate.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    query_template_id = "hello world"
    query_template = {}

    create_query_template_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_query_template, name
      assert_kind_of ::Google::Cloud::Bigquery::AnalyticsHub::V1::CreateQueryTemplateRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["query_template_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Bigquery::AnalyticsHub::V1::QueryTemplate), request["query_template"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_query_template_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_query_template({ parent: parent, query_template_id: query_template_id, query_template: query_template }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_query_template parent: parent, query_template_id: query_template_id, query_template: query_template do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_query_template ::Google::Cloud::Bigquery::AnalyticsHub::V1::CreateQueryTemplateRequest.new(parent: parent, query_template_id: query_template_id, query_template: query_template) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_query_template({ parent: parent, query_template_id: query_template_id, query_template: query_template }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_query_template(::Google::Cloud::Bigquery::AnalyticsHub::V1::CreateQueryTemplateRequest.new(parent: parent, query_template_id: query_template_id, query_template: query_template), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_query_template_client_stub.call_rpc_count
    end
  end

  def test_get_query_template
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::AnalyticsHub::V1::QueryTemplate.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_query_template_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_query_template, name
      assert_kind_of ::Google::Cloud::Bigquery::AnalyticsHub::V1::GetQueryTemplateRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_query_template_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_query_template({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_query_template name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_query_template ::Google::Cloud::Bigquery::AnalyticsHub::V1::GetQueryTemplateRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_query_template({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_query_template(::Google::Cloud::Bigquery::AnalyticsHub::V1::GetQueryTemplateRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_query_template_client_stub.call_rpc_count
    end
  end

  def test_list_query_templates
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::AnalyticsHub::V1::ListQueryTemplatesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_query_templates_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_query_templates, name
      assert_kind_of ::Google::Cloud::Bigquery::AnalyticsHub::V1::ListQueryTemplatesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_query_templates_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_query_templates({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_query_templates parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_query_templates ::Google::Cloud::Bigquery::AnalyticsHub::V1::ListQueryTemplatesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_query_templates({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_query_templates(::Google::Cloud::Bigquery::AnalyticsHub::V1::ListQueryTemplatesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_query_templates_client_stub.call_rpc_count
    end
  end

  def test_update_query_template
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::AnalyticsHub::V1::QueryTemplate.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    query_template = {}

    update_query_template_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_query_template, name
      assert_kind_of ::Google::Cloud::Bigquery::AnalyticsHub::V1::UpdateQueryTemplateRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Bigquery::AnalyticsHub::V1::QueryTemplate), request["query_template"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_query_template_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_query_template({ update_mask: update_mask, query_template: query_template }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_query_template update_mask: update_mask, query_template: query_template do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_query_template ::Google::Cloud::Bigquery::AnalyticsHub::V1::UpdateQueryTemplateRequest.new(update_mask: update_mask, query_template: query_template) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_query_template({ update_mask: update_mask, query_template: query_template }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_query_template(::Google::Cloud::Bigquery::AnalyticsHub::V1::UpdateQueryTemplateRequest.new(update_mask: update_mask, query_template: query_template), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_query_template_client_stub.call_rpc_count
    end
  end

  def test_delete_query_template
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_query_template_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_query_template, name
      assert_kind_of ::Google::Cloud::Bigquery::AnalyticsHub::V1::DeleteQueryTemplateRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_query_template_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_query_template({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_query_template name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_query_template ::Google::Cloud::Bigquery::AnalyticsHub::V1::DeleteQueryTemplateRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_query_template({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_query_template(::Google::Cloud::Bigquery::AnalyticsHub::V1::DeleteQueryTemplateRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_query_template_client_stub.call_rpc_count
    end
  end

  def test_submit_query_template
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::AnalyticsHub::V1::QueryTemplate.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    submit_query_template_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :submit_query_template, name
      assert_kind_of ::Google::Cloud::Bigquery::AnalyticsHub::V1::SubmitQueryTemplateRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, submit_query_template_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.submit_query_template({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.submit_query_template name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.submit_query_template ::Google::Cloud::Bigquery::AnalyticsHub::V1::SubmitQueryTemplateRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.submit_query_template({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.submit_query_template(::Google::Cloud::Bigquery::AnalyticsHub::V1::SubmitQueryTemplateRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, submit_query_template_client_stub.call_rpc_count
    end
  end

  def test_approve_query_template
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigquery::AnalyticsHub::V1::QueryTemplate.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    approve_query_template_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :approve_query_template, name
      assert_kind_of ::Google::Cloud::Bigquery::AnalyticsHub::V1::ApproveQueryTemplateRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, approve_query_template_client_stub do
      # Create client
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.approve_query_template({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.approve_query_template name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.approve_query_template ::Google::Cloud::Bigquery::AnalyticsHub::V1::ApproveQueryTemplateRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.approve_query_template({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.approve_query_template(::Google::Cloud::Bigquery::AnalyticsHub::V1::ApproveQueryTemplateRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, approve_query_template_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Operations, client.operations_client
  end
end
