# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/bigquery/analyticshub/v1/analyticshub_pb"
require "google/cloud/bigquery/analytics_hub/v1/analytics_hub_service/rest"


class ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_data_exchanges
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::AnalyticsHub::V1::ListDataExchangesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_data_exchanges_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::ServiceStub.stub :transcode_list_data_exchanges_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_data_exchanges_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_data_exchanges({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_data_exchanges parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_data_exchanges ::Google::Cloud::Bigquery::AnalyticsHub::V1::ListDataExchangesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_data_exchanges({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_data_exchanges(::Google::Cloud::Bigquery::AnalyticsHub::V1::ListDataExchangesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_data_exchanges_client_stub.call_count
      end
    end
  end

  def test_list_org_data_exchanges
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::AnalyticsHub::V1::ListOrgDataExchangesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    organization = "hello world"
    page_size = 42
    page_token = "hello world"

    list_org_data_exchanges_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::ServiceStub.stub :transcode_list_org_data_exchanges_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_org_data_exchanges_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_org_data_exchanges({ organization: organization, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_org_data_exchanges organization: organization, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_org_data_exchanges ::Google::Cloud::Bigquery::AnalyticsHub::V1::ListOrgDataExchangesRequest.new(organization: organization, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_org_data_exchanges({ organization: organization, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_org_data_exchanges(::Google::Cloud::Bigquery::AnalyticsHub::V1::ListOrgDataExchangesRequest.new(organization: organization, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_org_data_exchanges_client_stub.call_count
      end
    end
  end

  def test_get_data_exchange
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::AnalyticsHub::V1::DataExchange.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_data_exchange_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::ServiceStub.stub :transcode_get_data_exchange_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_data_exchange_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_data_exchange({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_data_exchange name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_data_exchange ::Google::Cloud::Bigquery::AnalyticsHub::V1::GetDataExchangeRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_data_exchange({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_data_exchange(::Google::Cloud::Bigquery::AnalyticsHub::V1::GetDataExchangeRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_data_exchange_client_stub.call_count
      end
    end
  end

  def test_create_data_exchange
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::AnalyticsHub::V1::DataExchange.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    data_exchange_id = "hello world"
    data_exchange = {}

    create_data_exchange_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::ServiceStub.stub :transcode_create_data_exchange_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_data_exchange_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_data_exchange({ parent: parent, data_exchange_id: data_exchange_id, data_exchange: data_exchange }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_data_exchange parent: parent, data_exchange_id: data_exchange_id, data_exchange: data_exchange do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_data_exchange ::Google::Cloud::Bigquery::AnalyticsHub::V1::CreateDataExchangeRequest.new(parent: parent, data_exchange_id: data_exchange_id, data_exchange: data_exchange) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_data_exchange({ parent: parent, data_exchange_id: data_exchange_id, data_exchange: data_exchange }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_data_exchange(::Google::Cloud::Bigquery::AnalyticsHub::V1::CreateDataExchangeRequest.new(parent: parent, data_exchange_id: data_exchange_id, data_exchange: data_exchange), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_data_exchange_client_stub.call_count
      end
    end
  end

  def test_update_data_exchange
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::AnalyticsHub::V1::DataExchange.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    data_exchange = {}

    update_data_exchange_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::ServiceStub.stub :transcode_update_data_exchange_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_data_exchange_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_data_exchange({ update_mask: update_mask, data_exchange: data_exchange }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_data_exchange update_mask: update_mask, data_exchange: data_exchange do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_data_exchange ::Google::Cloud::Bigquery::AnalyticsHub::V1::UpdateDataExchangeRequest.new(update_mask: update_mask, data_exchange: data_exchange) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_data_exchange({ update_mask: update_mask, data_exchange: data_exchange }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_data_exchange(::Google::Cloud::Bigquery::AnalyticsHub::V1::UpdateDataExchangeRequest.new(update_mask: update_mask, data_exchange: data_exchange), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_data_exchange_client_stub.call_count
      end
    end
  end

  def test_delete_data_exchange
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_data_exchange_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::ServiceStub.stub :transcode_delete_data_exchange_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_data_exchange_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_data_exchange({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_data_exchange name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_data_exchange ::Google::Cloud::Bigquery::AnalyticsHub::V1::DeleteDataExchangeRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_data_exchange({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_data_exchange(::Google::Cloud::Bigquery::AnalyticsHub::V1::DeleteDataExchangeRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_data_exchange_client_stub.call_count
      end
    end
  end

  def test_list_listings
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::AnalyticsHub::V1::ListListingsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_listings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::ServiceStub.stub :transcode_list_listings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_listings_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_listings({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_listings parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_listings ::Google::Cloud::Bigquery::AnalyticsHub::V1::ListListingsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_listings({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_listings(::Google::Cloud::Bigquery::AnalyticsHub::V1::ListListingsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_listings_client_stub.call_count
      end
    end
  end

  def test_get_listing
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::AnalyticsHub::V1::Listing.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_listing_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::ServiceStub.stub :transcode_get_listing_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_listing_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_listing({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_listing name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_listing ::Google::Cloud::Bigquery::AnalyticsHub::V1::GetListingRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_listing({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_listing(::Google::Cloud::Bigquery::AnalyticsHub::V1::GetListingRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_listing_client_stub.call_count
      end
    end
  end

  def test_create_listing
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::AnalyticsHub::V1::Listing.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    listing_id = "hello world"
    listing = {}

    create_listing_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::ServiceStub.stub :transcode_create_listing_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_listing_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_listing({ parent: parent, listing_id: listing_id, listing: listing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_listing parent: parent, listing_id: listing_id, listing: listing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_listing ::Google::Cloud::Bigquery::AnalyticsHub::V1::CreateListingRequest.new(parent: parent, listing_id: listing_id, listing: listing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_listing({ parent: parent, listing_id: listing_id, listing: listing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_listing(::Google::Cloud::Bigquery::AnalyticsHub::V1::CreateListingRequest.new(parent: parent, listing_id: listing_id, listing: listing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_listing_client_stub.call_count
      end
    end
  end

  def test_update_listing
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::AnalyticsHub::V1::Listing.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    listing = {}

    update_listing_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::ServiceStub.stub :transcode_update_listing_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_listing_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_listing({ update_mask: update_mask, listing: listing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_listing update_mask: update_mask, listing: listing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_listing ::Google::Cloud::Bigquery::AnalyticsHub::V1::UpdateListingRequest.new(update_mask: update_mask, listing: listing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_listing({ update_mask: update_mask, listing: listing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_listing(::Google::Cloud::Bigquery::AnalyticsHub::V1::UpdateListingRequest.new(update_mask: update_mask, listing: listing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_listing_client_stub.call_count
      end
    end
  end

  def test_delete_listing
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    delete_commercial = true

    delete_listing_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::ServiceStub.stub :transcode_delete_listing_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_listing_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_listing({ name: name, delete_commercial: delete_commercial }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_listing name: name, delete_commercial: delete_commercial do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_listing ::Google::Cloud::Bigquery::AnalyticsHub::V1::DeleteListingRequest.new(name: name, delete_commercial: delete_commercial) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_listing({ name: name, delete_commercial: delete_commercial }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_listing(::Google::Cloud::Bigquery::AnalyticsHub::V1::DeleteListingRequest.new(name: name, delete_commercial: delete_commercial), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_listing_client_stub.call_count
      end
    end
  end

  def test_subscribe_listing
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::AnalyticsHub::V1::SubscribeListingResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    destination_dataset = {}
    name = "hello world"

    subscribe_listing_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::ServiceStub.stub :transcode_subscribe_listing_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, subscribe_listing_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.subscribe_listing({ destination_dataset: destination_dataset, name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.subscribe_listing destination_dataset: destination_dataset, name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.subscribe_listing ::Google::Cloud::Bigquery::AnalyticsHub::V1::SubscribeListingRequest.new(destination_dataset: destination_dataset, name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.subscribe_listing({ destination_dataset: destination_dataset, name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.subscribe_listing(::Google::Cloud::Bigquery::AnalyticsHub::V1::SubscribeListingRequest.new(destination_dataset: destination_dataset, name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, subscribe_listing_client_stub.call_count
      end
    end
  end

  def test_subscribe_data_exchange
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    destination = "hello world"
    destination_dataset = {}
    subscription = "hello world"
    subscriber_contact = "hello world"

    subscribe_data_exchange_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::ServiceStub.stub :transcode_subscribe_data_exchange_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, subscribe_data_exchange_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.subscribe_data_exchange({ name: name, destination: destination, destination_dataset: destination_dataset, subscription: subscription, subscriber_contact: subscriber_contact }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.subscribe_data_exchange name: name, destination: destination, destination_dataset: destination_dataset, subscription: subscription, subscriber_contact: subscriber_contact do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.subscribe_data_exchange ::Google::Cloud::Bigquery::AnalyticsHub::V1::SubscribeDataExchangeRequest.new(name: name, destination: destination, destination_dataset: destination_dataset, subscription: subscription, subscriber_contact: subscriber_contact) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.subscribe_data_exchange({ name: name, destination: destination, destination_dataset: destination_dataset, subscription: subscription, subscriber_contact: subscriber_contact }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.subscribe_data_exchange(::Google::Cloud::Bigquery::AnalyticsHub::V1::SubscribeDataExchangeRequest.new(name: name, destination: destination, destination_dataset: destination_dataset, subscription: subscription, subscriber_contact: subscriber_contact), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, subscribe_data_exchange_client_stub.call_count
      end
    end
  end

  def test_refresh_subscription
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    refresh_subscription_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::ServiceStub.stub :transcode_refresh_subscription_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, refresh_subscription_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.refresh_subscription({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.refresh_subscription name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.refresh_subscription ::Google::Cloud::Bigquery::AnalyticsHub::V1::RefreshSubscriptionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.refresh_subscription({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.refresh_subscription(::Google::Cloud::Bigquery::AnalyticsHub::V1::RefreshSubscriptionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, refresh_subscription_client_stub.call_count
      end
    end
  end

  def test_get_subscription
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::AnalyticsHub::V1::Subscription.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_subscription_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::ServiceStub.stub :transcode_get_subscription_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_subscription_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_subscription({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_subscription name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_subscription ::Google::Cloud::Bigquery::AnalyticsHub::V1::GetSubscriptionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_subscription({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_subscription(::Google::Cloud::Bigquery::AnalyticsHub::V1::GetSubscriptionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_subscription_client_stub.call_count
      end
    end
  end

  def test_list_subscriptions
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::AnalyticsHub::V1::ListSubscriptionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_subscriptions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::ServiceStub.stub :transcode_list_subscriptions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_subscriptions_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_subscriptions({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_subscriptions parent: parent, filter: filter, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_subscriptions ::Google::Cloud::Bigquery::AnalyticsHub::V1::ListSubscriptionsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_subscriptions({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_subscriptions(::Google::Cloud::Bigquery::AnalyticsHub::V1::ListSubscriptionsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_subscriptions_client_stub.call_count
      end
    end
  end

  def test_list_shared_resource_subscriptions
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::AnalyticsHub::V1::ListSharedResourceSubscriptionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    include_deleted_subscriptions = true
    page_size = 42
    page_token = "hello world"

    list_shared_resource_subscriptions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::ServiceStub.stub :transcode_list_shared_resource_subscriptions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_shared_resource_subscriptions_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_shared_resource_subscriptions({ resource: resource, include_deleted_subscriptions: include_deleted_subscriptions, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_shared_resource_subscriptions resource: resource, include_deleted_subscriptions: include_deleted_subscriptions, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_shared_resource_subscriptions ::Google::Cloud::Bigquery::AnalyticsHub::V1::ListSharedResourceSubscriptionsRequest.new(resource: resource, include_deleted_subscriptions: include_deleted_subscriptions, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_shared_resource_subscriptions({ resource: resource, include_deleted_subscriptions: include_deleted_subscriptions, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_shared_resource_subscriptions(::Google::Cloud::Bigquery::AnalyticsHub::V1::ListSharedResourceSubscriptionsRequest.new(resource: resource, include_deleted_subscriptions: include_deleted_subscriptions, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_shared_resource_subscriptions_client_stub.call_count
      end
    end
  end

  def test_revoke_subscription
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::AnalyticsHub::V1::RevokeSubscriptionResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    revoke_commercial = true

    revoke_subscription_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::ServiceStub.stub :transcode_revoke_subscription_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, revoke_subscription_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.revoke_subscription({ name: name, revoke_commercial: revoke_commercial }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.revoke_subscription name: name, revoke_commercial: revoke_commercial do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.revoke_subscription ::Google::Cloud::Bigquery::AnalyticsHub::V1::RevokeSubscriptionRequest.new(name: name, revoke_commercial: revoke_commercial) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.revoke_subscription({ name: name, revoke_commercial: revoke_commercial }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.revoke_subscription(::Google::Cloud::Bigquery::AnalyticsHub::V1::RevokeSubscriptionRequest.new(name: name, revoke_commercial: revoke_commercial), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, revoke_subscription_client_stub.call_count
      end
    end
  end

  def test_delete_subscription
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_subscription_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::ServiceStub.stub :transcode_delete_subscription_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_subscription_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_subscription({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_subscription name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_subscription ::Google::Cloud::Bigquery::AnalyticsHub::V1::DeleteSubscriptionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_subscription({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_subscription(::Google::Cloud::Bigquery::AnalyticsHub::V1::DeleteSubscriptionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_subscription_client_stub.call_count
      end
    end
  end

  def test_get_iam_policy
    # Create test objects.
    client_result = ::Google::Iam::V1::Policy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    options = {}

    get_iam_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::ServiceStub.stub :transcode_get_iam_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_iam_policy_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_iam_policy({ resource: resource, options: options }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_iam_policy resource: resource, options: options do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_iam_policy ::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_iam_policy({ resource: resource, options: options }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_iam_policy(::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_iam_policy_client_stub.call_count
      end
    end
  end

  def test_set_iam_policy
    # Create test objects.
    client_result = ::Google::Iam::V1::Policy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    policy = {}
    update_mask = {}

    set_iam_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::ServiceStub.stub :transcode_set_iam_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_iam_policy_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_iam_policy resource: resource, policy: policy, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_iam_policy ::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_iam_policy(::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_iam_policy_client_stub.call_count
      end
    end
  end

  def test_test_iam_permissions
    # Create test objects.
    client_result = ::Google::Iam::V1::TestIamPermissionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    permissions = ["hello world"]

    test_iam_permissions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::ServiceStub.stub :transcode_test_iam_permissions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, test_iam_permissions_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.test_iam_permissions({ resource: resource, permissions: permissions }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.test_iam_permissions resource: resource, permissions: permissions do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.test_iam_permissions ::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.test_iam_permissions({ resource: resource, permissions: permissions }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.test_iam_permissions(::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, test_iam_permissions_client_stub.call_count
      end
    end
  end

  def test_create_query_template
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::AnalyticsHub::V1::QueryTemplate.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    query_template_id = "hello world"
    query_template = {}

    create_query_template_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::ServiceStub.stub :transcode_create_query_template_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_query_template_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_query_template({ parent: parent, query_template_id: query_template_id, query_template: query_template }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_query_template parent: parent, query_template_id: query_template_id, query_template: query_template do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_query_template ::Google::Cloud::Bigquery::AnalyticsHub::V1::CreateQueryTemplateRequest.new(parent: parent, query_template_id: query_template_id, query_template: query_template) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_query_template({ parent: parent, query_template_id: query_template_id, query_template: query_template }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_query_template(::Google::Cloud::Bigquery::AnalyticsHub::V1::CreateQueryTemplateRequest.new(parent: parent, query_template_id: query_template_id, query_template: query_template), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_query_template_client_stub.call_count
      end
    end
  end

  def test_get_query_template
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::AnalyticsHub::V1::QueryTemplate.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_query_template_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::ServiceStub.stub :transcode_get_query_template_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_query_template_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_query_template({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_query_template name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_query_template ::Google::Cloud::Bigquery::AnalyticsHub::V1::GetQueryTemplateRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_query_template({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_query_template(::Google::Cloud::Bigquery::AnalyticsHub::V1::GetQueryTemplateRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_query_template_client_stub.call_count
      end
    end
  end

  def test_list_query_templates
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::AnalyticsHub::V1::ListQueryTemplatesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_query_templates_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::ServiceStub.stub :transcode_list_query_templates_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_query_templates_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_query_templates({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_query_templates parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_query_templates ::Google::Cloud::Bigquery::AnalyticsHub::V1::ListQueryTemplatesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_query_templates({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_query_templates(::Google::Cloud::Bigquery::AnalyticsHub::V1::ListQueryTemplatesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_query_templates_client_stub.call_count
      end
    end
  end

  def test_update_query_template
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::AnalyticsHub::V1::QueryTemplate.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    query_template = {}

    update_query_template_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::ServiceStub.stub :transcode_update_query_template_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_query_template_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_query_template({ update_mask: update_mask, query_template: query_template }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_query_template update_mask: update_mask, query_template: query_template do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_query_template ::Google::Cloud::Bigquery::AnalyticsHub::V1::UpdateQueryTemplateRequest.new(update_mask: update_mask, query_template: query_template) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_query_template({ update_mask: update_mask, query_template: query_template }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_query_template(::Google::Cloud::Bigquery::AnalyticsHub::V1::UpdateQueryTemplateRequest.new(update_mask: update_mask, query_template: query_template), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_query_template_client_stub.call_count
      end
    end
  end

  def test_delete_query_template
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_query_template_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::ServiceStub.stub :transcode_delete_query_template_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_query_template_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_query_template({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_query_template name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_query_template ::Google::Cloud::Bigquery::AnalyticsHub::V1::DeleteQueryTemplateRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_query_template({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_query_template(::Google::Cloud::Bigquery::AnalyticsHub::V1::DeleteQueryTemplateRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_query_template_client_stub.call_count
      end
    end
  end

  def test_submit_query_template
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::AnalyticsHub::V1::QueryTemplate.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    submit_query_template_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::ServiceStub.stub :transcode_submit_query_template_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, submit_query_template_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.submit_query_template({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.submit_query_template name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.submit_query_template ::Google::Cloud::Bigquery::AnalyticsHub::V1::SubmitQueryTemplateRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.submit_query_template({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.submit_query_template(::Google::Cloud::Bigquery::AnalyticsHub::V1::SubmitQueryTemplateRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, submit_query_template_client_stub.call_count
      end
    end
  end

  def test_approve_query_template
    # Create test objects.
    client_result = ::Google::Cloud::Bigquery::AnalyticsHub::V1::QueryTemplate.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    approve_query_template_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::ServiceStub.stub :transcode_approve_query_template_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, approve_query_template_client_stub do
        # Create client
        client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.approve_query_template({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.approve_query_template name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.approve_query_template ::Google::Cloud::Bigquery::AnalyticsHub::V1::ApproveQueryTemplateRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.approve_query_template({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.approve_query_template(::Google::Cloud::Bigquery::AnalyticsHub::V1::ApproveQueryTemplateRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, approve_query_template_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Bigquery::AnalyticsHub::V1::AnalyticsHubService::Rest::Client::Configuration, config
  end
end
