# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Bigquery
      module AnalyticsHub
        module V1
          # Defines the destination Pub/Sub subscription.
          # If none of `push_config`, `bigquery_config`, `cloud_storage_config`,
          # `pubsub_export_config`, or `pubsublite_export_config`
          # is set, then the subscriber will pull and ack messages using API methods. At
          # most one of these fields may be set.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Name of the subscription.
          #     Format is `projects/{project}/subscriptions/{sub}`.
          # @!attribute [rw] push_config
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::PushConfig]
          #     Optional. If push delivery is used with this subscription, this field is
          #     used to configure it.
          # @!attribute [rw] bigquery_config
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::BigQueryConfig]
          #     Optional. If delivery to BigQuery is used with this subscription, this
          #     field is used to configure it.
          # @!attribute [rw] cloud_storage_config
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::CloudStorageConfig]
          #     Optional. If delivery to Google Cloud Storage is used with this
          #     subscription, this field is used to configure it.
          # @!attribute [rw] ack_deadline_seconds
          #   @return [::Integer]
          #     Optional. The approximate amount of time (on a best-effort basis) Pub/Sub
          #     waits for the subscriber to acknowledge receipt before resending the
          #     message. In the interval after the message is delivered and before it is
          #     acknowledged, it is considered to be _outstanding_. During that time
          #     period, the message will not be redelivered (on a best-effort basis).
          #
          #     For pull subscriptions, this value is used as the initial value for the ack
          #     deadline. To override this value for a given message, call
          #     `ModifyAckDeadline` with the corresponding `ack_id` if using
          #     non-streaming pull or send the `ack_id` in a
          #     `StreamingModifyAckDeadlineRequest` if using streaming pull.
          #     The minimum custom deadline you can specify is 10 seconds.
          #     The maximum custom deadline you can specify is 600 seconds (10 minutes).
          #     If this parameter is 0, a default value of 10 seconds is used.
          #
          #     For push delivery, this value is also used to set the request timeout for
          #     the call to the push endpoint.
          #
          #     If the subscriber never acknowledges the message, the Pub/Sub
          #     system will eventually redeliver the message.
          # @!attribute [rw] retain_acked_messages
          #   @return [::Boolean]
          #     Optional. Indicates whether to retain acknowledged messages. If true, then
          #     messages are not expunged from the subscription's backlog, even if they are
          #     acknowledged, until they fall out of the `message_retention_duration`
          #     window. This must be true if you would like to [`Seek` to a timestamp]
          #     (https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time) in
          #     the past to replay previously-acknowledged messages.
          # @!attribute [rw] message_retention_duration
          #   @return [::Google::Protobuf::Duration]
          #     Optional. How long to retain unacknowledged messages in the subscription's
          #     backlog, from the moment a message is published. If `retain_acked_messages`
          #     is true, then this also configures the retention of acknowledged messages,
          #     and thus configures how far back in time a `Seek` can be done. Defaults to
          #     7 days. Cannot be more than 31 days or less than 10 minutes.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. See [Creating and managing
          #     labels](https://cloud.google.com/pubsub/docs/labels).
          # @!attribute [rw] enable_message_ordering
          #   @return [::Boolean]
          #     Optional. If true, messages published with the same `ordering_key` in
          #     `PubsubMessage` will be delivered to the subscribers in the order in which
          #     they are received by the Pub/Sub system. Otherwise, they may be delivered
          #     in any order.
          # @!attribute [rw] expiration_policy
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::ExpirationPolicy]
          #     Optional. A policy that specifies the conditions for this subscription's
          #     expiration. A subscription is considered active as long as any connected
          #     subscriber is successfully consuming messages from the subscription or is
          #     issuing operations on the subscription. If `expiration_policy` is not set,
          #     a *default policy* with `ttl` of 31 days will be used. The minimum allowed
          #     value for `expiration_policy.ttl` is 1 day. If `expiration_policy` is set,
          #     but `expiration_policy.ttl` is not set, the subscription never expires.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Optional. An expression written in the Pub/Sub [filter
          #     language](https://cloud.google.com/pubsub/docs/filtering). If non-empty,
          #     then only `PubsubMessage`s whose `attributes` field matches the filter are
          #     delivered on this subscription. If empty, then no messages are filtered
          #     out.
          # @!attribute [rw] dead_letter_policy
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::DeadLetterPolicy]
          #     Optional. A policy that specifies the conditions for dead lettering
          #     messages in this subscription. If dead_letter_policy is not set, dead
          #     lettering is disabled.
          #
          #     The Pub/Sub service account associated with this subscriptions's
          #     parent project (i.e.,
          #     service-\\{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
          #     permission to Acknowledge() messages on this subscription.
          # @!attribute [rw] retry_policy
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::RetryPolicy]
          #     Optional. A policy that specifies how Pub/Sub retries message delivery for
          #     this subscription.
          #
          #     If not set, the default retry policy is applied. This generally implies
          #     that messages will be retried as soon as possible for healthy subscribers.
          #     RetryPolicy will be triggered on NACKs or acknowledgement deadline
          #     exceeded events for a given message.
          # @!attribute [rw] detached
          #   @return [::Boolean]
          #     Optional. Indicates whether the subscription is detached from its topic.
          #     Detached subscriptions don't receive messages from their topic and don't
          #     retain any backlog. `Pull` and `StreamingPull` requests will return
          #     FAILED_PRECONDITION. If the subscription is a push subscription, pushes to
          #     the endpoint will not be made.
          # @!attribute [rw] enable_exactly_once_delivery
          #   @return [::Boolean]
          #     Optional. If true, Pub/Sub provides the following guarantees for the
          #     delivery of a message with a given value of `message_id` on this
          #     subscription:
          #
          #     * The message sent to a subscriber is guaranteed not to be resent
          #     before the message's acknowledgement deadline expires.
          #     * An acknowledged message will not be resent to a subscriber.
          #
          #     Note that subscribers may still receive multiple copies of a message
          #     when `enable_exactly_once_delivery` is true if the message was published
          #     multiple times by a publisher client. These copies are  considered distinct
          #     by Pub/Sub and have distinct `message_id` values.
          # @!attribute [rw] message_transforms
          #   @return [::Array<::Google::Cloud::Bigquery::AnalyticsHub::V1::MessageTransform>]
          #     Optional. Transforms to be applied to messages before they are delivered to
          #     subscribers. Transforms are applied in the order specified.
          # @!attribute [rw] tags
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. Input only. Immutable. Tag keys/values directly bound to this
          #     resource. For example:
          #       "123/environment": "production",
          #       "123/costCenter": "marketing"
          class PubSubSubscription
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class TagsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # A policy that specifies how Pub/Sub retries message delivery.
          #
          # Retry delay will be exponential based on provided minimum and maximum
          # backoffs. https://en.wikipedia.org/wiki/Exponential_backoff.
          #
          # RetryPolicy will be triggered on NACKs or acknowledgement deadline exceeded
          # events for a given message.
          #
          # Retry Policy is implemented on a best effort basis. At times, the delay
          # between consecutive deliveries may not match the configuration. That is,
          # delay can be more or less than configured backoff.
          # @!attribute [rw] minimum_backoff
          #   @return [::Google::Protobuf::Duration]
          #     Optional. The minimum delay between consecutive deliveries of a given
          #     message. Value should be between 0 and 600 seconds. Defaults to 10 seconds.
          # @!attribute [rw] maximum_backoff
          #   @return [::Google::Protobuf::Duration]
          #     Optional. The maximum delay between consecutive deliveries of a given
          #     message. Value should be between 0 and 600 seconds. Defaults to 600
          #     seconds.
          class RetryPolicy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Dead lettering is done on a best effort basis. The same message might be
          # dead lettered multiple times.
          #
          # If validation on any of the fields fails at subscription creation/updation,
          # the create/update subscription request will fail.
          # @!attribute [rw] dead_letter_topic
          #   @return [::String]
          #     Optional. The name of the topic to which dead letter messages should be
          #     published. Format is `projects/{project}/topics/{topic}`.The Pub/Sub
          #     service account associated with the enclosing subscription's parent project
          #     (i.e., service-\\{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must
          #     have permission to Publish() to this topic.
          #
          #     The operation will fail if the topic does not exist.
          #     Users should ensure that there is a subscription attached to this topic
          #     since messages published to a topic with no subscriptions are lost.
          # @!attribute [rw] max_delivery_attempts
          #   @return [::Integer]
          #     Optional. The maximum number of delivery attempts for any message. The
          #     value must be between 5 and 100.
          #
          #     The number of delivery attempts is defined as 1 + (the sum of number of
          #     NACKs and number of times the acknowledgement deadline has been exceeded
          #     for the message).
          #
          #     A NACK is any call to ModifyAckDeadline with a 0 deadline. Note that
          #     client libraries may automatically extend ack_deadlines.
          #
          #     This field will be honored on a best effort basis.
          #
          #     If this parameter is 0, a default value of 5 is used.
          class DeadLetterPolicy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A policy that specifies the conditions for resource expiration (i.e.,
          # automatic resource deletion).
          # @!attribute [rw] ttl
          #   @return [::Google::Protobuf::Duration]
          #     Optional. Specifies the "time-to-live" duration for an associated resource.
          #     The resource expires if it is not active for a period of `ttl`. The
          #     definition of "activity" depends on the type of the associated resource.
          #     The minimum and maximum allowed values for `ttl` depend on the type of the
          #     associated resource, as well. If `ttl` is not set, the associated resource
          #     never expires.
          class ExpirationPolicy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration for a push delivery endpoint.
          # @!attribute [rw] oidc_token
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::PushConfig::OidcToken]
          #     Optional. If specified, Pub/Sub will generate and attach an OIDC JWT
          #     token as an `Authorization` header in the HTTP request for every pushed
          #     message.
          # @!attribute [rw] pubsub_wrapper
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::PushConfig::PubsubWrapper]
          #     Optional. When set, the payload to the push endpoint is in the form of
          #     the JSON representation of a PubsubMessage
          #     (https://cloud.google.com/pubsub/docs/reference/rpc/google.pubsub.v1#pubsubmessage).
          #
          #     Note: The following fields are mutually exclusive: `pubsub_wrapper`, `no_wrapper`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] no_wrapper
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::PushConfig::NoWrapper]
          #     Optional. When set, the payload to the push endpoint is not wrapped.
          #
          #     Note: The following fields are mutually exclusive: `no_wrapper`, `pubsub_wrapper`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] push_endpoint
          #   @return [::String]
          #     Optional. A URL locating the endpoint to which messages should be pushed.
          #     For example, a Webhook endpoint might use `https://example.com/push`.
          # @!attribute [rw] attributes
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. Endpoint configuration attributes that can be used to control
          #     different aspects of the message delivery.
          #
          #     The only currently supported attribute is `x-goog-version`, which you can
          #     use to change the format of the pushed message. This attribute
          #     indicates the version of the data expected by the endpoint. This
          #     controls the shape of the pushed message (i.e., its fields and metadata).
          #
          #     If not present during the `CreateSubscription` call, it will default to
          #     the version of the Pub/Sub API used to make such call. If not present in a
          #     `ModifyPushConfig` call, its value will not be changed. `GetSubscription`
          #     calls will always return a valid version, even if the subscription was
          #     created without this attribute.
          #
          #     The only supported values for the `x-goog-version` attribute are:
          #
          #     * `v1beta1`: uses the push format defined in the v1beta1 Pub/Sub API.
          #     * `v1` or `v1beta2`: uses the push format defined in the v1 Pub/Sub API.
          #
          #     For example:
          #     `attributes { "x-goog-version": "v1" }`
          class PushConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Contains information needed for generating an
            # [OpenID Connect
            # token](https://developers.google.com/identity/protocols/OpenIDConnect).
            # @!attribute [rw] service_account_email
            #   @return [::String]
            #     Optional. [Service account
            #     email](https://cloud.google.com/iam/docs/service-accounts)
            #     used for generating the OIDC token. For more information
            #     on setting up authentication, see
            #     [Push subscriptions](https://cloud.google.com/pubsub/docs/push).
            # @!attribute [rw] audience
            #   @return [::String]
            #     Optional. Audience to be used when generating OIDC token. The audience
            #     claim identifies the recipients that the JWT is intended for. The
            #     audience value is a single case-sensitive string. Having multiple values
            #     (array) for the audience field is not supported. More info about the OIDC
            #     JWT token audience here:
            #     https://tools.ietf.org/html/rfc7519#section-4.1.3 Note: if not specified,
            #     the Push endpoint URL will be used.
            class OidcToken
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The payload to the push endpoint is in the form of the JSON representation
            # of a PubsubMessage
            # (https://cloud.google.com/pubsub/docs/reference/rpc/google.pubsub.v1#pubsubmessage).
            class PubsubWrapper
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Sets the `data` field as the HTTP body for delivery.
            # @!attribute [rw] write_metadata
            #   @return [::Boolean]
            #     Optional. When true, writes the Pub/Sub message metadata to
            #     `x-goog-pubsub-<KEY>:<VAL>` headers of the HTTP request. Writes the
            #     Pub/Sub message attributes to `<KEY>:<VAL>` headers of the HTTP request.
            class NoWrapper
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class AttributesEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Configuration for a BigQuery subscription.
          # @!attribute [rw] table
          #   @return [::String]
          #     Optional. The name of the table to which to write data, of the form
          #     \\{projectId}.\\{datasetId}.\\{tableId}
          # @!attribute [rw] use_topic_schema
          #   @return [::Boolean]
          #     Optional. When true, use the topic's schema as the columns to write to in
          #     BigQuery, if it exists. `use_topic_schema` and `use_table_schema` cannot be
          #     enabled at the same time.
          # @!attribute [rw] write_metadata
          #   @return [::Boolean]
          #     Optional. When true, write the subscription name, message_id, publish_time,
          #     attributes, and ordering_key to additional columns in the table. The
          #     subscription name, message_id, and publish_time fields are put in their own
          #     columns while all other message properties (other than data) are written to
          #     a JSON object in the attributes column.
          # @!attribute [rw] drop_unknown_fields
          #   @return [::Boolean]
          #     Optional. When true and use_topic_schema is true, any fields that are a
          #     part of the topic schema that are not part of the BigQuery table schema are
          #     dropped when writing to BigQuery. Otherwise, the schemas must be kept in
          #     sync and any messages with extra fields are not written and remain in the
          #     subscription's backlog.
          # @!attribute [rw] use_table_schema
          #   @return [::Boolean]
          #     Optional. When true, use the BigQuery table's schema as the columns to
          #     write to in BigQuery. `use_table_schema` and `use_topic_schema` cannot be
          #     enabled at the same time.
          # @!attribute [rw] service_account_email
          #   @return [::String]
          #     Optional. The service account to use to write to BigQuery. The subscription
          #     creator or updater that specifies this field must have
          #     `iam.serviceAccounts.actAs` permission on the service account. If not
          #     specified, the Pub/Sub [service
          #     agent](https://cloud.google.com/iam/docs/service-agents),
          #     service-\\{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com, is used.
          class BigQueryConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration for a Cloud Storage subscription.
          # @!attribute [rw] text_config
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::CloudStorageConfig::TextConfig]
          #     Optional. If set, message data will be written to Cloud Storage in text
          #     format.
          #
          #     Note: The following fields are mutually exclusive: `text_config`, `avro_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] avro_config
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::CloudStorageConfig::AvroConfig]
          #     Optional. If set, message data will be written to Cloud Storage in Avro
          #     format.
          #
          #     Note: The following fields are mutually exclusive: `avro_config`, `text_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] bucket
          #   @return [::String]
          #     Required. User-provided name for the Cloud Storage bucket.
          #     The bucket must be created by the user. The bucket name must be without
          #     any prefix like "gs://". See the [bucket naming
          #     requirements] (https://cloud.google.com/storage/docs/buckets#naming).
          # @!attribute [rw] filename_prefix
          #   @return [::String]
          #     Optional. User-provided prefix for Cloud Storage filename. See the [object
          #     naming requirements](https://cloud.google.com/storage/docs/objects#naming).
          # @!attribute [rw] filename_suffix
          #   @return [::String]
          #     Optional. User-provided suffix for Cloud Storage filename. See the [object
          #     naming requirements](https://cloud.google.com/storage/docs/objects#naming).
          #     Must not end in "/".
          # @!attribute [rw] filename_datetime_format
          #   @return [::String]
          #     Optional. User-provided format string specifying how to represent datetimes
          #     in Cloud Storage filenames. See the [datetime format
          #     guidance](https://cloud.google.com/pubsub/docs/create-cloudstorage-subscription#file_names).
          # @!attribute [rw] max_duration
          #   @return [::Google::Protobuf::Duration]
          #     Optional. File batching settings.
          #     If no max_duration setting is specified, a max_duration of 5 minutes will
          #     be set by default. max_duration is required regardless of whether other
          #     file batching settings are specified.
          #
          #     The maximum duration that can elapse before a new Cloud Storage file is
          #     created. Min 1 minute, max 10 minutes, default 5 minutes. May not exceed
          #     the subscription's acknowledgement deadline.
          # @!attribute [rw] max_bytes
          #   @return [::Integer]
          #     Optional. The maximum bytes that can be written to a Cloud Storage file
          #     before a new file is created. Min 1 KB, max 10 GiB. The max_bytes limit may
          #     be exceeded in cases where messages are larger than the limit.
          # @!attribute [rw] max_messages
          #   @return [::Integer]
          #     Optional. The maximum number of messages that can be written to a Cloud
          #     Storage file before a new file is created. Min 1000 messages.
          # @!attribute [rw] service_account_email
          #   @return [::String]
          #     Optional. The service account to use to write to Cloud Storage. The
          #     subscription creator or updater that specifies this field must have
          #     `iam.serviceAccounts.actAs` permission on the service account. If not
          #     specified, the Pub/Sub
          #     [service agent](https://cloud.google.com/iam/docs/service-agents),
          #     service-\\{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com, is used.
          class CloudStorageConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Configuration for writing message data in text format.
            # Message payloads will be written to files as raw text, separated by a
            # newline.
            class TextConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Configuration for writing message data in Avro format.
            # Message payloads and metadata will be written to files as an Avro binary.
            # @!attribute [rw] write_metadata
            #   @return [::Boolean]
            #     Optional. When true, write the subscription name, message_id,
            #     publish_time, attributes, and ordering_key as additional fields in the
            #     output. The subscription name, message_id, and publish_time fields are
            #     put in their own fields while all other message properties other than
            #     data (for example, an ordering_key, if present) are added as entries in
            #     the attributes map.
            # @!attribute [rw] use_topic_schema
            #   @return [::Boolean]
            #     Optional. When true, the output Cloud Storage file will be serialized
            #     using the topic schema, if it exists.
            class AvroConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # All supported message transforms types.
          # @!attribute [rw] javascript_udf
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::JavaScriptUDF]
          #     Optional. JavaScript User Defined Function. If multiple JavaScriptUDF's
          #     are specified on a resource, each must have a unique `function_name`.
          # @!attribute [rw] enabled
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Boolean]
          #     Optional. This field is deprecated, use the `disabled` field to disable
          #     transforms.
          # @!attribute [rw] disabled
          #   @return [::Boolean]
          #     Optional. If true, the transform is disabled and will not be applied to
          #     messages. Defaults to `false`.
          class MessageTransform
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # User-defined JavaScript function that can transform or filter a Pub/Sub
          # message.
          # @!attribute [rw] function_name
          #   @return [::String]
          #     Required. Name of the JavasScript function that should applied to Pub/Sub
          #     messages.
          # @!attribute [rw] code
          #   @return [::String]
          #     Required. JavaScript code that contains a function `function_name` with the
          #     below signature:
          #
          #     ```
          #       /**
          #       * Transforms a Pub/Sub message.
          #
          #       * @return \\{(Object<string, (string | Object<string, string>)>|null)} - To
          #       * filter a message, return `null`. To transform a message return a map
          #       * with the following keys:
          #       *   - (required) 'data' : \\{string}
          #       *   - (optional) 'attributes' : \\{Object<string, string>}
          #       * Returning empty `attributes` will remove all attributes from the
          #       * message.
          #       *
          #       * @param  \\{(Object<string, (string | Object<string, string>)>} Pub/Sub
          #       * message. Keys:
          #       *   - (required) 'data' : \\{string}
          #       *   - (required) 'attributes' : \\{Object<string, string>}
          #       *
          #       * @param  \\{Object<string, any>} metadata - Pub/Sub message metadata.
          #       * Keys:
          #       *   - (required) 'message_id'  : \\{string}
          #       *   - (optional) 'publish_time': \\{string} YYYY-MM-DDTHH:MM:SSZ format
          #       *   - (optional) 'ordering_key': \\{string}
          #       */
          #
          #       function <function_name>(message, metadata) {
          #       }
          #     ```
          class JavaScriptUDF
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
