# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Bigquery
      module AnalyticsHub
        module V1
          # A data exchange is a container that lets you share data. Along with the
          # descriptive information about the data exchange, it contains listings that
          # reference shared datasets.
          # @!attribute [r] name
          #   @return [::String]
          #     Output only. The resource name of the data exchange.
          #     e.g. `projects/myproject/locations/us/dataExchanges/123`.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     Required. Human-readable display name of the data exchange. The display
          #     name must contain only Unicode letters, numbers (0-9), underscores (_),
          #     dashes (-), spaces ( ), ampersands (&) and must not start or end with
          #     spaces. Default value is an empty string. Max length: 63 bytes.
          # @!attribute [rw] description
          #   @return [::String]
          #     Optional. Description of the data exchange. The description must not
          #     contain Unicode non-characters as well as C0 and C1 control codes except
          #     tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF).
          #     Default value is an empty string.
          #     Max length: 2000 bytes.
          # @!attribute [rw] primary_contact
          #   @return [::String]
          #     Optional. Email or URL of the primary point of contact of the data
          #     exchange. Max Length: 1000 bytes.
          # @!attribute [rw] documentation
          #   @return [::String]
          #     Optional. Documentation describing the data exchange.
          # @!attribute [r] listing_count
          #   @return [::Integer]
          #     Output only. Number of listings contained in the data exchange.
          # @!attribute [rw] icon
          #   @return [::String]
          #     Optional. Base64 encoded image representing the data exchange. Max
          #     Size: 3.0MiB Expected image dimensions are 512x512 pixels, however the API
          #     only performs validation on size of the encoded data. Note: For byte
          #     fields, the content of the fields are base64-encoded (which increases the
          #     size of the data by 33-36%) when using JSON on the wire.
          # @!attribute [rw] sharing_environment_config
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::SharingEnvironmentConfig]
          #     Optional. Configurable data sharing environment option for a data exchange.
          # @!attribute [rw] discovery_type
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::DiscoveryType]
          #     Optional. Type of discovery on the discovery page for all the listings
          #     under this exchange. Updating this field also updates (overwrites) the
          #     discovery_type field for all the listings under this exchange.
          # @!attribute [rw] log_linked_dataset_query_user_email
          #   @return [::Boolean]
          #     Optional. By default, false.
          #     If true, the DataExchange has an email sharing mandate enabled.
          class DataExchange
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A query template is a container for sharing table-valued functions defined by
          # contributors in a data clean room.
          # @!attribute [r] name
          #   @return [::String]
          #     Output only. The resource name of the QueryTemplate.
          #     e.g. `projects/myproject/locations/us/dataExchanges/123/queryTemplates/456`
          # @!attribute [rw] display_name
          #   @return [::String]
          #     Required. Human-readable display name of the QueryTemplate. The display
          #     name must contain only Unicode letters, numbers (0-9), underscores (_),
          #     dashes (-), spaces ( ), ampersands (&) and can't start or end with spaces.
          #     Default value is an empty string. Max length: 63 bytes.
          # @!attribute [rw] description
          #   @return [::String]
          #     Optional. Short description of the QueryTemplate. The description must not
          #     contain Unicode non-characters and C0 and C1 control codes except tabs
          #     (HT), new lines (LF), carriage returns (CR), and page breaks (FF). Default
          #     value is an empty string. Max length: 2000 bytes.
          # @!attribute [rw] proposer
          #   @return [::String]
          #     Optional. Will be deprecated.
          #     Email or URL of the primary point of contact of the QueryTemplate.
          #     Max Length: 1000 bytes.
          # @!attribute [rw] primary_contact
          #   @return [::String]
          #     Optional. Email or URL of the primary point of contact of the
          #     QueryTemplate. Max Length: 1000 bytes.
          # @!attribute [rw] documentation
          #   @return [::String]
          #     Optional. Documentation describing the QueryTemplate.
          # @!attribute [r] state
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::QueryTemplate::State]
          #     Output only. The QueryTemplate lifecycle state.
          # @!attribute [rw] routine
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::Routine]
          #     Optional. The routine associated with the QueryTemplate.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. Timestamp when the QueryTemplate was created.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. Timestamp when the QueryTemplate was last modified.
          class QueryTemplate
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The QueryTemplate lifecycle state.
            module State
              # Default value. This value is unused.
              STATE_UNSPECIFIED = 0

              # The QueryTemplate is in draft state.
              DRAFTED = 1

              # The QueryTemplate is in pending state.
              PENDING = 2

              # The QueryTemplate is in deleted state.
              DELETED = 3

              # The QueryTemplate is in approved state.
              APPROVED = 4
            end
          end

          # Represents a bigquery routine.
          # @!attribute [rw] routine_type
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::Routine::RoutineType]
          #     Required. The type of routine.
          # @!attribute [rw] definition_body
          #   @return [::String]
          #     Optional. The definition body of the routine.
          class Routine
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Represents the type of a given routine.
            module RoutineType
              # Default value.
              ROUTINE_TYPE_UNSPECIFIED = 0

              # Non-built-in persistent TVF.
              TABLE_VALUED_FUNCTION = 1
            end
          end

          # Message for creating a QueryTemplate.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent resource path of the QueryTemplate.
          #     e.g.
          #     `projects/myproject/locations/us/dataExchanges/123/queryTemplates/myQueryTemplate`.
          # @!attribute [rw] query_template_id
          #   @return [::String]
          #     Required. The ID of the QueryTemplate to create.
          #     Must contain only Unicode letters, numbers (0-9), underscores (_).
          #     Max length: 100 bytes.
          # @!attribute [rw] query_template
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::QueryTemplate]
          #     Required. The QueryTemplate to create.
          class CreateQueryTemplateRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for creating a QueryTemplate.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The parent resource path of the QueryTemplate.
          #     e.g.
          #     `projects/myproject/locations/us/dataExchanges/123/queryTemplates/myqueryTemplate`.
          class GetQueryTemplateRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for requesting the list of QueryTemplates.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent resource path of the QueryTemplates.
          #     e.g. `projects/myproject/locations/us/dataExchanges/123`.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. The maximum number of results to return in a single response
          #     page. Leverage the page tokens to iterate through the entire collection.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. Page token, returned by a previous call, to request the next page
          #     of results.
          class ListQueryTemplatesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for response to the list of QueryTemplates.
          # @!attribute [rw] query_templates
          #   @return [::Array<::Google::Cloud::Bigquery::AnalyticsHub::V1::QueryTemplate>]
          #     The list of QueryTemplates.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token to request the next page of results.
          class ListQueryTemplatesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for updating a QueryTemplate.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Optional. Field mask specifies the fields to update in the query template
          #     resource. The fields specified in the `updateMask` are relative to the
          #     resource and are not a full request.
          # @!attribute [rw] query_template
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::QueryTemplate]
          #     Required. The QueryTemplate to update.
          class UpdateQueryTemplateRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for deleting a QueryTemplate.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource path of the QueryTemplate.
          #     e.g.
          #     `projects/myproject/locations/us/dataExchanges/123/queryTemplates/myqueryTemplate`.
          class DeleteQueryTemplateRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for submitting a QueryTemplate.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource path of the QueryTemplate.
          #     e.g.
          #     `projects/myproject/locations/us/dataExchanges/123/queryTemplates/myqueryTemplate`.
          class SubmitQueryTemplateRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for approving a QueryTemplate.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource path of the QueryTemplate.
          #     e.g.
          #     `projects/myproject/locations/us/dataExchanges/123/queryTemplates/myqueryTemplate`.
          class ApproveQueryTemplateRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Sharing environment is a behavior model for sharing data within a
          # data exchange. This option is configurable for a data exchange.
          # @!attribute [rw] default_exchange_config
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::SharingEnvironmentConfig::DefaultExchangeConfig]
          #     Default Analytics Hub data exchange, used for secured data sharing.
          #
          #     Note: The following fields are mutually exclusive: `default_exchange_config`, `dcr_exchange_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] dcr_exchange_config
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::SharingEnvironmentConfig::DcrExchangeConfig]
          #     Data Clean Room (DCR), used for privacy-safe and secured data sharing.
          #
          #     Note: The following fields are mutually exclusive: `dcr_exchange_config`, `default_exchange_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class SharingEnvironmentConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Default Analytics Hub data exchange, used for secured data sharing.
            class DefaultExchangeConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Data Clean Room (DCR), used for privacy-safe and secured data sharing.
            # @!attribute [r] single_selected_resource_sharing_restriction
            #   @return [::Boolean]
            #     Output only. If True, this DCR restricts the contributors to sharing
            #     only a single resource in a Listing. And no two resources should have the
            #     same IDs. So if a contributor adds a view with a conflicting name, the
            #     CreateListing API will reject the request. if False, the data contributor
            #     can publish an entire dataset (as before). This is not configurable, and
            #     by default, all new DCRs will have the restriction set to True.
            # @!attribute [r] single_linked_dataset_per_cleanroom
            #   @return [::Boolean]
            #     Output only. If True, when subscribing to this DCR, it will create only
            #     one linked dataset containing all resources shared within the
            #     cleanroom. If False, when subscribing to this DCR, it will
            #     create 1 linked dataset per listing. This is not configurable, and by
            #     default, all new DCRs will have the restriction set to True.
            class DcrExchangeConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Contains details of the data provider.
          # @!attribute [rw] name
          #   @return [::String]
          #     Optional. Name of the data provider.
          # @!attribute [rw] primary_contact
          #   @return [::String]
          #     Optional. Email or URL of the data provider.
          #     Max Length: 1000 bytes.
          class DataProvider
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Contains details of the listing publisher.
          # @!attribute [rw] name
          #   @return [::String]
          #     Optional. Name of the listing publisher.
          # @!attribute [rw] primary_contact
          #   @return [::String]
          #     Optional. Email or URL of the listing publisher.
          #     Max Length: 1000 bytes.
          class Publisher
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] dataset_id
          #   @return [::String]
          #     Required. A unique ID for this dataset, without the project name. The ID
          #     must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_).
          #     The maximum length is 1,024 characters.
          # @!attribute [rw] project_id
          #   @return [::String]
          #     Required. The ID of the project containing this dataset.
          class DestinationDatasetReference
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Defines the destination bigquery dataset.
          # @!attribute [rw] dataset_reference
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::DestinationDatasetReference]
          #     Required. A reference that identifies the destination dataset.
          # @!attribute [rw] friendly_name
          #   @return [::Google::Protobuf::StringValue]
          #     Optional. A descriptive name for the dataset.
          # @!attribute [rw] description
          #   @return [::Google::Protobuf::StringValue]
          #     Optional. A user-friendly description of the dataset.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. The labels associated with this dataset. You can use these
          #     to organize and group your datasets.
          #     You can set this property when inserting or updating a dataset.
          #     See https://cloud.google.com/resource-manager/docs/creating-managing-labels
          #     for more information.
          # @!attribute [rw] location
          #   @return [::String]
          #     Required. The geographic location where the dataset should reside. See
          #     https://cloud.google.com/bigquery/docs/locations for supported
          #     locations.
          # @!attribute [rw] replica_locations
          #   @return [::Array<::String>]
          #     Optional. The geographic locations where the dataset should be replicated.
          #     See [BigQuery locations](https://cloud.google.com/bigquery/docs/locations)
          #     for supported locations.
          class DestinationDataset
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Defines the destination Pub/Sub subscription.
          # @!attribute [rw] pubsub_subscription
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::PubSubSubscription]
          #     Required. Destination Pub/Sub subscription resource.
          class DestinationPubSubSubscription
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A listing is what gets published into a data exchange that a subscriber can
          # subscribe to. It contains a reference to the data source along with
          # descriptive information that will help subscribers find and subscribe the
          # data.
          # @!attribute [rw] bigquery_dataset
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::Listing::BigQueryDatasetSource]
          #     Shared dataset i.e. BigQuery dataset source.
          #
          #     Note: The following fields are mutually exclusive: `bigquery_dataset`, `pubsub_topic`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] pubsub_topic
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::Listing::PubSubTopicSource]
          #     Pub/Sub topic source.
          #
          #     Note: The following fields are mutually exclusive: `pubsub_topic`, `bigquery_dataset`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [r] name
          #   @return [::String]
          #     Output only. The resource name of the listing.
          #     e.g. `projects/myproject/locations/us/dataExchanges/123/listings/456`
          # @!attribute [rw] display_name
          #   @return [::String]
          #     Required. Human-readable display name of the listing. The display name must
          #     contain only Unicode letters, numbers (0-9), underscores (_), dashes (-),
          #     spaces ( ), ampersands (&) and can't start or end with spaces. Default
          #     value is an empty string. Max length: 63 bytes.
          # @!attribute [rw] description
          #   @return [::String]
          #     Optional. Short description of the listing. The description must not
          #     contain Unicode non-characters and C0 and C1 control codes except tabs
          #     (HT), new lines (LF), carriage returns (CR), and page breaks (FF). Default
          #     value is an empty string. Max length: 2000 bytes.
          # @!attribute [rw] primary_contact
          #   @return [::String]
          #     Optional. Email or URL of the primary point of contact of the listing.
          #     Max Length: 1000 bytes.
          # @!attribute [rw] documentation
          #   @return [::String]
          #     Optional. Documentation describing the listing.
          # @!attribute [r] state
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::Listing::State]
          #     Output only. Current state of the listing.
          # @!attribute [rw] icon
          #   @return [::String]
          #     Optional. Base64 encoded image representing the listing. Max Size: 3.0MiB
          #     Expected image dimensions are 512x512 pixels, however the API only
          #     performs validation on size of the encoded data.
          #     Note: For byte fields, the contents of the field are base64-encoded (which
          #     increases the size of the data by 33-36%) when using JSON on the wire.
          # @!attribute [rw] data_provider
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::DataProvider]
          #     Optional. Details of the data provider who owns the source data.
          # @!attribute [rw] categories
          #   @return [::Array<::Google::Cloud::Bigquery::AnalyticsHub::V1::Listing::Category>]
          #     Optional. Categories of the listing. Up to five categories are allowed.
          # @!attribute [rw] publisher
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::Publisher]
          #     Optional. Details of the publisher who owns the listing and who can share
          #     the source data.
          # @!attribute [rw] request_access
          #   @return [::String]
          #     Optional. Email or URL of the request access of the listing.
          #     Subscribers can use this reference to request access.
          #     Max Length: 1000 bytes.
          # @!attribute [rw] restricted_export_config
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::Listing::RestrictedExportConfig]
          #     Optional. If set, restricted export configuration will be propagated and
          #     enforced on the linked dataset.
          # @!attribute [rw] stored_procedure_config
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::StoredProcedureConfig]
          #     Optional. If set, stored procedure configuration will be propagated and
          #     enforced on the linked dataset.
          # @!attribute [rw] discovery_type
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::DiscoveryType]
          #     Optional. Type of discovery of the listing on the discovery page.
          # @!attribute [r] resource_type
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::SharedResourceType]
          #     Output only. Listing shared asset type.
          # @!attribute [r] commercial_info
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::Listing::CommercialInfo]
          #     Output only. Commercial info contains the information about the commercial
          #     data products associated with the listing.
          # @!attribute [rw] log_linked_dataset_query_user_email
          #   @return [::Boolean]
          #     Optional. By default, false.
          #     If true, the Listing has an email sharing mandate enabled.
          # @!attribute [rw] allow_only_metadata_sharing
          #   @return [::Boolean]
          #     Optional. If true, the listing is only available to get the resource
          #     metadata. Listing is non subscribable.
          class Listing
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # A reference to a shared dataset. It is an existing BigQuery dataset with a
            # collection of objects such as tables and views that you want to share
            # with subscribers.
            # When subscriber's subscribe to a listing, Analytics Hub creates a linked
            # dataset in
            # the subscriber's project. A Linked dataset is an opaque, read-only BigQuery
            # dataset that serves as a _symbolic link_ to a shared dataset.
            # @!attribute [rw] dataset
            #   @return [::String]
            #     Optional. Resource name of the dataset source for this listing.
            #     e.g. `projects/myproject/datasets/123`
            # @!attribute [rw] selected_resources
            #   @return [::Array<::Google::Cloud::Bigquery::AnalyticsHub::V1::Listing::BigQueryDatasetSource::SelectedResource>]
            #     Optional. Resource in this dataset that is selectively shared.
            #     This field is required for data clean room exchanges.
            # @!attribute [rw] restricted_export_policy
            #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::Listing::BigQueryDatasetSource::RestrictedExportPolicy]
            #     Optional. If set, restricted export policy will be propagated and
            #     enforced on the linked dataset.
            # @!attribute [rw] replica_locations
            #   @return [::Array<::String>]
            #     Optional. A list of regions where the publisher has created shared
            #     dataset replicas.
            # @!attribute [r] effective_replicas
            #   @return [::Array<::Google::Cloud::Bigquery::AnalyticsHub::V1::Listing::BigQueryDatasetSource::Replica>]
            #     Output only. Server-owned effective state of replicas.
            #     Contains both primary and secondary replicas.
            #     Each replica includes a system-computed (output-only) state and primary
            #     designation.
            class BigQueryDatasetSource
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Resource in this dataset that is selectively shared.
              # @!attribute [rw] table
              #   @return [::String]
              #     Optional. Format:
              #     For table:
              #     `projects/{projectId}/datasets/{datasetId}/tables/{tableId}`
              #     Example:"projects/test_project/datasets/test_dataset/tables/test_table"
              #
              #     Note: The following fields are mutually exclusive: `table`, `routine`. If a field in that set is populated, all other fields in the set will automatically be cleared.
              # @!attribute [rw] routine
              #   @return [::String]
              #     Optional. Format:
              #     For routine:
              #     `projects/{projectId}/datasets/{datasetId}/routines/{routineId}`
              #     Example:"projects/test_project/datasets/test_dataset/routines/test_routine"
              #
              #     Note: The following fields are mutually exclusive: `routine`, `table`. If a field in that set is populated, all other fields in the set will automatically be cleared.
              class SelectedResource
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # Restricted export policy used to configure restricted export on linked
              # dataset.
              # @!attribute [rw] enabled
              #   @return [::Google::Protobuf::BoolValue]
              #     Optional. If true, enable restricted export.
              # @!attribute [rw] restrict_direct_table_access
              #   @return [::Google::Protobuf::BoolValue]
              #     Optional. If true, restrict direct table access (read
              #     api/tabledata.list) on linked table.
              # @!attribute [rw] restrict_query_result
              #   @return [::Google::Protobuf::BoolValue]
              #     Optional. If true, restrict export of query result derived from
              #     restricted linked dataset table.
              class RestrictedExportPolicy
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # Represents the state of a replica of a shared dataset.
              # It includes the geographic location of the replica and
              # system-computed, output-only fields indicating its replication state and
              # whether it is the primary replica.
              # @!attribute [r] location
              #   @return [::String]
              #     Output only. The geographic location where the replica resides. See
              #     [BigQuery locations](https://cloud.google.com/bigquery/docs/locations)
              #     for supported locations. Eg. "us-central1".
              # @!attribute [r] replica_state
              #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::Listing::BigQueryDatasetSource::Replica::ReplicaState]
              #     Output only. Assigned by Analytics Hub based on real BigQuery
              #     replication state.
              # @!attribute [r] primary_state
              #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::Listing::BigQueryDatasetSource::Replica::PrimaryState]
              #     Output only. Indicates that this replica is the primary replica.
              class Replica
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods

                # Replica state of the shared dataset.
                module ReplicaState
                  # Default value. This value is unused.
                  REPLICA_STATE_UNSPECIFIED = 0

                  # The replica is backfilled and ready to use.
                  READY_TO_USE = 1

                  # The replica is unavailable, does not exist, or has not been
                  # backfilled yet.
                  UNAVAILABLE = 2
                end

                # Primary state of the replica. Set only for the primary replica.
                module PrimaryState
                  # Default value. This value is unused.
                  PRIMARY_STATE_UNSPECIFIED = 0

                  # The replica is the primary replica.
                  PRIMARY_REPLICA = 1
                end
              end
            end

            # Pub/Sub topic source.
            # @!attribute [rw] topic
            #   @return [::String]
            #     Required. Resource name of the Pub/Sub topic source for this listing.
            #     e.g. projects/myproject/topics/topicId
            # @!attribute [rw] data_affinity_regions
            #   @return [::Array<::String>]
            #     Optional. Region hint on where the data might be published. Data affinity
            #     regions are modifiable. See https://cloud.google.com/about/locations for
            #     full listing of possible Cloud regions.
            class PubSubTopicSource
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Restricted export config, used to configure restricted export on linked
            # dataset.
            # @!attribute [rw] enabled
            #   @return [::Boolean]
            #     Optional. If true, enable restricted export.
            # @!attribute [r] restrict_direct_table_access
            #   @return [::Boolean]
            #     Output only. If true, restrict direct table access(read
            #     api/tabledata.list) on linked table.
            # @!attribute [rw] restrict_query_result
            #   @return [::Boolean]
            #     Optional. If true, restrict export of query result derived from
            #     restricted linked dataset table.
            class RestrictedExportConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Commercial info contains the information about the commercial data products
            # associated with the listing.
            # @!attribute [r] cloud_marketplace
            #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::Listing::CommercialInfo::GoogleCloudMarketplaceInfo]
            #     Output only. Details of the Marketplace Data Product associated with the
            #     Listing.
            class CommercialInfo
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Specifies the details of the Marketplace Data Product associated with the
              # Listing.
              # @!attribute [r] service
              #   @return [::String]
              #     Output only. Resource name of the commercial service associated with
              #     the Marketplace Data Product. e.g. example.com
              # @!attribute [r] commercial_state
              #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::Listing::CommercialInfo::GoogleCloudMarketplaceInfo::CommercialState]
              #     Output only. Commercial state of the Marketplace Data Product.
              class GoogleCloudMarketplaceInfo
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods

                # Indicates whether this commercial access is currently active.
                module CommercialState
                  # Commercialization is incomplete and cannot be used.
                  COMMERCIAL_STATE_UNSPECIFIED = 0

                  # Commercialization has been initialized.
                  ONBOARDING = 1

                  # Commercialization is complete and available for use.
                  ACTIVE = 2
                end
              end
            end

            # State of the listing.
            module State
              # Default value. This value is unused.
              STATE_UNSPECIFIED = 0

              # Subscribable state. Users with dataexchange.listings.subscribe permission
              # can subscribe to this listing.
              ACTIVE = 1
            end

            # Listing categories.
            module Category
              CATEGORY_UNSPECIFIED = 0

              CATEGORY_OTHERS = 1

              CATEGORY_ADVERTISING_AND_MARKETING = 2

              CATEGORY_COMMERCE = 3

              CATEGORY_CLIMATE_AND_ENVIRONMENT = 4

              CATEGORY_DEMOGRAPHICS = 5

              CATEGORY_ECONOMICS = 6

              CATEGORY_EDUCATION = 7

              CATEGORY_ENERGY = 8

              CATEGORY_FINANCIAL = 9

              CATEGORY_GAMING = 10

              CATEGORY_GEOSPATIAL = 11

              CATEGORY_HEALTHCARE_AND_LIFE_SCIENCE = 12

              CATEGORY_MEDIA = 13

              CATEGORY_PUBLIC_SECTOR = 14

              CATEGORY_RETAIL = 15

              CATEGORY_SPORTS = 16

              CATEGORY_SCIENCE_AND_RESEARCH = 17

              CATEGORY_TRANSPORTATION_AND_LOGISTICS = 18

              CATEGORY_TRAVEL_AND_TOURISM = 19

              CATEGORY_GOOGLE_EARTH_ENGINE = 20
            end
          end

          # Stored procedure configuration, used to configure stored procedure sharing
          # on linked dataset.
          # @!attribute [rw] enabled
          #   @return [::Boolean]
          #     Optional. If true, enable sharing of stored procedure.
          # @!attribute [r] allowed_stored_procedure_types
          #   @return [::Array<::Google::Cloud::Bigquery::AnalyticsHub::V1::StoredProcedureConfig::StoredProcedureType>]
          #     Output only. Types of stored procedure supported to share.
          class StoredProcedureConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Enum to specify the type of stored procedure to share.
            module StoredProcedureType
              # Default value. This value is unused.
              STORED_PROCEDURE_TYPE_UNSPECIFIED = 0

              # SQL stored procedure.
              SQL_PROCEDURE = 1
            end
          end

          # A subscription represents a subscribers' access to a particular set of
          # published data. It contains references to associated listings,
          # data exchanges, and linked datasets.
          # @!attribute [r] listing
          #   @return [::String]
          #     Output only. Resource name of the source Listing.
          #     e.g. projects/123/locations/us/dataExchanges/456/listings/789
          #
          #     Note: The following fields are mutually exclusive: `listing`, `data_exchange`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [r] data_exchange
          #   @return [::String]
          #     Output only. Resource name of the source Data Exchange.
          #     e.g. projects/123/locations/us/dataExchanges/456
          #
          #     Note: The following fields are mutually exclusive: `data_exchange`, `listing`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [r] name
          #   @return [::String]
          #     Output only. The resource name of the subscription.
          #     e.g. `projects/myproject/locations/us/subscriptions/123`.
          # @!attribute [r] creation_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. Timestamp when the subscription was created.
          # @!attribute [r] last_modify_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. Timestamp when the subscription was last modified.
          # @!attribute [r] organization_id
          #   @return [::String]
          #     Output only. Organization of the project this subscription belongs to.
          # @!attribute [r] organization_display_name
          #   @return [::String]
          #     Output only. Display name of the project of this subscription.
          # @!attribute [r] state
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::Subscription::State]
          #     Output only. Current state of the subscription.
          # @!attribute [r] linked_dataset_map
          #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Bigquery::AnalyticsHub::V1::Subscription::LinkedResource}]
          #     Output only. Map of listing resource names to associated linked resource,
          #     e.g. projects/123/locations/us/dataExchanges/456/listings/789
          #     ->
          #     projects/123/datasets/my_dataset
          #
          #     For listing-level subscriptions, this is a map of size 1.
          #     Only contains values if state == STATE_ACTIVE.
          # @!attribute [r] subscriber_contact
          #   @return [::String]
          #     Output only. Email of the subscriber.
          # @!attribute [r] linked_resources
          #   @return [::Array<::Google::Cloud::Bigquery::AnalyticsHub::V1::Subscription::LinkedResource>]
          #     Output only. Linked resources created in the subscription. Only contains
          #     values if state = STATE_ACTIVE.
          # @!attribute [r] resource_type
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::SharedResourceType]
          #     Output only. Listing shared asset type.
          # @!attribute [r] commercial_info
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::Subscription::CommercialInfo]
          #     Output only. This is set if this is a commercial subscription i.e. if this
          #     subscription was created from subscribing to a commercial listing.
          # @!attribute [r] log_linked_dataset_query_user_email
          #   @return [::Boolean]
          #     Output only. By default, false.
          #     If true, the Subscriber agreed to the email sharing mandate
          #     that is enabled for DataExchange/Listing.
          # @!attribute [rw] destination_dataset
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::DestinationDataset]
          #     Optional. BigQuery destination dataset to create for the subscriber.
          class Subscription
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Reference to a linked resource tracked by this Subscription.
            # @!attribute [r] linked_dataset
            #   @return [::String]
            #     Output only. Name of the linked dataset, e.g.
            #     projects/subscriberproject/datasets/linked_dataset
            #
            #     Note: The following fields are mutually exclusive: `linked_dataset`, `linked_pubsub_subscription`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [r] linked_pubsub_subscription
            #   @return [::String]
            #     Output only. Name of the Pub/Sub subscription, e.g.
            #     projects/subscriberproject/subscriptions/subscriptions/sub_id
            #
            #     Note: The following fields are mutually exclusive: `linked_pubsub_subscription`, `linked_dataset`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [r] listing
            #   @return [::String]
            #     Output only. Listing for which linked resource is created.
            class LinkedResource
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Commercial info metadata for this subscription.
            # @!attribute [r] cloud_marketplace
            #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::Subscription::CommercialInfo::GoogleCloudMarketplaceInfo]
            #     Output only. This is set when the subscription is commercialised via
            #     Cloud Marketplace.
            class CommercialInfo
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Cloud Marketplace commercial metadata for this subscription.
              # @!attribute [rw] order
              #   @return [::String]
              #     Resource name of the Marketplace Order.
              class GoogleCloudMarketplaceInfo
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::Subscription::LinkedResource]
            class LinkedDatasetMapEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # State of the subscription.
            module State
              # Default value. This value is unused.
              STATE_UNSPECIFIED = 0

              # This subscription is active and the data is accessible.
              STATE_ACTIVE = 1

              # The data referenced by this subscription is out of date and should be
              # refreshed. This can happen when a data provider adds or removes datasets.
              STATE_STALE = 2

              # This subscription has been cancelled or revoked and the data is no longer
              # accessible.
              STATE_INACTIVE = 3
            end
          end

          # Message for requesting the list of data exchanges.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent resource path of the data exchanges.
          #     e.g. `projects/myproject/locations/us`.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of results to return in a single response page. Leverage
          #     the page tokens to iterate through the entire collection.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Page token, returned by a previous call, to request the next page of
          #     results.
          class ListDataExchangesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for response to the list of data exchanges.
          # @!attribute [rw] data_exchanges
          #   @return [::Array<::Google::Cloud::Bigquery::AnalyticsHub::V1::DataExchange>]
          #     The list of data exchanges.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token to request the next page of results.
          class ListDataExchangesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for requesting the list of data exchanges from projects in an
          # organization and location.
          # @!attribute [rw] organization
          #   @return [::String]
          #     Required. The organization resource path of the projects containing
          #     DataExchanges. e.g. `organizations/myorg/locations/us`.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of results to return in a single response page. Leverage
          #     the page tokens to iterate through the entire collection.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Page token, returned by a previous call, to request the next page of
          #     results.
          class ListOrgDataExchangesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for response to listing data exchanges in an organization and
          # location.
          # @!attribute [rw] data_exchanges
          #   @return [::Array<::Google::Cloud::Bigquery::AnalyticsHub::V1::DataExchange>]
          #     The list of data exchanges.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token to request the next page of results.
          class ListOrgDataExchangesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for getting a data exchange.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the data exchange.
          #     e.g. `projects/myproject/locations/us/dataExchanges/123`.
          class GetDataExchangeRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for creating a data exchange.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent resource path of the data exchange.
          #     e.g. `projects/myproject/locations/us`.
          # @!attribute [rw] data_exchange_id
          #   @return [::String]
          #     Required. The ID of the data exchange.
          #     Must contain only Unicode letters, numbers (0-9), underscores (_).
          #     Max length: 100 bytes.
          # @!attribute [rw] data_exchange
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::DataExchange]
          #     Required. The data exchange to create.
          class CreateDataExchangeRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for updating a data exchange.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Required. Field mask specifies the fields to update in the data exchange
          #     resource. The fields specified in the
          #     `updateMask` are relative to the resource and are not a full request.
          # @!attribute [rw] data_exchange
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::DataExchange]
          #     Required. The data exchange to update.
          class UpdateDataExchangeRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for deleting a data exchange.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The full name of the data exchange resource that you want to
          #     delete. For example, `projects/myproject/locations/us/dataExchanges/123`.
          class DeleteDataExchangeRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for requesting the list of listings.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent resource path of the listing.
          #     e.g. `projects/myproject/locations/us/dataExchanges/123`.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of results to return in a single response page. Leverage
          #     the page tokens to iterate through the entire collection.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Page token, returned by a previous call, to request the next page of
          #     results.
          class ListListingsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for response to the list of Listings.
          # @!attribute [rw] listings
          #   @return [::Array<::Google::Cloud::Bigquery::AnalyticsHub::V1::Listing>]
          #     The list of Listing.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token to request the next page of results.
          class ListListingsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for getting a listing.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the listing.
          #     e.g. `projects/myproject/locations/us/dataExchanges/123/listings/456`.
          class GetListingRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for creating a listing.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent resource path of the listing.
          #     e.g. `projects/myproject/locations/us/dataExchanges/123`.
          # @!attribute [rw] listing_id
          #   @return [::String]
          #     Required. The ID of the listing to create.
          #     Must contain only Unicode letters, numbers (0-9), underscores (_).
          #     Max length: 100 bytes.
          # @!attribute [rw] listing
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::Listing]
          #     Required. The listing to create.
          class CreateListingRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for updating a Listing.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Required. Field mask specifies the fields to update in the listing
          #     resource. The fields specified in the `updateMask` are relative to the
          #     resource and are not a full request.
          # @!attribute [rw] listing
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::Listing]
          #     Required. The listing to update.
          class UpdateListingRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for deleting a listing.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Resource name of the listing to delete.
          #     e.g. `projects/myproject/locations/us/dataExchanges/123/listings/456`.
          # @!attribute [rw] delete_commercial
          #   @return [::Boolean]
          #     Optional. If the listing is commercial then this field must be set to true,
          #     otherwise a failure is thrown. This acts as a safety guard to avoid
          #     deleting commercial listings accidentally.
          class DeleteListingRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for subscribing to a listing.
          # @!attribute [rw] destination_dataset
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::DestinationDataset]
          #     Input only. BigQuery destination dataset to create for the subscriber.
          #
          #     Note: The following fields are mutually exclusive: `destination_dataset`, `destination_pubsub_subscription`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] destination_pubsub_subscription
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::DestinationPubSubSubscription]
          #     Input only. Destination Pub/Sub subscription to create for the
          #     subscriber.
          #
          #     Note: The following fields are mutually exclusive: `destination_pubsub_subscription`, `destination_dataset`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Resource name of the listing that you want to subscribe to.
          #     e.g. `projects/myproject/locations/us/dataExchanges/123/listings/456`.
          class SubscribeListingRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for response when you subscribe to a listing.
          # @!attribute [rw] subscription
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::Subscription]
          #     Subscription object created from this subscribe action.
          class SubscribeListingResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for subscribing to a Data Exchange.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Resource name of the Data Exchange.
          #     e.g. `projects/publisherproject/locations/us/dataExchanges/123`
          # @!attribute [rw] destination
          #   @return [::String]
          #     Required. The parent resource path of the Subscription.
          #     e.g. `projects/subscriberproject/locations/us`
          # @!attribute [rw] destination_dataset
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::DestinationDataset]
          #     Optional. BigQuery destination dataset to create for the subscriber.
          # @!attribute [rw] subscription
          #   @return [::String]
          #     Required. Name of the subscription to create.
          #     e.g. `subscription1`
          # @!attribute [rw] subscriber_contact
          #   @return [::String]
          #     Email of the subscriber.
          class SubscribeDataExchangeRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for response when you subscribe to a Data Exchange.
          # @!attribute [rw] subscription
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::Subscription]
          #     Subscription object created from this subscribe action.
          class SubscribeDataExchangeResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for refreshing a subscription.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Resource name of the Subscription to refresh.
          #     e.g. `projects/subscriberproject/locations/us/subscriptions/123`
          class RefreshSubscriptionRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for response when you refresh a subscription.
          # @!attribute [rw] subscription
          #   @return [::Google::Cloud::Bigquery::AnalyticsHub::V1::Subscription]
          #     The refreshed subscription resource.
          class RefreshSubscriptionResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for getting a subscription.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Resource name of the subscription.
          #     e.g. projects/123/locations/us/subscriptions/456
          class GetSubscriptionRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for listing subscriptions.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent resource path of the subscription.
          #     e.g. projects/myproject/locations/us
          # @!attribute [rw] filter
          #   @return [::String]
          #     An expression for filtering the results of the request. Eligible
          #     fields for filtering are:
          #
          #      + `listing`
          #      + `data_exchange`
          #
          #     Alternatively, a literal wrapped in double quotes may be provided.
          #     This will be checked for an exact match against both fields above.
          #
          #     In all cases, the full Data Exchange or Listing resource name must
          #     be provided. Some example of using filters:
          #
          #      + data_exchange="projects/myproject/locations/us/dataExchanges/123"
          #      + listing="projects/123/locations/us/dataExchanges/456/listings/789"
          #      + "projects/myproject/locations/us/dataExchanges/123"
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of results to return in a single response page.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Page token, returned by a previous call.
          class ListSubscriptionsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for response to the listing of subscriptions.
          # @!attribute [rw] subscriptions
          #   @return [::Array<::Google::Cloud::Bigquery::AnalyticsHub::V1::Subscription>]
          #     The list of subscriptions.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     Next page token.
          class ListSubscriptionsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for listing subscriptions of a shared resource.
          # @!attribute [rw] resource
          #   @return [::String]
          #     Required. Resource name of the requested target. This resource may be
          #     either a Listing or a DataExchange. e.g.
          #     projects/123/locations/us/dataExchanges/456 OR e.g.
          #     projects/123/locations/us/dataExchanges/456/listings/789
          # @!attribute [rw] include_deleted_subscriptions
          #   @return [::Boolean]
          #     If selected, includes deleted subscriptions in the response
          #     (up to 63 days after deletion).
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of results to return in a single response page.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Page token, returned by a previous call.
          class ListSharedResourceSubscriptionsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for response to the listing of shared resource subscriptions.
          # @!attribute [rw] shared_resource_subscriptions
          #   @return [::Array<::Google::Cloud::Bigquery::AnalyticsHub::V1::Subscription>]
          #     The list of subscriptions.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     Next page token.
          class ListSharedResourceSubscriptionsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for revoking a subscription.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Resource name of the subscription to revoke.
          #     e.g. projects/123/locations/us/subscriptions/456
          # @!attribute [rw] revoke_commercial
          #   @return [::Boolean]
          #     Optional. If the subscription is commercial then this field must be set to
          #     true, otherwise a failure is thrown. This acts as a safety guard to avoid
          #     revoking commercial subscriptions accidentally.
          class RevokeSubscriptionRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for response when you revoke a subscription.
          # Empty for now.
          class RevokeSubscriptionResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for deleting a subscription.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Resource name of the subscription to delete.
          #     e.g. projects/123/locations/us/subscriptions/456
          class DeleteSubscriptionRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents the metadata of a long-running operation in Analytics Hub.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time the operation was created.
          # @!attribute [r] end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time the operation finished running.
          # @!attribute [r] target
          #   @return [::String]
          #     Output only. Server-defined resource path for the target of the operation.
          # @!attribute [r] verb
          #   @return [::String]
          #     Output only. Name of the verb executed by the operation.
          # @!attribute [r] status_message
          #   @return [::String]
          #     Output only. Human-readable status of the operation, if any.
          # @!attribute [r] requested_cancellation
          #   @return [::Boolean]
          #     Output only. Identifies whether the user has requested cancellation
          #     of the operation. Operations that have successfully been cancelled
          #     have [Operation.error][] value with a
          #     {::Google::Rpc::Status#code google.rpc.Status.code} of 1, corresponding to
          #     `Code.CANCELLED`.
          # @!attribute [r] api_version
          #   @return [::String]
          #     Output only. API version used to start the operation.
          class OperationMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Specifies the type of discovery on the discovery page. Note that
          # this does not control the visibility of the exchange/listing which is
          # defined by IAM permission.
          module DiscoveryType
            # Unspecified. Defaults to DISCOVERY_TYPE_PRIVATE.
            DISCOVERY_TYPE_UNSPECIFIED = 0

            # The Data exchange/listing can be discovered in the 'Private' results
            # list.
            DISCOVERY_TYPE_PRIVATE = 1

            # The Data exchange/listing can be discovered in the 'Public' results
            # list.
            DISCOVERY_TYPE_PUBLIC = 2
          end

          # The underlying shared asset type shared in a listing by a publisher.
          module SharedResourceType
            # Not specified.
            SHARED_RESOURCE_TYPE_UNSPECIFIED = 0

            # BigQuery Dataset Asset.
            BIGQUERY_DATASET = 1

            # Pub/Sub Topic Asset.
            PUBSUB_TOPIC = 2
          end
        end
      end
    end
  end
end
