# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Bigquery
      module AnalyticsHub
        module V1
          module AnalyticsHubService
            # Path helper methods for the AnalyticsHubService API.
            module Paths
              ##
              # Create a fully-qualified DataExchange resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}/dataExchanges/{data_exchange}`
              #
              # @param project [String]
              # @param location [String]
              # @param data_exchange [String]
              #
              # @return [::String]
              def data_exchange_path project:, location:, data_exchange:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                "projects/#{project}/locations/#{location}/dataExchanges/#{data_exchange}"
              end

              ##
              # Create a fully-qualified Dataset resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/datasets/{dataset}`
              #
              # @param project [String]
              # @param dataset [String]
              #
              # @return [::String]
              def dataset_path project:, dataset:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                "projects/#{project}/datasets/#{dataset}"
              end

              ##
              # Create a fully-qualified Listing resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}/dataExchanges/{data_exchange}/listings/{listing}`
              #
              # @param project [String]
              # @param location [String]
              # @param data_exchange [String]
              # @param listing [String]
              #
              # @return [::String]
              def listing_path project:, location:, data_exchange:, listing:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                raise ::ArgumentError, "data_exchange cannot contain /" if data_exchange.to_s.include? "/"

                "projects/#{project}/locations/#{location}/dataExchanges/#{data_exchange}/listings/#{listing}"
              end

              ##
              # Create a fully-qualified Location resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}`
              #
              # @param project [String]
              # @param location [String]
              #
              # @return [::String]
              def location_path project:, location:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                "projects/#{project}/locations/#{location}"
              end

              ##
              # Create a fully-qualified ManagedService resource string.
              #
              # The resource will be in the following format:
              #
              # `services/{service}`
              #
              # @param service [String]
              #
              # @return [::String]
              def managed_service_path service:
                "services/#{service}"
              end

              ##
              # Create a fully-qualified QueryTemplate resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}/dataExchanges/{data_exchange}/queryTemplates/{query_template}`
              #
              # @param project [String]
              # @param location [String]
              # @param data_exchange [String]
              # @param query_template [String]
              #
              # @return [::String]
              def query_template_path project:, location:, data_exchange:, query_template:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                raise ::ArgumentError, "data_exchange cannot contain /" if data_exchange.to_s.include? "/"

                "projects/#{project}/locations/#{location}/dataExchanges/#{data_exchange}/queryTemplates/#{query_template}"
              end

              ##
              # Create a fully-qualified Routine resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/datasets/{dataset}/routines/{routine}`
              #
              # @param project [String]
              # @param dataset [String]
              # @param routine [String]
              #
              # @return [::String]
              def routine_path project:, dataset:, routine:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "dataset cannot contain /" if dataset.to_s.include? "/"

                "projects/#{project}/datasets/#{dataset}/routines/#{routine}"
              end

              ##
              # Create a fully-qualified Subscription resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}/subscriptions/{subscription}`
              #
              # @param project [String]
              # @param location [String]
              # @param subscription [String]
              #
              # @return [::String]
              def subscription_path project:, location:, subscription:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                "projects/#{project}/locations/#{location}/subscriptions/#{subscription}"
              end

              ##
              # Create a fully-qualified Table resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/datasets/{dataset}/tables/{table}`
              #
              # @param project [String]
              # @param dataset [String]
              # @param table [String]
              #
              # @return [::String]
              def table_path project:, dataset:, table:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "dataset cannot contain /" if dataset.to_s.include? "/"

                "projects/#{project}/datasets/#{dataset}/tables/#{table}"
              end

              ##
              # Create a fully-qualified Topic resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/topics/{topic}`
              #
              # @param project [String]
              # @param topic [String]
              #
              # @return [::String]
              def topic_path project:, topic:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                "projects/#{project}/topics/#{topic}"
              end

              extend self
            end
          end
        end
      end
    end
  end
end
