# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module BeyondCorp
      module ClientGateways
        module V1
          # Message describing ClientGateway object.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. name of resource. The name is ignored during creation.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. [Output only] Create time stamp.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. [Output only] Update time stamp.
          # @!attribute [r] state
          #   @return [::Google::Cloud::BeyondCorp::ClientGateways::V1::ClientGateway::State]
          #     Output only. The operational state of the gateway.
          # @!attribute [r] id
          #   @return [::String]
          #     Output only. A unique identifier for the instance generated by the system.
          # @!attribute [r] client_connector_service
          #   @return [::String]
          #     Output only. The client connector service name that the client gateway is
          #     associated to. Client Connector Services, named as follows:
          #       `projects/{project_id}/locations/{location_id}/client_connector_services/{client_connector_service_id}`.
          class ClientGateway
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Represents the different states of a gateway.
            module State
              # Default value. This value is unused.
              STATE_UNSPECIFIED = 0

              # Gateway is being created.
              CREATING = 1

              # Gateway is being updated.
              UPDATING = 2

              # Gateway is being deleted.
              DELETING = 3

              # Gateway is running.
              RUNNING = 4

              # Gateway is down and may be restored in the future.
              # This happens when CCFE sends ProjectState = OFF.
              DOWN = 5

              # ClientGateway encountered an error and is in indeterministic state.
              ERROR = 6
            end
          end

          # Message for requesting list of ClientGateways.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. Parent value for ListClientGatewaysRequest.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. Requested page size. Server may return fewer items than
          #     requested. If unspecified, server will pick an appropriate default.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. A token identifying a page of results the server should return.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Optional. Filtering results.
          # @!attribute [rw] order_by
          #   @return [::String]
          #     Optional. Hint for how to order the results.
          class ListClientGatewaysRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for response to listing ClientGateways.
          # @!attribute [rw] client_gateways
          #   @return [::Array<::Google::Cloud::BeyondCorp::ClientGateways::V1::ClientGateway>]
          #     The list of ClientGateway.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token identifying a page of results the server should return.
          # @!attribute [rw] unreachable
          #   @return [::Array<::String>]
          #     Locations that could not be reached.
          class ListClientGatewaysResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for getting a ClientGateway.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Name of the resource
          class GetClientGatewayRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for creating a ClientGateway.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. Value for parent.
          # @!attribute [rw] client_gateway_id
          #   @return [::String]
          #     Optional. User-settable client gateway resource ID.
          #      * Must start with a letter.
          #      * Must contain between 4-63 characters from `/[a-z][0-9]-/`.
          #      * Must end with a number or a letter.
          # @!attribute [rw] client_gateway
          #   @return [::Google::Cloud::BeyondCorp::ClientGateways::V1::ClientGateway]
          #     Required. The resource being created.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An optional request ID to identify requests. Specify a unique
          #     request ID so that if you must retry your request, the server will know to
          #     ignore the request if it has already been completed. The server will
          #     guarantee that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and t
          #     he request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     Optional. If set, validates request by executing a dry-run which would not
          #     alter the resource in any way.
          class CreateClientGatewayRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for deleting a ClientGateway
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Name of the resource
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An optional request ID to identify requests. Specify a unique
          #     request ID so that if you must retry your request, the server will know to
          #     ignore the request if it has already been completed. The server will
          #     guarantee that for at least 60 minutes after the first request.
          #
          #     For example, consider a situation where you make an initial request and t
          #     he request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     Optional. If set, validates request by executing a dry-run which would not
          #     alter the resource in any way.
          class DeleteClientGatewayRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents the metadata of the long-running operation.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time the operation was created.
          # @!attribute [r] end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time the operation finished running.
          # @!attribute [r] target
          #   @return [::String]
          #     Output only. Server-defined resource path for the target of the operation.
          # @!attribute [r] verb
          #   @return [::String]
          #     Output only. Name of the verb executed by the operation.
          # @!attribute [r] status_message
          #   @return [::String]
          #     Output only. Human-readable status of the operation, if any.
          # @!attribute [r] requested_cancellation
          #   @return [::Boolean]
          #     Output only. Identifies whether the user has requested cancellation
          #     of the operation. Operations that have been cancelled successfully
          #     have [Operation.error][] value with a
          #     {::Google::Rpc::Status#code google.rpc.Status.code} of 1, corresponding to
          #     `Code.CANCELLED`.
          # @!attribute [r] api_version
          #   @return [::String]
          #     Output only. API version used to start the operation.
          class ClientGatewayOperationMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
