# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module BeyondCorp
      module AppGateways
        module V1
          # Request message for BeyondCorp.ListAppGateways.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The resource name of the AppGateway location using the form:
          #     `projects/{project_id}/locations/{location_id}`
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. The maximum number of items to return.
          #     If not specified, a default value of 50 will be used by the service.
          #     Regardless of the page_size value, the response may include a partial list
          #     and a caller should only rely on response's
          #     [next_page_token][BeyondCorp.ListAppGatewaysResponse.next_page_token] to
          #     determine if there are more instances left to be queried.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. The next_page_token value returned from a previous
          #     ListAppGatewaysRequest, if any.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Optional. A filter specifying constraints of a list operation.
          # @!attribute [rw] order_by
          #   @return [::String]
          #     Optional. Specifies the ordering of results. See
          #     [Sorting
          #     order](https://cloud.google.com/apis/design/design_patterns#sorting_order)
          #     for more information.
          class ListAppGatewaysRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for BeyondCorp.ListAppGateways.
          # @!attribute [rw] app_gateways
          #   @return [::Array<::Google::Cloud::BeyondCorp::AppGateways::V1::AppGateway>]
          #     A list of BeyondCorp AppGateways in the project.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token to retrieve the next page of results, or empty if there are no more
          #     results in the list.
          # @!attribute [rw] unreachable
          #   @return [::Array<::String>]
          #     A list of locations that could not be reached.
          class ListAppGatewaysResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for BeyondCorp.GetAppGateway.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. BeyondCorp AppGateway name using the form:
          #     `projects/{project_id}/locations/{location_id}/appGateways/{app_gateway_id}`
          class GetAppGatewayRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for BeyondCorp.CreateAppGateway.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The resource project name of the AppGateway location using the
          #     form: `projects/{project_id}/locations/{location_id}`
          # @!attribute [rw] app_gateway_id
          #   @return [::String]
          #     Optional. User-settable AppGateway resource ID.
          #      * Must start with a letter.
          #      * Must contain between 4-63 characters from `/[a-z][0-9]-/`.
          #      * Must end with a number or a letter.
          # @!attribute [rw] app_gateway
          #   @return [::Google::Cloud::BeyondCorp::AppGateways::V1::AppGateway]
          #     Required. A BeyondCorp AppGateway resource.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An optional request ID to identify requests. Specify a unique
          #     request ID so that if you must retry your request, the server will know to
          #     ignore the request if it has already been completed. The server will
          #     guarantee that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and t
          #     he request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     Optional. If set, validates request by executing a dry-run which would not
          #     alter the resource in any way.
          class CreateAppGatewayRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for BeyondCorp.DeleteAppGateway.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. BeyondCorp AppGateway name using the form:
          #     `projects/{project_id}/locations/{location_id}/appGateways/{app_gateway_id}`
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An optional request ID to identify requests. Specify a unique
          #     request ID so that if you must retry your request, the server will know to
          #     ignore the request if it has already been completed. The server will
          #     guarantee that for at least 60 minutes after the first request.
          #
          #     For example, consider a situation where you make an initial request and t
          #     he request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     Optional. If set, validates request by executing a dry-run which would not
          #     alter the resource in any way.
          class DeleteAppGatewayRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A BeyondCorp AppGateway resource represents a BeyondCorp protected AppGateway
          # to a remote application. It creates all the necessary GCP components needed
          # for creating a BeyondCorp protected AppGateway. Multiple connectors can be
          # authorised for a single AppGateway.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Unique resource name of the AppGateway.
          #     The name is ignored when creating an AppGateway.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. Timestamp when the resource was created.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. Timestamp when the resource was last modified.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. Resource labels to represent user provided metadata.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     Optional. An arbitrary user-provided name for the AppGateway. Cannot exceed
          #     64 characters.
          # @!attribute [r] uid
          #   @return [::String]
          #     Output only. A unique identifier for the instance generated by the
          #     system.
          # @!attribute [rw] type
          #   @return [::Google::Cloud::BeyondCorp::AppGateways::V1::AppGateway::Type]
          #     Required. The type of network connectivity used by the AppGateway.
          # @!attribute [r] state
          #   @return [::Google::Cloud::BeyondCorp::AppGateways::V1::AppGateway::State]
          #     Output only. The current state of the AppGateway.
          # @!attribute [r] uri
          #   @return [::String]
          #     Output only. Server-defined URI for this resource.
          # @!attribute [r] allocated_connections
          #   @return [::Array<::Google::Cloud::BeyondCorp::AppGateways::V1::AppGateway::AllocatedConnection>]
          #     Output only. A list of connections allocated for the Gateway
          # @!attribute [rw] host_type
          #   @return [::Google::Cloud::BeyondCorp::AppGateways::V1::AppGateway::HostType]
          #     Required. The type of hosting used by the AppGateway.
          class AppGateway
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Allocated connection of the AppGateway.
            # @!attribute [rw] psc_uri
            #   @return [::String]
            #     Required. The PSC uri of an allocated connection
            # @!attribute [rw] ingress_port
            #   @return [::Integer]
            #     Required. The ingress port of an allocated connection
            class AllocatedConnection
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Enum containing list of all possible network connectivity options
            # supported by BeyondCorp AppGateway.
            module Type
              # Default value. This value is unused.
              TYPE_UNSPECIFIED = 0

              # TCP Proxy based BeyondCorp Connection. API will default to this if unset.
              TCP_PROXY = 1
            end

            # Represents the different states of an AppGateway.
            module State
              # Default value. This value is unused.
              STATE_UNSPECIFIED = 0

              # AppGateway is being created.
              CREATING = 1

              # AppGateway has been created.
              CREATED = 2

              # AppGateway's configuration is being updated.
              UPDATING = 3

              # AppGateway is being deleted.
              DELETING = 4

              # AppGateway is down and may be restored in the future.
              # This happens when CCFE sends ProjectState = OFF.
              DOWN = 5
            end

            # Enum containing list of all possible host types supported by BeyondCorp
            # Connection.
            module HostType
              # Default value. This value is unused.
              HOST_TYPE_UNSPECIFIED = 0

              # AppGateway hosted in a GCP regional managed instance group.
              GCP_REGIONAL_MIG = 1
            end
          end

          # Represents the metadata of the long-running operation.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time the operation was created.
          # @!attribute [r] end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time the operation finished running.
          # @!attribute [r] target
          #   @return [::String]
          #     Output only. Server-defined resource path for the target of the operation.
          # @!attribute [r] verb
          #   @return [::String]
          #     Output only. Name of the verb executed by the operation.
          # @!attribute [r] status_message
          #   @return [::String]
          #     Output only. Human-readable status of the operation, if any.
          # @!attribute [r] requested_cancellation
          #   @return [::Boolean]
          #     Output only. Identifies whether the user has requested cancellation
          #     of the operation. Operations that have successfully been cancelled
          #     have [Operation.error][] value with a
          #     {::Google::Rpc::Status#code google.rpc.Status.code} of 1, corresponding to
          #     `Code.CANCELLED`.
          # @!attribute [r] api_version
          #   @return [::String]
          #     Output only. API version used to start the operation.
          class AppGatewayOperationMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
