# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module BeyondCorp
      module AppConnectors
        module V1
          # ResourceInfo represents the information/status of an app connector resource.
          # Such as:
          # - remote_agent
          #   - container
          #     - runtime
          #     - appgateway
          #       - appconnector
          #         - appconnection
          #           - tunnel
          #       - logagent
          # @!attribute [rw] id
          #   @return [::String]
          #     Required. Unique Id for the resource.
          # @!attribute [rw] status
          #   @return [::Google::Cloud::BeyondCorp::AppConnectors::V1::HealthStatus]
          #     Overall health status. Overall status is derived based on the status of
          #     each sub level resources.
          # @!attribute [rw] resource
          #   @return [::Google::Protobuf::Any]
          #     Specific details for the resource. This is for internal use only.
          # @!attribute [rw] time
          #   @return [::Google::Protobuf::Timestamp]
          #     The timestamp to collect the info. It is suggested to be set by
          #     the topmost level resource only.
          # @!attribute [rw] sub
          #   @return [::Array<::Google::Cloud::BeyondCorp::AppConnectors::V1::ResourceInfo>]
          #     List of Info for the sub level resources.
          class ResourceInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # HealthStatus represents the health status.
          module HealthStatus
            # Health status is unknown: not initialized or failed to retrieve.
            HEALTH_STATUS_UNSPECIFIED = 0

            # The resource is healthy.
            HEALTHY = 1

            # The resource is unhealthy.
            UNHEALTHY = 2

            # The resource is unresponsive.
            UNRESPONSIVE = 3

            # Some sub-resources are UNHEALTHY.
            DEGRADED = 4
          end
        end
      end
    end
  end
end
