# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module BeyondCorp
      module AppConnectors
        module V1
          # Request message for BeyondCorp.ListAppConnectors.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The resource name of the AppConnector location using the form:
          #     `projects/{project_id}/locations/{location_id}`
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. The maximum number of items to return.
          #     If not specified, a default value of 50 will be used by the service.
          #     Regardless of the page_size value, the response may include a partial list
          #     and a caller should only rely on response's
          #     [next_page_token][BeyondCorp.ListAppConnectorsResponse.next_page_token] to
          #     determine if there are more instances left to be queried.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. The next_page_token value returned from a previous
          #     ListAppConnectorsRequest, if any.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Optional. A filter specifying constraints of a list operation.
          # @!attribute [rw] order_by
          #   @return [::String]
          #     Optional. Specifies the ordering of results. See
          #     [Sorting
          #     order](https://cloud.google.com/apis/design/design_patterns#sorting_order)
          #     for more information.
          class ListAppConnectorsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for BeyondCorp.ListAppConnectors.
          # @!attribute [rw] app_connectors
          #   @return [::Array<::Google::Cloud::BeyondCorp::AppConnectors::V1::AppConnector>]
          #     A list of BeyondCorp AppConnectors in the project.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token to retrieve the next page of results, or empty if there are no more
          #     results in the list.
          # @!attribute [rw] unreachable
          #   @return [::Array<::String>]
          #     A list of locations that could not be reached.
          class ListAppConnectorsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for BeyondCorp.GetAppConnector.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. BeyondCorp AppConnector name using the form:
          #     `projects/{project_id}/locations/{location_id}/appConnectors/{app_connector_id}`
          class GetAppConnectorRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for BeyondCorp.CreateAppConnector.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The resource project name of the AppConnector location using the
          #     form: `projects/{project_id}/locations/{location_id}`
          # @!attribute [rw] app_connector_id
          #   @return [::String]
          #     Optional. User-settable AppConnector resource ID.
          #
          #      * Must start with a letter.
          #      * Must contain between 4-63 characters from `/[a-z][0-9]-/`.
          #      * Must end with a number or a letter.
          # @!attribute [rw] app_connector
          #   @return [::Google::Cloud::BeyondCorp::AppConnectors::V1::AppConnector]
          #     Required. A BeyondCorp AppConnector resource.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An optional request ID to identify requests. Specify a unique
          #     request ID so that if you must retry your request, the server will know to
          #     ignore the request if it has already been completed. The server will
          #     guarantee that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and t
          #     he request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     Optional. If set, validates request by executing a dry-run which would not
          #     alter the resource in any way.
          class CreateAppConnectorRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for BeyondCorp.UpdateAppConnector.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Required. Mask of fields to update. At least one path must be supplied in
          #     this field. The elements of the repeated paths field may only include these
          #     fields from [BeyondCorp.AppConnector]:
          #     * `labels`
          #     * `display_name`
          # @!attribute [rw] app_connector
          #   @return [::Google::Cloud::BeyondCorp::AppConnectors::V1::AppConnector]
          #     Required. AppConnector message with updated fields. Only supported fields
          #     specified in update_mask are updated.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An optional request ID to identify requests. Specify a unique
          #     request ID so that if you must retry your request, the server will know to
          #     ignore the request if it has already been completed. The server will
          #     guarantee that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and t
          #     he request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     Optional. If set, validates request by executing a dry-run which would not
          #     alter the resource in any way.
          class UpdateAppConnectorRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for BeyondCorp.DeleteAppConnector.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. BeyondCorp AppConnector name using the form:
          #     `projects/{project_id}/locations/{location_id}/appConnectors/{app_connector_id}`
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An optional request ID to identify requests. Specify a unique
          #     request ID so that if you must retry your request, the server will know to
          #     ignore the request if it has already been completed. The server will
          #     guarantee that for at least 60 minutes after the first request.
          #
          #     For example, consider a situation where you make an initial request and t
          #     he request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     Optional. If set, validates request by executing a dry-run which would not
          #     alter the resource in any way.
          class DeleteAppConnectorRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request report the connector status.
          # @!attribute [rw] app_connector
          #   @return [::String]
          #     Required. BeyondCorp Connector name using the form:
          #     `projects/{project_id}/locations/{location_id}/connectors/{connector}`
          # @!attribute [rw] resource_info
          #   @return [::Google::Cloud::BeyondCorp::AppConnectors::V1::ResourceInfo]
          #     Required. Resource info of the connector.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An optional request ID to identify requests. Specify a unique
          #     request ID so that if you must retry your request, the server will know to
          #     ignore the request if it has already been completed. The server will
          #     guarantee that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and t
          #     he request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     Optional. If set, validates request by executing a dry-run which would not
          #     alter the resource in any way.
          class ReportStatusRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A BeyondCorp connector resource that represents an application facing
          # component deployed proximal to and with direct access to the application
          # instances. It is used to establish connectivity between the remote enterprise
          # environment and GCP. It initiates connections to the applications and can
          # proxy the data from users over the connection.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Unique resource name of the AppConnector.
          #     The name is ignored when creating a AppConnector.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. Timestamp when the resource was created.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. Timestamp when the resource was last modified.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. Resource labels to represent user provided metadata.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     Optional. An arbitrary user-provided name for the AppConnector. Cannot
          #     exceed 64 characters.
          # @!attribute [r] uid
          #   @return [::String]
          #     Output only. A unique identifier for the instance generated by the
          #     system.
          # @!attribute [r] state
          #   @return [::Google::Cloud::BeyondCorp::AppConnectors::V1::AppConnector::State]
          #     Output only. The current state of the AppConnector.
          # @!attribute [rw] principal_info
          #   @return [::Google::Cloud::BeyondCorp::AppConnectors::V1::AppConnector::PrincipalInfo]
          #     Required. Principal information about the Identity of the AppConnector.
          # @!attribute [rw] resource_info
          #   @return [::Google::Cloud::BeyondCorp::AppConnectors::V1::ResourceInfo]
          #     Optional. Resource info of the connector.
          class AppConnector
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # PrincipalInfo represents an Identity oneof.
            # @!attribute [rw] service_account
            #   @return [::Google::Cloud::BeyondCorp::AppConnectors::V1::AppConnector::PrincipalInfo::ServiceAccount]
            #     A GCP service account.
            class PrincipalInfo
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # ServiceAccount represents a GCP service account.
              # @!attribute [rw] email
              #   @return [::String]
              #     Email address of the service account.
              class ServiceAccount
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Represents the different states of a AppConnector.
            module State
              # Default value. This value is unused.
              STATE_UNSPECIFIED = 0

              # AppConnector is being created.
              CREATING = 1

              # AppConnector has been created.
              CREATED = 2

              # AppConnector's configuration is being updated.
              UPDATING = 3

              # AppConnector is being deleted.
              DELETING = 4

              # AppConnector is down and may be restored in the future.
              # This happens when CCFE sends ProjectState = OFF.
              DOWN = 5
            end
          end

          # Represents the metadata of the long-running operation.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time the operation was created.
          # @!attribute [r] end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time the operation finished running.
          # @!attribute [r] target
          #   @return [::String]
          #     Output only. Server-defined resource path for the target of the operation.
          # @!attribute [r] verb
          #   @return [::String]
          #     Output only. Name of the verb executed by the operation.
          # @!attribute [r] status_message
          #   @return [::String]
          #     Output only. Human-readable status of the operation, if any.
          # @!attribute [r] requested_cancellation
          #   @return [::Boolean]
          #     Output only. Identifies whether the user has requested cancellation
          #     of the operation. Operations that have successfully been cancelled
          #     have [Operation.error][] value with a
          #     {::Google::Rpc::Status#code google.rpc.Status.code} of 1, corresponding to
          #     `Code.CANCELLED`.
          # @!attribute [r] api_version
          #   @return [::String]
          #     Output only. API version used to start the operation.
          class AppConnectorOperationMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
