# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module BeyondCorp
      module AppConnectors
        module V1
          # AppConnectorInstanceConfig defines the instance config of a AppConnector.
          # @!attribute [rw] sequence_number
          #   @return [::Integer]
          #     Required. A monotonically increasing number generated and maintained
          #     by the API provider. Every time a config changes in the backend, the
          #     sequenceNumber should be bumped up to reflect the change.
          # @!attribute [rw] instance_config
          #   @return [::Google::Protobuf::Any]
          #     The SLM instance agent configuration.
          # @!attribute [rw] notification_config
          #   @return [::Google::Cloud::BeyondCorp::AppConnectors::V1::NotificationConfig]
          #     NotificationConfig defines the notification mechanism that the remote
          #     instance should subscribe to in order to receive notification.
          # @!attribute [rw] image_config
          #   @return [::Google::Cloud::BeyondCorp::AppConnectors::V1::ImageConfig]
          #     ImageConfig defines the GCR images to run for the remote agent's control
          #     plane.
          class AppConnectorInstanceConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # NotificationConfig defines the mechanisms to notify instance agent.
          # @!attribute [rw] pubsub_notification
          #   @return [::Google::Cloud::BeyondCorp::AppConnectors::V1::NotificationConfig::CloudPubSubNotificationConfig]
          #     Cloud Pub/Sub Configuration to receive notifications.
          class NotificationConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The configuration for Pub/Sub messaging for the AppConnector.
            # @!attribute [rw] pubsub_subscription
            #   @return [::String]
            #     The Pub/Sub subscription the AppConnector uses to receive notifications.
            class CloudPubSubNotificationConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # ImageConfig defines the control plane images to run.
          # @!attribute [rw] target_image
          #   @return [::String]
          #     The initial image the remote agent will attempt to run for the control
          #     plane.
          # @!attribute [rw] stable_image
          #   @return [::String]
          #     The stable image that the remote agent will fallback to if the target image
          #     fails.
          class ImageConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
