# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/beyondcorp/appconnections/v1/app_connections_service.proto for package 'Google.Cloud.BeyondCorp.AppConnections.V1'
# Original file comments:
# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/beyondcorp/appconnections/v1/app_connections_service_pb'

module Google
  module Cloud
    module BeyondCorp
      module AppConnections
        module V1
          module AppConnectionsService
            # API Overview:
            #
            # The `beyondcorp.googleapis.com` service implements the Google Cloud
            # BeyondCorp API.
            #
            # Data Model:
            #
            # The AppConnectionsService exposes the following resources:
            #
            # * AppConnections, named as follows:
            #   `projects/{project_id}/locations/{location_id}/appConnections/{app_connection_id}`.
            #
            # The AppConnectionsService service provides methods to manage
            # (create/read/update/delete) BeyondCorp AppConnections.
            class Service

              include ::GRPC::GenericService

              self.marshal_class_method = :encode
              self.unmarshal_class_method = :decode
              self.service_name = 'google.cloud.beyondcorp.appconnections.v1.AppConnectionsService'

              # Lists AppConnections in a given project and location.
              rpc :ListAppConnections, ::Google::Cloud::BeyondCorp::AppConnections::V1::ListAppConnectionsRequest, ::Google::Cloud::BeyondCorp::AppConnections::V1::ListAppConnectionsResponse
              # Gets details of a single AppConnection.
              rpc :GetAppConnection, ::Google::Cloud::BeyondCorp::AppConnections::V1::GetAppConnectionRequest, ::Google::Cloud::BeyondCorp::AppConnections::V1::AppConnection
              # Creates a new AppConnection in a given project and location.
              rpc :CreateAppConnection, ::Google::Cloud::BeyondCorp::AppConnections::V1::CreateAppConnectionRequest, ::Google::Longrunning::Operation
              # Updates the parameters of a single AppConnection.
              rpc :UpdateAppConnection, ::Google::Cloud::BeyondCorp::AppConnections::V1::UpdateAppConnectionRequest, ::Google::Longrunning::Operation
              # Deletes a single AppConnection.
              rpc :DeleteAppConnection, ::Google::Cloud::BeyondCorp::AppConnections::V1::DeleteAppConnectionRequest, ::Google::Longrunning::Operation
              # Resolves AppConnections details for a given AppConnector.
              # An internal method called by a connector to find AppConnections to connect
              # to.
              rpc :ResolveAppConnections, ::Google::Cloud::BeyondCorp::AppConnections::V1::ResolveAppConnectionsRequest, ::Google::Cloud::BeyondCorp::AppConnections::V1::ResolveAppConnectionsResponse
            end

            Stub = Service.rpc_stub_class
          end
        end
      end
    end
  end
end
