# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/beyondcorp/appconnections/v1/app_connections_service_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module BeyondCorp
      module AppConnections
        module V1
          module AppConnectionsService
            ##
            # Client for the AppConnectionsService service.
            #
            # API Overview:
            #
            # The `beyondcorp.googleapis.com` service implements the Google Cloud
            # BeyondCorp API.
            #
            # Data Model:
            #
            # The AppConnectionsService exposes the following resources:
            #
            # * AppConnections, named as follows:
            #   `projects/{project_id}/locations/{location_id}/appConnections/{app_connection_id}`.
            #
            # The AppConnectionsService service provides methods to manage
            # (create/read/update/delete) BeyondCorp AppConnections.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "beyondcorp.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :app_connections_service_stub

              ##
              # Configure the AppConnectionsService Client class.
              #
              # See {::Google::Cloud::BeyondCorp::AppConnections::V1::AppConnectionsService::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all AppConnectionsService clients
              #   ::Google::Cloud::BeyondCorp::AppConnections::V1::AppConnectionsService::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "BeyondCorp", "AppConnections", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the AppConnectionsService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::BeyondCorp::AppConnections::V1::AppConnectionsService::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @app_connections_service_stub.universe_domain
              end

              ##
              # Create a new AppConnectionsService client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::BeyondCorp::AppConnections::V1::AppConnectionsService::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::BeyondCorp::AppConnections::V1::AppConnectionsService::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the AppConnectionsService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # These require statements are intentionally placed here to initialize
                # the gRPC module only when it's required.
                # See https://github.com/googleapis/toolkit/issues/446
                require "gapic/grpc"
                require "google/cloud/beyondcorp/appconnections/v1/app_connections_service_services_pb"

                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end
                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @app_connections_service_stub = ::Gapic::ServiceStub.new(
                  ::Google::Cloud::BeyondCorp::AppConnections::V1::AppConnectionsService::Stub,
                  credentials: credentials,
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  channel_args: @config.channel_args,
                  interceptors: @config.interceptors,
                  channel_pool_config: @config.channel_pool,
                  logger: @config.logger
                )

                @app_connections_service_stub.stub_logger&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @app_connections_service_stub.endpoint
                  config.universe_domain = @app_connections_service_stub.universe_domain
                  config.logger = @app_connections_service_stub.logger if config.respond_to? :logger=
                end

                @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @app_connections_service_stub.endpoint
                  config.universe_domain = @app_connections_service_stub.universe_domain
                  config.logger = @app_connections_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::BeyondCorp::AppConnections::V1::AppConnectionsService::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Client]
              #
              attr_reader :location_client

              ##
              # Get the associated client for mix-in of the IAMPolicy.
              #
              # @return [Google::Iam::V1::IAMPolicy::Client]
              #
              attr_reader :iam_policy_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @app_connections_service_stub.logger
              end

              # Service calls

              ##
              # Lists AppConnections in a given project and location.
              #
              # @overload list_app_connections(request, options = nil)
              #   Pass arguments to `list_app_connections` via a request object, either of type
              #   {::Google::Cloud::BeyondCorp::AppConnections::V1::ListAppConnectionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BeyondCorp::AppConnections::V1::ListAppConnectionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_app_connections(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_app_connections` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the AppConnection location using the form:
              #     `projects/{project_id}/locations/{location_id}`
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return.
              #     If not specified, a default value of 50 will be used by the service.
              #     Regardless of the page_size value, the response may include a partial list
              #     and a caller should only rely on response's
              #     [next_page_token][BeyondCorp.ListAppConnectionsResponse.next_page_token] to
              #     determine if there are more instances left to be queried.
              #   @param page_token [::String]
              #     Optional. The next_page_token value returned from a previous
              #     ListAppConnectionsRequest, if any.
              #   @param filter [::String]
              #     Optional. A filter specifying constraints of a list operation.
              #   @param order_by [::String]
              #     Optional. Specifies the ordering of results. See
              #     [Sorting
              #     order](https://cloud.google.com/apis/design/design_patterns#sorting_order)
              #     for more information.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::BeyondCorp::AppConnections::V1::AppConnection>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::BeyondCorp::AppConnections::V1::AppConnection>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/beyond_corp/app_connections/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BeyondCorp::AppConnections::V1::AppConnectionsService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BeyondCorp::AppConnections::V1::ListAppConnectionsRequest.new
              #
              #   # Call the list_app_connections method.
              #   result = client.list_app_connections request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::BeyondCorp::AppConnections::V1::AppConnection.
              #     p item
              #   end
              #
              def list_app_connections request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BeyondCorp::AppConnections::V1::ListAppConnectionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_app_connections.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BeyondCorp::AppConnections::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_app_connections.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_app_connections.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @app_connections_service_stub.call_rpc :list_app_connections, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @app_connections_service_stub, :list_app_connections, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single AppConnection.
              #
              # @overload get_app_connection(request, options = nil)
              #   Pass arguments to `get_app_connection` via a request object, either of type
              #   {::Google::Cloud::BeyondCorp::AppConnections::V1::GetAppConnectionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BeyondCorp::AppConnections::V1::GetAppConnectionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_app_connection(name: nil)
              #   Pass arguments to `get_app_connection` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. BeyondCorp AppConnection name using the form:
              #     `projects/{project_id}/locations/{location_id}/appConnections/{app_connection_id}`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::BeyondCorp::AppConnections::V1::AppConnection]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::BeyondCorp::AppConnections::V1::AppConnection]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/beyond_corp/app_connections/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BeyondCorp::AppConnections::V1::AppConnectionsService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BeyondCorp::AppConnections::V1::GetAppConnectionRequest.new
              #
              #   # Call the get_app_connection method.
              #   result = client.get_app_connection request
              #
              #   # The returned object is of type Google::Cloud::BeyondCorp::AppConnections::V1::AppConnection.
              #   p result
              #
              def get_app_connection request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BeyondCorp::AppConnections::V1::GetAppConnectionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_app_connection.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BeyondCorp::AppConnections::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_app_connection.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_app_connection.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @app_connections_service_stub.call_rpc :get_app_connection, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new AppConnection in a given project and location.
              #
              # @overload create_app_connection(request, options = nil)
              #   Pass arguments to `create_app_connection` via a request object, either of type
              #   {::Google::Cloud::BeyondCorp::AppConnections::V1::CreateAppConnectionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BeyondCorp::AppConnections::V1::CreateAppConnectionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_app_connection(parent: nil, app_connection_id: nil, app_connection: nil, request_id: nil, validate_only: nil)
              #   Pass arguments to `create_app_connection` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource project name of the AppConnection location using the
              #     form: `projects/{project_id}/locations/{location_id}`
              #   @param app_connection_id [::String]
              #     Optional. User-settable AppConnection resource ID.
              #      * Must start with a letter.
              #      * Must contain between 4-63 characters from `/[a-z][0-9]-/`.
              #      * Must end with a number or a letter.
              #   @param app_connection [::Google::Cloud::BeyondCorp::AppConnections::V1::AppConnection, ::Hash]
              #     Required. A BeyondCorp AppConnection resource.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and t
              #     he request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param validate_only [::Boolean]
              #     Optional. If set, validates request by executing a dry-run which would not
              #     alter the resource in any way.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/beyond_corp/app_connections/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BeyondCorp::AppConnections::V1::AppConnectionsService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BeyondCorp::AppConnections::V1::CreateAppConnectionRequest.new
              #
              #   # Call the create_app_connection method.
              #   result = client.create_app_connection request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_app_connection request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BeyondCorp::AppConnections::V1::CreateAppConnectionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_app_connection.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BeyondCorp::AppConnections::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_app_connection.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_app_connection.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @app_connections_service_stub.call_rpc :create_app_connection, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a single AppConnection.
              #
              # @overload update_app_connection(request, options = nil)
              #   Pass arguments to `update_app_connection` via a request object, either of type
              #   {::Google::Cloud::BeyondCorp::AppConnections::V1::UpdateAppConnectionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BeyondCorp::AppConnections::V1::UpdateAppConnectionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_app_connection(update_mask: nil, app_connection: nil, request_id: nil, validate_only: nil, allow_missing: nil)
              #   Pass arguments to `update_app_connection` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Mask of fields to update. At least one path must be supplied in
              #     this field. The elements of the repeated paths field may only include these
              #     fields from [BeyondCorp.AppConnection]:
              #     * `labels`
              #     * `display_name`
              #     * `application_endpoint`
              #     * `connectors`
              #   @param app_connection [::Google::Cloud::BeyondCorp::AppConnections::V1::AppConnection, ::Hash]
              #     Required. AppConnection message with updated fields. Only supported fields
              #     specified in update_mask are updated.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and t
              #     he request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param validate_only [::Boolean]
              #     Optional. If set, validates request by executing a dry-run which would not
              #     alter the resource in any way.
              #   @param allow_missing [::Boolean]
              #     Optional. If set as true, will create the resource if it is not found.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/beyond_corp/app_connections/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BeyondCorp::AppConnections::V1::AppConnectionsService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BeyondCorp::AppConnections::V1::UpdateAppConnectionRequest.new
              #
              #   # Call the update_app_connection method.
              #   result = client.update_app_connection request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_app_connection request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BeyondCorp::AppConnections::V1::UpdateAppConnectionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_app_connection.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BeyondCorp::AppConnections::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.app_connection&.name
                  header_params["app_connection.name"] = request.app_connection.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_app_connection.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_app_connection.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @app_connections_service_stub.call_rpc :update_app_connection, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single AppConnection.
              #
              # @overload delete_app_connection(request, options = nil)
              #   Pass arguments to `delete_app_connection` via a request object, either of type
              #   {::Google::Cloud::BeyondCorp::AppConnections::V1::DeleteAppConnectionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BeyondCorp::AppConnections::V1::DeleteAppConnectionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_app_connection(name: nil, request_id: nil, validate_only: nil)
              #   Pass arguments to `delete_app_connection` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. BeyondCorp Connector name using the form:
              #     `projects/{project_id}/locations/{location_id}/appConnections/{app_connection_id}`
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and t
              #     he request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param validate_only [::Boolean]
              #     Optional. If set, validates request by executing a dry-run which would not
              #     alter the resource in any way.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/beyond_corp/app_connections/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BeyondCorp::AppConnections::V1::AppConnectionsService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BeyondCorp::AppConnections::V1::DeleteAppConnectionRequest.new
              #
              #   # Call the delete_app_connection method.
              #   result = client.delete_app_connection request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_app_connection request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BeyondCorp::AppConnections::V1::DeleteAppConnectionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_app_connection.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BeyondCorp::AppConnections::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_app_connection.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_app_connection.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @app_connections_service_stub.call_rpc :delete_app_connection, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Resolves AppConnections details for a given AppConnector.
              # An internal method called by a connector to find AppConnections to connect
              # to.
              #
              # @overload resolve_app_connections(request, options = nil)
              #   Pass arguments to `resolve_app_connections` via a request object, either of type
              #   {::Google::Cloud::BeyondCorp::AppConnections::V1::ResolveAppConnectionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BeyondCorp::AppConnections::V1::ResolveAppConnectionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload resolve_app_connections(parent: nil, app_connector_id: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `resolve_app_connections` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the AppConnection location using the form:
              #     `projects/{project_id}/locations/{location_id}`
              #   @param app_connector_id [::String]
              #     Required. BeyondCorp Connector name of the connector associated with those
              #     AppConnections using the form:
              #     `projects/{project_id}/locations/{location_id}/appConnectors/{app_connector_id}`
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return.
              #     If not specified, a default value of 50 will be used by the service.
              #     Regardless of the page_size value, the response may include a partial list
              #     and a caller should only rely on response's
              #     [next_page_token][BeyondCorp.ResolveAppConnectionsResponse.next_page_token]
              #     to determine if there are more instances left to be queried.
              #   @param page_token [::String]
              #     Optional. The next_page_token value returned from a previous
              #     ResolveAppConnectionsResponse, if any.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::BeyondCorp::AppConnections::V1::ResolveAppConnectionsResponse::AppConnectionDetails>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::BeyondCorp::AppConnections::V1::ResolveAppConnectionsResponse::AppConnectionDetails>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/beyond_corp/app_connections/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BeyondCorp::AppConnections::V1::AppConnectionsService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BeyondCorp::AppConnections::V1::ResolveAppConnectionsRequest.new
              #
              #   # Call the resolve_app_connections method.
              #   result = client.resolve_app_connections request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::BeyondCorp::AppConnections::V1::ResolveAppConnectionsResponse::AppConnectionDetails.
              #     p item
              #   end
              #
              def resolve_app_connections request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BeyondCorp::AppConnections::V1::ResolveAppConnectionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.resolve_app_connections.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BeyondCorp::AppConnections::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.resolve_app_connections.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.resolve_app_connections.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @app_connections_service_stub.call_rpc :resolve_app_connections, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @app_connections_service_stub, :resolve_app_connections, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the AppConnectionsService API.
              #
              # This class represents the configuration for AppConnectionsService,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::BeyondCorp::AppConnections::V1::AppConnectionsService::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_app_connections to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::BeyondCorp::AppConnections::V1::AppConnectionsService::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_app_connections.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::BeyondCorp::AppConnections::V1::AppConnectionsService::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_app_connections.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
              #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
              #    *  (`nil`) indicating no credentials
              #
              #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
              #     is deprecated. Providing an unvalidated credential configuration to
              #     Google APIs can compromise the security of your systems and data.
              #
              #   @example
              #
              #     # The recommended way to provide credentials is to use the `make_creds` method
              #     # on the appropriate credentials class for your environment.
              #
              #     require "googleauth"
              #
              #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
              #       json_key_io: ::File.open("/path/to/keyfile.json")
              #     )
              #
              #     client = ::Google::Cloud::BeyondCorp::AppConnections::V1::AppConnectionsService::Client.new do |config|
              #       config.credentials = credentials
              #     end
              #
              #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] channel_args
              #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
              #   `GRPC::Core::Channel` object is provided as the credential.
              #   @return [::Hash]
              # @!attribute [rw] interceptors
              #   An array of interceptors that are run before calls are executed.
              #   @return [::Array<::GRPC::ClientInterceptor>]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional gRPC headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "beyondcorp.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
                config_attr :interceptors,  nil, ::Array, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration for the channel pool
                # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
                #
                def channel_pool
                  @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
                end

                ##
                # Configuration RPC class for the AppConnectionsService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_app_connections`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_app_connections
                  ##
                  # RPC-specific configuration for `get_app_connection`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_app_connection
                  ##
                  # RPC-specific configuration for `create_app_connection`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_app_connection
                  ##
                  # RPC-specific configuration for `update_app_connection`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_app_connection
                  ##
                  # RPC-specific configuration for `delete_app_connection`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_app_connection
                  ##
                  # RPC-specific configuration for `resolve_app_connections`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :resolve_app_connections

                  # @private
                  def initialize parent_rpcs = nil
                    list_app_connections_config = parent_rpcs.list_app_connections if parent_rpcs.respond_to? :list_app_connections
                    @list_app_connections = ::Gapic::Config::Method.new list_app_connections_config
                    get_app_connection_config = parent_rpcs.get_app_connection if parent_rpcs.respond_to? :get_app_connection
                    @get_app_connection = ::Gapic::Config::Method.new get_app_connection_config
                    create_app_connection_config = parent_rpcs.create_app_connection if parent_rpcs.respond_to? :create_app_connection
                    @create_app_connection = ::Gapic::Config::Method.new create_app_connection_config
                    update_app_connection_config = parent_rpcs.update_app_connection if parent_rpcs.respond_to? :update_app_connection
                    @update_app_connection = ::Gapic::Config::Method.new update_app_connection_config
                    delete_app_connection_config = parent_rpcs.delete_app_connection if parent_rpcs.respond_to? :delete_app_connection
                    @delete_app_connection = ::Gapic::Config::Method.new delete_app_connection_config
                    resolve_app_connections_config = parent_rpcs.resolve_app_connections if parent_rpcs.respond_to? :resolve_app_connections
                    @resolve_app_connections = ::Gapic::Config::Method.new resolve_app_connections_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
