# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Batch
      module V1
        # Volume describes a volume and parameters for it to be mounted to a VM.
        # @!attribute [rw] nfs
        #   @return [::Google::Cloud::Batch::V1::NFS]
        #     A Network File System (NFS) volume. For example, a
        #     Filestore file share.
        #
        #     Note: The following fields are mutually exclusive: `nfs`, `gcs`, `device_name`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] gcs
        #   @return [::Google::Cloud::Batch::V1::GCS]
        #     A Google Cloud Storage (GCS) volume.
        #
        #     Note: The following fields are mutually exclusive: `gcs`, `nfs`, `device_name`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] device_name
        #   @return [::String]
        #     Device name of an attached disk volume, which should align with a
        #     device_name specified by
        #     job.allocation_policy.instances[0].policy.disks[i].device_name or
        #     defined by the given instance template in
        #     job.allocation_policy.instances[0].instance_template.
        #
        #     Note: The following fields are mutually exclusive: `device_name`, `nfs`, `gcs`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] mount_path
        #   @return [::String]
        #     The mount path for the volume, e.g. /mnt/disks/share.
        # @!attribute [rw] mount_options
        #   @return [::Array<::String>]
        #     Mount options vary based on the type of storage volume:
        #
        #     * For a Cloud Storage bucket, all the mount options provided
        #     by
        #       the [`gcsfuse` tool](https://cloud.google.com/storage/docs/gcsfuse-cli)
        #       are supported.
        #     * For an existing persistent disk, all mount options provided by the
        #       [`mount` command](https://man7.org/linux/man-pages/man8/mount.8.html)
        #       except writing are supported. This is due to restrictions of
        #       [multi-writer
        #       mode](https://cloud.google.com/compute/docs/disks/sharing-disks-between-vms).
        #     * For any other disk or a Network File System (NFS), all the
        #       mount options provided by the `mount` command are supported.
        class Volume
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents an NFS volume.
        # @!attribute [rw] server
        #   @return [::String]
        #     The IP address of the NFS.
        # @!attribute [rw] remote_path
        #   @return [::String]
        #     Remote source path exported from the NFS, e.g., "/share".
        class NFS
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a Google Cloud Storage volume.
        # @!attribute [rw] remote_path
        #   @return [::String]
        #     Remote path, either a bucket name or a subdirectory of a bucket, e.g.:
        #     bucket_name, bucket_name/subdirectory/
        class GCS
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
