# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Batch
      module V1
        # CreateJob Request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource name where the Job will be created.
        #     Pattern: "projects/\\{project}/locations/\\{location}"
        # @!attribute [rw] job_id
        #   @return [::String]
        #     ID used to uniquely identify the Job within its parent scope.
        #     This field should contain at most 63 characters and must start with
        #     lowercase characters.
        #     Only lowercase characters, numbers and '-' are accepted.
        #     The '-' character cannot be the first or the last one.
        #     A system generated ID will be used if the field is not set.
        #
        #     The job.name field in the request will be ignored and the created resource
        #     name of the Job will be "\\{parent}/jobs/\\{job_id}".
        # @!attribute [rw] job
        #   @return [::Google::Cloud::Batch::V1::Job]
        #     Required. The Job to create.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # GetJob Request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Job name.
        class GetJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DeleteJob Request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Job name.
        # @!attribute [rw] reason
        #   @return [::String]
        #     Optional. Reason for this deletion.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CancelJob Request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Job name.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CancelJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response to the CancelJob request.
        class CancelJobResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListJob Request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Parent path.
        # @!attribute [rw] filter
        #   @return [::String]
        #     List filter.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Sort results. Supported are "name", "name desc", "create_time",
        #     and "create_time desc".
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Page size.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Page token.
        class ListJobsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListJob Response.
        # @!attribute [rw] jobs
        #   @return [::Array<::Google::Cloud::Batch::V1::Job>]
        #     Jobs.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Next page token.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListJobsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListTasks Request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of a TaskGroup from which Tasks are being requested.
        #     Pattern:
        #     "projects/\\{project}/locations/\\{location}/jobs/\\{job}/taskGroups/\\{task_group}"
        # @!attribute [rw] filter
        #   @return [::String]
        #     Task filter, null filter matches all Tasks.
        #     Filter string should be of the format State=TaskStatus.State e.g.
        #     State=RUNNING
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Page size.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Page token.
        class ListTasksRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListTasks Response.
        # @!attribute [rw] tasks
        #   @return [::Array<::Google::Cloud::Batch::V1::Task>]
        #     Tasks.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Next page token.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListTasksResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for a single Task by name.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Task name.
        class GetTaskRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the metadata of the long-running operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. Server-defined resource path for the target of the operation.
        # @!attribute [r] verb
        #   @return [::String]
        #     Output only. Name of the verb executed by the operation.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. Identifies whether the user has requested cancellation
        #     of the operation. Operations that have successfully been cancelled
        #     have
        #     {::Google::Longrunning::Operation#error google.longrunning.Operation.error}
        #     value with a {::Google::Rpc::Status#code google.rpc.Status.code} of 1,
        #     corresponding to `Code.CANCELLED`.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. API version used to start the operation.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
