# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/baremetalsolution/v2/baremetalsolution_pb"
require "google/cloud/bare_metal_solution/v2/bare_metal_solution"

class ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_instances
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BareMetalSolution::V2::ListInstancesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_instances_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_instances, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::ListInstancesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_instances_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_instances({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_instances parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_instances ::Google::Cloud::BareMetalSolution::V2::ListInstancesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_instances({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_instances(::Google::Cloud::BareMetalSolution::V2::ListInstancesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_instances_client_stub.call_rpc_count
    end
  end

  def test_get_instance
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BareMetalSolution::V2::Instance.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_instance, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::GetInstanceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_instance_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_instance({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_instance name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_instance ::Google::Cloud::BareMetalSolution::V2::GetInstanceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_instance({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_instance(::Google::Cloud::BareMetalSolution::V2::GetInstanceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_instance_client_stub.call_rpc_count
    end
  end

  def test_update_instance
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    instance = {}
    update_mask = {}

    update_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_instance, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::UpdateInstanceRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::BareMetalSolution::V2::Instance), request["instance"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_instance_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_instance({ instance: instance, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_instance instance: instance, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_instance ::Google::Cloud::BareMetalSolution::V2::UpdateInstanceRequest.new(instance: instance, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_instance({ instance: instance, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_instance(::Google::Cloud::BareMetalSolution::V2::UpdateInstanceRequest.new(instance: instance, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_instance_client_stub.call_rpc_count
    end
  end

  def test_rename_instance
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BareMetalSolution::V2::Instance.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    new_instance_id = "hello world"

    rename_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :rename_instance, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::RenameInstanceRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["new_instance_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, rename_instance_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.rename_instance({ name: name, new_instance_id: new_instance_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.rename_instance name: name, new_instance_id: new_instance_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.rename_instance ::Google::Cloud::BareMetalSolution::V2::RenameInstanceRequest.new(name: name, new_instance_id: new_instance_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.rename_instance({ name: name, new_instance_id: new_instance_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.rename_instance(::Google::Cloud::BareMetalSolution::V2::RenameInstanceRequest.new(name: name, new_instance_id: new_instance_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, rename_instance_client_stub.call_rpc_count
    end
  end

  def test_reset_instance
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    reset_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :reset_instance, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::ResetInstanceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, reset_instance_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.reset_instance({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.reset_instance name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.reset_instance ::Google::Cloud::BareMetalSolution::V2::ResetInstanceRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.reset_instance({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.reset_instance(::Google::Cloud::BareMetalSolution::V2::ResetInstanceRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, reset_instance_client_stub.call_rpc_count
    end
  end

  def test_start_instance
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    start_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :start_instance, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::StartInstanceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, start_instance_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.start_instance({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.start_instance name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.start_instance ::Google::Cloud::BareMetalSolution::V2::StartInstanceRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.start_instance({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.start_instance(::Google::Cloud::BareMetalSolution::V2::StartInstanceRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, start_instance_client_stub.call_rpc_count
    end
  end

  def test_stop_instance
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    stop_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :stop_instance, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::StopInstanceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, stop_instance_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.stop_instance({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.stop_instance name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.stop_instance ::Google::Cloud::BareMetalSolution::V2::StopInstanceRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.stop_instance({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.stop_instance(::Google::Cloud::BareMetalSolution::V2::StopInstanceRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, stop_instance_client_stub.call_rpc_count
    end
  end

  def test_enable_interactive_serial_console
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    enable_interactive_serial_console_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :enable_interactive_serial_console, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::EnableInteractiveSerialConsoleRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, enable_interactive_serial_console_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.enable_interactive_serial_console({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.enable_interactive_serial_console name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.enable_interactive_serial_console ::Google::Cloud::BareMetalSolution::V2::EnableInteractiveSerialConsoleRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.enable_interactive_serial_console({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.enable_interactive_serial_console(::Google::Cloud::BareMetalSolution::V2::EnableInteractiveSerialConsoleRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, enable_interactive_serial_console_client_stub.call_rpc_count
    end
  end

  def test_disable_interactive_serial_console
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    disable_interactive_serial_console_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :disable_interactive_serial_console, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::DisableInteractiveSerialConsoleRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, disable_interactive_serial_console_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.disable_interactive_serial_console({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.disable_interactive_serial_console name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.disable_interactive_serial_console ::Google::Cloud::BareMetalSolution::V2::DisableInteractiveSerialConsoleRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.disable_interactive_serial_console({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.disable_interactive_serial_console(::Google::Cloud::BareMetalSolution::V2::DisableInteractiveSerialConsoleRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, disable_interactive_serial_console_client_stub.call_rpc_count
    end
  end

  def test_detach_lun
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    lun = "hello world"
    skip_reboot = true

    detach_lun_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :detach_lun, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::DetachLunRequest, request
      assert_equal "hello world", request["instance"]
      assert_equal "hello world", request["lun"]
      assert_equal true, request["skip_reboot"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, detach_lun_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.detach_lun({ instance: instance, lun: lun, skip_reboot: skip_reboot }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.detach_lun instance: instance, lun: lun, skip_reboot: skip_reboot do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.detach_lun ::Google::Cloud::BareMetalSolution::V2::DetachLunRequest.new(instance: instance, lun: lun, skip_reboot: skip_reboot) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.detach_lun({ instance: instance, lun: lun, skip_reboot: skip_reboot }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.detach_lun(::Google::Cloud::BareMetalSolution::V2::DetachLunRequest.new(instance: instance, lun: lun, skip_reboot: skip_reboot), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, detach_lun_client_stub.call_rpc_count
    end
  end

  def test_list_ssh_keys
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BareMetalSolution::V2::ListSSHKeysResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_ssh_keys_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_ssh_keys, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::ListSSHKeysRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_ssh_keys_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_ssh_keys({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_ssh_keys parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_ssh_keys ::Google::Cloud::BareMetalSolution::V2::ListSSHKeysRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_ssh_keys({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_ssh_keys(::Google::Cloud::BareMetalSolution::V2::ListSSHKeysRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_ssh_keys_client_stub.call_rpc_count
    end
  end

  def test_create_ssh_key
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BareMetalSolution::V2::SSHKey.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    ssh_key = {}
    ssh_key_id = "hello world"

    create_ssh_key_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_ssh_key, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::CreateSSHKeyRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::BareMetalSolution::V2::SSHKey), request["ssh_key"]
      assert_equal "hello world", request["ssh_key_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_ssh_key_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_ssh_key({ parent: parent, ssh_key: ssh_key, ssh_key_id: ssh_key_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_ssh_key parent: parent, ssh_key: ssh_key, ssh_key_id: ssh_key_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_ssh_key ::Google::Cloud::BareMetalSolution::V2::CreateSSHKeyRequest.new(parent: parent, ssh_key: ssh_key, ssh_key_id: ssh_key_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_ssh_key({ parent: parent, ssh_key: ssh_key, ssh_key_id: ssh_key_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_ssh_key(::Google::Cloud::BareMetalSolution::V2::CreateSSHKeyRequest.new(parent: parent, ssh_key: ssh_key, ssh_key_id: ssh_key_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_ssh_key_client_stub.call_rpc_count
    end
  end

  def test_delete_ssh_key
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_ssh_key_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_ssh_key, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::DeleteSSHKeyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_ssh_key_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_ssh_key({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_ssh_key name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_ssh_key ::Google::Cloud::BareMetalSolution::V2::DeleteSSHKeyRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_ssh_key({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_ssh_key(::Google::Cloud::BareMetalSolution::V2::DeleteSSHKeyRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_ssh_key_client_stub.call_rpc_count
    end
  end

  def test_list_volumes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BareMetalSolution::V2::ListVolumesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_volumes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_volumes, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::ListVolumesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_volumes_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_volumes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_volumes parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_volumes ::Google::Cloud::BareMetalSolution::V2::ListVolumesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_volumes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_volumes(::Google::Cloud::BareMetalSolution::V2::ListVolumesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_volumes_client_stub.call_rpc_count
    end
  end

  def test_get_volume
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BareMetalSolution::V2::Volume.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_volume_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_volume, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::GetVolumeRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_volume_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_volume({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_volume name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_volume ::Google::Cloud::BareMetalSolution::V2::GetVolumeRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_volume({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_volume(::Google::Cloud::BareMetalSolution::V2::GetVolumeRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_volume_client_stub.call_rpc_count
    end
  end

  def test_update_volume
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    volume = {}
    update_mask = {}

    update_volume_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_volume, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::UpdateVolumeRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::BareMetalSolution::V2::Volume), request["volume"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_volume_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_volume({ volume: volume, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_volume volume: volume, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_volume ::Google::Cloud::BareMetalSolution::V2::UpdateVolumeRequest.new(volume: volume, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_volume({ volume: volume, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_volume(::Google::Cloud::BareMetalSolution::V2::UpdateVolumeRequest.new(volume: volume, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_volume_client_stub.call_rpc_count
    end
  end

  def test_rename_volume
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BareMetalSolution::V2::Volume.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    new_volume_id = "hello world"

    rename_volume_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :rename_volume, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::RenameVolumeRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["new_volume_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, rename_volume_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.rename_volume({ name: name, new_volume_id: new_volume_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.rename_volume name: name, new_volume_id: new_volume_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.rename_volume ::Google::Cloud::BareMetalSolution::V2::RenameVolumeRequest.new(name: name, new_volume_id: new_volume_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.rename_volume({ name: name, new_volume_id: new_volume_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.rename_volume(::Google::Cloud::BareMetalSolution::V2::RenameVolumeRequest.new(name: name, new_volume_id: new_volume_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, rename_volume_client_stub.call_rpc_count
    end
  end

  def test_evict_volume
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    evict_volume_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :evict_volume, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::EvictVolumeRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, evict_volume_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.evict_volume({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.evict_volume name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.evict_volume ::Google::Cloud::BareMetalSolution::V2::EvictVolumeRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.evict_volume({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.evict_volume(::Google::Cloud::BareMetalSolution::V2::EvictVolumeRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, evict_volume_client_stub.call_rpc_count
    end
  end

  def test_resize_volume
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    volume = "hello world"
    size_gib = 42

    resize_volume_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :resize_volume, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::ResizeVolumeRequest, request
      assert_equal "hello world", request["volume"]
      assert_equal 42, request["size_gib"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, resize_volume_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.resize_volume({ volume: volume, size_gib: size_gib }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.resize_volume volume: volume, size_gib: size_gib do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.resize_volume ::Google::Cloud::BareMetalSolution::V2::ResizeVolumeRequest.new(volume: volume, size_gib: size_gib) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.resize_volume({ volume: volume, size_gib: size_gib }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.resize_volume(::Google::Cloud::BareMetalSolution::V2::ResizeVolumeRequest.new(volume: volume, size_gib: size_gib), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, resize_volume_client_stub.call_rpc_count
    end
  end

  def test_list_networks
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BareMetalSolution::V2::ListNetworksResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_networks_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_networks, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::ListNetworksRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_networks_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_networks({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_networks parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_networks ::Google::Cloud::BareMetalSolution::V2::ListNetworksRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_networks({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_networks(::Google::Cloud::BareMetalSolution::V2::ListNetworksRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_networks_client_stub.call_rpc_count
    end
  end

  def test_list_network_usage
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BareMetalSolution::V2::ListNetworkUsageResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    location = "hello world"

    list_network_usage_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_network_usage, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::ListNetworkUsageRequest, request
      assert_equal "hello world", request["location"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_network_usage_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_network_usage({ location: location }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_network_usage location: location do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_network_usage ::Google::Cloud::BareMetalSolution::V2::ListNetworkUsageRequest.new(location: location) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_network_usage({ location: location }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_network_usage(::Google::Cloud::BareMetalSolution::V2::ListNetworkUsageRequest.new(location: location), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_network_usage_client_stub.call_rpc_count
    end
  end

  def test_get_network
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BareMetalSolution::V2::Network.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_network_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_network, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::GetNetworkRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_network_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_network({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_network name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_network ::Google::Cloud::BareMetalSolution::V2::GetNetworkRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_network({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_network(::Google::Cloud::BareMetalSolution::V2::GetNetworkRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_network_client_stub.call_rpc_count
    end
  end

  def test_update_network
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    network = {}
    update_mask = {}

    update_network_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_network, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::UpdateNetworkRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::BareMetalSolution::V2::Network), request["network"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_network_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_network({ network: network, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_network network: network, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_network ::Google::Cloud::BareMetalSolution::V2::UpdateNetworkRequest.new(network: network, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_network({ network: network, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_network(::Google::Cloud::BareMetalSolution::V2::UpdateNetworkRequest.new(network: network, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_network_client_stub.call_rpc_count
    end
  end

  def test_create_volume_snapshot
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BareMetalSolution::V2::VolumeSnapshot.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    volume_snapshot = {}

    create_volume_snapshot_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_volume_snapshot, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::CreateVolumeSnapshotRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::BareMetalSolution::V2::VolumeSnapshot), request["volume_snapshot"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_volume_snapshot_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_volume_snapshot({ parent: parent, volume_snapshot: volume_snapshot }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_volume_snapshot parent: parent, volume_snapshot: volume_snapshot do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_volume_snapshot ::Google::Cloud::BareMetalSolution::V2::CreateVolumeSnapshotRequest.new(parent: parent, volume_snapshot: volume_snapshot) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_volume_snapshot({ parent: parent, volume_snapshot: volume_snapshot }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_volume_snapshot(::Google::Cloud::BareMetalSolution::V2::CreateVolumeSnapshotRequest.new(parent: parent, volume_snapshot: volume_snapshot), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_volume_snapshot_client_stub.call_rpc_count
    end
  end

  def test_restore_volume_snapshot
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    volume_snapshot = "hello world"

    restore_volume_snapshot_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :restore_volume_snapshot, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::RestoreVolumeSnapshotRequest, request
      assert_equal "hello world", request["volume_snapshot"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, restore_volume_snapshot_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.restore_volume_snapshot({ volume_snapshot: volume_snapshot }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.restore_volume_snapshot volume_snapshot: volume_snapshot do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.restore_volume_snapshot ::Google::Cloud::BareMetalSolution::V2::RestoreVolumeSnapshotRequest.new(volume_snapshot: volume_snapshot) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.restore_volume_snapshot({ volume_snapshot: volume_snapshot }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.restore_volume_snapshot(::Google::Cloud::BareMetalSolution::V2::RestoreVolumeSnapshotRequest.new(volume_snapshot: volume_snapshot), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, restore_volume_snapshot_client_stub.call_rpc_count
    end
  end

  def test_delete_volume_snapshot
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_volume_snapshot_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_volume_snapshot, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::DeleteVolumeSnapshotRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_volume_snapshot_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_volume_snapshot({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_volume_snapshot name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_volume_snapshot ::Google::Cloud::BareMetalSolution::V2::DeleteVolumeSnapshotRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_volume_snapshot({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_volume_snapshot(::Google::Cloud::BareMetalSolution::V2::DeleteVolumeSnapshotRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_volume_snapshot_client_stub.call_rpc_count
    end
  end

  def test_get_volume_snapshot
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BareMetalSolution::V2::VolumeSnapshot.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_volume_snapshot_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_volume_snapshot, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::GetVolumeSnapshotRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_volume_snapshot_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_volume_snapshot({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_volume_snapshot name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_volume_snapshot ::Google::Cloud::BareMetalSolution::V2::GetVolumeSnapshotRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_volume_snapshot({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_volume_snapshot(::Google::Cloud::BareMetalSolution::V2::GetVolumeSnapshotRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_volume_snapshot_client_stub.call_rpc_count
    end
  end

  def test_list_volume_snapshots
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BareMetalSolution::V2::ListVolumeSnapshotsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_volume_snapshots_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_volume_snapshots, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::ListVolumeSnapshotsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_volume_snapshots_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_volume_snapshots({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_volume_snapshots parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_volume_snapshots ::Google::Cloud::BareMetalSolution::V2::ListVolumeSnapshotsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_volume_snapshots({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_volume_snapshots(::Google::Cloud::BareMetalSolution::V2::ListVolumeSnapshotsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_volume_snapshots_client_stub.call_rpc_count
    end
  end

  def test_get_lun
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BareMetalSolution::V2::Lun.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_lun_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_lun, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::GetLunRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_lun_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_lun({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_lun name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_lun ::Google::Cloud::BareMetalSolution::V2::GetLunRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_lun({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_lun(::Google::Cloud::BareMetalSolution::V2::GetLunRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_lun_client_stub.call_rpc_count
    end
  end

  def test_list_luns
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BareMetalSolution::V2::ListLunsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_luns_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_luns, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::ListLunsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_luns_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_luns({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_luns parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_luns ::Google::Cloud::BareMetalSolution::V2::ListLunsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_luns({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_luns(::Google::Cloud::BareMetalSolution::V2::ListLunsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_luns_client_stub.call_rpc_count
    end
  end

  def test_evict_lun
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    evict_lun_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :evict_lun, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::EvictLunRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, evict_lun_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.evict_lun({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.evict_lun name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.evict_lun ::Google::Cloud::BareMetalSolution::V2::EvictLunRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.evict_lun({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.evict_lun(::Google::Cloud::BareMetalSolution::V2::EvictLunRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, evict_lun_client_stub.call_rpc_count
    end
  end

  def test_get_nfs_share
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BareMetalSolution::V2::NfsShare.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_nfs_share_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_nfs_share, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::GetNfsShareRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_nfs_share_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_nfs_share({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_nfs_share name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_nfs_share ::Google::Cloud::BareMetalSolution::V2::GetNfsShareRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_nfs_share({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_nfs_share(::Google::Cloud::BareMetalSolution::V2::GetNfsShareRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_nfs_share_client_stub.call_rpc_count
    end
  end

  def test_list_nfs_shares
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BareMetalSolution::V2::ListNfsSharesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_nfs_shares_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_nfs_shares, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::ListNfsSharesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_nfs_shares_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_nfs_shares({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_nfs_shares parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_nfs_shares ::Google::Cloud::BareMetalSolution::V2::ListNfsSharesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_nfs_shares({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_nfs_shares(::Google::Cloud::BareMetalSolution::V2::ListNfsSharesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_nfs_shares_client_stub.call_rpc_count
    end
  end

  def test_update_nfs_share
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    nfs_share = {}
    update_mask = {}

    update_nfs_share_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_nfs_share, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::UpdateNfsShareRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::BareMetalSolution::V2::NfsShare), request["nfs_share"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_nfs_share_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_nfs_share({ nfs_share: nfs_share, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_nfs_share nfs_share: nfs_share, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_nfs_share ::Google::Cloud::BareMetalSolution::V2::UpdateNfsShareRequest.new(nfs_share: nfs_share, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_nfs_share({ nfs_share: nfs_share, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_nfs_share(::Google::Cloud::BareMetalSolution::V2::UpdateNfsShareRequest.new(nfs_share: nfs_share, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_nfs_share_client_stub.call_rpc_count
    end
  end

  def test_create_nfs_share
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    nfs_share = {}

    create_nfs_share_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_nfs_share, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::CreateNfsShareRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::BareMetalSolution::V2::NfsShare), request["nfs_share"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_nfs_share_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_nfs_share({ parent: parent, nfs_share: nfs_share }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_nfs_share parent: parent, nfs_share: nfs_share do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_nfs_share ::Google::Cloud::BareMetalSolution::V2::CreateNfsShareRequest.new(parent: parent, nfs_share: nfs_share) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_nfs_share({ parent: parent, nfs_share: nfs_share }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_nfs_share(::Google::Cloud::BareMetalSolution::V2::CreateNfsShareRequest.new(parent: parent, nfs_share: nfs_share), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_nfs_share_client_stub.call_rpc_count
    end
  end

  def test_rename_nfs_share
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BareMetalSolution::V2::NfsShare.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    new_nfsshare_id = "hello world"

    rename_nfs_share_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :rename_nfs_share, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::RenameNfsShareRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["new_nfsshare_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, rename_nfs_share_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.rename_nfs_share({ name: name, new_nfsshare_id: new_nfsshare_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.rename_nfs_share name: name, new_nfsshare_id: new_nfsshare_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.rename_nfs_share ::Google::Cloud::BareMetalSolution::V2::RenameNfsShareRequest.new(name: name, new_nfsshare_id: new_nfsshare_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.rename_nfs_share({ name: name, new_nfsshare_id: new_nfsshare_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.rename_nfs_share(::Google::Cloud::BareMetalSolution::V2::RenameNfsShareRequest.new(name: name, new_nfsshare_id: new_nfsshare_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, rename_nfs_share_client_stub.call_rpc_count
    end
  end

  def test_delete_nfs_share
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_nfs_share_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_nfs_share, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::DeleteNfsShareRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_nfs_share_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_nfs_share({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_nfs_share name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_nfs_share ::Google::Cloud::BareMetalSolution::V2::DeleteNfsShareRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_nfs_share({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_nfs_share(::Google::Cloud::BareMetalSolution::V2::DeleteNfsShareRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_nfs_share_client_stub.call_rpc_count
    end
  end

  def test_list_provisioning_quotas
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BareMetalSolution::V2::ListProvisioningQuotasResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_provisioning_quotas_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_provisioning_quotas, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::ListProvisioningQuotasRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_provisioning_quotas_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_provisioning_quotas({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_provisioning_quotas parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_provisioning_quotas ::Google::Cloud::BareMetalSolution::V2::ListProvisioningQuotasRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_provisioning_quotas({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_provisioning_quotas(::Google::Cloud::BareMetalSolution::V2::ListProvisioningQuotasRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_provisioning_quotas_client_stub.call_rpc_count
    end
  end

  def test_submit_provisioning_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BareMetalSolution::V2::SubmitProvisioningConfigResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    provisioning_config = {}
    email = "hello world"

    submit_provisioning_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :submit_provisioning_config, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::SubmitProvisioningConfigRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::BareMetalSolution::V2::ProvisioningConfig), request["provisioning_config"]
      assert_equal "hello world", request["email"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, submit_provisioning_config_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.submit_provisioning_config({ parent: parent, provisioning_config: provisioning_config, email: email }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.submit_provisioning_config parent: parent, provisioning_config: provisioning_config, email: email do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.submit_provisioning_config ::Google::Cloud::BareMetalSolution::V2::SubmitProvisioningConfigRequest.new(parent: parent, provisioning_config: provisioning_config, email: email) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.submit_provisioning_config({ parent: parent, provisioning_config: provisioning_config, email: email }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.submit_provisioning_config(::Google::Cloud::BareMetalSolution::V2::SubmitProvisioningConfigRequest.new(parent: parent, provisioning_config: provisioning_config, email: email), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, submit_provisioning_config_client_stub.call_rpc_count
    end
  end

  def test_get_provisioning_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BareMetalSolution::V2::ProvisioningConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_provisioning_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_provisioning_config, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::GetProvisioningConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_provisioning_config_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_provisioning_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_provisioning_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_provisioning_config ::Google::Cloud::BareMetalSolution::V2::GetProvisioningConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_provisioning_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_provisioning_config(::Google::Cloud::BareMetalSolution::V2::GetProvisioningConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_provisioning_config_client_stub.call_rpc_count
    end
  end

  def test_create_provisioning_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BareMetalSolution::V2::ProvisioningConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    provisioning_config = {}
    email = "hello world"

    create_provisioning_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_provisioning_config, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::CreateProvisioningConfigRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::BareMetalSolution::V2::ProvisioningConfig), request["provisioning_config"]
      assert_equal "hello world", request["email"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_provisioning_config_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_provisioning_config({ parent: parent, provisioning_config: provisioning_config, email: email }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_provisioning_config parent: parent, provisioning_config: provisioning_config, email: email do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_provisioning_config ::Google::Cloud::BareMetalSolution::V2::CreateProvisioningConfigRequest.new(parent: parent, provisioning_config: provisioning_config, email: email) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_provisioning_config({ parent: parent, provisioning_config: provisioning_config, email: email }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_provisioning_config(::Google::Cloud::BareMetalSolution::V2::CreateProvisioningConfigRequest.new(parent: parent, provisioning_config: provisioning_config, email: email), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_provisioning_config_client_stub.call_rpc_count
    end
  end

  def test_update_provisioning_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BareMetalSolution::V2::ProvisioningConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    provisioning_config = {}
    update_mask = {}
    email = "hello world"

    update_provisioning_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_provisioning_config, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::UpdateProvisioningConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::BareMetalSolution::V2::ProvisioningConfig), request["provisioning_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal "hello world", request["email"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_provisioning_config_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_provisioning_config({ provisioning_config: provisioning_config, update_mask: update_mask, email: email }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_provisioning_config provisioning_config: provisioning_config, update_mask: update_mask, email: email do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_provisioning_config ::Google::Cloud::BareMetalSolution::V2::UpdateProvisioningConfigRequest.new(provisioning_config: provisioning_config, update_mask: update_mask, email: email) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_provisioning_config({ provisioning_config: provisioning_config, update_mask: update_mask, email: email }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_provisioning_config(::Google::Cloud::BareMetalSolution::V2::UpdateProvisioningConfigRequest.new(provisioning_config: provisioning_config, update_mask: update_mask, email: email), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_provisioning_config_client_stub.call_rpc_count
    end
  end

  def test_rename_network
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BareMetalSolution::V2::Network.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    new_network_id = "hello world"

    rename_network_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :rename_network, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::RenameNetworkRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["new_network_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, rename_network_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.rename_network({ name: name, new_network_id: new_network_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.rename_network name: name, new_network_id: new_network_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.rename_network ::Google::Cloud::BareMetalSolution::V2::RenameNetworkRequest.new(name: name, new_network_id: new_network_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.rename_network({ name: name, new_network_id: new_network_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.rename_network(::Google::Cloud::BareMetalSolution::V2::RenameNetworkRequest.new(name: name, new_network_id: new_network_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, rename_network_client_stub.call_rpc_count
    end
  end

  def test_list_os_images
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BareMetalSolution::V2::ListOSImagesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_os_images_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_os_images, name
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::ListOSImagesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_os_images_client_stub do
      # Create client
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_os_images({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_os_images parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_os_images ::Google::Cloud::BareMetalSolution::V2::ListOSImagesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_os_images({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_os_images(::Google::Cloud::BareMetalSolution::V2::ListOSImagesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_os_images_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Operations, client.operations_client
  end
end
