# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/baremetalsolution/v2/baremetalsolution_pb"
require "google/cloud/bare_metal_solution/v2/bare_metal_solution/rest"


class ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_instances
    # Create test objects.
    client_result = ::Google::Cloud::BareMetalSolution::V2::ListInstancesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_instances_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_list_instances_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_instances_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_instances({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_instances parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_instances ::Google::Cloud::BareMetalSolution::V2::ListInstancesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_instances({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_instances(::Google::Cloud::BareMetalSolution::V2::ListInstancesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_instances_client_stub.call_count
      end
    end
  end

  def test_get_instance
    # Create test objects.
    client_result = ::Google::Cloud::BareMetalSolution::V2::Instance.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_instance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_get_instance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_instance_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_instance({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_instance name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_instance ::Google::Cloud::BareMetalSolution::V2::GetInstanceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_instance({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_instance(::Google::Cloud::BareMetalSolution::V2::GetInstanceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_instance_client_stub.call_count
      end
    end
  end

  def test_update_instance
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = {}
    update_mask = {}

    update_instance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_update_instance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_instance_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_instance({ instance: instance, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_instance instance: instance, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_instance ::Google::Cloud::BareMetalSolution::V2::UpdateInstanceRequest.new(instance: instance, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_instance({ instance: instance, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_instance(::Google::Cloud::BareMetalSolution::V2::UpdateInstanceRequest.new(instance: instance, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_instance_client_stub.call_count
      end
    end
  end

  def test_rename_instance
    # Create test objects.
    client_result = ::Google::Cloud::BareMetalSolution::V2::Instance.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    new_instance_id = "hello world"

    rename_instance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_rename_instance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, rename_instance_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.rename_instance({ name: name, new_instance_id: new_instance_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.rename_instance name: name, new_instance_id: new_instance_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.rename_instance ::Google::Cloud::BareMetalSolution::V2::RenameInstanceRequest.new(name: name, new_instance_id: new_instance_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.rename_instance({ name: name, new_instance_id: new_instance_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.rename_instance(::Google::Cloud::BareMetalSolution::V2::RenameInstanceRequest.new(name: name, new_instance_id: new_instance_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, rename_instance_client_stub.call_count
      end
    end
  end

  def test_reset_instance
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    reset_instance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_reset_instance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, reset_instance_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.reset_instance({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.reset_instance name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.reset_instance ::Google::Cloud::BareMetalSolution::V2::ResetInstanceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.reset_instance({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.reset_instance(::Google::Cloud::BareMetalSolution::V2::ResetInstanceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, reset_instance_client_stub.call_count
      end
    end
  end

  def test_start_instance
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    start_instance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_start_instance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, start_instance_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.start_instance({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.start_instance name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.start_instance ::Google::Cloud::BareMetalSolution::V2::StartInstanceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.start_instance({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.start_instance(::Google::Cloud::BareMetalSolution::V2::StartInstanceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, start_instance_client_stub.call_count
      end
    end
  end

  def test_stop_instance
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    stop_instance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_stop_instance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, stop_instance_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.stop_instance({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.stop_instance name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.stop_instance ::Google::Cloud::BareMetalSolution::V2::StopInstanceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.stop_instance({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.stop_instance(::Google::Cloud::BareMetalSolution::V2::StopInstanceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, stop_instance_client_stub.call_count
      end
    end
  end

  def test_enable_interactive_serial_console
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    enable_interactive_serial_console_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_enable_interactive_serial_console_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, enable_interactive_serial_console_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.enable_interactive_serial_console({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.enable_interactive_serial_console name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.enable_interactive_serial_console ::Google::Cloud::BareMetalSolution::V2::EnableInteractiveSerialConsoleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.enable_interactive_serial_console({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.enable_interactive_serial_console(::Google::Cloud::BareMetalSolution::V2::EnableInteractiveSerialConsoleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, enable_interactive_serial_console_client_stub.call_count
      end
    end
  end

  def test_disable_interactive_serial_console
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    disable_interactive_serial_console_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_disable_interactive_serial_console_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, disable_interactive_serial_console_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.disable_interactive_serial_console({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.disable_interactive_serial_console name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.disable_interactive_serial_console ::Google::Cloud::BareMetalSolution::V2::DisableInteractiveSerialConsoleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.disable_interactive_serial_console({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.disable_interactive_serial_console(::Google::Cloud::BareMetalSolution::V2::DisableInteractiveSerialConsoleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, disable_interactive_serial_console_client_stub.call_count
      end
    end
  end

  def test_detach_lun
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    lun = "hello world"
    skip_reboot = true

    detach_lun_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_detach_lun_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, detach_lun_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.detach_lun({ instance: instance, lun: lun, skip_reboot: skip_reboot }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.detach_lun instance: instance, lun: lun, skip_reboot: skip_reboot do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.detach_lun ::Google::Cloud::BareMetalSolution::V2::DetachLunRequest.new(instance: instance, lun: lun, skip_reboot: skip_reboot) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.detach_lun({ instance: instance, lun: lun, skip_reboot: skip_reboot }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.detach_lun(::Google::Cloud::BareMetalSolution::V2::DetachLunRequest.new(instance: instance, lun: lun, skip_reboot: skip_reboot), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, detach_lun_client_stub.call_count
      end
    end
  end

  def test_list_ssh_keys
    # Create test objects.
    client_result = ::Google::Cloud::BareMetalSolution::V2::ListSSHKeysResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_ssh_keys_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_list_ssh_keys_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_ssh_keys_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_ssh_keys({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_ssh_keys parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_ssh_keys ::Google::Cloud::BareMetalSolution::V2::ListSSHKeysRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_ssh_keys({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_ssh_keys(::Google::Cloud::BareMetalSolution::V2::ListSSHKeysRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_ssh_keys_client_stub.call_count
      end
    end
  end

  def test_create_ssh_key
    # Create test objects.
    client_result = ::Google::Cloud::BareMetalSolution::V2::SSHKey.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    ssh_key = {}
    ssh_key_id = "hello world"

    create_ssh_key_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_create_ssh_key_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_ssh_key_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_ssh_key({ parent: parent, ssh_key: ssh_key, ssh_key_id: ssh_key_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_ssh_key parent: parent, ssh_key: ssh_key, ssh_key_id: ssh_key_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_ssh_key ::Google::Cloud::BareMetalSolution::V2::CreateSSHKeyRequest.new(parent: parent, ssh_key: ssh_key, ssh_key_id: ssh_key_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_ssh_key({ parent: parent, ssh_key: ssh_key, ssh_key_id: ssh_key_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_ssh_key(::Google::Cloud::BareMetalSolution::V2::CreateSSHKeyRequest.new(parent: parent, ssh_key: ssh_key, ssh_key_id: ssh_key_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_ssh_key_client_stub.call_count
      end
    end
  end

  def test_delete_ssh_key
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_ssh_key_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_delete_ssh_key_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_ssh_key_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_ssh_key({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_ssh_key name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_ssh_key ::Google::Cloud::BareMetalSolution::V2::DeleteSSHKeyRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_ssh_key({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_ssh_key(::Google::Cloud::BareMetalSolution::V2::DeleteSSHKeyRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_ssh_key_client_stub.call_count
      end
    end
  end

  def test_list_volumes
    # Create test objects.
    client_result = ::Google::Cloud::BareMetalSolution::V2::ListVolumesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_volumes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_list_volumes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_volumes_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_volumes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_volumes parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_volumes ::Google::Cloud::BareMetalSolution::V2::ListVolumesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_volumes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_volumes(::Google::Cloud::BareMetalSolution::V2::ListVolumesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_volumes_client_stub.call_count
      end
    end
  end

  def test_get_volume
    # Create test objects.
    client_result = ::Google::Cloud::BareMetalSolution::V2::Volume.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_volume_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_get_volume_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_volume_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_volume({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_volume name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_volume ::Google::Cloud::BareMetalSolution::V2::GetVolumeRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_volume({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_volume(::Google::Cloud::BareMetalSolution::V2::GetVolumeRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_volume_client_stub.call_count
      end
    end
  end

  def test_update_volume
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    volume = {}
    update_mask = {}

    update_volume_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_update_volume_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_volume_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_volume({ volume: volume, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_volume volume: volume, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_volume ::Google::Cloud::BareMetalSolution::V2::UpdateVolumeRequest.new(volume: volume, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_volume({ volume: volume, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_volume(::Google::Cloud::BareMetalSolution::V2::UpdateVolumeRequest.new(volume: volume, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_volume_client_stub.call_count
      end
    end
  end

  def test_rename_volume
    # Create test objects.
    client_result = ::Google::Cloud::BareMetalSolution::V2::Volume.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    new_volume_id = "hello world"

    rename_volume_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_rename_volume_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, rename_volume_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.rename_volume({ name: name, new_volume_id: new_volume_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.rename_volume name: name, new_volume_id: new_volume_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.rename_volume ::Google::Cloud::BareMetalSolution::V2::RenameVolumeRequest.new(name: name, new_volume_id: new_volume_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.rename_volume({ name: name, new_volume_id: new_volume_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.rename_volume(::Google::Cloud::BareMetalSolution::V2::RenameVolumeRequest.new(name: name, new_volume_id: new_volume_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, rename_volume_client_stub.call_count
      end
    end
  end

  def test_evict_volume
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    evict_volume_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_evict_volume_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, evict_volume_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.evict_volume({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.evict_volume name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.evict_volume ::Google::Cloud::BareMetalSolution::V2::EvictVolumeRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.evict_volume({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.evict_volume(::Google::Cloud::BareMetalSolution::V2::EvictVolumeRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, evict_volume_client_stub.call_count
      end
    end
  end

  def test_resize_volume
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    volume = "hello world"
    size_gib = 42

    resize_volume_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_resize_volume_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, resize_volume_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.resize_volume({ volume: volume, size_gib: size_gib }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.resize_volume volume: volume, size_gib: size_gib do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.resize_volume ::Google::Cloud::BareMetalSolution::V2::ResizeVolumeRequest.new(volume: volume, size_gib: size_gib) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.resize_volume({ volume: volume, size_gib: size_gib }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.resize_volume(::Google::Cloud::BareMetalSolution::V2::ResizeVolumeRequest.new(volume: volume, size_gib: size_gib), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, resize_volume_client_stub.call_count
      end
    end
  end

  def test_list_networks
    # Create test objects.
    client_result = ::Google::Cloud::BareMetalSolution::V2::ListNetworksResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_networks_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_list_networks_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_networks_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_networks({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_networks parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_networks ::Google::Cloud::BareMetalSolution::V2::ListNetworksRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_networks({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_networks(::Google::Cloud::BareMetalSolution::V2::ListNetworksRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_networks_client_stub.call_count
      end
    end
  end

  def test_list_network_usage
    # Create test objects.
    client_result = ::Google::Cloud::BareMetalSolution::V2::ListNetworkUsageResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    location = "hello world"

    list_network_usage_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_list_network_usage_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_network_usage_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_network_usage({ location: location }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_network_usage location: location do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_network_usage ::Google::Cloud::BareMetalSolution::V2::ListNetworkUsageRequest.new(location: location) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_network_usage({ location: location }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_network_usage(::Google::Cloud::BareMetalSolution::V2::ListNetworkUsageRequest.new(location: location), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_network_usage_client_stub.call_count
      end
    end
  end

  def test_get_network
    # Create test objects.
    client_result = ::Google::Cloud::BareMetalSolution::V2::Network.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_network_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_get_network_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_network_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_network({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_network name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_network ::Google::Cloud::BareMetalSolution::V2::GetNetworkRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_network({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_network(::Google::Cloud::BareMetalSolution::V2::GetNetworkRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_network_client_stub.call_count
      end
    end
  end

  def test_update_network
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    network = {}
    update_mask = {}

    update_network_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_update_network_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_network_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_network({ network: network, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_network network: network, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_network ::Google::Cloud::BareMetalSolution::V2::UpdateNetworkRequest.new(network: network, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_network({ network: network, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_network(::Google::Cloud::BareMetalSolution::V2::UpdateNetworkRequest.new(network: network, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_network_client_stub.call_count
      end
    end
  end

  def test_create_volume_snapshot
    # Create test objects.
    client_result = ::Google::Cloud::BareMetalSolution::V2::VolumeSnapshot.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    volume_snapshot = {}

    create_volume_snapshot_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_create_volume_snapshot_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_volume_snapshot_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_volume_snapshot({ parent: parent, volume_snapshot: volume_snapshot }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_volume_snapshot parent: parent, volume_snapshot: volume_snapshot do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_volume_snapshot ::Google::Cloud::BareMetalSolution::V2::CreateVolumeSnapshotRequest.new(parent: parent, volume_snapshot: volume_snapshot) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_volume_snapshot({ parent: parent, volume_snapshot: volume_snapshot }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_volume_snapshot(::Google::Cloud::BareMetalSolution::V2::CreateVolumeSnapshotRequest.new(parent: parent, volume_snapshot: volume_snapshot), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_volume_snapshot_client_stub.call_count
      end
    end
  end

  def test_restore_volume_snapshot
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    volume_snapshot = "hello world"

    restore_volume_snapshot_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_restore_volume_snapshot_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, restore_volume_snapshot_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.restore_volume_snapshot({ volume_snapshot: volume_snapshot }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.restore_volume_snapshot volume_snapshot: volume_snapshot do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.restore_volume_snapshot ::Google::Cloud::BareMetalSolution::V2::RestoreVolumeSnapshotRequest.new(volume_snapshot: volume_snapshot) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.restore_volume_snapshot({ volume_snapshot: volume_snapshot }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.restore_volume_snapshot(::Google::Cloud::BareMetalSolution::V2::RestoreVolumeSnapshotRequest.new(volume_snapshot: volume_snapshot), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, restore_volume_snapshot_client_stub.call_count
      end
    end
  end

  def test_delete_volume_snapshot
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_volume_snapshot_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_delete_volume_snapshot_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_volume_snapshot_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_volume_snapshot({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_volume_snapshot name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_volume_snapshot ::Google::Cloud::BareMetalSolution::V2::DeleteVolumeSnapshotRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_volume_snapshot({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_volume_snapshot(::Google::Cloud::BareMetalSolution::V2::DeleteVolumeSnapshotRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_volume_snapshot_client_stub.call_count
      end
    end
  end

  def test_get_volume_snapshot
    # Create test objects.
    client_result = ::Google::Cloud::BareMetalSolution::V2::VolumeSnapshot.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_volume_snapshot_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_get_volume_snapshot_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_volume_snapshot_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_volume_snapshot({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_volume_snapshot name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_volume_snapshot ::Google::Cloud::BareMetalSolution::V2::GetVolumeSnapshotRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_volume_snapshot({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_volume_snapshot(::Google::Cloud::BareMetalSolution::V2::GetVolumeSnapshotRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_volume_snapshot_client_stub.call_count
      end
    end
  end

  def test_list_volume_snapshots
    # Create test objects.
    client_result = ::Google::Cloud::BareMetalSolution::V2::ListVolumeSnapshotsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_volume_snapshots_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_list_volume_snapshots_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_volume_snapshots_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_volume_snapshots({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_volume_snapshots parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_volume_snapshots ::Google::Cloud::BareMetalSolution::V2::ListVolumeSnapshotsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_volume_snapshots({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_volume_snapshots(::Google::Cloud::BareMetalSolution::V2::ListVolumeSnapshotsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_volume_snapshots_client_stub.call_count
      end
    end
  end

  def test_get_lun
    # Create test objects.
    client_result = ::Google::Cloud::BareMetalSolution::V2::Lun.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_lun_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_get_lun_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_lun_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_lun({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_lun name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_lun ::Google::Cloud::BareMetalSolution::V2::GetLunRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_lun({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_lun(::Google::Cloud::BareMetalSolution::V2::GetLunRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_lun_client_stub.call_count
      end
    end
  end

  def test_list_luns
    # Create test objects.
    client_result = ::Google::Cloud::BareMetalSolution::V2::ListLunsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_luns_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_list_luns_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_luns_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_luns({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_luns parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_luns ::Google::Cloud::BareMetalSolution::V2::ListLunsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_luns({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_luns(::Google::Cloud::BareMetalSolution::V2::ListLunsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_luns_client_stub.call_count
      end
    end
  end

  def test_evict_lun
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    evict_lun_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_evict_lun_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, evict_lun_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.evict_lun({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.evict_lun name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.evict_lun ::Google::Cloud::BareMetalSolution::V2::EvictLunRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.evict_lun({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.evict_lun(::Google::Cloud::BareMetalSolution::V2::EvictLunRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, evict_lun_client_stub.call_count
      end
    end
  end

  def test_get_nfs_share
    # Create test objects.
    client_result = ::Google::Cloud::BareMetalSolution::V2::NfsShare.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_nfs_share_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_get_nfs_share_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_nfs_share_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_nfs_share({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_nfs_share name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_nfs_share ::Google::Cloud::BareMetalSolution::V2::GetNfsShareRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_nfs_share({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_nfs_share(::Google::Cloud::BareMetalSolution::V2::GetNfsShareRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_nfs_share_client_stub.call_count
      end
    end
  end

  def test_list_nfs_shares
    # Create test objects.
    client_result = ::Google::Cloud::BareMetalSolution::V2::ListNfsSharesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_nfs_shares_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_list_nfs_shares_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_nfs_shares_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_nfs_shares({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_nfs_shares parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_nfs_shares ::Google::Cloud::BareMetalSolution::V2::ListNfsSharesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_nfs_shares({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_nfs_shares(::Google::Cloud::BareMetalSolution::V2::ListNfsSharesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_nfs_shares_client_stub.call_count
      end
    end
  end

  def test_update_nfs_share
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    nfs_share = {}
    update_mask = {}

    update_nfs_share_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_update_nfs_share_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_nfs_share_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_nfs_share({ nfs_share: nfs_share, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_nfs_share nfs_share: nfs_share, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_nfs_share ::Google::Cloud::BareMetalSolution::V2::UpdateNfsShareRequest.new(nfs_share: nfs_share, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_nfs_share({ nfs_share: nfs_share, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_nfs_share(::Google::Cloud::BareMetalSolution::V2::UpdateNfsShareRequest.new(nfs_share: nfs_share, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_nfs_share_client_stub.call_count
      end
    end
  end

  def test_create_nfs_share
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    nfs_share = {}

    create_nfs_share_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_create_nfs_share_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_nfs_share_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_nfs_share({ parent: parent, nfs_share: nfs_share }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_nfs_share parent: parent, nfs_share: nfs_share do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_nfs_share ::Google::Cloud::BareMetalSolution::V2::CreateNfsShareRequest.new(parent: parent, nfs_share: nfs_share) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_nfs_share({ parent: parent, nfs_share: nfs_share }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_nfs_share(::Google::Cloud::BareMetalSolution::V2::CreateNfsShareRequest.new(parent: parent, nfs_share: nfs_share), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_nfs_share_client_stub.call_count
      end
    end
  end

  def test_rename_nfs_share
    # Create test objects.
    client_result = ::Google::Cloud::BareMetalSolution::V2::NfsShare.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    new_nfsshare_id = "hello world"

    rename_nfs_share_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_rename_nfs_share_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, rename_nfs_share_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.rename_nfs_share({ name: name, new_nfsshare_id: new_nfsshare_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.rename_nfs_share name: name, new_nfsshare_id: new_nfsshare_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.rename_nfs_share ::Google::Cloud::BareMetalSolution::V2::RenameNfsShareRequest.new(name: name, new_nfsshare_id: new_nfsshare_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.rename_nfs_share({ name: name, new_nfsshare_id: new_nfsshare_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.rename_nfs_share(::Google::Cloud::BareMetalSolution::V2::RenameNfsShareRequest.new(name: name, new_nfsshare_id: new_nfsshare_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, rename_nfs_share_client_stub.call_count
      end
    end
  end

  def test_delete_nfs_share
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_nfs_share_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_delete_nfs_share_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_nfs_share_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_nfs_share({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_nfs_share name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_nfs_share ::Google::Cloud::BareMetalSolution::V2::DeleteNfsShareRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_nfs_share({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_nfs_share(::Google::Cloud::BareMetalSolution::V2::DeleteNfsShareRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_nfs_share_client_stub.call_count
      end
    end
  end

  def test_list_provisioning_quotas
    # Create test objects.
    client_result = ::Google::Cloud::BareMetalSolution::V2::ListProvisioningQuotasResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_provisioning_quotas_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_list_provisioning_quotas_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_provisioning_quotas_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_provisioning_quotas({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_provisioning_quotas parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_provisioning_quotas ::Google::Cloud::BareMetalSolution::V2::ListProvisioningQuotasRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_provisioning_quotas({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_provisioning_quotas(::Google::Cloud::BareMetalSolution::V2::ListProvisioningQuotasRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_provisioning_quotas_client_stub.call_count
      end
    end
  end

  def test_submit_provisioning_config
    # Create test objects.
    client_result = ::Google::Cloud::BareMetalSolution::V2::SubmitProvisioningConfigResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    provisioning_config = {}
    email = "hello world"

    submit_provisioning_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_submit_provisioning_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, submit_provisioning_config_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.submit_provisioning_config({ parent: parent, provisioning_config: provisioning_config, email: email }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.submit_provisioning_config parent: parent, provisioning_config: provisioning_config, email: email do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.submit_provisioning_config ::Google::Cloud::BareMetalSolution::V2::SubmitProvisioningConfigRequest.new(parent: parent, provisioning_config: provisioning_config, email: email) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.submit_provisioning_config({ parent: parent, provisioning_config: provisioning_config, email: email }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.submit_provisioning_config(::Google::Cloud::BareMetalSolution::V2::SubmitProvisioningConfigRequest.new(parent: parent, provisioning_config: provisioning_config, email: email), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, submit_provisioning_config_client_stub.call_count
      end
    end
  end

  def test_get_provisioning_config
    # Create test objects.
    client_result = ::Google::Cloud::BareMetalSolution::V2::ProvisioningConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_provisioning_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_get_provisioning_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_provisioning_config_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_provisioning_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_provisioning_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_provisioning_config ::Google::Cloud::BareMetalSolution::V2::GetProvisioningConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_provisioning_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_provisioning_config(::Google::Cloud::BareMetalSolution::V2::GetProvisioningConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_provisioning_config_client_stub.call_count
      end
    end
  end

  def test_create_provisioning_config
    # Create test objects.
    client_result = ::Google::Cloud::BareMetalSolution::V2::ProvisioningConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    provisioning_config = {}
    email = "hello world"

    create_provisioning_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_create_provisioning_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_provisioning_config_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_provisioning_config({ parent: parent, provisioning_config: provisioning_config, email: email }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_provisioning_config parent: parent, provisioning_config: provisioning_config, email: email do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_provisioning_config ::Google::Cloud::BareMetalSolution::V2::CreateProvisioningConfigRequest.new(parent: parent, provisioning_config: provisioning_config, email: email) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_provisioning_config({ parent: parent, provisioning_config: provisioning_config, email: email }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_provisioning_config(::Google::Cloud::BareMetalSolution::V2::CreateProvisioningConfigRequest.new(parent: parent, provisioning_config: provisioning_config, email: email), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_provisioning_config_client_stub.call_count
      end
    end
  end

  def test_update_provisioning_config
    # Create test objects.
    client_result = ::Google::Cloud::BareMetalSolution::V2::ProvisioningConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    provisioning_config = {}
    update_mask = {}
    email = "hello world"

    update_provisioning_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_update_provisioning_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_provisioning_config_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_provisioning_config({ provisioning_config: provisioning_config, update_mask: update_mask, email: email }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_provisioning_config provisioning_config: provisioning_config, update_mask: update_mask, email: email do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_provisioning_config ::Google::Cloud::BareMetalSolution::V2::UpdateProvisioningConfigRequest.new(provisioning_config: provisioning_config, update_mask: update_mask, email: email) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_provisioning_config({ provisioning_config: provisioning_config, update_mask: update_mask, email: email }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_provisioning_config(::Google::Cloud::BareMetalSolution::V2::UpdateProvisioningConfigRequest.new(provisioning_config: provisioning_config, update_mask: update_mask, email: email), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_provisioning_config_client_stub.call_count
      end
    end
  end

  def test_rename_network
    # Create test objects.
    client_result = ::Google::Cloud::BareMetalSolution::V2::Network.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    new_network_id = "hello world"

    rename_network_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_rename_network_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, rename_network_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.rename_network({ name: name, new_network_id: new_network_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.rename_network name: name, new_network_id: new_network_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.rename_network ::Google::Cloud::BareMetalSolution::V2::RenameNetworkRequest.new(name: name, new_network_id: new_network_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.rename_network({ name: name, new_network_id: new_network_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.rename_network(::Google::Cloud::BareMetalSolution::V2::RenameNetworkRequest.new(name: name, new_network_id: new_network_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, rename_network_client_stub.call_count
      end
    end
  end

  def test_list_os_images
    # Create test objects.
    client_result = ::Google::Cloud::BareMetalSolution::V2::ListOSImagesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_os_images_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.stub :transcode_list_os_images_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_os_images_client_stub do
        # Create client
        client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_os_images({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_os_images parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_os_images ::Google::Cloud::BareMetalSolution::V2::ListOSImagesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_os_images({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_os_images(::Google::Cloud::BareMetalSolution::V2::ListOSImagesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_os_images_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client::Configuration, config
  end
end
