# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/bare_metal_solution/v2/bare_metal_solution"

class ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_instance_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.instance_path project: "value0", location: "value1", instance: "value2"
      assert_equal "projects/value0/locations/value1/instances/value2", path
    end
  end

  def test_instance_config_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.instance_config_path project: "value0", location: "value1", instance_config: "value2"
      assert_equal "projects/value0/locations/value1/instanceConfigs/value2", path
    end
  end

  def test_interconnect_attachment_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.interconnect_attachment_path project: "value0", region: "value1", interconnect_attachment: "value2"
      assert_equal "projects/value0/regions/value1/interconnectAttachments/value2", path
    end
  end

  def test_location_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.location_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1", path
    end
  end

  def test_lun_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.lun_path project: "value0", location: "value1", volume: "value2", lun: "value3"
      assert_equal "projects/value0/locations/value1/volumes/value2/luns/value3", path
    end
  end

  def test_nfs_share_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.nfs_share_path project: "value0", location: "value1", nfs_share: "value2"
      assert_equal "projects/value0/locations/value1/nfsShares/value2", path
    end
  end

  def test_network_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.network_path project: "value0", location: "value1", network: "value2"
      assert_equal "projects/value0/locations/value1/networks/value2", path
    end
  end

  def test_network_config_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.network_config_path project: "value0", location: "value1", network_config: "value2"
      assert_equal "projects/value0/locations/value1/networkConfigs/value2", path
    end
  end

  def test_provisioning_config_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.provisioning_config_path project: "value0", location: "value1", provisioning_config: "value2"
      assert_equal "projects/value0/locations/value1/provisioningConfigs/value2", path
    end
  end

  def test_server_network_template_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.server_network_template_path project: "value0", location: "value1", server_network_template: "value2"
      assert_equal "projects/value0/locations/value1/serverNetworkTemplate/value2", path
    end
  end

  def test_ssh_key_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.ssh_key_path project: "value0", location: "value1", ssh_key: "value2"
      assert_equal "projects/value0/locations/value1/sshKeys/value2", path
    end
  end

  def test_volume_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.volume_path project: "value0", location: "value1", volume: "value2"
      assert_equal "projects/value0/locations/value1/volumes/value2", path
    end
  end

  def test_volume_config_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.volume_config_path project: "value0", location: "value1", volume_config: "value2"
      assert_equal "projects/value0/locations/value1/volumeConfigs/value2", path
    end
  end

  def test_volume_snapshot_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.volume_snapshot_path project: "value0", location: "value1", volume: "value2", snapshot: "value3"
      assert_equal "projects/value0/locations/value1/volumes/value2/snapshots/value3", path
    end
  end
end
