# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module BareMetalSolution
      module V2
        # A provisioning configuration.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The system-generated name of the provisioning config. This
        #     follows the UUID format.
        # @!attribute [rw] instances
        #   @return [::Array<::Google::Cloud::BareMetalSolution::V2::InstanceConfig>]
        #     Instances to be created.
        # @!attribute [rw] networks
        #   @return [::Array<::Google::Cloud::BareMetalSolution::V2::NetworkConfig>]
        #     Networks to be created.
        # @!attribute [rw] volumes
        #   @return [::Array<::Google::Cloud::BareMetalSolution::V2::VolumeConfig>]
        #     Volumes to be created.
        # @!attribute [rw] ticket_id
        #   @return [::String]
        #     A generated ticket id to track provisioning request.
        # @!attribute [rw] handover_service_account
        #   @return [::String]
        #     A service account to enable customers to access instance credentials upon
        #     handover.
        # @!attribute [rw] email
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Email provided to send a confirmation with provisioning config to.
        #     Deprecated in favour of email field in request messages.
        # @!attribute [r] state
        #   @return [::Google::Cloud::BareMetalSolution::V2::ProvisioningConfig::State]
        #     Output only. State of ProvisioningConfig.
        # @!attribute [rw] location
        #   @return [::String]
        #     Optional. Location name of this ProvisioningConfig.
        #     It is optional only for Intake UI transition period.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Last update timestamp.
        # @!attribute [r] cloud_console_uri
        #   @return [::String]
        #     Output only. URI to Cloud Console UI view of this provisioning config.
        # @!attribute [rw] vpc_sc_enabled
        #   @return [::Boolean]
        #     If true, VPC SC is enabled for the cluster.
        # @!attribute [rw] status_message
        #   @return [::String]
        #     Optional status messages associated with the FAILED state.
        # @!attribute [rw] custom_id
        #   @return [::String]
        #     Optional. The user-defined identifier of the provisioning config.
        class ProvisioningConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The possible states for this ProvisioningConfig.
          module State
            # State wasn't specified.
            STATE_UNSPECIFIED = 0

            # ProvisioningConfig is a draft and can be freely modified.
            DRAFT = 1

            # ProvisioningConfig was already submitted and cannot be modified.
            SUBMITTED = 2

            # ProvisioningConfig was in the provisioning state.  Initially this state
            # comes from the work order table in big query when SNOW is used.  Later
            # this field can be set by the work order API.
            PROVISIONING = 3

            # ProvisioningConfig was provisioned, meaning the resources exist.
            PROVISIONED = 4

            # ProvisioningConfig was validated.  A validation tool will be run to
            # set this state.
            VALIDATED = 5

            # ProvisioningConfig was canceled.
            CANCELLED = 6

            # The request is submitted for provisioning, with error return.
            FAILED = 7
          end
        end

        # Request for SubmitProvisioningConfig.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent project and location containing the
        #     ProvisioningConfig.
        # @!attribute [rw] provisioning_config
        #   @return [::Google::Cloud::BareMetalSolution::V2::ProvisioningConfig]
        #     Required. The ProvisioningConfig to create.
        # @!attribute [rw] email
        #   @return [::String]
        #     Optional. Email provided to send a confirmation with provisioning config
        #     to.
        class SubmitProvisioningConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for SubmitProvisioningConfig.
        # @!attribute [rw] provisioning_config
        #   @return [::Google::Cloud::BareMetalSolution::V2::ProvisioningConfig]
        #     The submitted provisioning config.
        class SubmitProvisioningConfigResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A provisioning quota for a given project.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The name of the provisioning quota.
        # @!attribute [rw] asset_type
        #   @return [::Google::Cloud::BareMetalSolution::V2::ProvisioningQuota::AssetType]
        #     The asset type of this provisioning quota.
        # @!attribute [rw] gcp_service
        #   @return [::String]
        #     The gcp service of the provisioning quota.
        # @!attribute [rw] location
        #   @return [::String]
        #     The specific location of the provisioining quota.
        # @!attribute [rw] available_count
        #   @return [::Integer]
        #     The available count of the provisioning quota.
        # @!attribute [rw] instance_quota
        #   @return [::Google::Cloud::BareMetalSolution::V2::InstanceQuota]
        #     Instance quota.
        # @!attribute [rw] server_count
        #   @return [::Integer]
        #     Server count.
        #
        #     Note: The following fields are mutually exclusive: `server_count`, `network_bandwidth`, `storage_gib`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] network_bandwidth
        #   @return [::Integer]
        #     Network bandwidth, Gbps
        #
        #     Note: The following fields are mutually exclusive: `network_bandwidth`, `server_count`, `storage_gib`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] storage_gib
        #   @return [::Integer]
        #     Storage size (GB).
        #
        #     Note: The following fields are mutually exclusive: `storage_gib`, `server_count`, `network_bandwidth`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class ProvisioningQuota
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The available asset types for intake.
          module AssetType
            # The unspecified type.
            ASSET_TYPE_UNSPECIFIED = 0

            # The server asset type.
            ASSET_TYPE_SERVER = 1

            # The storage asset type.
            ASSET_TYPE_STORAGE = 2

            # The network asset type.
            ASSET_TYPE_NETWORK = 3
          end
        end

        # Message for requesting the list of provisioning quotas.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListProvisioningQuotasRequest.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. The server might return fewer items than requested.
        #     If unspecified, server will pick an appropriate default.
        #     Notice that page_size field is not supported and won't be respected in
        #     the API request for now, will be updated when pagination is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results from the server.
        class ListProvisioningQuotasRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for the list of provisioning quotas.
        # @!attribute [rw] provisioning_quotas
        #   @return [::Array<::Google::Cloud::BareMetalSolution::V2::ProvisioningQuota>]
        #     The provisioning quotas registered in this project.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        class ListProvisioningQuotasResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration parameters for a new instance.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The name of the instance config.
        # @!attribute [rw] id
        #   @return [::String]
        #     A transient unique identifier to idenfity an instance within an
        #     ProvisioningConfig request.
        # @!attribute [rw] instance_type
        #   @return [::String]
        #     Instance type.
        #     [Available
        #     types](https://cloud.google.com/bare-metal/docs/bms-planning#server_configurations)
        # @!attribute [rw] hyperthreading
        #   @return [::Boolean]
        #     Whether the instance should be provisioned with Hyperthreading enabled.
        # @!attribute [rw] os_image
        #   @return [::String]
        #     OS image to initialize the instance.
        #     [Available
        #     images](https://cloud.google.com/bare-metal/docs/bms-planning#server_configurations)
        # @!attribute [rw] client_network
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::BareMetalSolution::V2::InstanceConfig::NetworkAddress]
        #     Client network address. Filled if InstanceConfig.multivlan_config is false.
        # @!attribute [rw] private_network
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::BareMetalSolution::V2::InstanceConfig::NetworkAddress]
        #     Private network address, if any. Filled if InstanceConfig.multivlan_config
        #     is false.
        # @!attribute [rw] user_note
        #   @return [::String]
        #     User note field, it can be used by customers to add additional information
        #     for the BMS Ops team .
        # @!attribute [rw] account_networks_enabled
        #   @return [::Boolean]
        #     If true networks can be from different projects of the same vendor account.
        # @!attribute [rw] network_config
        #   @return [::Google::Cloud::BareMetalSolution::V2::InstanceConfig::NetworkConfig]
        #     The type of network configuration on the instance.
        # @!attribute [rw] network_template
        #   @return [::String]
        #     Server network template name. Filled if InstanceConfig.multivlan_config is
        #     true.
        # @!attribute [rw] logical_interfaces
        #   @return [::Array<::Google::Cloud::BareMetalSolution::V2::LogicalInterface>]
        #     List of logical interfaces for the instance. The number of logical
        #     interfaces will be the same as number of hardware bond/nic on the chosen
        #     network template. Filled if InstanceConfig.multivlan_config is true.
        # @!attribute [rw] ssh_key_names
        #   @return [::Array<::String>]
        #     List of names of ssh keys used to provision the instance.
        class InstanceConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A network.
          # @!attribute [rw] network_id
          #   @return [::String]
          #     Id of the network to use, within the same ProvisioningConfig request.
          # @!attribute [rw] address
          #   @return [::String]
          #     IPv4 address to be assigned to the server.
          # @!attribute [rw] existing_network_id
          #   @return [::String]
          #     Name of the existing network to use.
          class NetworkAddress
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The network configuration of the instance.
          module NetworkConfig
            # The unspecified network configuration.
            NETWORKCONFIG_UNSPECIFIED = 0

            # Instance part of single client network and single private network.
            SINGLE_VLAN = 1

            # Instance part of multiple (or single) client networks and private
            # networks.
            MULTI_VLAN = 2
          end
        end

        # Configuration parameters for a new volume.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The name of the volume config.
        # @!attribute [rw] id
        #   @return [::String]
        #     A transient unique identifier to identify a volume within an
        #     ProvisioningConfig request.
        # @!attribute [rw] snapshots_enabled
        #   @return [::Boolean]
        #     Whether snapshots should be enabled.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::BareMetalSolution::V2::VolumeConfig::Type]
        #     The type of this Volume.
        # @!attribute [rw] protocol
        #   @return [::Google::Cloud::BareMetalSolution::V2::VolumeConfig::Protocol]
        #     Volume protocol.
        # @!attribute [rw] size_gb
        #   @return [::Integer]
        #     The requested size of this volume, in GB.
        # @!attribute [rw] lun_ranges
        #   @return [::Array<::Google::Cloud::BareMetalSolution::V2::VolumeConfig::LunRange>]
        #     LUN ranges to be configured. Set only when protocol is PROTOCOL_FC.
        # @!attribute [rw] machine_ids
        #   @return [::Array<::String>]
        #     Machine ids connected to this volume. Set only when protocol is
        #     PROTOCOL_FC.
        # @!attribute [rw] nfs_exports
        #   @return [::Array<::Google::Cloud::BareMetalSolution::V2::VolumeConfig::NfsExport>]
        #     NFS exports. Set only when protocol is PROTOCOL_NFS.
        # @!attribute [rw] user_note
        #   @return [::String]
        #     User note field, it can be used by customers to add additional information
        #     for the BMS Ops team .
        # @!attribute [rw] gcp_service
        #   @return [::String]
        #     The GCP service of the storage volume. Available gcp_service are in
        #     https://cloud.google.com/bare-metal/docs/bms-planning.
        # @!attribute [rw] performance_tier
        #   @return [::Google::Cloud::BareMetalSolution::V2::VolumePerformanceTier]
        #     Performance tier of the Volume.
        #     Default is SHARED.
        class VolumeConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A LUN(Logical Unit Number) range.
          # @!attribute [rw] quantity
          #   @return [::Integer]
          #     Number of LUNs to create.
          # @!attribute [rw] size_gb
          #   @return [::Integer]
          #     The requested size of each LUN, in GB.
          class LunRange
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A NFS export entry.
          # @!attribute [rw] network_id
          #   @return [::String]
          #     Network to use to publish the export.
          # @!attribute [rw] machine_id
          #   @return [::String]
          #     Either a single machine, identified by an ID, or a comma-separated
          #     list of machine IDs.
          #
          #     Note: The following fields are mutually exclusive: `machine_id`, `cidr`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] cidr
          #   @return [::String]
          #     A CIDR range.
          #
          #     Note: The following fields are mutually exclusive: `cidr`, `machine_id`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] permissions
          #   @return [::Google::Cloud::BareMetalSolution::V2::VolumeConfig::NfsExport::Permissions]
          #     Export permissions.
          # @!attribute [rw] no_root_squash
          #   @return [::Boolean]
          #     Disable root squashing, which is a feature of NFS.
          #     Root squash is a special mapping of the remote superuser (root) identity
          #     when using identity authentication.
          # @!attribute [rw] allow_suid
          #   @return [::Boolean]
          #     Allow the setuid flag.
          # @!attribute [rw] allow_dev
          #   @return [::Boolean]
          #     Allow dev flag in NfsShare AllowedClientsRequest.
          class NfsExport
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Permissions that can granted for an export.
            module Permissions
              # Unspecified value.
              PERMISSIONS_UNSPECIFIED = 0

              # Read-only permission.
              READ_ONLY = 1

              # Read-write permission.
              READ_WRITE = 2
            end
          end

          # The types of Volumes.
          module Type
            # The unspecified type.
            TYPE_UNSPECIFIED = 0

            # This Volume is on flash.
            FLASH = 1

            # This Volume is on disk.
            DISK = 2
          end

          # The protocol used to access the volume.
          module Protocol
            # Unspecified value.
            PROTOCOL_UNSPECIFIED = 0

            # Fibre channel.
            PROTOCOL_FC = 1

            # Network file system.
            PROTOCOL_NFS = 2
          end
        end

        # Configuration parameters for a new network.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The name of the network config.
        # @!attribute [rw] id
        #   @return [::String]
        #     A transient unique identifier to identify a volume within an
        #     ProvisioningConfig request.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::BareMetalSolution::V2::NetworkConfig::Type]
        #     The type of this network, either Client or Private.
        # @!attribute [rw] bandwidth
        #   @return [::Google::Cloud::BareMetalSolution::V2::NetworkConfig::Bandwidth]
        #     Interconnect bandwidth. Set only when type is CLIENT.
        # @!attribute [rw] vlan_attachments
        #   @return [::Array<::Google::Cloud::BareMetalSolution::V2::NetworkConfig::IntakeVlanAttachment>]
        #     List of VLAN attachments. As of now there are always 2 attachments, but it
        #     is going to change in  the future (multi vlan).
        # @!attribute [rw] cidr
        #   @return [::String]
        #     CIDR range of the network.
        # @!attribute [rw] service_cidr
        #   @return [::Google::Cloud::BareMetalSolution::V2::NetworkConfig::ServiceCidr]
        #     Service CIDR, if any.
        # @!attribute [rw] user_note
        #   @return [::String]
        #     User note field, it can be used by customers to add additional information
        #     for the BMS Ops team .
        # @!attribute [rw] gcp_service
        #   @return [::String]
        #     The GCP service of the network. Available gcp_service are in
        #     https://cloud.google.com/bare-metal/docs/bms-planning.
        # @!attribute [rw] vlan_same_project
        #   @return [::Boolean]
        #     Whether the VLAN attachment pair is located in the same project.
        # @!attribute [rw] jumbo_frames_enabled
        #   @return [::Boolean]
        #     The JumboFramesEnabled option for customer to set.
        class NetworkConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A GCP vlan attachment.
          # @!attribute [rw] id
          #   @return [::String]
          #     Identifier of the VLAN attachment.
          # @!attribute [rw] pairing_key
          #   @return [::String]
          #     Attachment pairing key.
          class IntakeVlanAttachment
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Network type.
          module Type
            # Unspecified value.
            TYPE_UNSPECIFIED = 0

            # Client network, that is a network peered to a GCP VPC.
            CLIENT = 1

            # Private network, that is a network local to the BMS POD.
            PRIVATE = 2
          end

          # Interconnect bandwidth.
          module Bandwidth
            # Unspecified value.
            BANDWIDTH_UNSPECIFIED = 0

            # 1 Gbps.
            BW_1_GBPS = 1

            # 2 Gbps.
            BW_2_GBPS = 2

            # 5 Gbps.
            BW_5_GBPS = 3

            # 10 Gbps.
            BW_10_GBPS = 4
          end

          # Service network block.
          module ServiceCidr
            # Unspecified value.
            SERVICE_CIDR_UNSPECIFIED = 0

            # Services are disabled for the given network.
            DISABLED = 1

            # Use the highest /26 block of the network to host services.
            HIGH_26 = 2

            # Use the highest /27 block of the network to host services.
            HIGH_27 = 3

            # Use the highest /28 block of the network to host services.
            HIGH_28 = 4
          end
        end

        # A resource budget.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The name of the instance quota.
        # @!attribute [rw] instance_type
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Instance type.
        #     Deprecated: use gcp_service.
        # @!attribute [rw] gcp_service
        #   @return [::String]
        #     The gcp service of the provisioning quota.
        # @!attribute [rw] location
        #   @return [::String]
        #     Location where the quota applies.
        # @!attribute [rw] available_machine_count
        #   @return [::Integer]
        #     Number of machines than can be created for the given location and
        #     instance_type.
        class InstanceQuota
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for GetProvisioningConfig.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the ProvisioningConfig.
        class GetProvisioningConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for CreateProvisioningConfig.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent project and location containing the
        #     ProvisioningConfig.
        # @!attribute [rw] provisioning_config
        #   @return [::Google::Cloud::BareMetalSolution::V2::ProvisioningConfig]
        #     Required. The ProvisioningConfig to create.
        # @!attribute [rw] email
        #   @return [::String]
        #     Optional. Email provided to send a confirmation with provisioning config
        #     to.
        class CreateProvisioningConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for updating a ProvisioningConfig.
        # @!attribute [rw] provisioning_config
        #   @return [::Google::Cloud::BareMetalSolution::V2::ProvisioningConfig]
        #     Required. The ProvisioningConfig to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to update.
        # @!attribute [rw] email
        #   @return [::String]
        #     Optional. Email provided to send a confirmation with provisioning config
        #     to.
        class UpdateProvisioningConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
