# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module BareMetalSolution
      module V2
        # Operation System image.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. OS Image's unique name.
        # @!attribute [rw] code
        #   @return [::String]
        #     OS Image code.
        # @!attribute [rw] description
        #   @return [::String]
        #     OS Image description.
        # @!attribute [rw] applicable_instance_types
        #   @return [::Array<::String>]
        #     Instance types this image is applicable to.
        #     [Available
        #     types](https://cloud.google.com/bare-metal/docs/bms-planning#server_configurations)
        # @!attribute [rw] supported_network_templates
        #   @return [::Array<::String>]
        #     Network templates that can be used with this OS Image.
        class OSImage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for getting all available OS images.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListProvisioningQuotasRequest.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. The server might return fewer items than requested.
        #     If unspecified, server will pick an appropriate default.
        #     Notice that page_size field is not supported and won't be respected in
        #     the API request for now, will be updated when pagination is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results from the server.
        class ListOSImagesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for getting all available OS images.
        # @!attribute [rw] os_images
        #   @return [::Array<::Google::Cloud::BareMetalSolution::V2::OSImage>]
        #     The OS images available.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        class ListOSImagesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
