# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module BareMetalSolution
      module V2
        # A storage volume logical unit number (LUN).
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The name of the LUN.
        # @!attribute [rw] id
        #   @return [::String]
        #     An identifier for the LUN, generated by the backend.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::BareMetalSolution::V2::Lun::State]
        #     The state of this storage volume.
        # @!attribute [rw] size_gb
        #   @return [::Integer]
        #     The size of this LUN, in gigabytes.
        # @!attribute [rw] multiprotocol_type
        #   @return [::Google::Cloud::BareMetalSolution::V2::Lun::MultiprotocolType]
        #     The LUN multiprotocol type ensures the characteristics of the LUN are
        #     optimized for each operating system.
        # @!attribute [rw] storage_volume
        #   @return [::String]
        #     Display the storage volume for this LUN.
        # @!attribute [rw] shareable
        #   @return [::Boolean]
        #     Display if this LUN can be shared between multiple physical servers.
        # @!attribute [rw] boot_lun
        #   @return [::Boolean]
        #     Display if this LUN is a boot LUN.
        # @!attribute [rw] storage_type
        #   @return [::Google::Cloud::BareMetalSolution::V2::Lun::StorageType]
        #     The storage type for this LUN.
        # @!attribute [rw] wwid
        #   @return [::String]
        #     The WWID for this LUN.
        # @!attribute [r] expire_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time after which LUN will be fully deleted.
        #     It is filled only for LUNs in COOL_OFF state.
        # @!attribute [r] instances
        #   @return [::Array<::String>]
        #     Output only. Instances this Lun is attached to.
        class Lun
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The possible states for the LUN.
          module State
            # The LUN is in an unknown state.
            STATE_UNSPECIFIED = 0

            # The LUN is being created.
            CREATING = 1

            # The LUN is being updated.
            UPDATING = 2

            # The LUN is ready for use.
            READY = 3

            # The LUN has been requested to be deleted.
            DELETING = 4

            # The LUN is in cool off state. It will be deleted after `expire_time`.
            COOL_OFF = 5
          end

          # Display the operating systems present for the LUN multiprotocol type.
          module MultiprotocolType
            # Server has no OS specified.
            MULTIPROTOCOL_TYPE_UNSPECIFIED = 0

            # Server with Linux OS.
            LINUX = 1
          end

          # The storage types for a LUN.
          module StorageType
            # The storage type for this LUN is unknown.
            STORAGE_TYPE_UNSPECIFIED = 0

            # This storage type for this LUN is SSD.
            SSD = 1

            # This storage type for this LUN is HDD.
            HDD = 2
          end
        end

        # Message for requesting storage lun information.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        class GetLunRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for requesting a list of storage volume luns.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListLunsRequest.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. The server might return fewer items than requested.
        #     If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results from the server.
        class ListLunsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message containing the list of storage volume luns.
        # @!attribute [rw] luns
        #   @return [::Array<::Google::Cloud::BareMetalSolution::V2::Lun>]
        #     The list of luns.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results from the server.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListLunsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for skip lun cooloff and delete it.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the lun.
        class EvictLunRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
