# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module BareMetalSolution
      module V2
        # A server.
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. The resource name of this `Instance`.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     Format:
        #     `projects/{project}/locations/{location}/instances/{instance}`
        # @!attribute [r] id
        #   @return [::String]
        #     Output only. An identifier for the `Instance`, generated by the backend.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Create a time stamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Update a time stamp.
        # @!attribute [rw] machine_type
        #   @return [::String]
        #     Immutable. The server type.
        #     [Available server
        #     types](https://cloud.google.com/bare-metal/docs/bms-planning#server_configurations)
        # @!attribute [r] state
        #   @return [::Google::Cloud::BareMetalSolution::V2::Instance::State]
        #     Output only. The state of the server.
        # @!attribute [rw] hyperthreading_enabled
        #   @return [::Boolean]
        #     True if you enable hyperthreading for the server, otherwise false.
        #     The default value is false.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels as key value pairs.
        # @!attribute [rw] luns
        #   @return [::Array<::Google::Cloud::BareMetalSolution::V2::Lun>]
        #     Immutable. List of LUNs associated with this server.
        # @!attribute [rw] volumes
        #   @return [::Array<::Google::Cloud::BareMetalSolution::V2::Volume>]
        #     Input only. List of Volumes to attach to this Instance on creation.
        #     This field won't be populated in Get/List responses.
        # @!attribute [r] networks
        #   @return [::Array<::Google::Cloud::BareMetalSolution::V2::Network>]
        #     Output only. List of networks associated with this server.
        # @!attribute [r] interactive_serial_console_enabled
        #   @return [::Boolean]
        #     Output only. True if the interactive serial console feature is enabled for
        #     the instance, false otherwise. The default value is false.
        # @!attribute [rw] os_image
        #   @return [::String]
        #     The OS image currently installed on the server.
        # @!attribute [rw] pod
        #   @return [::String]
        #     Immutable. Pod name.
        #     Pod is an independent part of infrastructure.
        #     Instance can be connected to the assets (networks, volumes) allocated
        #     in the same pod only.
        # @!attribute [rw] network_template
        #   @return [::String]
        #     Instance network template name. For eg, bondaa-bondaa, bondab-nic, etc.
        #     Generally, the template name follows the syntax of
        #     "bond<bond_mode>" or "nic".
        # @!attribute [rw] logical_interfaces
        #   @return [::Array<::Google::Cloud::BareMetalSolution::V2::LogicalInterface>]
        #     List of logical interfaces for the instance. The number of logical
        #     interfaces will be the same as number of hardware bond/nic on the chosen
        #     network template. For the non-multivlan configurations (for eg, existing
        #     servers) that use existing default network template (bondaa-bondaa), both
        #     the Instance.networks field and the Instance.logical_interfaces fields will
        #     be filled to ensure backward compatibility. For the others, only
        #     Instance.logical_interfaces will be filled.
        # @!attribute [r] login_info
        #   @return [::String]
        #     Output only. Text field about info for logging in.
        # @!attribute [rw] workload_profile
        #   @return [::Google::Cloud::BareMetalSolution::V2::WorkloadProfile]
        #     The workload profile for the instance.
        # @!attribute [r] firmware_version
        #   @return [::String]
        #     Output only. The firmware version for the instance.
        class Instance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The possible states for this server.
          module State
            # The server is in an unknown state.
            STATE_UNSPECIFIED = 0

            # The server is being provisioned.
            PROVISIONING = 1

            # The server is running.
            RUNNING = 2

            # The server has been deleted.
            DELETED = 3

            # The server is being updated.
            UPDATING = 4

            # The server is starting.
            STARTING = 5

            # The server is stopping.
            STOPPING = 6

            # The server is shutdown.
            SHUTDOWN = 7
          end
        end

        # Message for requesting server information.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        class GetInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for requesting the list of servers.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListInstancesRequest.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. Server may return fewer items than requested.
        #     If unspecified, the server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results from the server.
        # @!attribute [rw] filter
        #   @return [::String]
        #     List filter.
        class ListInstancesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for the list of servers.
        # @!attribute [rw] instances
        #   @return [::Array<::Google::Cloud::BareMetalSolution::V2::Instance>]
        #     The list of servers.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results from the server.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListInstancesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message requesting to updating a server.
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::BareMetalSolution::V2::Instance]
        #     Required. The server to update.
        #
        #     The `name` field is used to identify the instance to update.
        #     Format: projects/\\{project}/locations/\\{location}/instances/\\{instance}
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to update.
        #     The currently supported fields are:
        #       `labels`
        #       `hyperthreading_enabled`
        #       `os_image`
        class UpdateInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message requesting rename of a server.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The `name` field is used to identify the instance.
        #     Format: projects/\\{project}/locations/\\{location}/instances/\\{instance}
        # @!attribute [rw] new_instance_id
        #   @return [::String]
        #     Required. The new `id` of the instance.
        class RenameInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message requesting to reset a server.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        class ResetInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message requesting to start a server.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        class StartInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message from starting a server.
        class StartInstanceResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message requesting to stop a server.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        class StopInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message from stopping a server.
        class StopInstanceResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for enabling the interactive serial console on an instance.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        class EnableInteractiveSerialConsoleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response of EnableInteractiveSerialConsole.
        class EnableInteractiveSerialConsoleResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for disabling the interactive serial console on an instance.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        class DisableInteractiveSerialConsoleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response of DisableInteractiveSerialConsole.
        class DisableInteractiveSerialConsoleResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for detach specific LUN from an Instance.
        # @!attribute [rw] instance
        #   @return [::String]
        #     Required. Name of the instance.
        # @!attribute [rw] lun
        #   @return [::String]
        #     Required. Name of the Lun to detach.
        # @!attribute [rw] skip_reboot
        #   @return [::Boolean]
        #     If true, performs lun unmapping without instance reboot.
        class DetachLunRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Network template.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Template's unique name. The full resource name follows the
        #     pattern:
        #     `projects/{project}/locations/{location}/serverNetworkTemplate/{server_network_template}`
        #     Generally, the \\{server_network_template} follows the syntax of
        #     "bond<interface_type_index><bond_mode>" or "nic<interface_type_index>".
        # @!attribute [rw] applicable_instance_types
        #   @return [::Array<::String>]
        #     Instance types this template is applicable to.
        # @!attribute [rw] logical_interfaces
        #   @return [::Array<::Google::Cloud::BareMetalSolution::V2::ServerNetworkTemplate::LogicalInterface>]
        #     Logical interfaces.
        class ServerNetworkTemplate
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Logical interface.
          # @!attribute [rw] name
          #   @return [::String]
          #     Interface name.
          #     This is not a globally unique identifier.
          #     Name is unique only inside the ServerNetworkTemplate. This is of syntax
          #     <bond><interface_type_index><bond_mode> or <nic><interface_type_index>
          #     and forms part of the network template name.
          # @!attribute [rw] type
          #   @return [::Google::Cloud::BareMetalSolution::V2::ServerNetworkTemplate::LogicalInterface::InterfaceType]
          #     Interface type.
          # @!attribute [rw] required
          #   @return [::Boolean]
          #     If true, interface must have network connected.
          class LogicalInterface
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Interface type.
            module InterfaceType
              # Unspecified value.
              INTERFACE_TYPE_UNSPECIFIED = 0

              # Bond interface type.
              BOND = 1

              # NIC interface type.
              NIC = 2
            end
          end
        end
      end
    end
  end
end
