# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/baremetalsolution/v2/baremetalsolution_pb"
require "google/cloud/bare_metal_solution/v2/bare_metal_solution/rest/service_stub"
require "google/cloud/location/rest"
require "google/iam/v1/rest"

module Google
  module Cloud
    module BareMetalSolution
      module V2
        module BareMetalSolution
          module Rest
            ##
            # REST client for the BareMetalSolution service.
            #
            # Performs management operations on Bare Metal Solution servers.
            #
            # The `baremetalsolution.googleapis.com` service provides management
            # capabilities for Bare Metal Solution servers. To access the API methods, you
            # must assign Bare Metal Solution IAM roles containing the desired permissions
            # to your staff in your Google Cloud project. You must also enable the Bare
            # Metal Solution API. Once enabled, the methods act
            # upon specific servers in your Bare Metal Solution environment.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "baremetalsolution.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :bare_metal_solution_stub

              ##
              # Configure the BareMetalSolution Client class.
              #
              # See {::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all BareMetalSolution clients
              #   ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "BareMetalSolution", "V2"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the BareMetalSolution Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @bare_metal_solution_stub.universe_domain
              end

              ##
              # Create a new BareMetalSolution REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the BareMetalSolution client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @bare_metal_solution_stub = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @bare_metal_solution_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @bare_metal_solution_stub.endpoint
                  config.universe_domain = @bare_metal_solution_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @bare_metal_solution_stub.logger if config.respond_to? :logger=
                end

                @iam_policy_client = Google::Iam::V1::IAMPolicy::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @bare_metal_solution_stub.endpoint
                  config.universe_domain = @bare_metal_solution_stub.universe_domain
                  config.logger = @bare_metal_solution_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # Get the associated client for mix-in of the IAMPolicy.
              #
              # @return [Google::Iam::V1::IAMPolicy::Rest::Client]
              #
              attr_reader :iam_policy_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @bare_metal_solution_stub.logger
              end

              # Service calls

              ##
              # List servers in a given project and location.
              #
              # @overload list_instances(request, options = nil)
              #   Pass arguments to `list_instances` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::ListInstancesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::ListInstancesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_instances(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_instances` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListInstancesRequest.
              #   @param page_size [::Integer]
              #     Requested page size. Server may return fewer items than requested.
              #     If unspecified, the server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results from the server.
              #   @param filter [::String]
              #     List filter.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::BareMetalSolution::V2::Instance>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::BareMetalSolution::V2::Instance>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::ListInstancesRequest.new
              #
              #   # Call the list_instances method.
              #   result = client.list_instances request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::BareMetalSolution::V2::Instance.
              #     p item
              #   end
              #
              def list_instances request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::ListInstancesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_instances.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_instances.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_instances.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.list_instances request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @bare_metal_solution_stub, :list_instances, "instances", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get details about a single server.
              #
              # @overload get_instance(request, options = nil)
              #   Pass arguments to `get_instance` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::GetInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::GetInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_instance(name: nil)
              #   Pass arguments to `get_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::BareMetalSolution::V2::Instance]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::BareMetalSolution::V2::Instance]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::GetInstanceRequest.new
              #
              #   # Call the get_instance method.
              #   result = client.get_instance request
              #
              #   # The returned object is of type Google::Cloud::BareMetalSolution::V2::Instance.
              #   p result
              #
              def get_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::GetInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_instance.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.get_instance request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update details of a single server.
              #
              # @overload update_instance(request, options = nil)
              #   Pass arguments to `update_instance` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::UpdateInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::UpdateInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_instance(instance: nil, update_mask: nil)
              #   Pass arguments to `update_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::Google::Cloud::BareMetalSolution::V2::Instance, ::Hash]
              #     Required. The server to update.
              #
              #     The `name` field is used to identify the instance to update.
              #     Format: projects/\\{project}/locations/\\{location}/instances/\\{instance}
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The list of fields to update.
              #     The currently supported fields are:
              #       `labels`
              #       `hyperthreading_enabled`
              #       `os_image`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::UpdateInstanceRequest.new
              #
              #   # Call the update_instance method.
              #   result = client.update_instance request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::UpdateInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_instance.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.update_instance request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # RenameInstance sets a new name for an instance.
              # Use with caution, previous names become immediately invalidated.
              #
              # @overload rename_instance(request, options = nil)
              #   Pass arguments to `rename_instance` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::RenameInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::RenameInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload rename_instance(name: nil, new_instance_id: nil)
              #   Pass arguments to `rename_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The `name` field is used to identify the instance.
              #     Format: projects/\\{project}/locations/\\{location}/instances/\\{instance}
              #   @param new_instance_id [::String]
              #     Required. The new `id` of the instance.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::BareMetalSolution::V2::Instance]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::BareMetalSolution::V2::Instance]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::RenameInstanceRequest.new
              #
              #   # Call the rename_instance method.
              #   result = client.rename_instance request
              #
              #   # The returned object is of type Google::Cloud::BareMetalSolution::V2::Instance.
              #   p result
              #
              def rename_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::RenameInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.rename_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.rename_instance.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.rename_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.rename_instance request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Perform an ungraceful, hard reset on a server. Equivalent to shutting the
              # power off and then turning it back on.
              #
              # @overload reset_instance(request, options = nil)
              #   Pass arguments to `reset_instance` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::ResetInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::ResetInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload reset_instance(name: nil)
              #   Pass arguments to `reset_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::ResetInstanceRequest.new
              #
              #   # Call the reset_instance method.
              #   result = client.reset_instance request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def reset_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::ResetInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.reset_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.reset_instance.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.reset_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.reset_instance request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Starts a server that was shutdown.
              #
              # @overload start_instance(request, options = nil)
              #   Pass arguments to `start_instance` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::StartInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::StartInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload start_instance(name: nil)
              #   Pass arguments to `start_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::StartInstanceRequest.new
              #
              #   # Call the start_instance method.
              #   result = client.start_instance request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def start_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::StartInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.start_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.start_instance.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.start_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.start_instance request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Stop a running server.
              #
              # @overload stop_instance(request, options = nil)
              #   Pass arguments to `stop_instance` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::StopInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::StopInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload stop_instance(name: nil)
              #   Pass arguments to `stop_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::StopInstanceRequest.new
              #
              #   # Call the stop_instance method.
              #   result = client.stop_instance request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def stop_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::StopInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.stop_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.stop_instance.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.stop_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.stop_instance request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Enable the interactive serial console feature on an instance.
              #
              # @overload enable_interactive_serial_console(request, options = nil)
              #   Pass arguments to `enable_interactive_serial_console` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::EnableInteractiveSerialConsoleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::EnableInteractiveSerialConsoleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload enable_interactive_serial_console(name: nil)
              #   Pass arguments to `enable_interactive_serial_console` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::EnableInteractiveSerialConsoleRequest.new
              #
              #   # Call the enable_interactive_serial_console method.
              #   result = client.enable_interactive_serial_console request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def enable_interactive_serial_console request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::EnableInteractiveSerialConsoleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.enable_interactive_serial_console.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.enable_interactive_serial_console.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.enable_interactive_serial_console.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.enable_interactive_serial_console request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Disable the interactive serial console feature on an instance.
              #
              # @overload disable_interactive_serial_console(request, options = nil)
              #   Pass arguments to `disable_interactive_serial_console` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::DisableInteractiveSerialConsoleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::DisableInteractiveSerialConsoleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload disable_interactive_serial_console(name: nil)
              #   Pass arguments to `disable_interactive_serial_console` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::DisableInteractiveSerialConsoleRequest.new
              #
              #   # Call the disable_interactive_serial_console method.
              #   result = client.disable_interactive_serial_console request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def disable_interactive_serial_console request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::DisableInteractiveSerialConsoleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.disable_interactive_serial_console.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.disable_interactive_serial_console.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.disable_interactive_serial_console.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.disable_interactive_serial_console request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Detach LUN from Instance.
              #
              # @overload detach_lun(request, options = nil)
              #   Pass arguments to `detach_lun` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::DetachLunRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::DetachLunRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload detach_lun(instance: nil, lun: nil, skip_reboot: nil)
              #   Pass arguments to `detach_lun` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     Required. Name of the instance.
              #   @param lun [::String]
              #     Required. Name of the Lun to detach.
              #   @param skip_reboot [::Boolean]
              #     If true, performs lun unmapping without instance reboot.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::DetachLunRequest.new
              #
              #   # Call the detach_lun method.
              #   result = client.detach_lun request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def detach_lun request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::DetachLunRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.detach_lun.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.detach_lun.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.detach_lun.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.detach_lun request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the public SSH keys registered for the specified project.
              # These SSH keys are used only for the interactive serial console feature.
              #
              # @overload list_ssh_keys(request, options = nil)
              #   Pass arguments to `list_ssh_keys` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::ListSSHKeysRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::ListSSHKeysRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_ssh_keys(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_ssh_keys` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent containing the SSH keys.
              #     Currently, the only valid value for the location is "global".
              #   @param page_size [::Integer]
              #     The maximum number of items to return.
              #   @param page_token [::String]
              #     The next_page_token value returned from a previous List request, if any.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::BareMetalSolution::V2::SSHKey>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::BareMetalSolution::V2::SSHKey>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::ListSSHKeysRequest.new
              #
              #   # Call the list_ssh_keys method.
              #   result = client.list_ssh_keys request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::BareMetalSolution::V2::SSHKey.
              #     p item
              #   end
              #
              def list_ssh_keys request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::ListSSHKeysRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_ssh_keys.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_ssh_keys.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_ssh_keys.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.list_ssh_keys request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @bare_metal_solution_stub, :list_ssh_keys, "ssh_keys", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Register a public SSH key in the specified project for use with the
              # interactive serial console feature.
              #
              # @overload create_ssh_key(request, options = nil)
              #   Pass arguments to `create_ssh_key` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::CreateSSHKeyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::CreateSSHKeyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_ssh_key(parent: nil, ssh_key: nil, ssh_key_id: nil)
              #   Pass arguments to `create_ssh_key` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent containing the SSH keys.
              #   @param ssh_key [::Google::Cloud::BareMetalSolution::V2::SSHKey, ::Hash]
              #     Required. The SSH key to register.
              #   @param ssh_key_id [::String]
              #     Required. The ID to use for the key, which will become the final component
              #     of the key's resource name.
              #
              #     This value must match the regex:
              #       [a-zA-Z0-9@.\-_]\\{1,64}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::BareMetalSolution::V2::SSHKey]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::BareMetalSolution::V2::SSHKey]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::CreateSSHKeyRequest.new
              #
              #   # Call the create_ssh_key method.
              #   result = client.create_ssh_key request
              #
              #   # The returned object is of type Google::Cloud::BareMetalSolution::V2::SSHKey.
              #   p result
              #
              def create_ssh_key request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::CreateSSHKeyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_ssh_key.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_ssh_key.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_ssh_key.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.create_ssh_key request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a public SSH key registered in the specified project.
              #
              # @overload delete_ssh_key(request, options = nil)
              #   Pass arguments to `delete_ssh_key` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::DeleteSSHKeyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::DeleteSSHKeyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_ssh_key(name: nil)
              #   Pass arguments to `delete_ssh_key` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the SSH key to delete.
              #     Currently, the only valid value for the location is "global".
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::DeleteSSHKeyRequest.new
              #
              #   # Call the delete_ssh_key method.
              #   result = client.delete_ssh_key request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_ssh_key request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::DeleteSSHKeyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_ssh_key.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_ssh_key.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_ssh_key.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.delete_ssh_key request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List storage volumes in a given project and location.
              #
              # @overload list_volumes(request, options = nil)
              #   Pass arguments to `list_volumes` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::ListVolumesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::ListVolumesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_volumes(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_volumes` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListVolumesRequest.
              #   @param page_size [::Integer]
              #     Requested page size. The server might return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results from the server.
              #   @param filter [::String]
              #     List filter.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::BareMetalSolution::V2::Volume>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::BareMetalSolution::V2::Volume>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::ListVolumesRequest.new
              #
              #   # Call the list_volumes method.
              #   result = client.list_volumes request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::BareMetalSolution::V2::Volume.
              #     p item
              #   end
              #
              def list_volumes request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::ListVolumesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_volumes.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_volumes.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_volumes.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.list_volumes request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @bare_metal_solution_stub, :list_volumes, "volumes", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get details of a single storage volume.
              #
              # @overload get_volume(request, options = nil)
              #   Pass arguments to `get_volume` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::GetVolumeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::GetVolumeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_volume(name: nil)
              #   Pass arguments to `get_volume` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::BareMetalSolution::V2::Volume]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::BareMetalSolution::V2::Volume]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::GetVolumeRequest.new
              #
              #   # Call the get_volume method.
              #   result = client.get_volume request
              #
              #   # The returned object is of type Google::Cloud::BareMetalSolution::V2::Volume.
              #   p result
              #
              def get_volume request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::GetVolumeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_volume.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_volume.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_volume.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.get_volume request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update details of a single storage volume.
              #
              # @overload update_volume(request, options = nil)
              #   Pass arguments to `update_volume` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::UpdateVolumeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::UpdateVolumeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_volume(volume: nil, update_mask: nil)
              #   Pass arguments to `update_volume` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param volume [::Google::Cloud::BareMetalSolution::V2::Volume, ::Hash]
              #     Required. The volume to update.
              #
              #     The `name` field is used to identify the volume to update.
              #     Format: projects/\\{project}/locations/\\{location}/volumes/\\{volume}
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The list of fields to update.
              #     The only currently supported fields are:
              #       'labels'
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::UpdateVolumeRequest.new
              #
              #   # Call the update_volume method.
              #   result = client.update_volume request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_volume request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::UpdateVolumeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_volume.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_volume.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_volume.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.update_volume request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # RenameVolume sets a new name for a volume.
              # Use with caution, previous names become immediately invalidated.
              #
              # @overload rename_volume(request, options = nil)
              #   Pass arguments to `rename_volume` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::RenameVolumeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::RenameVolumeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload rename_volume(name: nil, new_volume_id: nil)
              #   Pass arguments to `rename_volume` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The `name` field is used to identify the volume.
              #     Format: projects/\\{project}/locations/\\{location}/volumes/\\{volume}
              #   @param new_volume_id [::String]
              #     Required. The new `id` of the volume.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::BareMetalSolution::V2::Volume]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::BareMetalSolution::V2::Volume]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::RenameVolumeRequest.new
              #
              #   # Call the rename_volume method.
              #   result = client.rename_volume request
              #
              #   # The returned object is of type Google::Cloud::BareMetalSolution::V2::Volume.
              #   p result
              #
              def rename_volume request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::RenameVolumeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.rename_volume.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.rename_volume.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.rename_volume.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.rename_volume request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Skips volume's cooloff and deletes it now.
              # Volume must be in cooloff state.
              #
              # @overload evict_volume(request, options = nil)
              #   Pass arguments to `evict_volume` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::EvictVolumeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::EvictVolumeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload evict_volume(name: nil)
              #   Pass arguments to `evict_volume` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Volume.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::EvictVolumeRequest.new
              #
              #   # Call the evict_volume method.
              #   result = client.evict_volume request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def evict_volume request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::EvictVolumeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.evict_volume.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.evict_volume.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.evict_volume.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.evict_volume request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Emergency Volume resize.
              #
              # @overload resize_volume(request, options = nil)
              #   Pass arguments to `resize_volume` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::ResizeVolumeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::ResizeVolumeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload resize_volume(volume: nil, size_gib: nil)
              #   Pass arguments to `resize_volume` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param volume [::String]
              #     Required. Volume to resize.
              #   @param size_gib [::Integer]
              #     New Volume size, in GiB.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::ResizeVolumeRequest.new
              #
              #   # Call the resize_volume method.
              #   result = client.resize_volume request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def resize_volume request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::ResizeVolumeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.resize_volume.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.resize_volume.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.resize_volume.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.resize_volume request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List network in a given project and location.
              #
              # @overload list_networks(request, options = nil)
              #   Pass arguments to `list_networks` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::ListNetworksRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::ListNetworksRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_networks(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_networks` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListNetworksRequest.
              #   @param page_size [::Integer]
              #     Requested page size. The server might return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results from the server.
              #   @param filter [::String]
              #     List filter.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::BareMetalSolution::V2::Network>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::BareMetalSolution::V2::Network>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::ListNetworksRequest.new
              #
              #   # Call the list_networks method.
              #   result = client.list_networks request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::BareMetalSolution::V2::Network.
              #     p item
              #   end
              #
              def list_networks request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::ListNetworksRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_networks.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_networks.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_networks.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.list_networks request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @bare_metal_solution_stub, :list_networks, "networks", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List all Networks (and used IPs for each Network) in the vendor account
              # associated with the specified project.
              #
              # @overload list_network_usage(request, options = nil)
              #   Pass arguments to `list_network_usage` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::ListNetworkUsageRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::ListNetworkUsageRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_network_usage(location: nil)
              #   Pass arguments to `list_network_usage` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param location [::String]
              #     Required. Parent value (project and location).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::BareMetalSolution::V2::ListNetworkUsageResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::BareMetalSolution::V2::ListNetworkUsageResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::ListNetworkUsageRequest.new
              #
              #   # Call the list_network_usage method.
              #   result = client.list_network_usage request
              #
              #   # The returned object is of type Google::Cloud::BareMetalSolution::V2::ListNetworkUsageResponse.
              #   p result
              #
              def list_network_usage request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::ListNetworkUsageRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_network_usage.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_network_usage.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_network_usage.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.list_network_usage request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get details of a single network.
              #
              # @overload get_network(request, options = nil)
              #   Pass arguments to `get_network` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::GetNetworkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::GetNetworkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_network(name: nil)
              #   Pass arguments to `get_network` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::BareMetalSolution::V2::Network]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::BareMetalSolution::V2::Network]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::GetNetworkRequest.new
              #
              #   # Call the get_network method.
              #   result = client.get_network request
              #
              #   # The returned object is of type Google::Cloud::BareMetalSolution::V2::Network.
              #   p result
              #
              def get_network request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::GetNetworkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_network.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_network.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_network.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.get_network request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update details of a single network.
              #
              # @overload update_network(request, options = nil)
              #   Pass arguments to `update_network` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::UpdateNetworkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::UpdateNetworkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_network(network: nil, update_mask: nil)
              #   Pass arguments to `update_network` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param network [::Google::Cloud::BareMetalSolution::V2::Network, ::Hash]
              #     Required. The network to update.
              #
              #     The `name` field is used to identify the instance to update.
              #     Format: projects/\\{project}/locations/\\{location}/networks/\\{network}
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The list of fields to update.
              #     The only currently supported fields are:
              #       `labels`, `reservations`, `vrf.vlan_attachments`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::UpdateNetworkRequest.new
              #
              #   # Call the update_network method.
              #   result = client.update_network request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_network request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::UpdateNetworkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_network.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_network.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_network.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.update_network request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Takes a snapshot of a boot volume.
              # Returns INVALID_ARGUMENT if called for a non-boot volume.
              #
              # @overload create_volume_snapshot(request, options = nil)
              #   Pass arguments to `create_volume_snapshot` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::CreateVolumeSnapshotRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::CreateVolumeSnapshotRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_volume_snapshot(parent: nil, volume_snapshot: nil)
              #   Pass arguments to `create_volume_snapshot` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The volume to snapshot.
              #   @param volume_snapshot [::Google::Cloud::BareMetalSolution::V2::VolumeSnapshot, ::Hash]
              #     Required. The snapshot to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::BareMetalSolution::V2::VolumeSnapshot]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::BareMetalSolution::V2::VolumeSnapshot]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::CreateVolumeSnapshotRequest.new
              #
              #   # Call the create_volume_snapshot method.
              #   result = client.create_volume_snapshot request
              #
              #   # The returned object is of type Google::Cloud::BareMetalSolution::V2::VolumeSnapshot.
              #   p result
              #
              def create_volume_snapshot request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::CreateVolumeSnapshotRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_volume_snapshot.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_volume_snapshot.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_volume_snapshot.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.create_volume_snapshot request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Uses the specified snapshot to restore its parent volume.
              # Returns INVALID_ARGUMENT if called for a non-boot volume.
              #
              # @overload restore_volume_snapshot(request, options = nil)
              #   Pass arguments to `restore_volume_snapshot` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::RestoreVolumeSnapshotRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::RestoreVolumeSnapshotRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload restore_volume_snapshot(volume_snapshot: nil)
              #   Pass arguments to `restore_volume_snapshot` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param volume_snapshot [::String]
              #     Required. Name of the snapshot which will be used to restore its parent
              #     volume.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::RestoreVolumeSnapshotRequest.new
              #
              #   # Call the restore_volume_snapshot method.
              #   result = client.restore_volume_snapshot request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def restore_volume_snapshot request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::RestoreVolumeSnapshotRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.restore_volume_snapshot.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.restore_volume_snapshot.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.restore_volume_snapshot.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.restore_volume_snapshot request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a volume snapshot.
              # Returns INVALID_ARGUMENT if called for a non-boot volume.
              #
              # @overload delete_volume_snapshot(request, options = nil)
              #   Pass arguments to `delete_volume_snapshot` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::DeleteVolumeSnapshotRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::DeleteVolumeSnapshotRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_volume_snapshot(name: nil)
              #   Pass arguments to `delete_volume_snapshot` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the snapshot to delete.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::DeleteVolumeSnapshotRequest.new
              #
              #   # Call the delete_volume_snapshot method.
              #   result = client.delete_volume_snapshot request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_volume_snapshot request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::DeleteVolumeSnapshotRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_volume_snapshot.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_volume_snapshot.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_volume_snapshot.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.delete_volume_snapshot request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the specified snapshot resource.
              # Returns INVALID_ARGUMENT if called for a non-boot volume.
              #
              # @overload get_volume_snapshot(request, options = nil)
              #   Pass arguments to `get_volume_snapshot` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::GetVolumeSnapshotRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::GetVolumeSnapshotRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_volume_snapshot(name: nil)
              #   Pass arguments to `get_volume_snapshot` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the snapshot.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::BareMetalSolution::V2::VolumeSnapshot]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::BareMetalSolution::V2::VolumeSnapshot]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::GetVolumeSnapshotRequest.new
              #
              #   # Call the get_volume_snapshot method.
              #   result = client.get_volume_snapshot request
              #
              #   # The returned object is of type Google::Cloud::BareMetalSolution::V2::VolumeSnapshot.
              #   p result
              #
              def get_volume_snapshot request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::GetVolumeSnapshotRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_volume_snapshot.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_volume_snapshot.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_volume_snapshot.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.get_volume_snapshot request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieves the list of snapshots for the specified volume.
              # Returns a response with an empty list of snapshots if called
              # for a non-boot volume.
              #
              # @overload list_volume_snapshots(request, options = nil)
              #   Pass arguments to `list_volume_snapshots` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::ListVolumeSnapshotsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::ListVolumeSnapshotsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_volume_snapshots(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_volume_snapshots` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListVolumesRequest.
              #   @param page_size [::Integer]
              #     Requested page size. The server might return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results from the server.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::BareMetalSolution::V2::VolumeSnapshot>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::BareMetalSolution::V2::VolumeSnapshot>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::ListVolumeSnapshotsRequest.new
              #
              #   # Call the list_volume_snapshots method.
              #   result = client.list_volume_snapshots request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::BareMetalSolution::V2::VolumeSnapshot.
              #     p item
              #   end
              #
              def list_volume_snapshots request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::ListVolumeSnapshotsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_volume_snapshots.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_volume_snapshots.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_volume_snapshots.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.list_volume_snapshots request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @bare_metal_solution_stub, :list_volume_snapshots, "volume_snapshots", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get details of a single storage logical unit number(LUN).
              #
              # @overload get_lun(request, options = nil)
              #   Pass arguments to `get_lun` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::GetLunRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::GetLunRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_lun(name: nil)
              #   Pass arguments to `get_lun` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::BareMetalSolution::V2::Lun]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::BareMetalSolution::V2::Lun]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::GetLunRequest.new
              #
              #   # Call the get_lun method.
              #   result = client.get_lun request
              #
              #   # The returned object is of type Google::Cloud::BareMetalSolution::V2::Lun.
              #   p result
              #
              def get_lun request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::GetLunRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_lun.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_lun.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_lun.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.get_lun request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List storage volume luns for given storage volume.
              #
              # @overload list_luns(request, options = nil)
              #   Pass arguments to `list_luns` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::ListLunsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::ListLunsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_luns(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_luns` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListLunsRequest.
              #   @param page_size [::Integer]
              #     Requested page size. The server might return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results from the server.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::BareMetalSolution::V2::Lun>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::BareMetalSolution::V2::Lun>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::ListLunsRequest.new
              #
              #   # Call the list_luns method.
              #   result = client.list_luns request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::BareMetalSolution::V2::Lun.
              #     p item
              #   end
              #
              def list_luns request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::ListLunsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_luns.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_luns.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_luns.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.list_luns request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @bare_metal_solution_stub, :list_luns, "luns", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Skips lun's cooloff and deletes it now.
              # Lun must be in cooloff state.
              #
              # @overload evict_lun(request, options = nil)
              #   Pass arguments to `evict_lun` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::EvictLunRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::EvictLunRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload evict_lun(name: nil)
              #   Pass arguments to `evict_lun` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the lun.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::EvictLunRequest.new
              #
              #   # Call the evict_lun method.
              #   result = client.evict_lun request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def evict_lun request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::EvictLunRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.evict_lun.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.evict_lun.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.evict_lun.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.evict_lun request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get details of a single NFS share.
              #
              # @overload get_nfs_share(request, options = nil)
              #   Pass arguments to `get_nfs_share` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::GetNfsShareRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::GetNfsShareRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_nfs_share(name: nil)
              #   Pass arguments to `get_nfs_share` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::BareMetalSolution::V2::NfsShare]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::BareMetalSolution::V2::NfsShare]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::GetNfsShareRequest.new
              #
              #   # Call the get_nfs_share method.
              #   result = client.get_nfs_share request
              #
              #   # The returned object is of type Google::Cloud::BareMetalSolution::V2::NfsShare.
              #   p result
              #
              def get_nfs_share request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::GetNfsShareRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_nfs_share.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_nfs_share.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_nfs_share.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.get_nfs_share request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List NFS shares.
              #
              # @overload list_nfs_shares(request, options = nil)
              #   Pass arguments to `list_nfs_shares` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::ListNfsSharesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::ListNfsSharesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_nfs_shares(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_nfs_shares` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListNfsSharesRequest.
              #   @param page_size [::Integer]
              #     Requested page size. The server might return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results from the server.
              #   @param filter [::String]
              #     List filter.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::BareMetalSolution::V2::NfsShare>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::BareMetalSolution::V2::NfsShare>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::ListNfsSharesRequest.new
              #
              #   # Call the list_nfs_shares method.
              #   result = client.list_nfs_shares request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::BareMetalSolution::V2::NfsShare.
              #     p item
              #   end
              #
              def list_nfs_shares request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::ListNfsSharesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_nfs_shares.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_nfs_shares.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_nfs_shares.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.list_nfs_shares request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @bare_metal_solution_stub, :list_nfs_shares, "nfs_shares", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update details of a single NFS share.
              #
              # @overload update_nfs_share(request, options = nil)
              #   Pass arguments to `update_nfs_share` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::UpdateNfsShareRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::UpdateNfsShareRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_nfs_share(nfs_share: nil, update_mask: nil)
              #   Pass arguments to `update_nfs_share` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param nfs_share [::Google::Cloud::BareMetalSolution::V2::NfsShare, ::Hash]
              #     Required. The NFS share to update.
              #
              #     The `name` field is used to identify the NFS share to update.
              #     Format: projects/\\{project}/locations/\\{location}/nfsShares/\\{nfs_share}
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The list of fields to update.
              #     The only currently supported fields are:
              #       `labels`
              #       `allowed_clients`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::UpdateNfsShareRequest.new
              #
              #   # Call the update_nfs_share method.
              #   result = client.update_nfs_share request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_nfs_share request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::UpdateNfsShareRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_nfs_share.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_nfs_share.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_nfs_share.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.update_nfs_share request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Create an NFS share.
              #
              # @overload create_nfs_share(request, options = nil)
              #   Pass arguments to `create_nfs_share` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::CreateNfsShareRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::CreateNfsShareRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_nfs_share(parent: nil, nfs_share: nil)
              #   Pass arguments to `create_nfs_share` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent project and location.
              #   @param nfs_share [::Google::Cloud::BareMetalSolution::V2::NfsShare, ::Hash]
              #     Required. The NfsShare to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::CreateNfsShareRequest.new
              #
              #   # Call the create_nfs_share method.
              #   result = client.create_nfs_share request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_nfs_share request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::CreateNfsShareRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_nfs_share.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_nfs_share.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_nfs_share.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.create_nfs_share request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # RenameNfsShare sets a new name for an nfsshare.
              # Use with caution, previous names become immediately invalidated.
              #
              # @overload rename_nfs_share(request, options = nil)
              #   Pass arguments to `rename_nfs_share` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::RenameNfsShareRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::RenameNfsShareRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload rename_nfs_share(name: nil, new_nfsshare_id: nil)
              #   Pass arguments to `rename_nfs_share` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The `name` field is used to identify the nfsshare.
              #     Format: projects/\\{project}/locations/\\{location}/nfsshares/\\{nfsshare}
              #   @param new_nfsshare_id [::String]
              #     Required. The new `id` of the nfsshare.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::BareMetalSolution::V2::NfsShare]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::BareMetalSolution::V2::NfsShare]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::RenameNfsShareRequest.new
              #
              #   # Call the rename_nfs_share method.
              #   result = client.rename_nfs_share request
              #
              #   # The returned object is of type Google::Cloud::BareMetalSolution::V2::NfsShare.
              #   p result
              #
              def rename_nfs_share request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::RenameNfsShareRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.rename_nfs_share.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.rename_nfs_share.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.rename_nfs_share.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.rename_nfs_share request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Delete an NFS share. The underlying volume is automatically deleted.
              #
              # @overload delete_nfs_share(request, options = nil)
              #   Pass arguments to `delete_nfs_share` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::DeleteNfsShareRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::DeleteNfsShareRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_nfs_share(name: nil)
              #   Pass arguments to `delete_nfs_share` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the NFS share to delete.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::DeleteNfsShareRequest.new
              #
              #   # Call the delete_nfs_share method.
              #   result = client.delete_nfs_share request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_nfs_share request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::DeleteNfsShareRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_nfs_share.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_nfs_share.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_nfs_share.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.delete_nfs_share request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List the budget details to provision resources on a given project.
              #
              # @overload list_provisioning_quotas(request, options = nil)
              #   Pass arguments to `list_provisioning_quotas` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::ListProvisioningQuotasRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::ListProvisioningQuotasRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_provisioning_quotas(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_provisioning_quotas` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListProvisioningQuotasRequest.
              #   @param page_size [::Integer]
              #     Requested page size. The server might return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #     Notice that page_size field is not supported and won't be respected in
              #     the API request for now, will be updated when pagination is supported.
              #   @param page_token [::String]
              #     A token identifying a page of results from the server.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::BareMetalSolution::V2::ProvisioningQuota>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::BareMetalSolution::V2::ProvisioningQuota>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::ListProvisioningQuotasRequest.new
              #
              #   # Call the list_provisioning_quotas method.
              #   result = client.list_provisioning_quotas request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::BareMetalSolution::V2::ProvisioningQuota.
              #     p item
              #   end
              #
              def list_provisioning_quotas request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::ListProvisioningQuotasRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_provisioning_quotas.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_provisioning_quotas.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_provisioning_quotas.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.list_provisioning_quotas request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @bare_metal_solution_stub, :list_provisioning_quotas, "provisioning_quotas", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Submit a provisiong configuration for a given project.
              #
              # @overload submit_provisioning_config(request, options = nil)
              #   Pass arguments to `submit_provisioning_config` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::SubmitProvisioningConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::SubmitProvisioningConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload submit_provisioning_config(parent: nil, provisioning_config: nil, email: nil)
              #   Pass arguments to `submit_provisioning_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent project and location containing the
              #     ProvisioningConfig.
              #   @param provisioning_config [::Google::Cloud::BareMetalSolution::V2::ProvisioningConfig, ::Hash]
              #     Required. The ProvisioningConfig to create.
              #   @param email [::String]
              #     Optional. Email provided to send a confirmation with provisioning config
              #     to.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::BareMetalSolution::V2::SubmitProvisioningConfigResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::BareMetalSolution::V2::SubmitProvisioningConfigResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::SubmitProvisioningConfigRequest.new
              #
              #   # Call the submit_provisioning_config method.
              #   result = client.submit_provisioning_config request
              #
              #   # The returned object is of type Google::Cloud::BareMetalSolution::V2::SubmitProvisioningConfigResponse.
              #   p result
              #
              def submit_provisioning_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::SubmitProvisioningConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.submit_provisioning_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.submit_provisioning_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.submit_provisioning_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.submit_provisioning_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get ProvisioningConfig by name.
              #
              # @overload get_provisioning_config(request, options = nil)
              #   Pass arguments to `get_provisioning_config` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::GetProvisioningConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::GetProvisioningConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_provisioning_config(name: nil)
              #   Pass arguments to `get_provisioning_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the ProvisioningConfig.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::BareMetalSolution::V2::ProvisioningConfig]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::BareMetalSolution::V2::ProvisioningConfig]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::GetProvisioningConfigRequest.new
              #
              #   # Call the get_provisioning_config method.
              #   result = client.get_provisioning_config request
              #
              #   # The returned object is of type Google::Cloud::BareMetalSolution::V2::ProvisioningConfig.
              #   p result
              #
              def get_provisioning_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::GetProvisioningConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_provisioning_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_provisioning_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_provisioning_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.get_provisioning_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Create new ProvisioningConfig.
              #
              # @overload create_provisioning_config(request, options = nil)
              #   Pass arguments to `create_provisioning_config` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::CreateProvisioningConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::CreateProvisioningConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_provisioning_config(parent: nil, provisioning_config: nil, email: nil)
              #   Pass arguments to `create_provisioning_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent project and location containing the
              #     ProvisioningConfig.
              #   @param provisioning_config [::Google::Cloud::BareMetalSolution::V2::ProvisioningConfig, ::Hash]
              #     Required. The ProvisioningConfig to create.
              #   @param email [::String]
              #     Optional. Email provided to send a confirmation with provisioning config
              #     to.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::BareMetalSolution::V2::ProvisioningConfig]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::BareMetalSolution::V2::ProvisioningConfig]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::CreateProvisioningConfigRequest.new
              #
              #   # Call the create_provisioning_config method.
              #   result = client.create_provisioning_config request
              #
              #   # The returned object is of type Google::Cloud::BareMetalSolution::V2::ProvisioningConfig.
              #   p result
              #
              def create_provisioning_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::CreateProvisioningConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_provisioning_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_provisioning_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_provisioning_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.create_provisioning_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update existing ProvisioningConfig.
              #
              # @overload update_provisioning_config(request, options = nil)
              #   Pass arguments to `update_provisioning_config` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::UpdateProvisioningConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::UpdateProvisioningConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_provisioning_config(provisioning_config: nil, update_mask: nil, email: nil)
              #   Pass arguments to `update_provisioning_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param provisioning_config [::Google::Cloud::BareMetalSolution::V2::ProvisioningConfig, ::Hash]
              #     Required. The ProvisioningConfig to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to update.
              #   @param email [::String]
              #     Optional. Email provided to send a confirmation with provisioning config
              #     to.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::BareMetalSolution::V2::ProvisioningConfig]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::BareMetalSolution::V2::ProvisioningConfig]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::UpdateProvisioningConfigRequest.new
              #
              #   # Call the update_provisioning_config method.
              #   result = client.update_provisioning_config request
              #
              #   # The returned object is of type Google::Cloud::BareMetalSolution::V2::ProvisioningConfig.
              #   p result
              #
              def update_provisioning_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::UpdateProvisioningConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_provisioning_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_provisioning_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_provisioning_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.update_provisioning_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # RenameNetwork sets a new name for a network.
              # Use with caution, previous names become immediately invalidated.
              #
              # @overload rename_network(request, options = nil)
              #   Pass arguments to `rename_network` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::RenameNetworkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::RenameNetworkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload rename_network(name: nil, new_network_id: nil)
              #   Pass arguments to `rename_network` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The `name` field is used to identify the network.
              #     Format: projects/\\{project}/locations/\\{location}/networks/\\{network}
              #   @param new_network_id [::String]
              #     Required. The new `id` of the network.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::BareMetalSolution::V2::Network]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::BareMetalSolution::V2::Network]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::RenameNetworkRequest.new
              #
              #   # Call the rename_network method.
              #   result = client.rename_network request
              #
              #   # The returned object is of type Google::Cloud::BareMetalSolution::V2::Network.
              #   p result
              #
              def rename_network request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::RenameNetworkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.rename_network.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.rename_network.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.rename_network.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.rename_network request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieves the list of OS images which are currently approved.
              #
              # @overload list_os_images(request, options = nil)
              #   Pass arguments to `list_os_images` via a request object, either of type
              #   {::Google::Cloud::BareMetalSolution::V2::ListOSImagesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::BareMetalSolution::V2::ListOSImagesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_os_images(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_os_images` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListProvisioningQuotasRequest.
              #   @param page_size [::Integer]
              #     Requested page size. The server might return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #     Notice that page_size field is not supported and won't be respected in
              #     the API request for now, will be updated when pagination is supported.
              #   @param page_token [::String]
              #     A token identifying a page of results from the server.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::BareMetalSolution::V2::OSImage>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::BareMetalSolution::V2::OSImage>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/bare_metal_solution/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::BareMetalSolution::V2::ListOSImagesRequest.new
              #
              #   # Call the list_os_images method.
              #   result = client.list_os_images request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::BareMetalSolution::V2::OSImage.
              #     p item
              #   end
              #
              def list_os_images request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BareMetalSolution::V2::ListOSImagesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_os_images.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::BareMetalSolution::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_os_images.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_os_images.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @bare_metal_solution_stub.list_os_images request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @bare_metal_solution_stub, :list_os_images, "os_images", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the BareMetalSolution REST API.
              #
              # This class represents the configuration for BareMetalSolution REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_instances to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_instances.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::BareMetalSolution::V2::BareMetalSolution::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_instances.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "baremetalsolution.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the BareMetalSolution API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_instances`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_instances
                  ##
                  # RPC-specific configuration for `get_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_instance
                  ##
                  # RPC-specific configuration for `update_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_instance
                  ##
                  # RPC-specific configuration for `rename_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :rename_instance
                  ##
                  # RPC-specific configuration for `reset_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :reset_instance
                  ##
                  # RPC-specific configuration for `start_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :start_instance
                  ##
                  # RPC-specific configuration for `stop_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :stop_instance
                  ##
                  # RPC-specific configuration for `enable_interactive_serial_console`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :enable_interactive_serial_console
                  ##
                  # RPC-specific configuration for `disable_interactive_serial_console`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :disable_interactive_serial_console
                  ##
                  # RPC-specific configuration for `detach_lun`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :detach_lun
                  ##
                  # RPC-specific configuration for `list_ssh_keys`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_ssh_keys
                  ##
                  # RPC-specific configuration for `create_ssh_key`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_ssh_key
                  ##
                  # RPC-specific configuration for `delete_ssh_key`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_ssh_key
                  ##
                  # RPC-specific configuration for `list_volumes`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_volumes
                  ##
                  # RPC-specific configuration for `get_volume`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_volume
                  ##
                  # RPC-specific configuration for `update_volume`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_volume
                  ##
                  # RPC-specific configuration for `rename_volume`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :rename_volume
                  ##
                  # RPC-specific configuration for `evict_volume`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :evict_volume
                  ##
                  # RPC-specific configuration for `resize_volume`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :resize_volume
                  ##
                  # RPC-specific configuration for `list_networks`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_networks
                  ##
                  # RPC-specific configuration for `list_network_usage`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_network_usage
                  ##
                  # RPC-specific configuration for `get_network`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_network
                  ##
                  # RPC-specific configuration for `update_network`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_network
                  ##
                  # RPC-specific configuration for `create_volume_snapshot`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_volume_snapshot
                  ##
                  # RPC-specific configuration for `restore_volume_snapshot`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :restore_volume_snapshot
                  ##
                  # RPC-specific configuration for `delete_volume_snapshot`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_volume_snapshot
                  ##
                  # RPC-specific configuration for `get_volume_snapshot`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_volume_snapshot
                  ##
                  # RPC-specific configuration for `list_volume_snapshots`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_volume_snapshots
                  ##
                  # RPC-specific configuration for `get_lun`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_lun
                  ##
                  # RPC-specific configuration for `list_luns`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_luns
                  ##
                  # RPC-specific configuration for `evict_lun`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :evict_lun
                  ##
                  # RPC-specific configuration for `get_nfs_share`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_nfs_share
                  ##
                  # RPC-specific configuration for `list_nfs_shares`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_nfs_shares
                  ##
                  # RPC-specific configuration for `update_nfs_share`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_nfs_share
                  ##
                  # RPC-specific configuration for `create_nfs_share`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_nfs_share
                  ##
                  # RPC-specific configuration for `rename_nfs_share`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :rename_nfs_share
                  ##
                  # RPC-specific configuration for `delete_nfs_share`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_nfs_share
                  ##
                  # RPC-specific configuration for `list_provisioning_quotas`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_provisioning_quotas
                  ##
                  # RPC-specific configuration for `submit_provisioning_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :submit_provisioning_config
                  ##
                  # RPC-specific configuration for `get_provisioning_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_provisioning_config
                  ##
                  # RPC-specific configuration for `create_provisioning_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_provisioning_config
                  ##
                  # RPC-specific configuration for `update_provisioning_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_provisioning_config
                  ##
                  # RPC-specific configuration for `rename_network`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :rename_network
                  ##
                  # RPC-specific configuration for `list_os_images`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_os_images

                  # @private
                  def initialize parent_rpcs = nil
                    list_instances_config = parent_rpcs.list_instances if parent_rpcs.respond_to? :list_instances
                    @list_instances = ::Gapic::Config::Method.new list_instances_config
                    get_instance_config = parent_rpcs.get_instance if parent_rpcs.respond_to? :get_instance
                    @get_instance = ::Gapic::Config::Method.new get_instance_config
                    update_instance_config = parent_rpcs.update_instance if parent_rpcs.respond_to? :update_instance
                    @update_instance = ::Gapic::Config::Method.new update_instance_config
                    rename_instance_config = parent_rpcs.rename_instance if parent_rpcs.respond_to? :rename_instance
                    @rename_instance = ::Gapic::Config::Method.new rename_instance_config
                    reset_instance_config = parent_rpcs.reset_instance if parent_rpcs.respond_to? :reset_instance
                    @reset_instance = ::Gapic::Config::Method.new reset_instance_config
                    start_instance_config = parent_rpcs.start_instance if parent_rpcs.respond_to? :start_instance
                    @start_instance = ::Gapic::Config::Method.new start_instance_config
                    stop_instance_config = parent_rpcs.stop_instance if parent_rpcs.respond_to? :stop_instance
                    @stop_instance = ::Gapic::Config::Method.new stop_instance_config
                    enable_interactive_serial_console_config = parent_rpcs.enable_interactive_serial_console if parent_rpcs.respond_to? :enable_interactive_serial_console
                    @enable_interactive_serial_console = ::Gapic::Config::Method.new enable_interactive_serial_console_config
                    disable_interactive_serial_console_config = parent_rpcs.disable_interactive_serial_console if parent_rpcs.respond_to? :disable_interactive_serial_console
                    @disable_interactive_serial_console = ::Gapic::Config::Method.new disable_interactive_serial_console_config
                    detach_lun_config = parent_rpcs.detach_lun if parent_rpcs.respond_to? :detach_lun
                    @detach_lun = ::Gapic::Config::Method.new detach_lun_config
                    list_ssh_keys_config = parent_rpcs.list_ssh_keys if parent_rpcs.respond_to? :list_ssh_keys
                    @list_ssh_keys = ::Gapic::Config::Method.new list_ssh_keys_config
                    create_ssh_key_config = parent_rpcs.create_ssh_key if parent_rpcs.respond_to? :create_ssh_key
                    @create_ssh_key = ::Gapic::Config::Method.new create_ssh_key_config
                    delete_ssh_key_config = parent_rpcs.delete_ssh_key if parent_rpcs.respond_to? :delete_ssh_key
                    @delete_ssh_key = ::Gapic::Config::Method.new delete_ssh_key_config
                    list_volumes_config = parent_rpcs.list_volumes if parent_rpcs.respond_to? :list_volumes
                    @list_volumes = ::Gapic::Config::Method.new list_volumes_config
                    get_volume_config = parent_rpcs.get_volume if parent_rpcs.respond_to? :get_volume
                    @get_volume = ::Gapic::Config::Method.new get_volume_config
                    update_volume_config = parent_rpcs.update_volume if parent_rpcs.respond_to? :update_volume
                    @update_volume = ::Gapic::Config::Method.new update_volume_config
                    rename_volume_config = parent_rpcs.rename_volume if parent_rpcs.respond_to? :rename_volume
                    @rename_volume = ::Gapic::Config::Method.new rename_volume_config
                    evict_volume_config = parent_rpcs.evict_volume if parent_rpcs.respond_to? :evict_volume
                    @evict_volume = ::Gapic::Config::Method.new evict_volume_config
                    resize_volume_config = parent_rpcs.resize_volume if parent_rpcs.respond_to? :resize_volume
                    @resize_volume = ::Gapic::Config::Method.new resize_volume_config
                    list_networks_config = parent_rpcs.list_networks if parent_rpcs.respond_to? :list_networks
                    @list_networks = ::Gapic::Config::Method.new list_networks_config
                    list_network_usage_config = parent_rpcs.list_network_usage if parent_rpcs.respond_to? :list_network_usage
                    @list_network_usage = ::Gapic::Config::Method.new list_network_usage_config
                    get_network_config = parent_rpcs.get_network if parent_rpcs.respond_to? :get_network
                    @get_network = ::Gapic::Config::Method.new get_network_config
                    update_network_config = parent_rpcs.update_network if parent_rpcs.respond_to? :update_network
                    @update_network = ::Gapic::Config::Method.new update_network_config
                    create_volume_snapshot_config = parent_rpcs.create_volume_snapshot if parent_rpcs.respond_to? :create_volume_snapshot
                    @create_volume_snapshot = ::Gapic::Config::Method.new create_volume_snapshot_config
                    restore_volume_snapshot_config = parent_rpcs.restore_volume_snapshot if parent_rpcs.respond_to? :restore_volume_snapshot
                    @restore_volume_snapshot = ::Gapic::Config::Method.new restore_volume_snapshot_config
                    delete_volume_snapshot_config = parent_rpcs.delete_volume_snapshot if parent_rpcs.respond_to? :delete_volume_snapshot
                    @delete_volume_snapshot = ::Gapic::Config::Method.new delete_volume_snapshot_config
                    get_volume_snapshot_config = parent_rpcs.get_volume_snapshot if parent_rpcs.respond_to? :get_volume_snapshot
                    @get_volume_snapshot = ::Gapic::Config::Method.new get_volume_snapshot_config
                    list_volume_snapshots_config = parent_rpcs.list_volume_snapshots if parent_rpcs.respond_to? :list_volume_snapshots
                    @list_volume_snapshots = ::Gapic::Config::Method.new list_volume_snapshots_config
                    get_lun_config = parent_rpcs.get_lun if parent_rpcs.respond_to? :get_lun
                    @get_lun = ::Gapic::Config::Method.new get_lun_config
                    list_luns_config = parent_rpcs.list_luns if parent_rpcs.respond_to? :list_luns
                    @list_luns = ::Gapic::Config::Method.new list_luns_config
                    evict_lun_config = parent_rpcs.evict_lun if parent_rpcs.respond_to? :evict_lun
                    @evict_lun = ::Gapic::Config::Method.new evict_lun_config
                    get_nfs_share_config = parent_rpcs.get_nfs_share if parent_rpcs.respond_to? :get_nfs_share
                    @get_nfs_share = ::Gapic::Config::Method.new get_nfs_share_config
                    list_nfs_shares_config = parent_rpcs.list_nfs_shares if parent_rpcs.respond_to? :list_nfs_shares
                    @list_nfs_shares = ::Gapic::Config::Method.new list_nfs_shares_config
                    update_nfs_share_config = parent_rpcs.update_nfs_share if parent_rpcs.respond_to? :update_nfs_share
                    @update_nfs_share = ::Gapic::Config::Method.new update_nfs_share_config
                    create_nfs_share_config = parent_rpcs.create_nfs_share if parent_rpcs.respond_to? :create_nfs_share
                    @create_nfs_share = ::Gapic::Config::Method.new create_nfs_share_config
                    rename_nfs_share_config = parent_rpcs.rename_nfs_share if parent_rpcs.respond_to? :rename_nfs_share
                    @rename_nfs_share = ::Gapic::Config::Method.new rename_nfs_share_config
                    delete_nfs_share_config = parent_rpcs.delete_nfs_share if parent_rpcs.respond_to? :delete_nfs_share
                    @delete_nfs_share = ::Gapic::Config::Method.new delete_nfs_share_config
                    list_provisioning_quotas_config = parent_rpcs.list_provisioning_quotas if parent_rpcs.respond_to? :list_provisioning_quotas
                    @list_provisioning_quotas = ::Gapic::Config::Method.new list_provisioning_quotas_config
                    submit_provisioning_config_config = parent_rpcs.submit_provisioning_config if parent_rpcs.respond_to? :submit_provisioning_config
                    @submit_provisioning_config = ::Gapic::Config::Method.new submit_provisioning_config_config
                    get_provisioning_config_config = parent_rpcs.get_provisioning_config if parent_rpcs.respond_to? :get_provisioning_config
                    @get_provisioning_config = ::Gapic::Config::Method.new get_provisioning_config_config
                    create_provisioning_config_config = parent_rpcs.create_provisioning_config if parent_rpcs.respond_to? :create_provisioning_config
                    @create_provisioning_config = ::Gapic::Config::Method.new create_provisioning_config_config
                    update_provisioning_config_config = parent_rpcs.update_provisioning_config if parent_rpcs.respond_to? :update_provisioning_config
                    @update_provisioning_config = ::Gapic::Config::Method.new update_provisioning_config_config
                    rename_network_config = parent_rpcs.rename_network if parent_rpcs.respond_to? :rename_network
                    @rename_network = ::Gapic::Config::Method.new rename_network_config
                    list_os_images_config = parent_rpcs.list_os_images if parent_rpcs.respond_to? :list_os_images
                    @list_os_images = ::Gapic::Config::Method.new list_os_images_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
