# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module BareMetalSolution
      module V2
        module BareMetalSolution
          # Path helper methods for the BareMetalSolution API.
          module Paths
            ##
            # Create a fully-qualified Instance resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/instances/{instance}`
            #
            # @param project [String]
            # @param location [String]
            # @param instance [String]
            #
            # @return [::String]
            def instance_path project:, location:, instance:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/instances/#{instance}"
            end

            ##
            # Create a fully-qualified InstanceConfig resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/instanceConfigs/{instance_config}`
            #
            # @param project [String]
            # @param location [String]
            # @param instance_config [String]
            #
            # @return [::String]
            def instance_config_path project:, location:, instance_config:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/instanceConfigs/#{instance_config}"
            end

            ##
            # Create a fully-qualified InterconnectAttachment resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/regions/{region}/interconnectAttachments/{interconnect_attachment}`
            #
            # @param project [String]
            # @param region [String]
            # @param interconnect_attachment [String]
            #
            # @return [::String]
            def interconnect_attachment_path project:, region:, interconnect_attachment:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "region cannot contain /" if region.to_s.include? "/"

              "projects/#{project}/regions/#{region}/interconnectAttachments/#{interconnect_attachment}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified Lun resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/volumes/{volume}/luns/{lun}`
            #
            # @param project [String]
            # @param location [String]
            # @param volume [String]
            # @param lun [String]
            #
            # @return [::String]
            def lun_path project:, location:, volume:, lun:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "volume cannot contain /" if volume.to_s.include? "/"

              "projects/#{project}/locations/#{location}/volumes/#{volume}/luns/#{lun}"
            end

            ##
            # Create a fully-qualified NFSShare resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/nfsShares/{nfs_share}`
            #
            # @param project [String]
            # @param location [String]
            # @param nfs_share [String]
            #
            # @return [::String]
            def nfs_share_path project:, location:, nfs_share:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/nfsShares/#{nfs_share}"
            end

            ##
            # Create a fully-qualified Network resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/networks/{network}`
            #
            # @param project [String]
            # @param location [String]
            # @param network [String]
            #
            # @return [::String]
            def network_path project:, location:, network:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/networks/#{network}"
            end

            ##
            # Create a fully-qualified NetworkConfig resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/networkConfigs/{network_config}`
            #
            # @param project [String]
            # @param location [String]
            # @param network_config [String]
            #
            # @return [::String]
            def network_config_path project:, location:, network_config:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/networkConfigs/#{network_config}"
            end

            ##
            # Create a fully-qualified ProvisioningConfig resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/provisioningConfigs/{provisioning_config}`
            #
            # @param project [String]
            # @param location [String]
            # @param provisioning_config [String]
            #
            # @return [::String]
            def provisioning_config_path project:, location:, provisioning_config:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/provisioningConfigs/#{provisioning_config}"
            end

            ##
            # Create a fully-qualified ServerNetworkTemplate resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/serverNetworkTemplate/{server_network_template}`
            #
            # @param project [String]
            # @param location [String]
            # @param server_network_template [String]
            #
            # @return [::String]
            def server_network_template_path project:, location:, server_network_template:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/serverNetworkTemplate/#{server_network_template}"
            end

            ##
            # Create a fully-qualified SshKey resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/sshKeys/{ssh_key}`
            #
            # @param project [String]
            # @param location [String]
            # @param ssh_key [String]
            #
            # @return [::String]
            def ssh_key_path project:, location:, ssh_key:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/sshKeys/#{ssh_key}"
            end

            ##
            # Create a fully-qualified Volume resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/volumes/{volume}`
            #
            # @param project [String]
            # @param location [String]
            # @param volume [String]
            #
            # @return [::String]
            def volume_path project:, location:, volume:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/volumes/#{volume}"
            end

            ##
            # Create a fully-qualified VolumeConfig resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/volumeConfigs/{volume_config}`
            #
            # @param project [String]
            # @param location [String]
            # @param volume_config [String]
            #
            # @return [::String]
            def volume_config_path project:, location:, volume_config:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/volumeConfigs/#{volume_config}"
            end

            ##
            # Create a fully-qualified VolumeSnapshot resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/volumes/{volume}/snapshots/{snapshot}`
            #
            # @param project [String]
            # @param location [String]
            # @param volume [String]
            # @param snapshot [String]
            #
            # @return [::String]
            def volume_snapshot_path project:, location:, volume:, snapshot:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "volume cannot contain /" if volume.to_s.include? "/"

              "projects/#{project}/locations/#{location}/volumes/#{volume}/snapshots/#{snapshot}"
            end

            extend self
          end
        end
      end
    end
  end
end
