# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/backupdr/v1/backupdr_pb"
require "google/cloud/backupdr/v1/backupdr"

class ::Google::Cloud::BackupDR::V1::BackupDR::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_management_servers
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BackupDR::V1::ListManagementServersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_management_servers_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_management_servers, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::ListManagementServersRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert request.has_filter?
      assert_equal "hello world", request["order_by"]
      assert request.has_order_by?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_management_servers_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_management_servers({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_management_servers parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_management_servers ::Google::Cloud::BackupDR::V1::ListManagementServersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_management_servers({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_management_servers(::Google::Cloud::BackupDR::V1::ListManagementServersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_management_servers_client_stub.call_rpc_count
    end
  end

  def test_get_management_server
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BackupDR::V1::ManagementServer.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_management_server_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_management_server, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::GetManagementServerRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_management_server_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_management_server({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_management_server name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_management_server ::Google::Cloud::BackupDR::V1::GetManagementServerRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_management_server({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_management_server(::Google::Cloud::BackupDR::V1::GetManagementServerRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_management_server_client_stub.call_rpc_count
    end
  end

  def test_create_management_server
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    management_server_id = "hello world"
    management_server = {}
    request_id = "hello world"

    create_management_server_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_management_server, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::CreateManagementServerRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["management_server_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::BackupDR::V1::ManagementServer), request["management_server"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_management_server_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_management_server({ parent: parent, management_server_id: management_server_id, management_server: management_server, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_management_server parent: parent, management_server_id: management_server_id, management_server: management_server, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_management_server ::Google::Cloud::BackupDR::V1::CreateManagementServerRequest.new(parent: parent, management_server_id: management_server_id, management_server: management_server, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_management_server({ parent: parent, management_server_id: management_server_id, management_server: management_server, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_management_server(::Google::Cloud::BackupDR::V1::CreateManagementServerRequest.new(parent: parent, management_server_id: management_server_id, management_server: management_server, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_management_server_client_stub.call_rpc_count
    end
  end

  def test_delete_management_server
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_management_server_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_management_server, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::DeleteManagementServerRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_management_server_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_management_server({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_management_server name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_management_server ::Google::Cloud::BackupDR::V1::DeleteManagementServerRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_management_server({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_management_server(::Google::Cloud::BackupDR::V1::DeleteManagementServerRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_management_server_client_stub.call_rpc_count
    end
  end

  def test_create_backup_vault
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    backup_vault_id = "hello world"
    backup_vault = {}
    request_id = "hello world"
    validate_only = true

    create_backup_vault_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_backup_vault, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::CreateBackupVaultRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["backup_vault_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::BackupDR::V1::BackupVault), request["backup_vault"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_backup_vault_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_backup_vault({ parent: parent, backup_vault_id: backup_vault_id, backup_vault: backup_vault, request_id: request_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_backup_vault parent: parent, backup_vault_id: backup_vault_id, backup_vault: backup_vault, request_id: request_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_backup_vault ::Google::Cloud::BackupDR::V1::CreateBackupVaultRequest.new(parent: parent, backup_vault_id: backup_vault_id, backup_vault: backup_vault, request_id: request_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_backup_vault({ parent: parent, backup_vault_id: backup_vault_id, backup_vault: backup_vault, request_id: request_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_backup_vault(::Google::Cloud::BackupDR::V1::CreateBackupVaultRequest.new(parent: parent, backup_vault_id: backup_vault_id, backup_vault: backup_vault, request_id: request_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_backup_vault_client_stub.call_rpc_count
    end
  end

  def test_list_backup_vaults
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BackupDR::V1::ListBackupVaultsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"
    view = :BACKUP_VAULT_VIEW_UNSPECIFIED

    list_backup_vaults_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_backup_vaults, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::ListBackupVaultsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      assert_equal :BACKUP_VAULT_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_backup_vaults_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_backup_vaults({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_backup_vaults parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_backup_vaults ::Google::Cloud::BackupDR::V1::ListBackupVaultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_backup_vaults({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_backup_vaults(::Google::Cloud::BackupDR::V1::ListBackupVaultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_backup_vaults_client_stub.call_rpc_count
    end
  end

  def test_fetch_usable_backup_vaults
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BackupDR::V1::FetchUsableBackupVaultsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    fetch_usable_backup_vaults_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_usable_backup_vaults, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::FetchUsableBackupVaultsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_usable_backup_vaults_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_usable_backup_vaults({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_usable_backup_vaults parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_usable_backup_vaults ::Google::Cloud::BackupDR::V1::FetchUsableBackupVaultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_usable_backup_vaults({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_usable_backup_vaults(::Google::Cloud::BackupDR::V1::FetchUsableBackupVaultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_usable_backup_vaults_client_stub.call_rpc_count
    end
  end

  def test_get_backup_vault
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BackupDR::V1::BackupVault.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :BACKUP_VAULT_VIEW_UNSPECIFIED

    get_backup_vault_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_backup_vault, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::GetBackupVaultRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :BACKUP_VAULT_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_backup_vault_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_backup_vault({ name: name, view: view }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_backup_vault name: name, view: view do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_backup_vault ::Google::Cloud::BackupDR::V1::GetBackupVaultRequest.new(name: name, view: view) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_backup_vault({ name: name, view: view }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_backup_vault(::Google::Cloud::BackupDR::V1::GetBackupVaultRequest.new(name: name, view: view), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_backup_vault_client_stub.call_rpc_count
    end
  end

  def test_update_backup_vault
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    backup_vault = {}
    request_id = "hello world"
    validate_only = true
    force = true
    force_update_access_restriction = true

    update_backup_vault_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_backup_vault, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::UpdateBackupVaultRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::BackupDR::V1::BackupVault), request["backup_vault"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      assert_equal true, request["force"]
      assert_equal true, request["force_update_access_restriction"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_backup_vault_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_backup_vault({ update_mask: update_mask, backup_vault: backup_vault, request_id: request_id, validate_only: validate_only, force: force, force_update_access_restriction: force_update_access_restriction }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_backup_vault update_mask: update_mask, backup_vault: backup_vault, request_id: request_id, validate_only: validate_only, force: force, force_update_access_restriction: force_update_access_restriction do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_backup_vault ::Google::Cloud::BackupDR::V1::UpdateBackupVaultRequest.new(update_mask: update_mask, backup_vault: backup_vault, request_id: request_id, validate_only: validate_only, force: force, force_update_access_restriction: force_update_access_restriction) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_backup_vault({ update_mask: update_mask, backup_vault: backup_vault, request_id: request_id, validate_only: validate_only, force: force, force_update_access_restriction: force_update_access_restriction }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_backup_vault(::Google::Cloud::BackupDR::V1::UpdateBackupVaultRequest.new(update_mask: update_mask, backup_vault: backup_vault, request_id: request_id, validate_only: validate_only, force: force, force_update_access_restriction: force_update_access_restriction), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_backup_vault_client_stub.call_rpc_count
    end
  end

  def test_delete_backup_vault
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    force = true
    etag = "hello world"
    validate_only = true
    allow_missing = true
    ignore_backup_plan_references = true

    delete_backup_vault_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_backup_vault, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::DeleteBackupVaultRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["force"]
      assert_equal "hello world", request["etag"]
      assert_equal true, request["validate_only"]
      assert_equal true, request["allow_missing"]
      assert_equal true, request["ignore_backup_plan_references"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_backup_vault_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_backup_vault({ name: name, request_id: request_id, force: force, etag: etag, validate_only: validate_only, allow_missing: allow_missing, ignore_backup_plan_references: ignore_backup_plan_references }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_backup_vault name: name, request_id: request_id, force: force, etag: etag, validate_only: validate_only, allow_missing: allow_missing, ignore_backup_plan_references: ignore_backup_plan_references do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_backup_vault ::Google::Cloud::BackupDR::V1::DeleteBackupVaultRequest.new(name: name, request_id: request_id, force: force, etag: etag, validate_only: validate_only, allow_missing: allow_missing, ignore_backup_plan_references: ignore_backup_plan_references) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_backup_vault({ name: name, request_id: request_id, force: force, etag: etag, validate_only: validate_only, allow_missing: allow_missing, ignore_backup_plan_references: ignore_backup_plan_references }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_backup_vault(::Google::Cloud::BackupDR::V1::DeleteBackupVaultRequest.new(name: name, request_id: request_id, force: force, etag: etag, validate_only: validate_only, allow_missing: allow_missing, ignore_backup_plan_references: ignore_backup_plan_references), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_backup_vault_client_stub.call_rpc_count
    end
  end

  def test_list_data_sources
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BackupDR::V1::ListDataSourcesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_data_sources_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_data_sources, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::ListDataSourcesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_data_sources_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_data_sources({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_data_sources parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_data_sources ::Google::Cloud::BackupDR::V1::ListDataSourcesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_data_sources({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_data_sources(::Google::Cloud::BackupDR::V1::ListDataSourcesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_data_sources_client_stub.call_rpc_count
    end
  end

  def test_get_data_source
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BackupDR::V1::DataSource.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_data_source_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_data_source, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::GetDataSourceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_data_source_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_data_source({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_data_source name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_data_source ::Google::Cloud::BackupDR::V1::GetDataSourceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_data_source({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_data_source(::Google::Cloud::BackupDR::V1::GetDataSourceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_data_source_client_stub.call_rpc_count
    end
  end

  def test_update_data_source
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    data_source = {}
    request_id = "hello world"
    allow_missing = true

    update_data_source_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_data_source, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::UpdateDataSourceRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::BackupDR::V1::DataSource), request["data_source"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["allow_missing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_data_source_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_data_source({ update_mask: update_mask, data_source: data_source, request_id: request_id, allow_missing: allow_missing }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_data_source update_mask: update_mask, data_source: data_source, request_id: request_id, allow_missing: allow_missing do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_data_source ::Google::Cloud::BackupDR::V1::UpdateDataSourceRequest.new(update_mask: update_mask, data_source: data_source, request_id: request_id, allow_missing: allow_missing) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_data_source({ update_mask: update_mask, data_source: data_source, request_id: request_id, allow_missing: allow_missing }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_data_source(::Google::Cloud::BackupDR::V1::UpdateDataSourceRequest.new(update_mask: update_mask, data_source: data_source, request_id: request_id, allow_missing: allow_missing), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_data_source_client_stub.call_rpc_count
    end
  end

  def test_list_backups
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BackupDR::V1::ListBackupsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"
    view = :BACKUP_VIEW_UNSPECIFIED

    list_backups_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_backups, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::ListBackupsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      assert_equal :BACKUP_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_backups_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_backups({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_backups parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_backups ::Google::Cloud::BackupDR::V1::ListBackupsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_backups({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_backups(::Google::Cloud::BackupDR::V1::ListBackupsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_backups_client_stub.call_rpc_count
    end
  end

  def test_fetch_backups_for_resource_type
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BackupDR::V1::FetchBackupsForResourceTypeResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    resource_type = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"
    view = :BACKUP_VIEW_UNSPECIFIED

    fetch_backups_for_resource_type_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_backups_for_resource_type, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::FetchBackupsForResourceTypeRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["resource_type"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      assert_equal :BACKUP_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_backups_for_resource_type_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_backups_for_resource_type({ parent: parent, resource_type: resource_type, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_backups_for_resource_type parent: parent, resource_type: resource_type, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_backups_for_resource_type ::Google::Cloud::BackupDR::V1::FetchBackupsForResourceTypeRequest.new(parent: parent, resource_type: resource_type, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_backups_for_resource_type({ parent: parent, resource_type: resource_type, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_backups_for_resource_type(::Google::Cloud::BackupDR::V1::FetchBackupsForResourceTypeRequest.new(parent: parent, resource_type: resource_type, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_backups_for_resource_type_client_stub.call_rpc_count
    end
  end

  def test_get_backup
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BackupDR::V1::Backup.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :BACKUP_VIEW_UNSPECIFIED

    get_backup_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_backup, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::GetBackupRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :BACKUP_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_backup_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_backup({ name: name, view: view }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_backup name: name, view: view do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_backup ::Google::Cloud::BackupDR::V1::GetBackupRequest.new(name: name, view: view) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_backup({ name: name, view: view }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_backup(::Google::Cloud::BackupDR::V1::GetBackupRequest.new(name: name, view: view), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_backup_client_stub.call_rpc_count
    end
  end

  def test_update_backup
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    backup = {}
    request_id = "hello world"

    update_backup_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_backup, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::UpdateBackupRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::BackupDR::V1::Backup), request["backup"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_backup_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_backup({ update_mask: update_mask, backup: backup, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_backup update_mask: update_mask, backup: backup, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_backup ::Google::Cloud::BackupDR::V1::UpdateBackupRequest.new(update_mask: update_mask, backup: backup, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_backup({ update_mask: update_mask, backup: backup, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_backup(::Google::Cloud::BackupDR::V1::UpdateBackupRequest.new(update_mask: update_mask, backup: backup, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_backup_client_stub.call_rpc_count
    end
  end

  def test_delete_backup
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_backup_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_backup, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::DeleteBackupRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_backup_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_backup({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_backup name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_backup ::Google::Cloud::BackupDR::V1::DeleteBackupRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_backup({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_backup(::Google::Cloud::BackupDR::V1::DeleteBackupRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_backup_client_stub.call_rpc_count
    end
  end

  def test_restore_backup
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    compute_instance_target_environment = {}
    compute_instance_restore_properties = {}
    clear_overrides_field_mask = {}

    restore_backup_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :restore_backup, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::RestoreBackupRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::BackupDR::V1::ComputeInstanceTargetEnvironment), request["compute_instance_target_environment"]
      assert_equal :compute_instance_target_environment, request.target_environment
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::BackupDR::V1::ComputeInstanceRestoreProperties), request["compute_instance_restore_properties"]
      assert_equal :compute_instance_restore_properties, request.instance_properties
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["clear_overrides_field_mask"]
      assert request.has_clear_overrides_field_mask?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, restore_backup_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.restore_backup({ name: name, request_id: request_id, compute_instance_target_environment: compute_instance_target_environment, compute_instance_restore_properties: compute_instance_restore_properties, clear_overrides_field_mask: clear_overrides_field_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.restore_backup name: name, request_id: request_id, compute_instance_target_environment: compute_instance_target_environment, compute_instance_restore_properties: compute_instance_restore_properties, clear_overrides_field_mask: clear_overrides_field_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.restore_backup ::Google::Cloud::BackupDR::V1::RestoreBackupRequest.new(name: name, request_id: request_id, compute_instance_target_environment: compute_instance_target_environment, compute_instance_restore_properties: compute_instance_restore_properties, clear_overrides_field_mask: clear_overrides_field_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.restore_backup({ name: name, request_id: request_id, compute_instance_target_environment: compute_instance_target_environment, compute_instance_restore_properties: compute_instance_restore_properties, clear_overrides_field_mask: clear_overrides_field_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.restore_backup(::Google::Cloud::BackupDR::V1::RestoreBackupRequest.new(name: name, request_id: request_id, compute_instance_target_environment: compute_instance_target_environment, compute_instance_restore_properties: compute_instance_restore_properties, clear_overrides_field_mask: clear_overrides_field_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, restore_backup_client_stub.call_rpc_count
    end
  end

  def test_create_backup_plan
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    backup_plan_id = "hello world"
    backup_plan = {}
    request_id = "hello world"

    create_backup_plan_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_backup_plan, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::CreateBackupPlanRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["backup_plan_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::BackupDR::V1::BackupPlan), request["backup_plan"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_backup_plan_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_backup_plan({ parent: parent, backup_plan_id: backup_plan_id, backup_plan: backup_plan, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_backup_plan parent: parent, backup_plan_id: backup_plan_id, backup_plan: backup_plan, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_backup_plan ::Google::Cloud::BackupDR::V1::CreateBackupPlanRequest.new(parent: parent, backup_plan_id: backup_plan_id, backup_plan: backup_plan, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_backup_plan({ parent: parent, backup_plan_id: backup_plan_id, backup_plan: backup_plan, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_backup_plan(::Google::Cloud::BackupDR::V1::CreateBackupPlanRequest.new(parent: parent, backup_plan_id: backup_plan_id, backup_plan: backup_plan, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_backup_plan_client_stub.call_rpc_count
    end
  end

  def test_update_backup_plan
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    backup_plan = {}
    update_mask = {}
    request_id = "hello world"

    update_backup_plan_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_backup_plan, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::UpdateBackupPlanRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::BackupDR::V1::BackupPlan), request["backup_plan"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_backup_plan_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_backup_plan({ backup_plan: backup_plan, update_mask: update_mask, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_backup_plan backup_plan: backup_plan, update_mask: update_mask, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_backup_plan ::Google::Cloud::BackupDR::V1::UpdateBackupPlanRequest.new(backup_plan: backup_plan, update_mask: update_mask, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_backup_plan({ backup_plan: backup_plan, update_mask: update_mask, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_backup_plan(::Google::Cloud::BackupDR::V1::UpdateBackupPlanRequest.new(backup_plan: backup_plan, update_mask: update_mask, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_backup_plan_client_stub.call_rpc_count
    end
  end

  def test_get_backup_plan
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BackupDR::V1::BackupPlan.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_backup_plan_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_backup_plan, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::GetBackupPlanRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_backup_plan_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_backup_plan({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_backup_plan name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_backup_plan ::Google::Cloud::BackupDR::V1::GetBackupPlanRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_backup_plan({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_backup_plan(::Google::Cloud::BackupDR::V1::GetBackupPlanRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_backup_plan_client_stub.call_rpc_count
    end
  end

  def test_list_backup_plans
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BackupDR::V1::ListBackupPlansResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_backup_plans_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_backup_plans, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::ListBackupPlansRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_backup_plans_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_backup_plans({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_backup_plans parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_backup_plans ::Google::Cloud::BackupDR::V1::ListBackupPlansRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_backup_plans({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_backup_plans(::Google::Cloud::BackupDR::V1::ListBackupPlansRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_backup_plans_client_stub.call_rpc_count
    end
  end

  def test_delete_backup_plan
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_backup_plan_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_backup_plan, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::DeleteBackupPlanRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_backup_plan_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_backup_plan({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_backup_plan name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_backup_plan ::Google::Cloud::BackupDR::V1::DeleteBackupPlanRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_backup_plan({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_backup_plan(::Google::Cloud::BackupDR::V1::DeleteBackupPlanRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_backup_plan_client_stub.call_rpc_count
    end
  end

  def test_get_backup_plan_revision
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BackupDR::V1::BackupPlanRevision.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_backup_plan_revision_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_backup_plan_revision, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::GetBackupPlanRevisionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_backup_plan_revision_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_backup_plan_revision({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_backup_plan_revision name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_backup_plan_revision ::Google::Cloud::BackupDR::V1::GetBackupPlanRevisionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_backup_plan_revision({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_backup_plan_revision(::Google::Cloud::BackupDR::V1::GetBackupPlanRevisionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_backup_plan_revision_client_stub.call_rpc_count
    end
  end

  def test_list_backup_plan_revisions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BackupDR::V1::ListBackupPlanRevisionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_backup_plan_revisions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_backup_plan_revisions, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::ListBackupPlanRevisionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_backup_plan_revisions_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_backup_plan_revisions({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_backup_plan_revisions parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_backup_plan_revisions ::Google::Cloud::BackupDR::V1::ListBackupPlanRevisionsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_backup_plan_revisions({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_backup_plan_revisions(::Google::Cloud::BackupDR::V1::ListBackupPlanRevisionsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_backup_plan_revisions_client_stub.call_rpc_count
    end
  end

  def test_create_backup_plan_association
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    backup_plan_association_id = "hello world"
    backup_plan_association = {}
    request_id = "hello world"

    create_backup_plan_association_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_backup_plan_association, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::CreateBackupPlanAssociationRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["backup_plan_association_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::BackupDR::V1::BackupPlanAssociation), request["backup_plan_association"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_backup_plan_association_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_backup_plan_association({ parent: parent, backup_plan_association_id: backup_plan_association_id, backup_plan_association: backup_plan_association, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_backup_plan_association parent: parent, backup_plan_association_id: backup_plan_association_id, backup_plan_association: backup_plan_association, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_backup_plan_association ::Google::Cloud::BackupDR::V1::CreateBackupPlanAssociationRequest.new(parent: parent, backup_plan_association_id: backup_plan_association_id, backup_plan_association: backup_plan_association, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_backup_plan_association({ parent: parent, backup_plan_association_id: backup_plan_association_id, backup_plan_association: backup_plan_association, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_backup_plan_association(::Google::Cloud::BackupDR::V1::CreateBackupPlanAssociationRequest.new(parent: parent, backup_plan_association_id: backup_plan_association_id, backup_plan_association: backup_plan_association, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_backup_plan_association_client_stub.call_rpc_count
    end
  end

  def test_update_backup_plan_association
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    backup_plan_association = {}
    update_mask = {}
    request_id = "hello world"

    update_backup_plan_association_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_backup_plan_association, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::UpdateBackupPlanAssociationRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::BackupDR::V1::BackupPlanAssociation), request["backup_plan_association"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_backup_plan_association_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_backup_plan_association({ backup_plan_association: backup_plan_association, update_mask: update_mask, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_backup_plan_association backup_plan_association: backup_plan_association, update_mask: update_mask, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_backup_plan_association ::Google::Cloud::BackupDR::V1::UpdateBackupPlanAssociationRequest.new(backup_plan_association: backup_plan_association, update_mask: update_mask, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_backup_plan_association({ backup_plan_association: backup_plan_association, update_mask: update_mask, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_backup_plan_association(::Google::Cloud::BackupDR::V1::UpdateBackupPlanAssociationRequest.new(backup_plan_association: backup_plan_association, update_mask: update_mask, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_backup_plan_association_client_stub.call_rpc_count
    end
  end

  def test_get_backup_plan_association
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BackupDR::V1::BackupPlanAssociation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_backup_plan_association_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_backup_plan_association, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::GetBackupPlanAssociationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_backup_plan_association_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_backup_plan_association({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_backup_plan_association name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_backup_plan_association ::Google::Cloud::BackupDR::V1::GetBackupPlanAssociationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_backup_plan_association({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_backup_plan_association(::Google::Cloud::BackupDR::V1::GetBackupPlanAssociationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_backup_plan_association_client_stub.call_rpc_count
    end
  end

  def test_list_backup_plan_associations
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BackupDR::V1::ListBackupPlanAssociationsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_backup_plan_associations_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_backup_plan_associations, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::ListBackupPlanAssociationsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_backup_plan_associations_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_backup_plan_associations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_backup_plan_associations parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_backup_plan_associations ::Google::Cloud::BackupDR::V1::ListBackupPlanAssociationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_backup_plan_associations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_backup_plan_associations(::Google::Cloud::BackupDR::V1::ListBackupPlanAssociationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_backup_plan_associations_client_stub.call_rpc_count
    end
  end

  def test_fetch_backup_plan_associations_for_resource_type
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BackupDR::V1::FetchBackupPlanAssociationsForResourceTypeResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    resource_type = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    fetch_backup_plan_associations_for_resource_type_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_backup_plan_associations_for_resource_type, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::FetchBackupPlanAssociationsForResourceTypeRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["resource_type"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_backup_plan_associations_for_resource_type_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_backup_plan_associations_for_resource_type({ parent: parent, resource_type: resource_type, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_backup_plan_associations_for_resource_type parent: parent, resource_type: resource_type, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_backup_plan_associations_for_resource_type ::Google::Cloud::BackupDR::V1::FetchBackupPlanAssociationsForResourceTypeRequest.new(parent: parent, resource_type: resource_type, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_backup_plan_associations_for_resource_type({ parent: parent, resource_type: resource_type, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_backup_plan_associations_for_resource_type(::Google::Cloud::BackupDR::V1::FetchBackupPlanAssociationsForResourceTypeRequest.new(parent: parent, resource_type: resource_type, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_backup_plan_associations_for_resource_type_client_stub.call_rpc_count
    end
  end

  def test_delete_backup_plan_association
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_backup_plan_association_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_backup_plan_association, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::DeleteBackupPlanAssociationRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_backup_plan_association_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_backup_plan_association({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_backup_plan_association name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_backup_plan_association ::Google::Cloud::BackupDR::V1::DeleteBackupPlanAssociationRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_backup_plan_association({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_backup_plan_association(::Google::Cloud::BackupDR::V1::DeleteBackupPlanAssociationRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_backup_plan_association_client_stub.call_rpc_count
    end
  end

  def test_trigger_backup
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    rule_id = "hello world"
    request_id = "hello world"

    trigger_backup_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :trigger_backup, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::TriggerBackupRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["rule_id"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, trigger_backup_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.trigger_backup({ name: name, rule_id: rule_id, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.trigger_backup name: name, rule_id: rule_id, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.trigger_backup ::Google::Cloud::BackupDR::V1::TriggerBackupRequest.new(name: name, rule_id: rule_id, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.trigger_backup({ name: name, rule_id: rule_id, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.trigger_backup(::Google::Cloud::BackupDR::V1::TriggerBackupRequest.new(name: name, rule_id: rule_id, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, trigger_backup_client_stub.call_rpc_count
    end
  end

  def test_get_data_source_reference
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BackupDR::V1::DataSourceReference.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_data_source_reference_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_data_source_reference, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::GetDataSourceReferenceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_data_source_reference_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_data_source_reference({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_data_source_reference name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_data_source_reference ::Google::Cloud::BackupDR::V1::GetDataSourceReferenceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_data_source_reference({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_data_source_reference(::Google::Cloud::BackupDR::V1::GetDataSourceReferenceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_data_source_reference_client_stub.call_rpc_count
    end
  end

  def test_list_data_source_references
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BackupDR::V1::ListDataSourceReferencesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_data_source_references_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_data_source_references, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::ListDataSourceReferencesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_data_source_references_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_data_source_references({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_data_source_references parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_data_source_references ::Google::Cloud::BackupDR::V1::ListDataSourceReferencesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_data_source_references({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_data_source_references(::Google::Cloud::BackupDR::V1::ListDataSourceReferencesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_data_source_references_client_stub.call_rpc_count
    end
  end

  def test_fetch_data_source_references_for_resource_type
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::BackupDR::V1::FetchDataSourceReferencesForResourceTypeResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    resource_type = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    fetch_data_source_references_for_resource_type_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_data_source_references_for_resource_type, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::FetchDataSourceReferencesForResourceTypeRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["resource_type"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_data_source_references_for_resource_type_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_data_source_references_for_resource_type({ parent: parent, resource_type: resource_type, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_data_source_references_for_resource_type parent: parent, resource_type: resource_type, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_data_source_references_for_resource_type ::Google::Cloud::BackupDR::V1::FetchDataSourceReferencesForResourceTypeRequest.new(parent: parent, resource_type: resource_type, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_data_source_references_for_resource_type({ parent: parent, resource_type: resource_type, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_data_source_references_for_resource_type(::Google::Cloud::BackupDR::V1::FetchDataSourceReferencesForResourceTypeRequest.new(parent: parent, resource_type: resource_type, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_data_source_references_for_resource_type_client_stub.call_rpc_count
    end
  end

  def test_initialize_service
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    resource_type = "hello world"
    request_id = "hello world"
    cloud_sql_instance_initialization_config = {}

    initialize_service_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :initialize_service, name
      assert_kind_of ::Google::Cloud::BackupDR::V1::InitializeServiceRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["resource_type"]
      assert_equal "hello world", request["request_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::BackupDR::V1::CloudSqlInstanceInitializationConfig), request["cloud_sql_instance_initialization_config"]
      assert_equal :cloud_sql_instance_initialization_config, request.initialization_config
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, initialize_service_client_stub do
      # Create client
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.initialize_service({ name: name, resource_type: resource_type, request_id: request_id, cloud_sql_instance_initialization_config: cloud_sql_instance_initialization_config }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.initialize_service name: name, resource_type: resource_type, request_id: request_id, cloud_sql_instance_initialization_config: cloud_sql_instance_initialization_config do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.initialize_service ::Google::Cloud::BackupDR::V1::InitializeServiceRequest.new(name: name, resource_type: resource_type, request_id: request_id, cloud_sql_instance_initialization_config: cloud_sql_instance_initialization_config) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.initialize_service({ name: name, resource_type: resource_type, request_id: request_id, cloud_sql_instance_initialization_config: cloud_sql_instance_initialization_config }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.initialize_service(::Google::Cloud::BackupDR::V1::InitializeServiceRequest.new(name: name, resource_type: resource_type, request_id: request_id, cloud_sql_instance_initialization_config: cloud_sql_instance_initialization_config), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, initialize_service_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::BackupDR::V1::BackupDR::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::BackupDR::V1::BackupDR::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::BackupDR::V1::BackupDR::Operations, client.operations_client
  end
end
