# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/backupdr/v1/backupdr_pb"
require "google/cloud/backupdr/v1/backupdr/rest"


class ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_management_servers
    # Create test objects.
    client_result = ::Google::Cloud::BackupDR::V1::ListManagementServersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_management_servers_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_list_management_servers_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_management_servers_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_management_servers({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_management_servers parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_management_servers ::Google::Cloud::BackupDR::V1::ListManagementServersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_management_servers({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_management_servers(::Google::Cloud::BackupDR::V1::ListManagementServersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_management_servers_client_stub.call_count
      end
    end
  end

  def test_get_management_server
    # Create test objects.
    client_result = ::Google::Cloud::BackupDR::V1::ManagementServer.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_management_server_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_get_management_server_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_management_server_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_management_server({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_management_server name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_management_server ::Google::Cloud::BackupDR::V1::GetManagementServerRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_management_server({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_management_server(::Google::Cloud::BackupDR::V1::GetManagementServerRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_management_server_client_stub.call_count
      end
    end
  end

  def test_create_management_server
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    management_server_id = "hello world"
    management_server = {}
    request_id = "hello world"

    create_management_server_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_create_management_server_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_management_server_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_management_server({ parent: parent, management_server_id: management_server_id, management_server: management_server, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_management_server parent: parent, management_server_id: management_server_id, management_server: management_server, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_management_server ::Google::Cloud::BackupDR::V1::CreateManagementServerRequest.new(parent: parent, management_server_id: management_server_id, management_server: management_server, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_management_server({ parent: parent, management_server_id: management_server_id, management_server: management_server, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_management_server(::Google::Cloud::BackupDR::V1::CreateManagementServerRequest.new(parent: parent, management_server_id: management_server_id, management_server: management_server, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_management_server_client_stub.call_count
      end
    end
  end

  def test_delete_management_server
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_management_server_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_delete_management_server_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_management_server_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_management_server({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_management_server name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_management_server ::Google::Cloud::BackupDR::V1::DeleteManagementServerRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_management_server({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_management_server(::Google::Cloud::BackupDR::V1::DeleteManagementServerRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_management_server_client_stub.call_count
      end
    end
  end

  def test_create_backup_vault
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    backup_vault_id = "hello world"
    backup_vault = {}
    request_id = "hello world"
    validate_only = true

    create_backup_vault_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_create_backup_vault_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_backup_vault_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_backup_vault({ parent: parent, backup_vault_id: backup_vault_id, backup_vault: backup_vault, request_id: request_id, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_backup_vault parent: parent, backup_vault_id: backup_vault_id, backup_vault: backup_vault, request_id: request_id, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_backup_vault ::Google::Cloud::BackupDR::V1::CreateBackupVaultRequest.new(parent: parent, backup_vault_id: backup_vault_id, backup_vault: backup_vault, request_id: request_id, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_backup_vault({ parent: parent, backup_vault_id: backup_vault_id, backup_vault: backup_vault, request_id: request_id, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_backup_vault(::Google::Cloud::BackupDR::V1::CreateBackupVaultRequest.new(parent: parent, backup_vault_id: backup_vault_id, backup_vault: backup_vault, request_id: request_id, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_backup_vault_client_stub.call_count
      end
    end
  end

  def test_list_backup_vaults
    # Create test objects.
    client_result = ::Google::Cloud::BackupDR::V1::ListBackupVaultsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"
    view = :BACKUP_VAULT_VIEW_UNSPECIFIED

    list_backup_vaults_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_list_backup_vaults_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_backup_vaults_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_backup_vaults({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_backup_vaults parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_backup_vaults ::Google::Cloud::BackupDR::V1::ListBackupVaultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_backup_vaults({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_backup_vaults(::Google::Cloud::BackupDR::V1::ListBackupVaultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_backup_vaults_client_stub.call_count
      end
    end
  end

  def test_fetch_usable_backup_vaults
    # Create test objects.
    client_result = ::Google::Cloud::BackupDR::V1::FetchUsableBackupVaultsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    fetch_usable_backup_vaults_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_fetch_usable_backup_vaults_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_usable_backup_vaults_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_usable_backup_vaults({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_usable_backup_vaults parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_usable_backup_vaults ::Google::Cloud::BackupDR::V1::FetchUsableBackupVaultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_usable_backup_vaults({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_usable_backup_vaults(::Google::Cloud::BackupDR::V1::FetchUsableBackupVaultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_usable_backup_vaults_client_stub.call_count
      end
    end
  end

  def test_get_backup_vault
    # Create test objects.
    client_result = ::Google::Cloud::BackupDR::V1::BackupVault.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :BACKUP_VAULT_VIEW_UNSPECIFIED

    get_backup_vault_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_get_backup_vault_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_backup_vault_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_backup_vault({ name: name, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_backup_vault name: name, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_backup_vault ::Google::Cloud::BackupDR::V1::GetBackupVaultRequest.new(name: name, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_backup_vault({ name: name, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_backup_vault(::Google::Cloud::BackupDR::V1::GetBackupVaultRequest.new(name: name, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_backup_vault_client_stub.call_count
      end
    end
  end

  def test_update_backup_vault
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    backup_vault = {}
    request_id = "hello world"
    validate_only = true
    force = true
    force_update_access_restriction = true

    update_backup_vault_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_update_backup_vault_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_backup_vault_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_backup_vault({ update_mask: update_mask, backup_vault: backup_vault, request_id: request_id, validate_only: validate_only, force: force, force_update_access_restriction: force_update_access_restriction }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_backup_vault update_mask: update_mask, backup_vault: backup_vault, request_id: request_id, validate_only: validate_only, force: force, force_update_access_restriction: force_update_access_restriction do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_backup_vault ::Google::Cloud::BackupDR::V1::UpdateBackupVaultRequest.new(update_mask: update_mask, backup_vault: backup_vault, request_id: request_id, validate_only: validate_only, force: force, force_update_access_restriction: force_update_access_restriction) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_backup_vault({ update_mask: update_mask, backup_vault: backup_vault, request_id: request_id, validate_only: validate_only, force: force, force_update_access_restriction: force_update_access_restriction }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_backup_vault(::Google::Cloud::BackupDR::V1::UpdateBackupVaultRequest.new(update_mask: update_mask, backup_vault: backup_vault, request_id: request_id, validate_only: validate_only, force: force, force_update_access_restriction: force_update_access_restriction), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_backup_vault_client_stub.call_count
      end
    end
  end

  def test_delete_backup_vault
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    force = true
    etag = "hello world"
    validate_only = true
    allow_missing = true
    ignore_backup_plan_references = true

    delete_backup_vault_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_delete_backup_vault_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_backup_vault_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_backup_vault({ name: name, request_id: request_id, force: force, etag: etag, validate_only: validate_only, allow_missing: allow_missing, ignore_backup_plan_references: ignore_backup_plan_references }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_backup_vault name: name, request_id: request_id, force: force, etag: etag, validate_only: validate_only, allow_missing: allow_missing, ignore_backup_plan_references: ignore_backup_plan_references do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_backup_vault ::Google::Cloud::BackupDR::V1::DeleteBackupVaultRequest.new(name: name, request_id: request_id, force: force, etag: etag, validate_only: validate_only, allow_missing: allow_missing, ignore_backup_plan_references: ignore_backup_plan_references) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_backup_vault({ name: name, request_id: request_id, force: force, etag: etag, validate_only: validate_only, allow_missing: allow_missing, ignore_backup_plan_references: ignore_backup_plan_references }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_backup_vault(::Google::Cloud::BackupDR::V1::DeleteBackupVaultRequest.new(name: name, request_id: request_id, force: force, etag: etag, validate_only: validate_only, allow_missing: allow_missing, ignore_backup_plan_references: ignore_backup_plan_references), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_backup_vault_client_stub.call_count
      end
    end
  end

  def test_list_data_sources
    # Create test objects.
    client_result = ::Google::Cloud::BackupDR::V1::ListDataSourcesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_data_sources_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_list_data_sources_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_data_sources_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_data_sources({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_data_sources parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_data_sources ::Google::Cloud::BackupDR::V1::ListDataSourcesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_data_sources({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_data_sources(::Google::Cloud::BackupDR::V1::ListDataSourcesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_data_sources_client_stub.call_count
      end
    end
  end

  def test_get_data_source
    # Create test objects.
    client_result = ::Google::Cloud::BackupDR::V1::DataSource.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_data_source_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_get_data_source_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_data_source_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_data_source({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_data_source name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_data_source ::Google::Cloud::BackupDR::V1::GetDataSourceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_data_source({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_data_source(::Google::Cloud::BackupDR::V1::GetDataSourceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_data_source_client_stub.call_count
      end
    end
  end

  def test_update_data_source
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    data_source = {}
    request_id = "hello world"
    allow_missing = true

    update_data_source_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_update_data_source_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_data_source_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_data_source({ update_mask: update_mask, data_source: data_source, request_id: request_id, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_data_source update_mask: update_mask, data_source: data_source, request_id: request_id, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_data_source ::Google::Cloud::BackupDR::V1::UpdateDataSourceRequest.new(update_mask: update_mask, data_source: data_source, request_id: request_id, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_data_source({ update_mask: update_mask, data_source: data_source, request_id: request_id, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_data_source(::Google::Cloud::BackupDR::V1::UpdateDataSourceRequest.new(update_mask: update_mask, data_source: data_source, request_id: request_id, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_data_source_client_stub.call_count
      end
    end
  end

  def test_list_backups
    # Create test objects.
    client_result = ::Google::Cloud::BackupDR::V1::ListBackupsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"
    view = :BACKUP_VIEW_UNSPECIFIED

    list_backups_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_list_backups_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_backups_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_backups({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_backups parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_backups ::Google::Cloud::BackupDR::V1::ListBackupsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_backups({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_backups(::Google::Cloud::BackupDR::V1::ListBackupsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_backups_client_stub.call_count
      end
    end
  end

  def test_fetch_backups_for_resource_type
    # Create test objects.
    client_result = ::Google::Cloud::BackupDR::V1::FetchBackupsForResourceTypeResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    resource_type = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"
    view = :BACKUP_VIEW_UNSPECIFIED

    fetch_backups_for_resource_type_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_fetch_backups_for_resource_type_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_backups_for_resource_type_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_backups_for_resource_type({ parent: parent, resource_type: resource_type, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_backups_for_resource_type parent: parent, resource_type: resource_type, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_backups_for_resource_type ::Google::Cloud::BackupDR::V1::FetchBackupsForResourceTypeRequest.new(parent: parent, resource_type: resource_type, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_backups_for_resource_type({ parent: parent, resource_type: resource_type, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_backups_for_resource_type(::Google::Cloud::BackupDR::V1::FetchBackupsForResourceTypeRequest.new(parent: parent, resource_type: resource_type, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_backups_for_resource_type_client_stub.call_count
      end
    end
  end

  def test_get_backup
    # Create test objects.
    client_result = ::Google::Cloud::BackupDR::V1::Backup.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :BACKUP_VIEW_UNSPECIFIED

    get_backup_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_get_backup_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_backup_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_backup({ name: name, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_backup name: name, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_backup ::Google::Cloud::BackupDR::V1::GetBackupRequest.new(name: name, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_backup({ name: name, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_backup(::Google::Cloud::BackupDR::V1::GetBackupRequest.new(name: name, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_backup_client_stub.call_count
      end
    end
  end

  def test_update_backup
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    backup = {}
    request_id = "hello world"

    update_backup_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_update_backup_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_backup_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_backup({ update_mask: update_mask, backup: backup, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_backup update_mask: update_mask, backup: backup, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_backup ::Google::Cloud::BackupDR::V1::UpdateBackupRequest.new(update_mask: update_mask, backup: backup, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_backup({ update_mask: update_mask, backup: backup, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_backup(::Google::Cloud::BackupDR::V1::UpdateBackupRequest.new(update_mask: update_mask, backup: backup, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_backup_client_stub.call_count
      end
    end
  end

  def test_delete_backup
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_backup_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_delete_backup_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_backup_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_backup({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_backup name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_backup ::Google::Cloud::BackupDR::V1::DeleteBackupRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_backup({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_backup(::Google::Cloud::BackupDR::V1::DeleteBackupRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_backup_client_stub.call_count
      end
    end
  end

  def test_restore_backup
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    compute_instance_target_environment = {}
    compute_instance_restore_properties = {}
    clear_overrides_field_mask = {}

    restore_backup_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_restore_backup_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, restore_backup_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.restore_backup({ name: name, request_id: request_id, compute_instance_target_environment: compute_instance_target_environment, compute_instance_restore_properties: compute_instance_restore_properties, clear_overrides_field_mask: clear_overrides_field_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.restore_backup name: name, request_id: request_id, compute_instance_target_environment: compute_instance_target_environment, compute_instance_restore_properties: compute_instance_restore_properties, clear_overrides_field_mask: clear_overrides_field_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.restore_backup ::Google::Cloud::BackupDR::V1::RestoreBackupRequest.new(name: name, request_id: request_id, compute_instance_target_environment: compute_instance_target_environment, compute_instance_restore_properties: compute_instance_restore_properties, clear_overrides_field_mask: clear_overrides_field_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.restore_backup({ name: name, request_id: request_id, compute_instance_target_environment: compute_instance_target_environment, compute_instance_restore_properties: compute_instance_restore_properties, clear_overrides_field_mask: clear_overrides_field_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.restore_backup(::Google::Cloud::BackupDR::V1::RestoreBackupRequest.new(name: name, request_id: request_id, compute_instance_target_environment: compute_instance_target_environment, compute_instance_restore_properties: compute_instance_restore_properties, clear_overrides_field_mask: clear_overrides_field_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, restore_backup_client_stub.call_count
      end
    end
  end

  def test_create_backup_plan
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    backup_plan_id = "hello world"
    backup_plan = {}
    request_id = "hello world"

    create_backup_plan_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_create_backup_plan_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_backup_plan_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_backup_plan({ parent: parent, backup_plan_id: backup_plan_id, backup_plan: backup_plan, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_backup_plan parent: parent, backup_plan_id: backup_plan_id, backup_plan: backup_plan, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_backup_plan ::Google::Cloud::BackupDR::V1::CreateBackupPlanRequest.new(parent: parent, backup_plan_id: backup_plan_id, backup_plan: backup_plan, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_backup_plan({ parent: parent, backup_plan_id: backup_plan_id, backup_plan: backup_plan, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_backup_plan(::Google::Cloud::BackupDR::V1::CreateBackupPlanRequest.new(parent: parent, backup_plan_id: backup_plan_id, backup_plan: backup_plan, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_backup_plan_client_stub.call_count
      end
    end
  end

  def test_update_backup_plan
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    backup_plan = {}
    update_mask = {}
    request_id = "hello world"

    update_backup_plan_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_update_backup_plan_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_backup_plan_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_backup_plan({ backup_plan: backup_plan, update_mask: update_mask, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_backup_plan backup_plan: backup_plan, update_mask: update_mask, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_backup_plan ::Google::Cloud::BackupDR::V1::UpdateBackupPlanRequest.new(backup_plan: backup_plan, update_mask: update_mask, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_backup_plan({ backup_plan: backup_plan, update_mask: update_mask, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_backup_plan(::Google::Cloud::BackupDR::V1::UpdateBackupPlanRequest.new(backup_plan: backup_plan, update_mask: update_mask, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_backup_plan_client_stub.call_count
      end
    end
  end

  def test_get_backup_plan
    # Create test objects.
    client_result = ::Google::Cloud::BackupDR::V1::BackupPlan.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_backup_plan_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_get_backup_plan_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_backup_plan_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_backup_plan({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_backup_plan name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_backup_plan ::Google::Cloud::BackupDR::V1::GetBackupPlanRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_backup_plan({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_backup_plan(::Google::Cloud::BackupDR::V1::GetBackupPlanRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_backup_plan_client_stub.call_count
      end
    end
  end

  def test_list_backup_plans
    # Create test objects.
    client_result = ::Google::Cloud::BackupDR::V1::ListBackupPlansResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_backup_plans_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_list_backup_plans_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_backup_plans_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_backup_plans({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_backup_plans parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_backup_plans ::Google::Cloud::BackupDR::V1::ListBackupPlansRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_backup_plans({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_backup_plans(::Google::Cloud::BackupDR::V1::ListBackupPlansRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_backup_plans_client_stub.call_count
      end
    end
  end

  def test_delete_backup_plan
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_backup_plan_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_delete_backup_plan_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_backup_plan_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_backup_plan({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_backup_plan name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_backup_plan ::Google::Cloud::BackupDR::V1::DeleteBackupPlanRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_backup_plan({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_backup_plan(::Google::Cloud::BackupDR::V1::DeleteBackupPlanRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_backup_plan_client_stub.call_count
      end
    end
  end

  def test_get_backup_plan_revision
    # Create test objects.
    client_result = ::Google::Cloud::BackupDR::V1::BackupPlanRevision.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_backup_plan_revision_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_get_backup_plan_revision_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_backup_plan_revision_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_backup_plan_revision({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_backup_plan_revision name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_backup_plan_revision ::Google::Cloud::BackupDR::V1::GetBackupPlanRevisionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_backup_plan_revision({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_backup_plan_revision(::Google::Cloud::BackupDR::V1::GetBackupPlanRevisionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_backup_plan_revision_client_stub.call_count
      end
    end
  end

  def test_list_backup_plan_revisions
    # Create test objects.
    client_result = ::Google::Cloud::BackupDR::V1::ListBackupPlanRevisionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_backup_plan_revisions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_list_backup_plan_revisions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_backup_plan_revisions_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_backup_plan_revisions({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_backup_plan_revisions parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_backup_plan_revisions ::Google::Cloud::BackupDR::V1::ListBackupPlanRevisionsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_backup_plan_revisions({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_backup_plan_revisions(::Google::Cloud::BackupDR::V1::ListBackupPlanRevisionsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_backup_plan_revisions_client_stub.call_count
      end
    end
  end

  def test_create_backup_plan_association
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    backup_plan_association_id = "hello world"
    backup_plan_association = {}
    request_id = "hello world"

    create_backup_plan_association_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_create_backup_plan_association_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_backup_plan_association_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_backup_plan_association({ parent: parent, backup_plan_association_id: backup_plan_association_id, backup_plan_association: backup_plan_association, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_backup_plan_association parent: parent, backup_plan_association_id: backup_plan_association_id, backup_plan_association: backup_plan_association, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_backup_plan_association ::Google::Cloud::BackupDR::V1::CreateBackupPlanAssociationRequest.new(parent: parent, backup_plan_association_id: backup_plan_association_id, backup_plan_association: backup_plan_association, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_backup_plan_association({ parent: parent, backup_plan_association_id: backup_plan_association_id, backup_plan_association: backup_plan_association, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_backup_plan_association(::Google::Cloud::BackupDR::V1::CreateBackupPlanAssociationRequest.new(parent: parent, backup_plan_association_id: backup_plan_association_id, backup_plan_association: backup_plan_association, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_backup_plan_association_client_stub.call_count
      end
    end
  end

  def test_update_backup_plan_association
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    backup_plan_association = {}
    update_mask = {}
    request_id = "hello world"

    update_backup_plan_association_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_update_backup_plan_association_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_backup_plan_association_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_backup_plan_association({ backup_plan_association: backup_plan_association, update_mask: update_mask, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_backup_plan_association backup_plan_association: backup_plan_association, update_mask: update_mask, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_backup_plan_association ::Google::Cloud::BackupDR::V1::UpdateBackupPlanAssociationRequest.new(backup_plan_association: backup_plan_association, update_mask: update_mask, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_backup_plan_association({ backup_plan_association: backup_plan_association, update_mask: update_mask, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_backup_plan_association(::Google::Cloud::BackupDR::V1::UpdateBackupPlanAssociationRequest.new(backup_plan_association: backup_plan_association, update_mask: update_mask, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_backup_plan_association_client_stub.call_count
      end
    end
  end

  def test_get_backup_plan_association
    # Create test objects.
    client_result = ::Google::Cloud::BackupDR::V1::BackupPlanAssociation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_backup_plan_association_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_get_backup_plan_association_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_backup_plan_association_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_backup_plan_association({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_backup_plan_association name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_backup_plan_association ::Google::Cloud::BackupDR::V1::GetBackupPlanAssociationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_backup_plan_association({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_backup_plan_association(::Google::Cloud::BackupDR::V1::GetBackupPlanAssociationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_backup_plan_association_client_stub.call_count
      end
    end
  end

  def test_list_backup_plan_associations
    # Create test objects.
    client_result = ::Google::Cloud::BackupDR::V1::ListBackupPlanAssociationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_backup_plan_associations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_list_backup_plan_associations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_backup_plan_associations_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_backup_plan_associations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_backup_plan_associations parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_backup_plan_associations ::Google::Cloud::BackupDR::V1::ListBackupPlanAssociationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_backup_plan_associations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_backup_plan_associations(::Google::Cloud::BackupDR::V1::ListBackupPlanAssociationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_backup_plan_associations_client_stub.call_count
      end
    end
  end

  def test_fetch_backup_plan_associations_for_resource_type
    # Create test objects.
    client_result = ::Google::Cloud::BackupDR::V1::FetchBackupPlanAssociationsForResourceTypeResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    resource_type = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    fetch_backup_plan_associations_for_resource_type_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_fetch_backup_plan_associations_for_resource_type_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_backup_plan_associations_for_resource_type_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_backup_plan_associations_for_resource_type({ parent: parent, resource_type: resource_type, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_backup_plan_associations_for_resource_type parent: parent, resource_type: resource_type, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_backup_plan_associations_for_resource_type ::Google::Cloud::BackupDR::V1::FetchBackupPlanAssociationsForResourceTypeRequest.new(parent: parent, resource_type: resource_type, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_backup_plan_associations_for_resource_type({ parent: parent, resource_type: resource_type, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_backup_plan_associations_for_resource_type(::Google::Cloud::BackupDR::V1::FetchBackupPlanAssociationsForResourceTypeRequest.new(parent: parent, resource_type: resource_type, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_backup_plan_associations_for_resource_type_client_stub.call_count
      end
    end
  end

  def test_delete_backup_plan_association
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_backup_plan_association_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_delete_backup_plan_association_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_backup_plan_association_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_backup_plan_association({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_backup_plan_association name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_backup_plan_association ::Google::Cloud::BackupDR::V1::DeleteBackupPlanAssociationRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_backup_plan_association({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_backup_plan_association(::Google::Cloud::BackupDR::V1::DeleteBackupPlanAssociationRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_backup_plan_association_client_stub.call_count
      end
    end
  end

  def test_trigger_backup
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    rule_id = "hello world"
    request_id = "hello world"

    trigger_backup_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_trigger_backup_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, trigger_backup_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.trigger_backup({ name: name, rule_id: rule_id, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.trigger_backup name: name, rule_id: rule_id, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.trigger_backup ::Google::Cloud::BackupDR::V1::TriggerBackupRequest.new(name: name, rule_id: rule_id, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.trigger_backup({ name: name, rule_id: rule_id, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.trigger_backup(::Google::Cloud::BackupDR::V1::TriggerBackupRequest.new(name: name, rule_id: rule_id, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, trigger_backup_client_stub.call_count
      end
    end
  end

  def test_get_data_source_reference
    # Create test objects.
    client_result = ::Google::Cloud::BackupDR::V1::DataSourceReference.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_data_source_reference_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_get_data_source_reference_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_data_source_reference_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_data_source_reference({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_data_source_reference name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_data_source_reference ::Google::Cloud::BackupDR::V1::GetDataSourceReferenceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_data_source_reference({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_data_source_reference(::Google::Cloud::BackupDR::V1::GetDataSourceReferenceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_data_source_reference_client_stub.call_count
      end
    end
  end

  def test_list_data_source_references
    # Create test objects.
    client_result = ::Google::Cloud::BackupDR::V1::ListDataSourceReferencesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_data_source_references_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_list_data_source_references_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_data_source_references_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_data_source_references({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_data_source_references parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_data_source_references ::Google::Cloud::BackupDR::V1::ListDataSourceReferencesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_data_source_references({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_data_source_references(::Google::Cloud::BackupDR::V1::ListDataSourceReferencesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_data_source_references_client_stub.call_count
      end
    end
  end

  def test_fetch_data_source_references_for_resource_type
    # Create test objects.
    client_result = ::Google::Cloud::BackupDR::V1::FetchDataSourceReferencesForResourceTypeResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    resource_type = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    fetch_data_source_references_for_resource_type_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_fetch_data_source_references_for_resource_type_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_data_source_references_for_resource_type_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_data_source_references_for_resource_type({ parent: parent, resource_type: resource_type, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_data_source_references_for_resource_type parent: parent, resource_type: resource_type, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_data_source_references_for_resource_type ::Google::Cloud::BackupDR::V1::FetchDataSourceReferencesForResourceTypeRequest.new(parent: parent, resource_type: resource_type, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_data_source_references_for_resource_type({ parent: parent, resource_type: resource_type, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_data_source_references_for_resource_type(::Google::Cloud::BackupDR::V1::FetchDataSourceReferencesForResourceTypeRequest.new(parent: parent, resource_type: resource_type, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_data_source_references_for_resource_type_client_stub.call_count
      end
    end
  end

  def test_initialize_service
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    resource_type = "hello world"
    request_id = "hello world"
    cloud_sql_instance_initialization_config = {}

    initialize_service_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::BackupDR::V1::BackupDR::Rest::ServiceStub.stub :transcode_initialize_service_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, initialize_service_client_stub do
        # Create client
        client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.initialize_service({ name: name, resource_type: resource_type, request_id: request_id, cloud_sql_instance_initialization_config: cloud_sql_instance_initialization_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.initialize_service name: name, resource_type: resource_type, request_id: request_id, cloud_sql_instance_initialization_config: cloud_sql_instance_initialization_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.initialize_service ::Google::Cloud::BackupDR::V1::InitializeServiceRequest.new(name: name, resource_type: resource_type, request_id: request_id, cloud_sql_instance_initialization_config: cloud_sql_instance_initialization_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.initialize_service({ name: name, resource_type: resource_type, request_id: request_id, cloud_sql_instance_initialization_config: cloud_sql_instance_initialization_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.initialize_service(::Google::Cloud::BackupDR::V1::InitializeServiceRequest.new(name: name, resource_type: resource_type, request_id: request_id, cloud_sql_instance_initialization_config: cloud_sql_instance_initialization_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, initialize_service_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::BackupDR::V1::BackupDR::Rest::Client::Configuration, config
  end
end
