# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/backupdr/v1/backupdr"

class ::Google::Cloud::BackupDR::V1::BackupDR::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_backup_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.backup_path project: "value0", location: "value1", backupvault: "value2", datasource: "value3", backup: "value4"
      assert_equal "projects/value0/locations/value1/backupVaults/value2/dataSources/value3/backups/value4", path
    end
  end

  def test_backup_plan_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.backup_plan_path project: "value0", location: "value1", backup_plan: "value2"
      assert_equal "projects/value0/locations/value1/backupPlans/value2", path
    end
  end

  def test_backup_plan_association_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.backup_plan_association_path project: "value0", location: "value1", backup_plan_association: "value2"
      assert_equal "projects/value0/locations/value1/backupPlanAssociations/value2", path
    end
  end

  def test_backup_plan_revision_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.backup_plan_revision_path project: "value0", location: "value1", backup_plan: "value2", revision: "value3"
      assert_equal "projects/value0/locations/value1/backupPlans/value2/revisions/value3", path
    end
  end

  def test_backup_vault_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.backup_vault_path project: "value0", location: "value1", backupvault: "value2"
      assert_equal "projects/value0/locations/value1/backupVaults/value2", path
    end
  end

  def test_crypto_key_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.crypto_key_path project: "value0", location: "value1", ring: "value2", key: "value3"
      assert_equal "projects/value0/locations/value1/keyRings/value2/cryptoKeys/value3", path
    end
  end

  def test_crypto_key_version_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.crypto_key_version_path project: "value0", location: "value1", key_ring: "value2", crypto_key: "value3", crypto_key_version: "value4"
      assert_equal "projects/value0/locations/value1/keyRings/value2/cryptoKeys/value3/cryptoKeyVersions/value4", path
    end
  end

  def test_data_source_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.data_source_path project: "value0", location: "value1", backupvault: "value2", datasource: "value3"
      assert_equal "projects/value0/locations/value1/backupVaults/value2/dataSources/value3", path
    end
  end

  def test_data_source_reference_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.data_source_reference_path project: "value0", location: "value1", data_source_reference: "value2"
      assert_equal "projects/value0/locations/value1/dataSourceReferences/value2", path
    end
  end

  def test_instance_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.instance_path project: "value0", instance: "value1"
      assert_equal "projects/value0/instances/value1", path
    end
  end

  def test_location_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.location_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1", path
    end
  end

  def test_management_server_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.management_server_path project: "value0", location: "value1", managementserver: "value2"
      assert_equal "projects/value0/locations/value1/managementServers/value2", path
    end
  end

  def test_storage_pool_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.storage_pool_path project: "value0", zone: "value1", storage_pool: "value2"
      assert_equal "projects/value0/zones/value1/storagePools/value2", path
    end
  end
end
