# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module BackupDR
      module V1
        # Request for ListResourceBackupConfigs.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location for which to retrieve resource backup
        #     configs. Format: 'projects/\\{project_id}/locations/\\{location}'. In Google
        #     Cloud Backup and DR, locations map to Google Cloud regions, for example
        #     **us-central1**.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will use 100 as default. Maximum value is
        #     500 and values above 500 will be coerced to 500.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results.
        class ListResourceBackupConfigsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for ListResourceBackupConfigs.
        # @!attribute [rw] resource_backup_configs
        #   @return [::Array<::Google::Cloud::BackupDR::V1::ResourceBackupConfig>]
        #     The list of ResourceBackupConfigs for the specified scope.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        class ListResourceBackupConfigsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ResourceBackupConfig represents a resource along with its backup
        # configurations.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the ResourceBackupConfig.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/resourceBackupConfigs/\\{uid}
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. The unique identifier of the resource backup config.
        # @!attribute [r] target_resource
        #   @return [::String]
        #     Output only. The [full resource
        #     name](https://cloud.google.com/asset-inventory/docs/resource-name-format)
        #     of the cloud resource that this configuration applies to. Supported
        #     resource types are
        #     {::Google::Cloud::BackupDR::V1::ResourceBackupConfig::ResourceType ResourceBackupConfig.ResourceType}.
        # @!attribute [r] target_resource_display_name
        #   @return [::String]
        #     Output only. The human friendly name of the target resource.
        # @!attribute [r] target_resource_type
        #   @return [::Google::Cloud::BackupDR::V1::ResourceBackupConfig::ResourceType]
        #     Output only. The type of the target resource.
        # @!attribute [rw] target_resource_labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels associated with the target resource.
        # @!attribute [rw] backup_configs_details
        #   @return [::Array<::Google::Cloud::BackupDR::V1::BackupConfigDetails>]
        #     Backup configurations applying to the target resource, including those
        #     targeting its related/child resources. For example, backup configuration
        #     applicable to Compute Engine disks will be populated in this field for a
        #     Compute Engine VM which has the disk associated.
        # @!attribute [r] backup_configured
        #   @return [::Boolean]
        #     Output only. Whether the target resource is configured for backup. This is
        #     true if the backup_configs_details is not empty.
        # @!attribute [r] vaulted
        #   @return [::Boolean]
        #     Output only. Whether the target resource is protected by a backup vault.
        #     This is true if the backup_configs_details is not empty and any of the
        #     {::Google::Cloud::BackupDR::V1::ResourceBackupConfig#backup_configs_details ResourceBackupConfig.backup_configs_details}
        #     has a backup configuration with
        #     {::Google::Cloud::BackupDR::V1::BackupConfigDetails#backup_vault BackupConfigDetails.backup_vault}
        #     set. set.
        class ResourceBackupConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class TargetResourceLabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The type of the cloud resource.
          module ResourceType
            # Resource type not set.
            RESOURCE_TYPE_UNSPECIFIED = 0

            # Cloud SQL instance.
            CLOUD_SQL_INSTANCE = 1

            # Compute Engine VM.
            COMPUTE_ENGINE_VM = 2

            # Compute Engine Disk.
            COMPUTE_ENGINE_DISK = 3

            # Compute Engine Regional Disk.
            COMPUTE_ENGINE_REGIONAL_DISK = 4
          end
        end

        # BackupConfigDetails has information about how the resource is configured
        # for backups and about the most recent backup taken for this configuration.
        # @!attribute [r] backup_config_source
        #   @return [::String]
        #     Output only. The full resource name of the backup config source resource.
        #     For example,
        #     "//backupdr.googleapis.com/v1/projects/\\{project}/locations/\\{region}/backupPlans/\\{backupplanId}"
        #     or
        #     "//compute.googleapis.com/projects/\\{project}/locations/\\{region}/resourcePolicies/\\{resourcePolicyId}".
        # @!attribute [r] backup_config_source_display_name
        #   @return [::String]
        #     Output only. The display name of the backup config source resource.
        # @!attribute [r] type
        #   @return [::Google::Cloud::BackupDR::V1::BackupConfigDetails::Type]
        #     Output only. The type of the backup config resource.
        # @!attribute [r] state
        #   @return [::Google::Cloud::BackupDR::V1::BackupConfigDetails::State]
        #     Output only. The state of the backup config resource.
        # @!attribute [r] pitr_settings
        #   @return [::Google::Cloud::BackupDR::V1::PitrSettings]
        #     Output only. Point in time recovery settings of the backup configuration
        #     resource.
        # @!attribute [r] latest_successful_backup_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp of the latest successful backup created via this
        #     backup configuration.
        # @!attribute [r] applicable_resource
        #   @return [::String]
        #     Output only. The [full resource
        #     name](https://cloud.google.com/asset-inventory/docs/resource-name-format)
        #     of the resource that is applicable for the backup configuration. Example:
        #     "//compute.googleapis.com/projects/\\{project}/zones/\\{zone}/instances/\\{instance}"
        # @!attribute [r] backup_vault
        #   @return [::String]
        #     Output only. The [full resource
        #     name](https://cloud.google.com/asset-inventory/docs/resource-name-format)
        #     of the backup vault that will store the backups generated through this
        #     backup configuration. Example:
        #     "//backupdr.googleapis.com/v1/projects/\\{project}/locations/\\{region}/backupVaults/\\{backupvaultId}"
        # @!attribute [rw] backup_locations
        #   @return [::Array<::Google::Cloud::BackupDR::V1::BackupLocation>]
        #     The locations where the backups are to be stored.
        # @!attribute [rw] backup_dr_plan_config
        #   @return [::Google::Cloud::BackupDR::V1::BackupDrPlanConfig]
        #     Google Cloud Backup and DR's Backup Plan specific data.
        #
        #     Note: The following fields are mutually exclusive: `backup_dr_plan_config`, `backup_dr_template_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] backup_dr_template_config
        #   @return [::Google::Cloud::BackupDR::V1::BackupDrTemplateConfig]
        #     Google Cloud Backup and DR's Template specific data.
        #
        #     Note: The following fields are mutually exclusive: `backup_dr_template_config`, `backup_dr_plan_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class BackupConfigDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Type of the backup configuration.
          # This enum may receive new values in the future.
          module Type
            # Backup config type is unspecified.
            TYPE_UNSPECIFIED = 0

            # Backup config is Cloud SQL instance's automated backup config.
            CLOUD_SQL_INSTANCE_BACKUP_CONFIG = 1

            # Backup config is Compute Engine Resource Policy.
            COMPUTE_ENGINE_RESOURCE_POLICY = 2

            # Backup config is Google Cloud Backup and DR's Backup Plan.
            BACKUPDR_BACKUP_PLAN = 3

            # Backup config is Google Cloud Backup and DR's Template.
            BACKUPDR_TEMPLATE = 4
          end

          # The state tells whether the backup config is active or not.
          module State
            # Backup config state not set.
            STATE_UNSPECIFIED = 0

            # The config is in an active state protecting the resource
            ACTIVE = 1

            # The config is currently not protecting the resource. Either because it is
            # disabled or the owning project has been deleted without cleanup of the
            # actual resource.
            INACTIVE = 2

            # The config still exists but because of some error state it is not
            # protecting the resource. Like the source project is deleted. For eg.
            # PlanAssociation, BackupPlan is deleted.
            ERROR = 3
          end
        end

        # Point in time recovery settings of the backup configuration resource.
        # @!attribute [r] retention_days
        #   @return [::Integer]
        #     Output only. Number of days to retain the backup.
        class PitrSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Provides additional information about Google Cloud Backup
        # and DR's Template backup configuration.
        # @!attribute [r] first_party_management_uri
        #   @return [::String]
        #     Output only. The URI of the BackupDr template resource for the first party
        #     identity users.
        # @!attribute [r] third_party_management_uri
        #   @return [::String]
        #     Output only. The URI of the BackupDr template resource for the third party
        #     identity users.
        class BackupDrTemplateConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # BackupDrPlanConfig has additional information about Google Cloud Backup and
        # DR's Plan backup configuration.
        # @!attribute [rw] backup_dr_plan_rules
        #   @return [::Array<::Google::Cloud::BackupDR::V1::BackupDrPlanRule>]
        #     Backup rules of the backup plan resource.
        class BackupDrPlanConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # BackupDrPlanRule has rule specific information of the backup plan resource.
        # @!attribute [r] rule_id
        #   @return [::String]
        #     Output only. Unique Id of the backup rule.
        # @!attribute [r] last_successful_backup_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp of the latest successful backup created via this
        #     backup rule.
        class BackupDrPlanRule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # BackupLocation represents a cloud location where a backup can be stored.
        # @!attribute [r] type
        #   @return [::Google::Cloud::BackupDR::V1::BackupLocation::Type]
        #     Output only. The type of the location.
        # @!attribute [r] location_id
        #   @return [::String]
        #     Output only. The id of the cloud location. Example: "us-central1"
        class BackupLocation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of the location.
          module Type
            # Location type is unspecified.
            TYPE_UNSPECIFIED = 0

            # Location type is zonal.
            ZONAL = 1

            # Location type is regional.
            REGIONAL = 2

            # Location type is multi regional.
            MULTI_REGIONAL = 3
          end
        end
      end
    end
  end
end
